/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module;

import com.google.common.base.Functions;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.GenerationStage;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.Module;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.base.world.WorldGenHandler;
import vazkii.quark.world.block.BlossomLeavesBlock;
import vazkii.quark.world.block.BlossomSaplingBlock;
import vazkii.quark.world.config.BlossomTreeConfig;
import vazkii.quark.world.gen.BlossomTreeGenerator;

@LoadModule(category=ModuleCategory.WORLD)
public class BlossomTreesModule
extends Module {
    @Config
    BlossomTreeConfig blue = new BlossomTreeConfig(200, Biome.Category.ICY);
    @Config
    BlossomTreeConfig lavender = new BlossomTreeConfig(100, Biome.Category.SWAMP);
    @Config
    BlossomTreeConfig orange = new BlossomTreeConfig(100, Biome.Category.SAVANNA);
    @Config
    BlossomTreeConfig pink = new BlossomTreeConfig(100, Biome.Category.EXTREME_HILLS);
    @Config
    BlossomTreeConfig yellow = new BlossomTreeConfig(200, Biome.Category.PLAINS);
    public static Map<BlossomSaplingBlock.BlossomTree, BlossomTreeConfig> trees = new HashMap<BlossomSaplingBlock.BlossomTree, BlossomTreeConfig>();

    @Override
    public void construct() {
        this.add("blue", MaterialColor.field_151674_s, this.blue);
        this.add("lavender", MaterialColor.field_151671_v, this.lavender);
        this.add("orange", MaterialColor.field_193562_N, this.orange);
        this.add("pink", MaterialColor.field_151671_v, this.pink);
        this.add("yellow", MaterialColor.field_151673_t, this.yellow);
    }

    @Override
    public void setup() {
        trees.forEach((tree, config) -> {
            ComposterBlock.field_220299_b.put((Object)tree.leaf.func_177230_c().func_199767_j(), 0.3f);
            ComposterBlock.field_220299_b.put((Object)tree.sapling.func_199767_j(), 0.3f);
            WorldGenHandler.addGenerator(this, new BlossomTreeGenerator((BlossomTreeConfig)config, (BlossomSaplingBlock.BlossomTree)((Object)tree)), GenerationStage.Decoration.TOP_LAYER_MODIFICATION, 1);
        });
    }

    private void add(String colorName, MaterialColor color, BlossomTreeConfig config) {
        BlossomLeavesBlock leaves = new BlossomLeavesBlock(colorName, this, color);
        BlossomSaplingBlock.BlossomTree tree = new BlossomSaplingBlock.BlossomTree((Block)leaves);
        BlossomSaplingBlock sapling = new BlossomSaplingBlock(colorName, this, tree, (Block)leaves);
        VariantHandler.addFlowerPot((Block)sapling, sapling.getRegistryName().func_110623_a(), (Function<AbstractBlock.Properties, AbstractBlock.Properties>)Functions.identity());
        trees.put(tree, config);
    }
}

