/*
 * Decompiled with CFR 0.152.
 */
package vazkii.quark.world.module.underground;

import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.block.ComposterBlock;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.spawner.WorldEntitySpawner;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import vazkii.quark.base.effect.QuarkEffect;
import vazkii.quark.base.handler.BrewingHandler;
import vazkii.quark.base.handler.VariantHandler;
import vazkii.quark.base.module.LoadModule;
import vazkii.quark.base.module.ModuleCategory;
import vazkii.quark.base.module.config.Config;
import vazkii.quark.world.block.GlowceliumBlock;
import vazkii.quark.world.block.GlowshroomBlock;
import vazkii.quark.world.block.HugeGlowshroomBlock;
import vazkii.quark.world.config.UndergroundBiomeConfig;
import vazkii.quark.world.gen.underground.GlowshroomUndergroundBiome;
import vazkii.quark.world.gen.underground.UndergroundBiome;
import vazkii.quark.world.module.underground.UndergroundBiomeModule;

@LoadModule(category=ModuleCategory.WORLD, hasSubscriptions=true, subscribeOn={Dist.CLIENT})
public class GlowshroomUndergroundBiomeModule
extends UndergroundBiomeModule {
    @Config
    @Config.Min(value=0.0, exclusive=true)
    public static int glowshroomGrowthRate = 20;
    @Config
    @Config.Min(value=0.0)
    @Config.Max(value=1.0)
    public static double glowshroomSpawnChance = 0.0625;
    @Config
    public static boolean enableHugeGlowshrooms = true;
    @Config(flag="glowshroom_danger_sight")
    public static boolean enableDangerSight = true;
    public static Block glowcelium;
    public static GlowshroomBlock glowshroom;
    public static Block glowshroom_block;
    public static Block glowshroom_stem;
    private QuarkEffect dangerSight;

    @Override
    public void construct() {
        glowcelium = new GlowceliumBlock(this);
        glowshroom = new GlowshroomBlock(this);
        glowshroom_block = new HugeGlowshroomBlock("glowshroom_block", this);
        glowshroom_stem = new HugeGlowshroomBlock("glowshroom_stem", this);
        this.dangerSight = new QuarkEffect("danger_sight", EffectType.BENEFICIAL, 575715);
        BrewingHandler.addPotionMix("glowshroom_danger_sight", () -> Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{glowshroom}), this.dangerSight, 3600, 9600, -1);
        VariantHandler.addFlowerPot((Block)glowshroom, "glowshroom", p -> p.func_235838_a_(b -> 14));
        super.construct();
    }

    @Override
    public void setup() {
        ComposterBlock.field_220299_b.put((Object)glowshroom_stem.func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)glowshroom.func_199767_j(), 0.65f);
        ComposterBlock.field_220299_b.put((Object)glowshroom_block.func_199767_j(), 0.65f);
        super.setup();
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientTick(TickEvent.ClientTickEvent event) {
        Minecraft mc = Minecraft.func_71410_x();
        if (enableDangerSight && event.phase == TickEvent.Phase.START && mc.field_71439_g != null && mc.field_71439_g.func_70660_b((Effect)this.dangerSight) != null && !mc.func_147113_T()) {
            int range = 12;
            ClientWorld world = mc.field_71441_e;
            Stream positions = BlockPos.func_218281_b((BlockPos)mc.field_71439_g.func_233580_cy_().func_177982_a(-range, -range, -range), (BlockPos)mc.field_71439_g.func_233580_cy_().func_177982_a(range, range, range));
            positions.forEach(arg_0 -> GlowshroomUndergroundBiomeModule.lambda$clientTick$3((World)world, arg_0));
        }
    }

    public static boolean canSpawnOn(EntityType<? extends MobEntity> typeIn, IWorld worldIn, BlockPos pos) {
        BlockPos testPos = pos.func_177977_b();
        return worldIn instanceof World && worldIn.func_226658_a_(LightType.BLOCK, pos) <= 7 && worldIn.func_180495_p(testPos).func_215688_a((IBlockReader)worldIn, testPos, typeIn) && WorldEntitySpawner.canSpawnAtBody((EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (IWorldReader)worldIn, (BlockPos)pos, (EntityType)EntityType.field_200725_aD) && ((World)worldIn).func_226664_a_(EntityType.field_200725_aD.func_220328_a((double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o(), (double)pos.func_177952_p() + 0.5));
    }

    @Override
    protected String getBiomeName() {
        return "glowshroom";
    }

    @Override
    protected UndergroundBiomeConfig getBiomeConfig() {
        return new UndergroundBiomeConfig((UndergroundBiome)new GlowshroomUndergroundBiome(), 80, Biome.Category.EXTREME_HILLS, Biome.Category.MUSHROOM);
    }

    private static /* synthetic */ void lambda$clientTick$3(World world, BlockPos pos) {
        if ((double)world.field_73012_v.nextFloat() < 0.1 && GlowshroomUndergroundBiomeModule.canSpawnOn((EntityType<? extends MobEntity>)EntityType.field_200725_aD, (IWorld)world, pos)) {
            float x = (float)pos.func_177958_n() + 0.3f + world.field_73012_v.nextFloat() * 0.4f;
            float y = pos.func_177956_o();
            float z = (float)pos.func_177952_p() + 0.3f + world.field_73012_v.nextFloat() * 0.4f;
            world.func_195594_a((IParticleData)ParticleTypes.field_197625_r, (double)x, (double)y, (double)z, (double)world.field_73012_v.nextFloat() < 0.9 ? 0.0 : 1.0, 0.0, 0.0);
        }
    }
}

