/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.config;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(modid="rsx", bus=Mod.EventBusSubscriber.Bus.MOD)
public class MyConfig {
    public static final Server SERVER;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static double energyFactor;

    @SubscribeEvent
    public static void onModConfigEvent(ModConfig.ModConfigEvent configEvent) {
        if (configEvent.getConfig().getSpec() == SERVER_SPEC) {
            MyConfig.bakeConfig();
        }
    }

    public static void bakeConfig() {
        energyFactor = (Double)MyConfig.SERVER.energyFactor.get();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.DoubleValue energyFactor;

        public Server(ForgeConfigSpec.Builder builder) {
            String baseTrans = "rsx.config.";
            String sectionTrans = baseTrans + "general.";
            this.energyFactor = builder.comment("Energy Factor").translation(sectionTrans + "energy_factor").defineInRange("EnergyFactor", () -> 0.3, 0.0, 1.0);
        }
    }
}

