/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lupicus.rsx.block.ModBlocks;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneDiodeBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BluestoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)13.0), Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0)};
    private RedstoneWireBlock wire = (RedstoneWireBlock)Blocks.field_150488_af;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public BluestoneWireBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE)).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPES[BluestoneWireBlock.getAABBIndex(state)];
    }

    private static int getAABBIndex(BlockState state) {
        boolean flag3;
        int i = 0;
        boolean flag = state.func_177229_b(NORTH) != RedstoneSide.NONE;
        boolean flag1 = state.func_177229_b(EAST) != RedstoneSide.NONE;
        boolean flag2 = state.func_177229_b(SOUTH) != RedstoneSide.NONE;
        boolean bl = flag3 = state.func_177229_b(WEST) != RedstoneSide.NONE;
        if (flag || flag2 && !flag && !flag1 && !flag3) {
            i |= 1 << Direction.NORTH.func_176736_b();
        }
        if (flag1 || flag3 && !flag && !flag1 && !flag2) {
            i |= 1 << Direction.EAST.func_176736_b();
        }
        if (flag2 || flag && !flag1 && !flag2 && !flag3) {
            i |= 1 << Direction.SOUTH.func_176736_b();
        }
        if (flag3 || flag1 && !flag && !flag2 && !flag3) {
            i |= 1 << Direction.WEST.func_176736_b();
        }
        return i;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.SOUTH));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        return facing == Direction.UP ? (BlockState)((BlockState)((BlockState)((BlockState)stateIn.func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)worldIn, currentPos, Direction.SOUTH)) : (BlockState)stateIn.func_206870_a((IProperty)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((IBlockReader)worldIn, currentPos, facing));
    }

    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags) {
        try (BlockPos.PooledMutable blockpos$pooledmutable = BlockPos.PooledMutable.func_185346_s();){
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((IProperty)FACING_PROPERTY_MAP.get(direction));
                if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction)).func_177230_c() == this) continue;
                blockpos$pooledmutable.func_189536_c(Direction.DOWN);
                BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$pooledmutable);
                if (blockstate.func_177230_c() != Blocks.field_190976_dk) {
                    BlockPos blockpos = blockpos$pooledmutable.func_177972_a(direction.func_176734_d());
                    BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$pooledmutable, blockpos);
                    BluestoneWireBlock.func_196263_a((BlockState)blockstate, (BlockState)blockstate1, (IWorld)worldIn, (BlockPos)blockpos$pooledmutable, (int)flags);
                }
                blockpos$pooledmutable.func_189533_g((Vec3i)pos).func_189536_c(direction).func_189536_c(Direction.UP);
                BlockState blockstate3 = worldIn.func_180495_p((BlockPos)blockpos$pooledmutable);
                if (blockstate3.func_177230_c() == Blocks.field_190976_dk) continue;
                BlockPos blockpos1 = blockpos$pooledmutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$pooledmutable, blockpos1);
                BluestoneWireBlock.func_196263_a((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)worldIn, (BlockPos)blockpos$pooledmutable, (int)flags);
            }
        }
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        BlockPos blockpos1 = pos.func_177984_a();
        BlockState blockstate1 = worldIn.func_180495_p(blockpos1);
        if (!blockstate1.func_215686_e(worldIn, blockpos1)) {
            boolean flag;
            boolean bl = flag = blockstate.func_224755_d(worldIn, blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
            if (flag && BluestoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
                if (blockstate.func_224756_o(worldIn, blockpos)) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !BluestoneWireBlock.canConnectTo(blockstate, worldIn, blockpos, face) && (blockstate.func_215686_e(worldIn, blockpos) || !BluestoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || blockstate.func_177230_c() == Blocks.field_150438_bZ;
    }

    private BlockState updateSurroundingRedstone(World worldIn, BlockPos pos, BlockState state) {
        state = this.func_212568_b(worldIn, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_195593_d(blockpos, (Block)this);
        }
        return state;
    }

    private BlockState func_212568_b(World world, BlockPos posIn, BlockState stateIn) {
        int l;
        BlockState blockstate = stateIn;
        int i = (Integer)stateIn.func_177229_b((IProperty)POWER);
        this.wire.field_150181_a = false;
        int j = world.func_175687_A(posIn);
        this.wire.field_150181_a = true;
        int k = 0;
        if (j < 15) {
            BlockPos blockpos1 = posIn.func_177984_a();
            Boolean isUpNormal = world.func_180495_p(blockpos1).func_215686_e((IBlockReader)world, blockpos1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = posIn.func_177972_a(direction);
                BlockState blockstate1 = world.func_180495_p(blockpos);
                k = this.maxSignal(k, blockstate1);
                if (blockstate1.func_215686_e((IBlockReader)world, blockpos)) {
                    if (isUpNormal.booleanValue()) continue;
                    k = this.maxSignal(k, world.func_180495_p(blockpos.func_177984_a()));
                    continue;
                }
                k = this.maxSignal(k, world.func_180495_p(blockpos.func_177977_b()));
            }
        }
        if (j > (l = k - 1)) {
            l = j;
        }
        if (i != l) {
            stateIn = (BlockState)stateIn.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(l));
            if (world.func_180495_p(posIn) == blockstate) {
                world.func_180501_a(posIn, stateIn, 2);
            }
            this.blocksNeedingUpdate.add(posIn);
            for (Direction direction1 : Direction.values()) {
                this.blocksNeedingUpdate.add(posIn.func_177972_a(direction1));
            }
        }
        return stateIn;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_177230_c() == this) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
            }
            for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = pos.func_177972_a(direction2);
                if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                    continue;
                }
                this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateSurroundingRedstone(worldIn, pos, state);
                for (Direction direction1 : Direction.Plane.HORIZONTAL) {
                    this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction1));
                }
                for (Direction direction2 : Direction.Plane.HORIZONTAL) {
                    BlockPos blockpos = pos.func_177972_a(direction2);
                    if (worldIn.func_180495_p(blockpos).func_215686_e((IBlockReader)worldIn, blockpos)) {
                        this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177984_a());
                        continue;
                    }
                    this.notifyWireNeighborsOfStateChange(worldIn, blockpos.func_177977_b());
                }
            }
        }
    }

    private int maxSignal(int existingSignal, BlockState neighbor) {
        if (neighbor.func_177230_c() != this) {
            return existingSignal;
        }
        int i = (Integer)neighbor.func_177229_b((IProperty)POWER);
        return i > existingSignal ? i : existingSignal;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            if (state.func_196955_c((IWorldReader)worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos, state);
            } else {
                BluestoneWireBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !this.wire.field_150181_a ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!this.wire.field_150181_a) {
            return 0;
        }
        int i = (Integer)blockState.func_177229_b((IProperty)POWER);
        if (i == 0) {
            return 0;
        }
        if (side == Direction.UP) {
            return i;
        }
        EnumSet<Direction> enumset = EnumSet.noneOf(Direction.class);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            if (!this.isPowerSourceAt(blockAccess, pos, direction)) continue;
            enumset.add(direction);
        }
        if (side.func_176740_k().func_176722_c() && enumset.isEmpty()) {
            return i;
        }
        return enumset.contains(side) && !enumset.contains(side.func_176735_f()) && !enumset.contains(side.func_176746_e()) ? i : 0;
    }

    private boolean isPowerSourceAt(IBlockReader worldIn, BlockPos pos, Direction side) {
        BlockPos blockpos = pos.func_177972_a(side);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        boolean flag = blockstate.func_215686_e(worldIn, blockpos);
        BlockPos blockpos1 = pos.func_177984_a();
        boolean flag1 = worldIn.func_180495_p(blockpos1).func_215686_e(worldIn, blockpos1);
        if (!flag1 && flag && BluestoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
            return true;
        }
        if (BluestoneWireBlock.canConnectTo(blockstate, worldIn, blockpos, side)) {
            return true;
        }
        if (blockstate.func_177230_c() == Blocks.field_196633_cV && ((Boolean)blockstate.func_177229_b((IProperty)RedstoneDiodeBlock.field_196348_c)).booleanValue() && blockstate.func_177229_b((IProperty)RedstoneDiodeBlock.field_185512_D) == side) {
            return true;
        }
        return !flag && BluestoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null);
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        Block block = blockState.func_177230_c();
        if (block == ModBlocks.BLUESTONE_WIRE) {
            return true;
        }
        if (block == Blocks.field_150488_af || block == ModBlocks.REDSTONE_PIPE_BLOCK) {
            return false;
        }
        if (block == Blocks.field_196633_cV) {
            Direction direction = (Direction)blockState.func_177229_b((IProperty)RepeaterBlock.field_185512_D);
            return direction == side || direction.func_176734_d() == side;
        }
        if (block == Blocks.field_190976_dk) {
            return side == blockState.func_177229_b((IProperty)ObserverBlock.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    public boolean func_149744_f(BlockState state) {
        return this.wire.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        float f = (float)power / 15.0f;
        float f3 = f * 0.6f + 0.4f;
        if (power == 0) {
            f3 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f1 = f * f * 0.6f - 0.7f;
        if (f2 < 0.0f) {
            f2 = 0.0f;
        }
        if (f1 < 0.0f) {
            f1 = 0.0f;
        }
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)POWER);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.0625f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f3 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f1 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, POWER});
    }
}

