/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import java.util.EnumSet;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.HorizontalBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class RedstoneBenderBlock
extends HorizontalBlock {
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    protected static final VoxelShape SHAPE = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    protected RedstoneBenderBlock(Block.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)field_185512_D, (Comparable)Direction.NORTH)).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        return RedstoneBenderBlock.func_220064_c((IBlockReader)worldIn, (BlockPos)pos.func_177977_b());
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult p_225533_6_) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        HashSet<Direction> set = new HashSet<Direction>();
        if (this.getActiveSignal((IBlockReader)world, pos, state) > 0) {
            this.getSides(state, set);
        }
        Rotation rot = player.func_225608_bj_() ? Rotation.CLOCKWISE_90 : Rotation.COUNTERCLOCKWISE_90;
        state = this.func_185499_a(state, rot);
        world.func_180501_a(pos, state, 0);
        int j = this.calculateInputStrength(world, pos, state);
        state = (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(j));
        world.func_180501_a(pos, state, 2);
        this.getSides(state, set);
        this.notifyNeighbors(world, pos, state, set);
        return ActionResultType.SUCCESS;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return (BlockState)this.func_176223_P().func_206870_a((IProperty)field_185512_D, (Comparable)context.func_195992_f().func_176734_d());
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (state.func_177230_c() != oldState.func_177230_c()) {
            this.updateState(worldIn, pos, state);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (this.getActiveSignal((IBlockReader)worldIn, pos, state) > 0) {
                this.notifyNeighbors(worldIn, pos, state);
            }
        }
    }

    protected void getSides(BlockState state, Set<Direction> set) {
        Direction facing = (Direction)state.func_177229_b((IProperty)field_185512_D);
        set.add(facing);
        set.add(facing.func_176735_f());
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, BlockState state, Set<Direction> set) {
        set.forEach(facing -> this.notifyNeighbors(worldIn, pos, state, (Direction)facing));
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, BlockState state) {
        Direction facing = (Direction)state.func_177229_b((IProperty)field_185512_D);
        this.notifyNeighbors(worldIn, pos, state, facing);
        this.notifyNeighbors(worldIn, pos, state, facing.func_176735_f());
    }

    protected void notifyNeighbors(World worldIn, BlockPos pos, BlockState state, Direction direction) {
        BlockPos blockpos = pos.func_177972_a(direction);
        if (ForgeEventFactory.onNeighborNotify((World)worldIn, (BlockPos)pos, (BlockState)worldIn.func_180495_p(pos), EnumSet.of(direction), (boolean)false).isCanceled()) {
            return;
        }
        worldIn.func_190524_a(blockpos, (Block)this, pos);
        worldIn.func_175695_a(blockpos, (Block)this, direction.func_176734_d());
    }

    protected void updateState(World world, BlockPos pos, BlockState state) {
        int j;
        int i;
        if (!world.field_72995_K && (i = ((Integer)state.func_177229_b((IProperty)POWER)).intValue()) != (j = this.calculateInputStrength(world, pos, state))) {
            state = (BlockState)state.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(j));
            world.func_180501_a(pos, state, 2);
            this.notifyNeighbors(world, pos, state);
        }
    }

    protected int calculateInputStrength(World world, BlockPos pos, BlockState state) {
        BlockState blockstate;
        Direction direction = (Direction)state.func_177229_b((IProperty)field_185512_D);
        BlockPos blockpos = pos.func_177972_a(direction);
        int i = world.func_175651_c(blockpos, direction);
        if (i >= 15) {
            return 15;
        }
        Direction direction2 = direction.func_176735_f();
        BlockPos blockpos2 = pos.func_177972_a(direction2);
        int i2 = world.func_175651_c(blockpos2, direction2);
        if (i2 >= 15) {
            return 15;
        }
        if (i == 0 && (blockstate = world.func_180495_p(blockpos)).func_177230_c() == Blocks.field_150488_af) {
            i = (Integer)blockstate.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O);
        }
        if (i2 == 0 && (blockstate = world.func_180495_p(blockpos2)).func_177230_c() == Blocks.field_150488_af) {
            i2 = (Integer)blockstate.func_177229_b((IProperty)RedstoneWireBlock.field_176351_O);
        }
        if (i < i2) {
            i = i2;
        }
        return i;
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.func_180656_a(blockState, blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.canConnectRedstone(blockState, blockAccess, pos, side) ? this.getActiveSignal(blockAccess, pos, blockState) : 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (state.func_196955_c((IWorldReader)worldIn, pos)) {
            Direction from = Direction.func_218383_a((int)(pos.func_177958_n() - fromPos.func_177958_n()), (int)(pos.func_177956_o() - fromPos.func_177956_o()), (int)(pos.func_177952_p() - fromPos.func_177952_p()));
            if (this.canConnectRedstone(state, (IBlockReader)worldIn, pos, from)) {
                this.updateState(worldIn, pos, state);
            }
        } else {
            TileEntity tileentity = state.hasTileEntity() ? worldIn.func_175625_s(pos) : null;
            RedstoneBenderBlock.func_220059_a((BlockState)state, (World)worldIn, (BlockPos)pos, (TileEntity)tileentity);
            worldIn.func_217377_a(pos, false);
        }
    }

    public boolean func_149744_f(BlockState state) {
        return true;
    }

    protected int getActiveSignal(IBlockReader worldIn, BlockPos pos, BlockState state) {
        int i = (Integer)state.func_177229_b((IProperty)POWER);
        return i > 0 ? i - 1 : 0;
    }

    public boolean canConnectRedstone(BlockState state, IBlockReader world, BlockPos pos, Direction side) {
        Direction facing = ((Direction)state.func_177229_b((IProperty)field_185512_D)).func_176734_d();
        return facing == side || facing.func_176735_f() == side;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        float f = (float)power / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (power == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)POWER);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            double d1 = (float)pos.func_177956_o() + 0.1875f;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.2;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{field_185512_D, POWER});
    }
}

