/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lupicus.rsx.block.ModBlocks;
import java.util.ArrayList;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstonePipeBlock
extends Block {
    public static final EnumProperty<RedstoneSide> REDSTONE_UP = EnumProperty.func_177709_a((String)"up", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> REDSTONE_DOWN = EnumProperty.func_177709_a((String)"down", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> UP = REDSTONE_UP;
    public static final EnumProperty<RedstoneSide> DOWN = REDSTONE_DOWN;
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final IntegerProperty POWER = RedstoneWireBlock.field_176351_O;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.NORTH, NORTH).put((Object)Direction.EAST, EAST).put((Object)Direction.SOUTH, SOUTH).put((Object)Direction.WEST, WEST).put((Object)Direction.UP, UP).put((Object)Direction.DOWN, DOWN).build());
    private RedstoneWireBlock wire = (RedstoneWireBlock)Blocks.field_150488_af;
    private final Set<BlockPos> blocksNeedingUpdate = Sets.newHashSet();

    public RedstonePipeBlock(Block.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE)).func_206870_a(UP, (Comparable)RedstoneSide.NONE)).func_206870_a(DOWN, (Comparable)RedstoneSide.NONE)).func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(0)));
    }

    public boolean func_220081_d(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.SOUTH))).func_206870_a(UP, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.UP))).func_206870_a(DOWN, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.DOWN));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.func_206870_a((IProperty)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((IBlockReader)worldIn, currentPos, facing));
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return RedstonePipeBlock.canConnectTo(blockstate, worldIn, blockpos, face) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    private BlockState updateSurroundingRedstone(World worldIn, BlockPos pos, BlockState state) {
        state = this.func_212568_b(worldIn, pos, state);
        ArrayList list = Lists.newArrayList(this.blocksNeedingUpdate);
        this.blocksNeedingUpdate.clear();
        for (BlockPos blockpos : list) {
            worldIn.func_195593_d(blockpos, (Block)this);
        }
        return state;
    }

    private BlockState func_212568_b(World world, BlockPos pos, BlockState stateIn) {
        int l;
        BlockState blockstate = stateIn;
        int i = (Integer)stateIn.func_177229_b((IProperty)POWER);
        int j = 0;
        this.wire.field_150181_a = false;
        j = world.func_175687_A(pos);
        this.wire.field_150181_a = true;
        int k = 0;
        if (j < 15) {
            for (Direction direction : Direction.values()) {
                BlockPos blockpos = pos.func_177972_a(direction);
                BlockState blockstate1 = world.func_180495_p(blockpos);
                k = this.maxSignal(k, blockstate1);
            }
        }
        if (j > (l = k - 1)) {
            l = j;
        }
        if (i != l) {
            stateIn = (BlockState)stateIn.func_206870_a((IProperty)POWER, (Comparable)Integer.valueOf(l));
            if (world.func_180495_p(pos) == blockstate) {
                world.func_180501_a(pos, stateIn, 2);
            }
            this.blocksNeedingUpdate.add(pos);
            for (Direction direction1 : Direction.values()) {
                this.blocksNeedingUpdate.add(pos.func_177972_a(direction1));
            }
        }
        return stateIn;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        Block test = worldIn.func_180495_p(pos).func_177230_c();
        if (test == this || test == Blocks.field_150488_af) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (oldState.func_177230_c() != state.func_177230_c() && !worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (Direction direction : Direction.values()) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction));
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && state.func_177230_c() != newState.func_177230_c()) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateSurroundingRedstone(worldIn, pos, state);
                for (Direction direction : Direction.values()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction));
                }
            }
        }
    }

    private int maxSignal(int existingSignal, BlockState neighbor) {
        Block test = neighbor.func_177230_c();
        if (test != this && test != Blocks.field_150488_af) {
            return existingSignal;
        }
        int i = (Integer)neighbor.func_177229_b((IProperty)POWER);
        return i > existingSignal ? i : existingSignal;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.wire.field_150181_a ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.wire.field_150181_a ? (Integer)blockState.func_177229_b((IProperty)POWER) : 0;
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        Block block = blockState.func_177230_c();
        if (block == Blocks.field_150488_af || block == ModBlocks.REDSTONE_PIPE_BLOCK) {
            return true;
        }
        if (block == Blocks.field_196633_cV) {
            Direction direction = (Direction)blockState.func_177229_b((IProperty)RepeaterBlock.field_185512_D);
            return direction == side || direction.func_176734_d() == side;
        }
        if (block == Blocks.field_190976_dk) {
            return side == blockState.func_177229_b((IProperty)ObserverBlock.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    public boolean func_149744_f(BlockState state) {
        return this.wire.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        float f = (float)power / 15.0f;
        float f1 = f * 0.6f + 0.4f;
        if (power == 0) {
            f1 = 0.3f;
        }
        float f2 = f * f * 0.7f - 0.5f;
        float f3 = f * f * 0.6f - 0.7f;
        int i = MathHelper.func_76125_a((int)((int)(f1 * 255.0f)), (int)0, (int)255);
        int j = MathHelper.func_76125_a((int)((int)(f2 * 255.0f)), (int)0, (int)255);
        int k = MathHelper.func_76125_a((int)((int)(f3 * 255.0f)), (int)0, (int)255);
        return 0xFF000000 | i << 16 | j << 8 | k;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((IProperty)POWER);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.8;
            double d1 = (double)pos.func_177956_o() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.8;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.8;
            float f = (float)i / 15.0f;
            float f1 = f * 0.6f + 0.4f;
            float f2 = Math.max(0.0f, f * f * 0.7f - 0.5f);
            float f3 = Math.max(0.0f, f * f * 0.6f - 0.7f);
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(f1, f2, f3, 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static Block getBlockHook(BlockState state) {
        Block block = state.func_177230_c();
        if (block == ModBlocks.REDSTONE_PIPE_BLOCK) {
            block = Blocks.field_150488_af;
        }
        return block;
    }

    public static int maxSignalHook(int existingSignal, BlockState neighbor) {
        Block test = neighbor.func_177230_c();
        if (test != ModBlocks.REDSTONE_PIPE_BLOCK && test != Blocks.field_150488_af) {
            return existingSignal;
        }
        int i = (Integer)neighbor.func_177229_b((IProperty)POWER);
        return i > existingSignal ? i : existingSignal;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, POWER});
    }
}

