/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lupicus.rsx.block.ModBlocks;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BluestoneWireBlock
extends Block {
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final IntegerProperty POWER = BlockStateProperties.field_208136_ak;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, NORTH, (Object)Direction.EAST, EAST, (Object)Direction.SOUTH, SOUTH, (Object)Direction.WEST, WEST));
    private static final VoxelShape DOT_SHAPE = Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0);
    private static final Map<Direction, VoxelShape> SIDE_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)1.0, (double)13.0), (Object)Direction.SOUTH, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)16.0), (Object)Direction.EAST, (Object)Block.func_208617_a((double)3.0, (double)0.0, (double)3.0, (double)16.0, (double)1.0, (double)13.0), (Object)Direction.WEST, (Object)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)));
    private static final Map<Direction, VoxelShape> UP_SHAPES = Maps.newEnumMap((Map)ImmutableMap.of((Object)Direction.NORTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_SHAPES.get(Direction.NORTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)1.0)), (Object)Direction.SOUTH, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_SHAPES.get(Direction.SOUTH), (VoxelShape)Block.func_208617_a((double)3.0, (double)0.0, (double)15.0, (double)13.0, (double)16.0, (double)16.0)), (Object)Direction.EAST, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_SHAPES.get(Direction.EAST), (VoxelShape)Block.func_208617_a((double)15.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0, (double)13.0)), (Object)Direction.WEST, (Object)VoxelShapes.func_197872_a((VoxelShape)SIDE_SHAPES.get(Direction.WEST), (VoxelShape)Block.func_208617_a((double)0.0, (double)0.0, (double)3.0, (double)1.0, (double)16.0, (double)13.0))));
    private final Map<BlockState, VoxelShape> shapes = Maps.newHashMap();
    private static final Vector3f[] COLORS = new Vector3f[16];
    private final BlockState powerDot;
    private RedstoneWireBlock wire = (RedstoneWireBlock)Blocks.field_150488_af;

    public BluestoneWireBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
        this.powerDot = (BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(EAST, (Comparable)RedstoneSide.SIDE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE)).func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
        for (BlockState blockstate : this.func_176194_O().func_177619_a()) {
            if ((Integer)blockstate.func_177229_b((Property)POWER) != 0) continue;
            this.shapes.put(blockstate, this.func_235554_l_(blockstate));
        }
    }

    private VoxelShape func_235554_l_(BlockState state) {
        VoxelShape voxelshape = DOT_SHAPE;
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.SIDE) {
                voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)SIDE_SHAPES.get(direction));
                continue;
            }
            if (redstoneside != RedstoneSide.UP) continue;
            voxelshape = VoxelShapes.func_197872_a((VoxelShape)voxelshape, (VoxelShape)UP_SHAPES.get(direction));
        }
        return voxelshape;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return this.shapes.get(state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        return this.getSides((IBlockReader)context.func_195991_k(), this.powerDot, context.func_195995_a());
    }

    private BlockState getSides(IBlockReader world, BlockState state, BlockPos pos) {
        boolean flag = BluestoneWireBlock.isAllOff(state);
        state = this.getOffSides(world, (BlockState)this.func_176223_P().func_206870_a((Property)POWER, state.func_177229_b((Property)POWER)), pos);
        if (flag && BluestoneWireBlock.isAllOff(state)) {
            return state;
        }
        boolean flag1 = ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_();
        boolean flag2 = ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_();
        boolean flag3 = ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_();
        boolean flag4 = ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
        if (!flag1 && !flag2) {
            if (!flag4) {
                state = (BlockState)state.func_206870_a(WEST, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag3) {
                state = (BlockState)state.func_206870_a(EAST, (Comparable)RedstoneSide.SIDE);
            }
        }
        if (!flag3 && !flag4) {
            if (!flag1) {
                state = (BlockState)state.func_206870_a(NORTH, (Comparable)RedstoneSide.SIDE);
            }
            if (!flag2) {
                state = (BlockState)state.func_206870_a(SOUTH, (Comparable)RedstoneSide.SIDE);
            }
        }
        return state;
    }

    private BlockState getOffSides(IBlockReader world, BlockState state, BlockPos pos) {
        boolean flag = !world.func_180495_p(pos.func_177984_a()).func_215686_e(world, pos);
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            EnumProperty<RedstoneSide> prop = FACING_PROPERTY_MAP.get(direction);
            if (((RedstoneSide)state.func_177229_b(prop)).func_235921_b_()) continue;
            state = (BlockState)state.func_206870_a(prop, (Comparable)this.getSide(world, pos, direction, flag));
        }
        return state;
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        if (facing == Direction.DOWN) {
            return stateIn;
        }
        if (facing == Direction.UP) {
            return this.getSides((IBlockReader)worldIn, stateIn, currentPos);
        }
        RedstoneSide redstoneside = this.getSide((IBlockReader)worldIn, currentPos, facing);
        return redstoneside.func_235921_b_() == ((RedstoneSide)stateIn.func_177229_b((Property)FACING_PROPERTY_MAP.get(facing))).func_235921_b_() && !BluestoneWireBlock.isAllOn(stateIn) ? (BlockState)stateIn.func_206870_a((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside) : this.getSides((IBlockReader)worldIn, (BlockState)((BlockState)this.powerDot.func_206870_a((Property)POWER, stateIn.func_177229_b((Property)POWER))).func_206870_a((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)redstoneside), currentPos);
    }

    private static boolean isAllOn(BlockState state) {
        return ((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && ((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    private static boolean isAllOff(BlockState state) {
        return !((RedstoneSide)state.func_177229_b(NORTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(SOUTH)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(EAST)).func_235921_b_() && !((RedstoneSide)state.func_177229_b(WEST)).func_235921_b_();
    }

    public void func_196248_b(BlockState state, IWorld worldIn, BlockPos pos, int flags, int p_196248_5_) {
        BlockPos.Mutable blockpos$mutable = new BlockPos.Mutable();
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            RedstoneSide redstoneside = (RedstoneSide)state.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction));
            if (redstoneside == RedstoneSide.NONE || worldIn.func_180495_p((BlockPos)blockpos$mutable.func_239622_a_((Vector3i)pos, direction)).func_203425_a((Block)this)) continue;
            blockpos$mutable.func_189536_c(Direction.DOWN);
            BlockState blockstate = worldIn.func_180495_p((BlockPos)blockpos$mutable);
            if (!blockstate.func_203425_a(Blocks.field_190976_dk)) {
                BlockPos blockpos = blockpos$mutable.func_177972_a(direction.func_176734_d());
                BlockState blockstate1 = blockstate.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos), worldIn, (BlockPos)blockpos$mutable, blockpos);
                BluestoneWireBlock.func_241468_a_((BlockState)blockstate, (BlockState)blockstate1, (IWorld)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)p_196248_5_);
            }
            blockpos$mutable.func_239622_a_((Vector3i)pos, direction).func_189536_c(Direction.UP);
            BlockState blockstate3 = worldIn.func_180495_p((BlockPos)blockpos$mutable);
            if (blockstate3.func_203425_a(Blocks.field_190976_dk)) continue;
            BlockPos blockpos1 = blockpos$mutable.func_177972_a(direction.func_176734_d());
            BlockState blockstate2 = blockstate3.func_196956_a(direction.func_176734_d(), worldIn.func_180495_p(blockpos1), worldIn, (BlockPos)blockpos$mutable, blockpos1);
            BluestoneWireBlock.func_241468_a_((BlockState)blockstate3, (BlockState)blockstate2, (IWorld)worldIn, (BlockPos)blockpos$mutable, (int)flags, (int)p_196248_5_);
        }
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos1 = pos.func_177984_a();
        return this.getSide(worldIn, pos, face, !worldIn.func_180495_p(blockpos1).func_215686_e(worldIn, blockpos1));
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face, boolean checkUp) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        if (checkUp) {
            boolean flag;
            boolean bl = flag = blockstate.func_224755_d(worldIn, blockpos, Direction.UP) || blockstate.func_203425_a(Blocks.field_150438_bZ);
            if (flag && BluestoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177984_a()), worldIn, blockpos.func_177984_a(), null)) {
                if (blockstate.func_224755_d(worldIn, blockpos, face.func_176734_d())) {
                    return RedstoneSide.UP;
                }
                return RedstoneSide.SIDE;
            }
        }
        return !BluestoneWireBlock.canConnectTo(blockstate, worldIn, blockpos, face) && (blockstate.func_215686_e(worldIn, blockpos) || !BluestoneWireBlock.canConnectTo(worldIn.func_180495_p(blockpos.func_177977_b()), worldIn, blockpos.func_177977_b(), null)) ? RedstoneSide.NONE : RedstoneSide.SIDE;
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockPos blockpos = pos.func_177977_b();
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return blockstate.func_224755_d((IBlockReader)worldIn, blockpos, Direction.UP) || blockstate.func_203425_a(Blocks.field_150438_bZ);
    }

    private void updateSurroundingRedstone(World worldIn, BlockPos pos, BlockState state) {
        int i = this.func_235546_a_(worldIn, pos, state);
        if ((Integer)state.func_177229_b((Property)POWER) != i) {
            if (worldIn.func_180495_p(pos) == state) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction : Direction.values()) {
                set.add(pos.func_177972_a(direction));
            }
            for (BlockPos blockpos : set) {
                worldIn.func_195593_d(blockpos, (Block)this);
            }
        }
    }

    private int func_235546_a_(World world, BlockPos posIn, BlockState state) {
        this.wire.field_150181_a = false;
        int i = world.func_175687_A(posIn);
        this.wire.field_150181_a = true;
        int j = 0;
        if (i < 15) {
            BlockPos blockpos1 = posIn.func_177984_a();
            Boolean isUpNormal = world.func_180495_p(blockpos1).func_215686_e((IBlockReader)world, blockpos1);
            for (Direction direction : Direction.Plane.HORIZONTAL) {
                BlockPos blockpos = posIn.func_177972_a(direction);
                BlockState blockstate1 = world.func_180495_p(blockpos);
                j = Math.max(j, this.getPower(blockstate1));
                if (blockstate1.func_215686_e((IBlockReader)world, blockpos)) {
                    if (isUpNormal.booleanValue()) continue;
                    j = Math.max(j, this.getPower(world.func_180495_p(blockpos.func_177984_a())));
                    continue;
                }
                j = Math.max(j, this.getPower(world.func_180495_p(blockpos.func_177977_b())));
            }
        }
        return Math.max(i, j - 1);
    }

    private int getPower(BlockState neighbor) {
        return neighbor.func_203425_a((Block)this) ? (Integer)neighbor.func_177229_b((Property)POWER) : 0;
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        if (worldIn.func_180495_p(pos).func_203425_a((Block)this)) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c()) && !worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (Direction direction : Direction.Plane.VERTICAL) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
            this.func_235553_d_(worldIn, pos);
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateSurroundingRedstone(worldIn, pos, state);
                this.func_235553_d_(worldIn, pos);
            }
        }
    }

    private void func_235553_d_(World world, BlockPos pos) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            this.notifyWireNeighborsOfStateChange(world, pos.func_177972_a(direction));
        }
        for (Direction direction1 : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction1);
            if (world.func_180495_p(blockpos).func_215686_e((IBlockReader)world, blockpos)) {
                this.notifyWireNeighborsOfStateChange(world, blockpos.func_177984_a());
                continue;
            }
            this.notifyWireNeighborsOfStateChange(world, blockpos.func_177977_b());
        }
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            if (state.func_196955_c((IWorldReader)worldIn, pos)) {
                this.updateSurroundingRedstone(worldIn, pos, state);
            } else {
                BluestoneWireBlock.func_220075_c((BlockState)state, (World)worldIn, (BlockPos)pos);
                worldIn.func_217377_a(pos, false);
            }
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return !this.wire.field_150181_a ? 0 : blockState.func_185911_a(blockAccess, pos, side);
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        if (!this.wire.field_150181_a || side == Direction.DOWN) {
            return 0;
        }
        int i = (Integer)blockState.func_177229_b((Property)POWER);
        if (i == 0) {
            return 0;
        }
        return side == Direction.UP || ((RedstoneSide)this.getSides(blockAccess, blockState, pos).func_177229_b((Property)FACING_PROPERTY_MAP.get(side.func_176734_d()))).func_235921_b_() ? i : 0;
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (blockState.func_203425_a(ModBlocks.BLUESTONE_WIRE)) {
            return true;
        }
        if (blockState.func_203425_a(Blocks.field_150488_af) || blockState.func_203425_a(ModBlocks.REDSTONE_PIPE_BLOCK)) {
            return false;
        }
        if (blockState.func_203425_a(Blocks.field_196633_cV)) {
            Direction direction = (Direction)blockState.func_177229_b((Property)RepeaterBlock.field_185512_D);
            return direction == side || direction.func_176734_d() == side;
        }
        if (blockState.func_203425_a(Blocks.field_190976_dk)) {
            return side == blockState.func_177229_b((Property)ObserverBlock.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    public boolean func_149744_f(BlockState state) {
        return this.wire.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        Vector3f vector3f = COLORS[power];
        return MathHelper.func_180183_b((float)vector3f.func_195899_a(), (float)vector3f.func_195900_b(), (float)vector3f.func_195902_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    private void doParticle(World world, Random rand, BlockPos pos, Vector3f vec, Direction dir1, Direction dir2, float fv1, float fv2) {
        float f = fv2 - fv1;
        if (!(rand.nextFloat() >= 0.2f * f)) {
            float f1 = 0.4375f;
            float f2 = fv1 + f * rand.nextFloat();
            double d0 = 0.5 + (double)(f1 * (float)dir1.func_82601_c()) + (double)(f2 * (float)dir2.func_82601_c());
            double d1 = 0.5 + (double)(f1 * (float)dir1.func_96559_d()) + (double)(f2 * (float)dir2.func_96559_d());
            double d2 = 0.5 + (double)(f1 * (float)dir1.func_82599_e()) + (double)(f2 * (float)dir2.func_82599_e());
            world.func_195594_a((IParticleData)new RedstoneParticleData(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c(), 1.0f), (double)pos.func_177958_n() + d0, (double)pos.func_177956_o() + d1, (double)pos.func_177952_p() + d2, 0.0, 0.0, 0.0);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((Property)POWER);
        if (i != 0) {
            block4: for (Direction direction : Direction.Plane.HORIZONTAL) {
                RedstoneSide redstoneside = (RedstoneSide)stateIn.func_177229_b((Property)FACING_PROPERTY_MAP.get(direction));
                switch (redstoneside) {
                    case UP: {
                        this.doParticle(worldIn, rand, pos, COLORS[i], direction, Direction.UP, -0.5f, 0.5f);
                    }
                    case SIDE: {
                        this.doParticle(worldIn, rand, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.5f);
                        continue block4;
                    }
                }
                this.doParticle(worldIn, rand, pos, COLORS[i], Direction.DOWN, direction, 0.0f, 0.3f);
            }
        }
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, POWER});
    }

    public ActionResultType func_225533_a_(BlockState state, World worldIn, BlockPos pos, PlayerEntity player, Hand handIn, BlockRayTraceResult hit) {
        if (!player.field_71075_bZ.field_75099_e) {
            return ActionResultType.PASS;
        }
        boolean flag = BluestoneWireBlock.isAllOn(state);
        if (flag || BluestoneWireBlock.isAllOff(state)) {
            BlockState blockstate = flag ? this.func_176223_P() : this.powerDot;
            blockstate = (BlockState)blockstate.func_206870_a((Property)POWER, state.func_177229_b((Property)POWER));
            if ((blockstate = this.getSides((IBlockReader)worldIn, blockstate, pos)) != state) {
                worldIn.func_180501_a(pos, blockstate, 3);
                this.notifyChangedSides(worldIn, pos, state, blockstate);
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    private void notifyChangedSides(World world, BlockPos pos, BlockState oldState, BlockState state) {
        for (Direction direction : Direction.Plane.HORIZONTAL) {
            BlockPos blockpos = pos.func_177972_a(direction);
            EnumProperty<RedstoneSide> prop = FACING_PROPERTY_MAP.get(direction);
            if (((RedstoneSide)oldState.func_177229_b(prop)).func_235921_b_() == ((RedstoneSide)state.func_177229_b(prop)).func_235921_b_() || !world.func_180495_p(blockpos).func_215686_e((IBlockReader)world, blockpos)) continue;
            world.func_175695_a(blockpos, state.func_177230_c(), direction.func_176734_d());
        }
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f3 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = MathHelper.func_76131_a((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f1 = MathHelper.func_76131_a((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            BluestoneWireBlock.COLORS[i] = new Vector3f(f1, f2, f3);
        }
    }
}

