/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.block;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.lupicus.rsx.block.ModBlocks;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.ObserverBlock;
import net.minecraft.block.RedstoneWireBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.RedstoneParticleData;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.state.properties.RedstoneSide;
import net.minecraft.util.Direction;
import net.minecraft.util.Mirror;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class RedstonePipeBlock
extends Block {
    public static final EnumProperty<RedstoneSide> REDSTONE_UP = EnumProperty.func_177709_a((String)"up", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> REDSTONE_DOWN = EnumProperty.func_177709_a((String)"down", RedstoneSide.class);
    public static final EnumProperty<RedstoneSide> UP = REDSTONE_UP;
    public static final EnumProperty<RedstoneSide> DOWN = REDSTONE_DOWN;
    public static final EnumProperty<RedstoneSide> NORTH = BlockStateProperties.field_208160_M;
    public static final EnumProperty<RedstoneSide> EAST = BlockStateProperties.field_208159_L;
    public static final EnumProperty<RedstoneSide> SOUTH = BlockStateProperties.field_208161_N;
    public static final EnumProperty<RedstoneSide> WEST = BlockStateProperties.field_208162_O;
    public static final IntegerProperty POWER = RedstoneWireBlock.field_176351_O;
    public static final Map<Direction, EnumProperty<RedstoneSide>> FACING_PROPERTY_MAP = Maps.newEnumMap((Map)ImmutableMap.builder().put((Object)Direction.NORTH, NORTH).put((Object)Direction.EAST, EAST).put((Object)Direction.SOUTH, SOUTH).put((Object)Direction.WEST, WEST).put((Object)Direction.UP, UP).put((Object)Direction.DOWN, DOWN).build());
    private static final Vector3f[] COLORS = new Vector3f[16];
    private RedstoneWireBlock wire = (RedstoneWireBlock)Blocks.field_150488_af;

    public RedstonePipeBlock(AbstractBlock.Properties properties) {
        super(properties);
        this.func_180632_j((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a(NORTH, (Comparable)RedstoneSide.NONE)).func_206870_a(EAST, (Comparable)RedstoneSide.NONE)).func_206870_a(SOUTH, (Comparable)RedstoneSide.NONE)).func_206870_a(WEST, (Comparable)RedstoneSide.NONE)).func_206870_a(UP, (Comparable)RedstoneSide.NONE)).func_206870_a(DOWN, (Comparable)RedstoneSide.NONE)).func_206870_a((Property)POWER, (Comparable)Integer.valueOf(0)));
    }

    public static boolean isNormalCube(BlockState state, IBlockReader worldIn, BlockPos pos) {
        return false;
    }

    public BlockState func_196258_a(BlockItemUseContext context) {
        World iblockreader = context.func_195991_k();
        BlockPos blockpos = context.func_195995_a();
        return (BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.func_176223_P().func_206870_a(WEST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.WEST))).func_206870_a(EAST, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.EAST))).func_206870_a(NORTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.NORTH))).func_206870_a(SOUTH, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.SOUTH))).func_206870_a(UP, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.UP))).func_206870_a(DOWN, (Comparable)this.getSide((IBlockReader)iblockreader, blockpos, Direction.DOWN));
    }

    public BlockState func_196271_a(BlockState stateIn, Direction facing, BlockState facingState, IWorld worldIn, BlockPos currentPos, BlockPos facingPos) {
        return (BlockState)stateIn.func_206870_a((Property)FACING_PROPERTY_MAP.get(facing), (Comparable)this.getSide((IBlockReader)worldIn, currentPos, facing));
    }

    private RedstoneSide getSide(IBlockReader worldIn, BlockPos pos, Direction face) {
        BlockPos blockpos = pos.func_177972_a(face);
        BlockState blockstate = worldIn.func_180495_p(blockpos);
        return RedstonePipeBlock.canConnectTo(blockstate, worldIn, blockpos, face) ? RedstoneSide.SIDE : RedstoneSide.NONE;
    }

    private void updateSurroundingRedstone(World worldIn, BlockPos pos, BlockState state) {
        int i = this.func_212568_b(worldIn, pos);
        if ((Integer)state.func_177229_b((Property)POWER) != i) {
            if (worldIn.func_180495_p(pos) == state) {
                worldIn.func_180501_a(pos, (BlockState)state.func_206870_a((Property)POWER, (Comparable)Integer.valueOf(i)), 2);
            }
            HashSet set = Sets.newHashSet();
            set.add(pos);
            for (Direction direction1 : Direction.values()) {
                set.add(pos.func_177972_a(direction1));
            }
            for (BlockPos blockpos : set) {
                worldIn.func_195593_d(blockpos, (Block)this);
            }
        }
    }

    private int func_212568_b(World world, BlockPos pos) {
        this.wire.field_150181_a = false;
        int i = world.func_175687_A(pos);
        this.wire.field_150181_a = true;
        int j = 0;
        if (i < 15) {
            for (Direction direction : Direction.values()) {
                BlockState blockstate1 = world.func_180495_p(pos.func_177972_a(direction));
                j = Math.max(j, this.getPower(blockstate1));
            }
        }
        return Math.max(i, j - 1);
    }

    private void notifyWireNeighborsOfStateChange(World worldIn, BlockPos pos) {
        BlockState state = worldIn.func_180495_p(pos);
        if (state.func_203425_a((Block)this) || state.func_203425_a(Blocks.field_150488_af)) {
            worldIn.func_195593_d(pos, (Block)this);
            for (Direction direction : Direction.values()) {
                worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
            }
        }
    }

    public void func_220082_b(BlockState state, World worldIn, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!oldState.func_203425_a(state.func_177230_c()) && !worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
            for (Direction direction : Direction.values()) {
                this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction));
            }
        }
    }

    public void func_196243_a(BlockState state, World worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        if (!isMoving && !state.func_203425_a(newState.func_177230_c())) {
            super.func_196243_a(state, worldIn, pos, newState, isMoving);
            if (!worldIn.field_72995_K) {
                for (Direction direction : Direction.values()) {
                    worldIn.func_195593_d(pos.func_177972_a(direction), (Block)this);
                }
                this.updateSurroundingRedstone(worldIn, pos, state);
                for (Direction direction : Direction.values()) {
                    this.notifyWireNeighborsOfStateChange(worldIn, pos.func_177972_a(direction));
                }
            }
        }
    }

    private int getPower(BlockState neighbor) {
        return neighbor.func_203425_a((Block)this) || neighbor.func_203425_a(Blocks.field_150488_af) ? (Integer)neighbor.func_177229_b((Property)POWER) : 0;
    }

    public void func_220069_a(BlockState state, World worldIn, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (!worldIn.field_72995_K) {
            this.updateSurroundingRedstone(worldIn, pos, state);
        }
    }

    public int func_176211_b(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.wire.field_150181_a ? blockState.func_185911_a(blockAccess, pos, side) : 0;
    }

    public int func_180656_a(BlockState blockState, IBlockReader blockAccess, BlockPos pos, Direction side) {
        return this.wire.field_150181_a ? (Integer)blockState.func_177229_b((Property)POWER) : 0;
    }

    protected static boolean canConnectTo(BlockState blockState, IBlockReader world, BlockPos pos, @Nullable Direction side) {
        if (blockState.func_203425_a(Blocks.field_150488_af) || blockState.func_203425_a(ModBlocks.REDSTONE_PIPE_BLOCK)) {
            return true;
        }
        if (blockState.func_203425_a(Blocks.field_196633_cV)) {
            Direction direction = (Direction)blockState.func_177229_b((Property)RepeaterBlock.field_185512_D);
            return direction == side || direction.func_176734_d() == side;
        }
        if (blockState.func_203425_a(Blocks.field_190976_dk)) {
            return side == blockState.func_177229_b((Property)ObserverBlock.field_176387_N);
        }
        return blockState.canConnectRedstone(world, pos, side) && side != null;
    }

    public boolean func_149744_f(BlockState state) {
        return this.wire.field_150181_a;
    }

    @OnlyIn(value=Dist.CLIENT)
    public static int colorMultiplier(int power) {
        Vector3f vector3f = COLORS[power];
        return MathHelper.func_180183_b((float)vector3f.func_195899_a(), (float)vector3f.func_195900_b(), (float)vector3f.func_195902_c());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        int i = (Integer)stateIn.func_177229_b((Property)POWER);
        if (i != 0) {
            double d0 = (double)pos.func_177958_n() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.8;
            double d1 = (double)pos.func_177956_o() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.8;
            double d2 = (double)pos.func_177952_p() + 0.5 + ((double)rand.nextFloat() - 0.5) * 0.8;
            Vector3f vec = COLORS[i];
            worldIn.func_195594_a((IParticleData)new RedstoneParticleData(vec.func_195899_a(), vec.func_195900_b(), vec.func_195902_c(), 1.0f), d0, d1, d2, 0.0, 0.0, 0.0);
        }
    }

    public static int getPowerHook(BlockState neighbor) {
        return neighbor.func_203425_a(ModBlocks.REDSTONE_PIPE_BLOCK) || neighbor.func_203425_a(Blocks.field_150488_af) ? (Integer)neighbor.func_177229_b((Property)POWER) : 0;
    }

    public BlockState func_185499_a(BlockState state, Rotation rot) {
        switch (rot) {
            case CLOCKWISE_180: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(SOUTH, state.func_177229_b(NORTH))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
            case COUNTERCLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(EAST))).func_206870_a(EAST, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(NORTH));
            }
            case CLOCKWISE_90: {
                return (BlockState)((BlockState)((BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(WEST))).func_206870_a(EAST, state.func_177229_b(NORTH))).func_206870_a(SOUTH, state.func_177229_b(EAST))).func_206870_a(WEST, state.func_177229_b(SOUTH));
            }
        }
        return state;
    }

    public BlockState func_185471_a(BlockState state, Mirror mirrorIn) {
        switch (mirrorIn) {
            case LEFT_RIGHT: {
                return (BlockState)((BlockState)state.func_206870_a(NORTH, state.func_177229_b(SOUTH))).func_206870_a(SOUTH, state.func_177229_b(NORTH));
            }
            case FRONT_BACK: {
                return (BlockState)((BlockState)state.func_206870_a(EAST, state.func_177229_b(WEST))).func_206870_a(WEST, state.func_177229_b(EAST));
            }
        }
        return super.func_185471_a(state, mirrorIn);
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new Property[]{NORTH, EAST, SOUTH, WEST, UP, DOWN, POWER});
    }

    static {
        for (int i = 0; i <= 15; ++i) {
            float f;
            float f1 = f * 0.6f + ((f = (float)i / 15.0f) > 0.0f ? 0.4f : 0.3f);
            float f2 = MathHelper.func_76131_a((float)(f * f * 0.7f - 0.5f), (float)0.0f, (float)1.0f);
            float f3 = MathHelper.func_76131_a((float)(f * f * 0.6f - 0.7f), (float)0.0f, (float)1.0f);
            RedstonePipeBlock.COLORS[i] = new Vector3f(f1, f2, f3);
        }
    }
}

