/*
 * Decompiled with CFR 0.152.
 */
package com.lupicus.rsx.tileentity;

import com.lupicus.rsx.block.RedstoneEnergyBlock;
import com.lupicus.rsx.config.MyConfig;
import com.lupicus.rsx.tileentity.ModTileEntities;
import net.minecraft.block.BlockState;
import net.minecraft.state.Property;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.common.util.NonNullSupplier;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class RedstoneEnergyTileEntity
extends TileEntity
implements IEnergyStorage,
ITickableTileEntity,
ICapabilityProvider {
    private int count = -1;
    private int energy = -1;
    private IEnergyStorage[] sides = new IEnergyStorage[6];

    public RedstoneEnergyTileEntity() {
        super(ModTileEntities.REDSTONE_ENERGY_BLOCK);
    }

    public void func_73660_a() {
        if (!this.field_145850_b.field_72995_K && this.count != 0) {
            if (this.count < 0) {
                this.updateSides();
            }
            if (this.count > 0) {
                this.giveToNeighbors();
            }
        }
    }

    public void neighborChanged() {
        this.count = -1;
        this.energy = -1;
    }

    private void giveToNeighbors() {
        int i;
        int[] want = new int[6];
        int total = 0;
        int num = 0;
        int max = this.getEnergyStored();
        for (i = 0; i < 6; ++i) {
            if (this.sides[i] != null) {
                want[i] = this.sides[i].receiveEnergy(max, true);
                if (want[i] > 0) {
                    ++num;
                }
            } else {
                want[i] = 0;
            }
            total += want[i];
        }
        if (num == 0) {
            return;
        }
        if (num == 1) {
            for (i = 0; i < 6; ++i) {
                if (want[i] <= 0) continue;
                this.sides[i].receiveEnergy(max, false);
                break;
            }
        } else if (total <= max) {
            for (i = 0; i < 6; ++i) {
                if (want[i] <= 0) continue;
                this.sides[i].receiveEnergy(want[i], false);
            }
        } else {
            int i2;
            total = max;
            int avg = total / num;
            int[] send = new int[6];
            for (i2 = 0; i2 < 6; ++i2) {
                send[i2] = want[i2] <= avg ? want[i2] : avg;
                total -= send[i2];
            }
            if (total > 0) {
                for (i2 = 0; i2 < 6; ++i2) {
                    int more = want[i2] - send[i2];
                    if (more <= 0) continue;
                    if (more >= total) {
                        int n = i2;
                        send[n] = send[n] + total;
                        break;
                    }
                    int n = i2;
                    send[n] = send[n] + more;
                    total -= more;
                }
            }
            for (i2 = 0; i2 < 6; ++i2) {
                if (send[i2] <= 0) continue;
                this.sides[i2].receiveEnergy(send[i2], false);
            }
        }
    }

    private void updateSides() {
        this.count = 0;
        BlockPos pos = this.func_174877_v();
        for (Direction dir : Direction.values()) {
            IEnergyStorage storage = null;
            BlockPos otherPos = pos.func_177972_a(dir);
            BlockState other = this.field_145850_b.func_180495_p(otherPos);
            if (other.hasTileEntity()) {
                TileEntity te = this.field_145850_b.func_175625_s(otherPos);
                if (te instanceof IEnergyStorage) {
                    storage = (IEnergyStorage)te;
                } else {
                    LazyOptional opt = te.getCapability(CapabilityEnergy.ENERGY, dir.func_176734_d());
                    if (opt.isPresent()) {
                        storage = (IEnergyStorage)opt.orElse(null);
                    }
                }
            }
            this.sides[dir.func_176745_a()] = storage;
            if (storage == null) continue;
            ++this.count;
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap == CapabilityEnergy.ENERGY) {
            return LazyOptional.of((NonNullSupplier)((NonNullSupplier)this));
        }
        return super.getCapability(cap, side);
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (maxExtract > 0) {
            int amount = this.getEnergyStored();
            if (maxExtract < amount) {
                amount = maxExtract;
            }
            return amount;
        }
        return 0;
    }

    public int getEnergyStored() {
        if (this.energy < 0) {
            BlockState blockstate = this.func_195044_w();
            this.energy = (int)((double)((Integer)blockstate.func_177229_b((Property)RedstoneEnergyBlock.POWER)).intValue() * MyConfig.energyFactor);
        }
        return this.energy;
    }

    public int getMaxEnergyStored() {
        return this.getEnergyStored();
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return false;
    }
}

