/*
 * Decompiled with CFR 0.152.
 */
package api.player.render;

import java.util.Map;
import java.util.Stack;
import org.objectweb.asm.MethodVisitor;

public final class RenderPlayerConstructorVisitor
extends MethodVisitor {
    private final boolean isObfuscated;
    private final Map<String, Stack<String>> constructorReplacements;

    public RenderPlayerConstructorVisitor(MethodVisitor paramMethodVisitor, boolean isObfuscated, Map<String, Stack<String>> constructorReplacements) {
        super(262144, paramMethodVisitor);
        this.isObfuscated = isObfuscated;
        this.constructorReplacements = constructorReplacements;
    }

    public void visitTypeInsn(int opcode, String type) {
        if (opcode == 187 && this.constructorReplacements != null && this.constructorReplacements.containsKey(type)) {
            int typeSeparatorIndex;
            Stack<String> replacementOwnerList = this.constructorReplacements.get(type);
            if (!replacementOwnerList.isEmpty()) {
                type = replacementOwnerList.peek();
            }
            if ((typeSeparatorIndex = type.indexOf(":")) > 0) {
                type = type.substring(0, typeSeparatorIndex);
            }
        }
        super.visitTypeInsn(opcode, type);
    }

    public void visitMethodInsn(int opcode, String owner, String name, String desc, boolean itf) {
        if (name.equals("<init>") && this.constructorReplacements != null && this.constructorReplacements.containsKey(owner)) {
            int typeSeparatorIndex;
            Stack<String> replacementOwnerList = this.constructorReplacements.get(owner);
            if (!replacementOwnerList.isEmpty()) {
                owner = replacementOwnerList.pop();
            }
            if ((typeSeparatorIndex = owner.indexOf(":")) > 0) {
                this.mv.visitLdcInsn((Object)owner.substring(typeSeparatorIndex + 1));
                owner = owner.substring(0, typeSeparatorIndex);
                int resultSeparatorIndex = desc.indexOf(")");
                desc = desc.substring(0, resultSeparatorIndex) + "Ljava/lang/String;" + desc.substring(resultSeparatorIndex);
            }
        }
        super.visitMethodInsn(opcode, owner, name, desc, itf);
        if (name.equals("<init>") && owner.equals(this.isObfuscated ? "caa" : "net/minecraft/client/renderer/entity/RenderLivingBase")) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 0);
            this.mv.visitMethodInsn(184, "api/player/render/RenderPlayerAPI", "create", "(Lapi/player/render/IRenderPlayerAPI;)Lapi/player/render/RenderPlayerAPI;", false);
            this.mv.visitFieldInsn(181, this.isObfuscated ? "cct" : "net/minecraft/client/renderer/entity/RenderPlayer", "renderPlayerAPI", "Lapi/player/render/RenderPlayerAPI;");
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(21, 2);
            this.mv.visitMethodInsn(184, "api/player/render/RenderPlayerAPI", "beforeLocalConstructing", "(Lapi/player/render/IRenderPlayerAPI;Lnet/minecraft/client/renderer/entity/RenderManager;Z)V", false);
        }
    }

    public void visitInsn(int opcode) {
        if (opcode == 177) {
            this.mv.visitVarInsn(25, 0);
            this.mv.visitVarInsn(25, 1);
            this.mv.visitVarInsn(21, 2);
            this.mv.visitMethodInsn(184, "api/player/render/RenderPlayerAPI", "afterLocalConstructing", "(Lapi/player/render/IRenderPlayerAPI;Lnet/minecraft/client/renderer/entity/RenderManager;Z)V", false);
        }
        super.visitInsn(opcode);
    }
}

