/*
 * Decompiled with CFR 0.152.
 */
package api.player.model;

import api.player.forge.RenderPlayerAPIPlugin;
import api.player.model.IModelPlayerAPI;
import api.player.model.ModelPlayerBase;
import api.player.model.ModelPlayerBaseSorter;
import api.player.model.ModelPlayerBaseSorting;
import java.io.File;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.logging.Logger;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.model.ModelBiped;
import net.minecraft.client.model.ModelPlayer;
import net.minecraft.client.model.ModelRenderer;
import net.minecraft.client.model.TextureOffset;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.EnumHandSide;

public final class ModelPlayerAPI {
    private static final Class<?>[] Class = new Class[]{ModelPlayerAPI.class};
    private static final Class<?>[] Classes = new Class[]{ModelPlayerAPI.class, String.class};
    private static boolean isCreated;
    private static final Logger logger;
    private static List<WeakReference<IModelPlayerAPI>> allInstances;
    private static final Map<String, String[]> EmptySortMap;
    private static final List<String> beforeGetArmForSideHookTypes;
    private static final List<String> overrideGetArmForSideHookTypes;
    private static final List<String> afterGetArmForSideHookTypes;
    private ModelPlayerBase[] beforeGetArmForSideHooks;
    private ModelPlayerBase[] overrideGetArmForSideHooks;
    private ModelPlayerBase[] afterGetArmForSideHooks;
    public boolean isGetArmForSideModded;
    private static final Map<String, String[]> allBaseBeforeGetArmForSideSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetArmForSideInferiors;
    private static final Map<String, String[]> allBaseOverrideGetArmForSideSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetArmForSideInferiors;
    private static final Map<String, String[]> allBaseAfterGetArmForSideSuperiors;
    private static final Map<String, String[]> allBaseAfterGetArmForSideInferiors;
    private static final List<String> beforeGetMainHandHookTypes;
    private static final List<String> overrideGetMainHandHookTypes;
    private static final List<String> afterGetMainHandHookTypes;
    private ModelPlayerBase[] beforeGetMainHandHooks;
    private ModelPlayerBase[] overrideGetMainHandHooks;
    private ModelPlayerBase[] afterGetMainHandHooks;
    public boolean isGetMainHandModded;
    private static final Map<String, String[]> allBaseBeforeGetMainHandSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetMainHandInferiors;
    private static final Map<String, String[]> allBaseOverrideGetMainHandSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetMainHandInferiors;
    private static final Map<String, String[]> allBaseAfterGetMainHandSuperiors;
    private static final Map<String, String[]> allBaseAfterGetMainHandInferiors;
    private static final List<String> beforeGetRandomModelBoxHookTypes;
    private static final List<String> overrideGetRandomModelBoxHookTypes;
    private static final List<String> afterGetRandomModelBoxHookTypes;
    private ModelPlayerBase[] beforeGetRandomModelBoxHooks;
    private ModelPlayerBase[] overrideGetRandomModelBoxHooks;
    private ModelPlayerBase[] afterGetRandomModelBoxHooks;
    public boolean isGetRandomModelBoxModded;
    private static final Map<String, String[]> allBaseBeforeGetRandomModelBoxSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetRandomModelBoxInferiors;
    private static final Map<String, String[]> allBaseOverrideGetRandomModelBoxSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetRandomModelBoxInferiors;
    private static final Map<String, String[]> allBaseAfterGetRandomModelBoxSuperiors;
    private static final Map<String, String[]> allBaseAfterGetRandomModelBoxInferiors;
    private static final List<String> beforeGetTextureOffsetHookTypes;
    private static final List<String> overrideGetTextureOffsetHookTypes;
    private static final List<String> afterGetTextureOffsetHookTypes;
    private ModelPlayerBase[] beforeGetTextureOffsetHooks;
    private ModelPlayerBase[] overrideGetTextureOffsetHooks;
    private ModelPlayerBase[] afterGetTextureOffsetHooks;
    public boolean isGetTextureOffsetModded;
    private static final Map<String, String[]> allBaseBeforeGetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseBeforeGetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseOverrideGetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseOverrideGetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseAfterGetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseAfterGetTextureOffsetInferiors;
    private static final List<String> beforePostRenderArmHookTypes;
    private static final List<String> overridePostRenderArmHookTypes;
    private static final List<String> afterPostRenderArmHookTypes;
    private ModelPlayerBase[] beforePostRenderArmHooks;
    private ModelPlayerBase[] overridePostRenderArmHooks;
    private ModelPlayerBase[] afterPostRenderArmHooks;
    public boolean isPostRenderArmModded;
    private static final Map<String, String[]> allBaseBeforePostRenderArmSuperiors;
    private static final Map<String, String[]> allBaseBeforePostRenderArmInferiors;
    private static final Map<String, String[]> allBaseOverridePostRenderArmSuperiors;
    private static final Map<String, String[]> allBaseOverridePostRenderArmInferiors;
    private static final Map<String, String[]> allBaseAfterPostRenderArmSuperiors;
    private static final Map<String, String[]> allBaseAfterPostRenderArmInferiors;
    private static final List<String> beforeRenderHookTypes;
    private static final List<String> overrideRenderHookTypes;
    private static final List<String> afterRenderHookTypes;
    private ModelPlayerBase[] beforeRenderHooks;
    private ModelPlayerBase[] overrideRenderHooks;
    private ModelPlayerBase[] afterRenderHooks;
    public boolean isRenderModded;
    private static final Map<String, String[]> allBaseBeforeRenderSuperiors;
    private static final Map<String, String[]> allBaseBeforeRenderInferiors;
    private static final Map<String, String[]> allBaseOverrideRenderSuperiors;
    private static final Map<String, String[]> allBaseOverrideRenderInferiors;
    private static final Map<String, String[]> allBaseAfterRenderSuperiors;
    private static final Map<String, String[]> allBaseAfterRenderInferiors;
    private static final List<String> beforeRenderCapeHookTypes;
    private static final List<String> overrideRenderCapeHookTypes;
    private static final List<String> afterRenderCapeHookTypes;
    private ModelPlayerBase[] beforeRenderCapeHooks;
    private ModelPlayerBase[] overrideRenderCapeHooks;
    private ModelPlayerBase[] afterRenderCapeHooks;
    public boolean isRenderCapeModded;
    private static final Map<String, String[]> allBaseBeforeRenderCapeSuperiors;
    private static final Map<String, String[]> allBaseBeforeRenderCapeInferiors;
    private static final Map<String, String[]> allBaseOverrideRenderCapeSuperiors;
    private static final Map<String, String[]> allBaseOverrideRenderCapeInferiors;
    private static final Map<String, String[]> allBaseAfterRenderCapeSuperiors;
    private static final Map<String, String[]> allBaseAfterRenderCapeInferiors;
    private static final List<String> beforeRenderDeadmau5HeadHookTypes;
    private static final List<String> overrideRenderDeadmau5HeadHookTypes;
    private static final List<String> afterRenderDeadmau5HeadHookTypes;
    private ModelPlayerBase[] beforeRenderDeadmau5HeadHooks;
    private ModelPlayerBase[] overrideRenderDeadmau5HeadHooks;
    private ModelPlayerBase[] afterRenderDeadmau5HeadHooks;
    public boolean isRenderDeadmau5HeadModded;
    private static final Map<String, String[]> allBaseBeforeRenderDeadmau5HeadSuperiors;
    private static final Map<String, String[]> allBaseBeforeRenderDeadmau5HeadInferiors;
    private static final Map<String, String[]> allBaseOverrideRenderDeadmau5HeadSuperiors;
    private static final Map<String, String[]> allBaseOverrideRenderDeadmau5HeadInferiors;
    private static final Map<String, String[]> allBaseAfterRenderDeadmau5HeadSuperiors;
    private static final Map<String, String[]> allBaseAfterRenderDeadmau5HeadInferiors;
    private static final List<String> beforeSetInvisibleHookTypes;
    private static final List<String> overrideSetInvisibleHookTypes;
    private static final List<String> afterSetInvisibleHookTypes;
    private ModelPlayerBase[] beforeSetInvisibleHooks;
    private ModelPlayerBase[] overrideSetInvisibleHooks;
    private ModelPlayerBase[] afterSetInvisibleHooks;
    public boolean isSetInvisibleModded;
    private static final Map<String, String[]> allBaseBeforeSetInvisibleSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetInvisibleInferiors;
    private static final Map<String, String[]> allBaseOverrideSetInvisibleSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetInvisibleInferiors;
    private static final Map<String, String[]> allBaseAfterSetInvisibleSuperiors;
    private static final Map<String, String[]> allBaseAfterSetInvisibleInferiors;
    private static final List<String> beforeSetLivingAnimationsHookTypes;
    private static final List<String> overrideSetLivingAnimationsHookTypes;
    private static final List<String> afterSetLivingAnimationsHookTypes;
    private ModelPlayerBase[] beforeSetLivingAnimationsHooks;
    private ModelPlayerBase[] overrideSetLivingAnimationsHooks;
    private ModelPlayerBase[] afterSetLivingAnimationsHooks;
    public boolean isSetLivingAnimationsModded;
    private static final Map<String, String[]> allBaseBeforeSetLivingAnimationsSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetLivingAnimationsInferiors;
    private static final Map<String, String[]> allBaseOverrideSetLivingAnimationsSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetLivingAnimationsInferiors;
    private static final Map<String, String[]> allBaseAfterSetLivingAnimationsSuperiors;
    private static final Map<String, String[]> allBaseAfterSetLivingAnimationsInferiors;
    private static final List<String> beforeSetModelAttributesHookTypes;
    private static final List<String> overrideSetModelAttributesHookTypes;
    private static final List<String> afterSetModelAttributesHookTypes;
    private ModelPlayerBase[] beforeSetModelAttributesHooks;
    private ModelPlayerBase[] overrideSetModelAttributesHooks;
    private ModelPlayerBase[] afterSetModelAttributesHooks;
    public boolean isSetModelAttributesModded;
    private static final Map<String, String[]> allBaseBeforeSetModelAttributesSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetModelAttributesInferiors;
    private static final Map<String, String[]> allBaseOverrideSetModelAttributesSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetModelAttributesInferiors;
    private static final Map<String, String[]> allBaseAfterSetModelAttributesSuperiors;
    private static final Map<String, String[]> allBaseAfterSetModelAttributesInferiors;
    private static final List<String> beforeSetRotationAnglesHookTypes;
    private static final List<String> overrideSetRotationAnglesHookTypes;
    private static final List<String> afterSetRotationAnglesHookTypes;
    private ModelPlayerBase[] beforeSetRotationAnglesHooks;
    private ModelPlayerBase[] overrideSetRotationAnglesHooks;
    private ModelPlayerBase[] afterSetRotationAnglesHooks;
    public boolean isSetRotationAnglesModded;
    private static final Map<String, String[]> allBaseBeforeSetRotationAnglesSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetRotationAnglesInferiors;
    private static final Map<String, String[]> allBaseOverrideSetRotationAnglesSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetRotationAnglesInferiors;
    private static final Map<String, String[]> allBaseAfterSetRotationAnglesSuperiors;
    private static final Map<String, String[]> allBaseAfterSetRotationAnglesInferiors;
    private static final List<String> beforeSetTextureOffsetHookTypes;
    private static final List<String> overrideSetTextureOffsetHookTypes;
    private static final List<String> afterSetTextureOffsetHookTypes;
    private ModelPlayerBase[] beforeSetTextureOffsetHooks;
    private ModelPlayerBase[] overrideSetTextureOffsetHooks;
    private ModelPlayerBase[] afterSetTextureOffsetHooks;
    public boolean isSetTextureOffsetModded;
    private static final Map<String, String[]> allBaseBeforeSetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseBeforeSetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseOverrideSetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseOverrideSetTextureOffsetInferiors;
    private static final Map<String, String[]> allBaseAfterSetTextureOffsetSuperiors;
    private static final Map<String, String[]> allBaseAfterSetTextureOffsetInferiors;
    protected final IModelPlayerAPI modelPlayer;
    private final float paramFloat1;
    private final float paramFloat2;
    private final int paramInt1;
    private final int paramInt2;
    private final boolean paramBoolean;
    private final String type;
    private static final Set<String> keys;
    private static final Map<String, String> keysToVirtualIds;
    private static final Set<Class<?>> dynamicTypes;
    private static final Map<Class<?>, Map<String, Method>> virtualDynamicHookMethods;
    private static final Map<Class<?>, Map<String, Method>> beforeDynamicHookMethods;
    private static final Map<Class<?>, Map<String, Method>> overrideDynamicHookMethods;
    private static final Map<Class<?>, Map<String, Method>> afterDynamicHookMethods;
    private static final List<String> beforeLocalConstructingHookTypes;
    private static final List<String> afterLocalConstructingHookTypes;
    private static final Map<String, List<String>> beforeDynamicHookTypes;
    private static final Map<String, List<String>> overrideDynamicHookTypes;
    private static final Map<String, List<String>> afterDynamicHookTypes;
    private ModelPlayerBase[] beforeLocalConstructingHooks;
    private ModelPlayerBase[] afterLocalConstructingHooks;
    private final Map<ModelPlayerBase, String> baseObjectsToId = new Hashtable<ModelPlayerBase, String>();
    private final Map<String, ModelPlayerBase> allBaseObjects = new Hashtable<String, ModelPlayerBase>();
    private final Set<String> unmodifiableAllBaseIds = Collections.unmodifiableSet(this.allBaseObjects.keySet());
    private static final Map<String, Constructor<?>> allBaseConstructors;
    private static final Set<String> unmodifiableAllIds;
    private static final Map<String, String[]> allBaseBeforeLocalConstructingSuperiors;
    private static final Map<String, String[]> allBaseBeforeLocalConstructingInferiors;
    private static final Map<String, String[]> allBaseAfterLocalConstructingSuperiors;
    private static final Map<String, String[]> allBaseAfterLocalConstructingInferiors;
    private static final Map<String, Map<String, String[]>> allBaseBeforeDynamicSuperiors;
    private static final Map<String, Map<String, String[]>> allBaseBeforeDynamicInferiors;
    private static final Map<String, Map<String, String[]>> allBaseOverrideDynamicSuperiors;
    private static final Map<String, Map<String, String[]>> allBaseOverrideDynamicInferiors;
    private static final Map<String, Map<String, String[]>> allBaseAfterDynamicSuperiors;
    private static final Map<String, Map<String, String[]>> allBaseAfterDynamicInferiors;
    private static boolean initialized;

    private static void log(String string) {
        System.out.println(string);
        logger.fine(string);
    }

    public static void register(String string, Class<?> clazz) {
        ModelPlayerAPI.register(string, clazz, null);
    }

    public static void register(String string, Class<?> clazz, ModelPlayerBaseSorting modelPlayerBaseSorting) {
        try {
            ModelPlayerAPI.register(clazz, string, modelPlayerBaseSorting);
        }
        catch (RuntimeException runtimeException) {
            if (string != null) {
                ModelPlayerAPI.log("Model Player: failed to register id '" + string + "'");
            } else {
                ModelPlayerAPI.log("Model Player: failed to register ModelPlayerBase");
            }
            throw runtimeException;
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void register(Class<?> clazz, String string, ModelPlayerBaseSorting modelPlayerBaseSorting) {
        Constructor<?> constructor;
        Executable executable;
        if (!isCreated) {
            try {
                executable = ModelPlayer.class.getMethod("getModelPlayerBase", String.class);
                if (((Method)executable).getReturnType() != ModelPlayerBase.class) {
                    throw new NoSuchMethodException(ModelPlayerBase.class.getName() + " " + ModelPlayer.class.getName() + ".getModelPlayerBase(" + String.class.getName() + ")");
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                void var9_20;
                void object;
                String[] stringArray = new String[]{"========================================", "The API \"Model Player\" version " + RenderPlayerAPIPlugin.Version + " of the mod \"Render Player API Core " + RenderPlayerAPIPlugin.Version + "\" can not be created!", "----------------------------------------", "Mandatory member method \"{0} getModelPlayerBase({3})\" not found in class \"{1}\".", "There are three scenarios this can happen:", "* Minecraft Forge is missing a Render Player API Core which Minecraft version matches its own.", "  Download and install the latest Render Player API Core for the Minecraft version you were trying to run.", "* The code of the class \"{2}\" of Render Player API Core has been modified beyond recognition by another Minecraft Forge coremod.", "  Try temporary deinstallation of other core mods to find the culprit and deinstall it permanently to fix this specific problem.", "* Render Player API Core has not been installed correctly.", "  Deinstall Render Player API Core and install it again following the installation instructions in the readme file.", "========================================"};
                String string2 = ModelPlayerBase.class.getName();
                String string3 = ModelPlayer.class.getName();
                String string4 = string3.replace(".", File.separator);
                String string5 = String.class.getName();
                boolean i = false;
                while (object < stringArray.length) {
                    stringArray[object] = MessageFormat.format(stringArray[object], string2, string3, string4, string5);
                    ++object;
                }
                for (String string6 : stringArray) {
                    logger.severe(string6);
                }
                for (String string6 : stringArray) {
                    System.err.println(string6);
                }
                String string7 = "\n\n";
                for (String string8 : stringArray) {
                    String string9 = (String)var9_20 + "\t" + string8 + "\n";
                }
                throw new RuntimeException((String)var9_20, noSuchMethodException);
            }
            ModelPlayerAPI.log("Model Player " + RenderPlayerAPIPlugin.Version + " Created");
            isCreated = true;
        }
        if (string == null) {
            throw new NullPointerException("Argument 'id' can not be null");
        }
        if (clazz == null) {
            throw new NullPointerException("Argument 'baseClass' can not be null");
        }
        executable = allBaseConstructors.get(string);
        if (executable != null) {
            throw new IllegalArgumentException("The class '" + clazz.getName() + "' can not be registered with the id '" + string + "' because the class '" + ((Constructor)executable).getDeclaringClass().getName() + "' has allready been registered with the same id");
        }
        try {
            constructor = clazz.getDeclaredConstructor(Classes);
        }
        catch (Throwable throwable) {
            try {
                constructor = clazz.getDeclaredConstructor(Class);
            }
            catch (Throwable throwable2) {
                throw new IllegalArgumentException("Can not find necessary constructor with one argument of type '" + ModelPlayerAPI.class.getName() + "' and eventually a second argument of type 'String' in the class '" + clazz.getName() + "'", throwable);
            }
        }
        allBaseConstructors.put(string, constructor);
        if (modelPlayerBaseSorting != null) {
            ModelPlayerAPI.addSorting(string, allBaseBeforeLocalConstructingSuperiors, modelPlayerBaseSorting.getBeforeLocalConstructingSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeLocalConstructingInferiors, modelPlayerBaseSorting.getBeforeLocalConstructingInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterLocalConstructingSuperiors, modelPlayerBaseSorting.getAfterLocalConstructingSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterLocalConstructingInferiors, modelPlayerBaseSorting.getAfterLocalConstructingInferiors());
            ModelPlayerAPI.addDynamicSorting(string, allBaseBeforeDynamicSuperiors, modelPlayerBaseSorting.getDynamicBeforeSuperiors());
            ModelPlayerAPI.addDynamicSorting(string, allBaseBeforeDynamicInferiors, modelPlayerBaseSorting.getDynamicBeforeInferiors());
            ModelPlayerAPI.addDynamicSorting(string, allBaseOverrideDynamicSuperiors, modelPlayerBaseSorting.getDynamicOverrideSuperiors());
            ModelPlayerAPI.addDynamicSorting(string, allBaseOverrideDynamicInferiors, modelPlayerBaseSorting.getDynamicOverrideInferiors());
            ModelPlayerAPI.addDynamicSorting(string, allBaseAfterDynamicSuperiors, modelPlayerBaseSorting.getDynamicAfterSuperiors());
            ModelPlayerAPI.addDynamicSorting(string, allBaseAfterDynamicInferiors, modelPlayerBaseSorting.getDynamicAfterInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetArmForSideSuperiors, modelPlayerBaseSorting.getBeforeGetArmForSideSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetArmForSideInferiors, modelPlayerBaseSorting.getBeforeGetArmForSideInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetArmForSideSuperiors, modelPlayerBaseSorting.getOverrideGetArmForSideSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetArmForSideInferiors, modelPlayerBaseSorting.getOverrideGetArmForSideInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetArmForSideSuperiors, modelPlayerBaseSorting.getAfterGetArmForSideSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetArmForSideInferiors, modelPlayerBaseSorting.getAfterGetArmForSideInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetMainHandSuperiors, modelPlayerBaseSorting.getBeforeGetMainHandSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetMainHandInferiors, modelPlayerBaseSorting.getBeforeGetMainHandInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetMainHandSuperiors, modelPlayerBaseSorting.getOverrideGetMainHandSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetMainHandInferiors, modelPlayerBaseSorting.getOverrideGetMainHandInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetMainHandSuperiors, modelPlayerBaseSorting.getAfterGetMainHandSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetMainHandInferiors, modelPlayerBaseSorting.getAfterGetMainHandInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetRandomModelBoxSuperiors, modelPlayerBaseSorting.getBeforeGetRandomModelBoxSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetRandomModelBoxInferiors, modelPlayerBaseSorting.getBeforeGetRandomModelBoxInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetRandomModelBoxSuperiors, modelPlayerBaseSorting.getOverrideGetRandomModelBoxSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetRandomModelBoxInferiors, modelPlayerBaseSorting.getOverrideGetRandomModelBoxInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetRandomModelBoxSuperiors, modelPlayerBaseSorting.getAfterGetRandomModelBoxSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetRandomModelBoxInferiors, modelPlayerBaseSorting.getAfterGetRandomModelBoxInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetTextureOffsetSuperiors, modelPlayerBaseSorting.getBeforeGetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeGetTextureOffsetInferiors, modelPlayerBaseSorting.getBeforeGetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetTextureOffsetSuperiors, modelPlayerBaseSorting.getOverrideGetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideGetTextureOffsetInferiors, modelPlayerBaseSorting.getOverrideGetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetTextureOffsetSuperiors, modelPlayerBaseSorting.getAfterGetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterGetTextureOffsetInferiors, modelPlayerBaseSorting.getAfterGetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforePostRenderArmSuperiors, modelPlayerBaseSorting.getBeforePostRenderArmSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforePostRenderArmInferiors, modelPlayerBaseSorting.getBeforePostRenderArmInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverridePostRenderArmSuperiors, modelPlayerBaseSorting.getOverridePostRenderArmSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverridePostRenderArmInferiors, modelPlayerBaseSorting.getOverridePostRenderArmInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterPostRenderArmSuperiors, modelPlayerBaseSorting.getAfterPostRenderArmSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterPostRenderArmInferiors, modelPlayerBaseSorting.getAfterPostRenderArmInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeRenderSuperiors, modelPlayerBaseSorting.getBeforeRenderSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeRenderInferiors, modelPlayerBaseSorting.getBeforeRenderInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideRenderSuperiors, modelPlayerBaseSorting.getOverrideRenderSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideRenderInferiors, modelPlayerBaseSorting.getOverrideRenderInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterRenderSuperiors, modelPlayerBaseSorting.getAfterRenderSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterRenderInferiors, modelPlayerBaseSorting.getAfterRenderInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeRenderCapeSuperiors, modelPlayerBaseSorting.getBeforeRenderCapeSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeRenderCapeInferiors, modelPlayerBaseSorting.getBeforeRenderCapeInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideRenderCapeSuperiors, modelPlayerBaseSorting.getOverrideRenderCapeSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideRenderCapeInferiors, modelPlayerBaseSorting.getOverrideRenderCapeInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterRenderCapeSuperiors, modelPlayerBaseSorting.getAfterRenderCapeSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterRenderCapeInferiors, modelPlayerBaseSorting.getAfterRenderCapeInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeRenderDeadmau5HeadSuperiors, modelPlayerBaseSorting.getBeforeRenderDeadmau5HeadSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeRenderDeadmau5HeadInferiors, modelPlayerBaseSorting.getBeforeRenderDeadmau5HeadInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideRenderDeadmau5HeadSuperiors, modelPlayerBaseSorting.getOverrideRenderDeadmau5HeadSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideRenderDeadmau5HeadInferiors, modelPlayerBaseSorting.getOverrideRenderDeadmau5HeadInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterRenderDeadmau5HeadSuperiors, modelPlayerBaseSorting.getAfterRenderDeadmau5HeadSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterRenderDeadmau5HeadInferiors, modelPlayerBaseSorting.getAfterRenderDeadmau5HeadInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetInvisibleSuperiors, modelPlayerBaseSorting.getBeforeSetInvisibleSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetInvisibleInferiors, modelPlayerBaseSorting.getBeforeSetInvisibleInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetInvisibleSuperiors, modelPlayerBaseSorting.getOverrideSetInvisibleSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetInvisibleInferiors, modelPlayerBaseSorting.getOverrideSetInvisibleInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetInvisibleSuperiors, modelPlayerBaseSorting.getAfterSetInvisibleSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetInvisibleInferiors, modelPlayerBaseSorting.getAfterSetInvisibleInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetLivingAnimationsSuperiors, modelPlayerBaseSorting.getBeforeSetLivingAnimationsSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetLivingAnimationsInferiors, modelPlayerBaseSorting.getBeforeSetLivingAnimationsInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetLivingAnimationsSuperiors, modelPlayerBaseSorting.getOverrideSetLivingAnimationsSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetLivingAnimationsInferiors, modelPlayerBaseSorting.getOverrideSetLivingAnimationsInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetLivingAnimationsSuperiors, modelPlayerBaseSorting.getAfterSetLivingAnimationsSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetLivingAnimationsInferiors, modelPlayerBaseSorting.getAfterSetLivingAnimationsInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetModelAttributesSuperiors, modelPlayerBaseSorting.getBeforeSetModelAttributesSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetModelAttributesInferiors, modelPlayerBaseSorting.getBeforeSetModelAttributesInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetModelAttributesSuperiors, modelPlayerBaseSorting.getOverrideSetModelAttributesSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetModelAttributesInferiors, modelPlayerBaseSorting.getOverrideSetModelAttributesInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetModelAttributesSuperiors, modelPlayerBaseSorting.getAfterSetModelAttributesSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetModelAttributesInferiors, modelPlayerBaseSorting.getAfterSetModelAttributesInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetRotationAnglesSuperiors, modelPlayerBaseSorting.getBeforeSetRotationAnglesSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetRotationAnglesInferiors, modelPlayerBaseSorting.getBeforeSetRotationAnglesInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetRotationAnglesSuperiors, modelPlayerBaseSorting.getOverrideSetRotationAnglesSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetRotationAnglesInferiors, modelPlayerBaseSorting.getOverrideSetRotationAnglesInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetRotationAnglesSuperiors, modelPlayerBaseSorting.getAfterSetRotationAnglesSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetRotationAnglesInferiors, modelPlayerBaseSorting.getAfterSetRotationAnglesInferiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetTextureOffsetSuperiors, modelPlayerBaseSorting.getBeforeSetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseBeforeSetTextureOffsetInferiors, modelPlayerBaseSorting.getBeforeSetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetTextureOffsetSuperiors, modelPlayerBaseSorting.getOverrideSetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseOverrideSetTextureOffsetInferiors, modelPlayerBaseSorting.getOverrideSetTextureOffsetInferiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetTextureOffsetSuperiors, modelPlayerBaseSorting.getAfterSetTextureOffsetSuperiors());
            ModelPlayerAPI.addSorting(string, allBaseAfterSetTextureOffsetInferiors, modelPlayerBaseSorting.getAfterSetTextureOffsetInferiors());
        }
        ModelPlayerAPI.addMethod(string, clazz, beforeLocalConstructingHookTypes, "beforeLocalConstructing", Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterLocalConstructingHookTypes, "afterLocalConstructing", Float.TYPE, Float.TYPE, Integer.TYPE, Integer.TYPE, Boolean.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, beforeGetArmForSideHookTypes, "beforeGetArmForSide", EnumHandSide.class);
        ModelPlayerAPI.addMethod(string, clazz, overrideGetArmForSideHookTypes, "getArmForSide", EnumHandSide.class);
        ModelPlayerAPI.addMethod(string, clazz, afterGetArmForSideHookTypes, "afterGetArmForSide", EnumHandSide.class);
        ModelPlayerAPI.addMethod(string, clazz, beforeGetMainHandHookTypes, "beforeGetMainHand", Entity.class);
        ModelPlayerAPI.addMethod(string, clazz, overrideGetMainHandHookTypes, "getMainHand", Entity.class);
        ModelPlayerAPI.addMethod(string, clazz, afterGetMainHandHookTypes, "afterGetMainHand", Entity.class);
        ModelPlayerAPI.addMethod(string, clazz, beforeGetRandomModelBoxHookTypes, "beforeGetRandomModelBox", Random.class);
        ModelPlayerAPI.addMethod(string, clazz, overrideGetRandomModelBoxHookTypes, "getRandomModelBox", Random.class);
        ModelPlayerAPI.addMethod(string, clazz, afterGetRandomModelBoxHookTypes, "afterGetRandomModelBox", Random.class);
        ModelPlayerAPI.addMethod(string, clazz, beforeGetTextureOffsetHookTypes, "beforeGetTextureOffset", String.class);
        ModelPlayerAPI.addMethod(string, clazz, overrideGetTextureOffsetHookTypes, "getTextureOffset", String.class);
        ModelPlayerAPI.addMethod(string, clazz, afterGetTextureOffsetHookTypes, "afterGetTextureOffset", String.class);
        ModelPlayerAPI.addMethod(string, clazz, beforePostRenderArmHookTypes, "beforePostRenderArm", Float.TYPE, EnumHandSide.class);
        ModelPlayerAPI.addMethod(string, clazz, overridePostRenderArmHookTypes, "postRenderArm", Float.TYPE, EnumHandSide.class);
        ModelPlayerAPI.addMethod(string, clazz, afterPostRenderArmHookTypes, "afterPostRenderArm", Float.TYPE, EnumHandSide.class);
        ModelPlayerAPI.addMethod(string, clazz, beforeRenderHookTypes, "beforeRender", Entity.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, overrideRenderHookTypes, "render", Entity.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterRenderHookTypes, "afterRender", Entity.class, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, beforeRenderCapeHookTypes, "beforeRenderCape", Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, overrideRenderCapeHookTypes, "renderCape", Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterRenderCapeHookTypes, "afterRenderCape", Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, beforeRenderDeadmau5HeadHookTypes, "beforeRenderDeadmau5Head", Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, overrideRenderDeadmau5HeadHookTypes, "renderDeadmau5Head", Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterRenderDeadmau5HeadHookTypes, "afterRenderDeadmau5Head", Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, beforeSetInvisibleHookTypes, "beforeSetInvisible", Boolean.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, overrideSetInvisibleHookTypes, "setInvisible", Boolean.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterSetInvisibleHookTypes, "afterSetInvisible", Boolean.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, beforeSetLivingAnimationsHookTypes, "beforeSetLivingAnimations", EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, overrideSetLivingAnimationsHookTypes, "setLivingAnimations", EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterSetLivingAnimationsHookTypes, "afterSetLivingAnimations", EntityLivingBase.class, Float.TYPE, Float.TYPE, Float.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, beforeSetModelAttributesHookTypes, "beforeSetModelAttributes", ModelBase.class);
        ModelPlayerAPI.addMethod(string, clazz, overrideSetModelAttributesHookTypes, "setModelAttributes", ModelBase.class);
        ModelPlayerAPI.addMethod(string, clazz, afterSetModelAttributesHookTypes, "afterSetModelAttributes", ModelBase.class);
        ModelPlayerAPI.addMethod(string, clazz, beforeSetRotationAnglesHookTypes, "beforeSetRotationAngles", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);
        ModelPlayerAPI.addMethod(string, clazz, overrideSetRotationAnglesHookTypes, "setRotationAngles", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);
        ModelPlayerAPI.addMethod(string, clazz, afterSetRotationAnglesHookTypes, "afterSetRotationAngles", Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Float.TYPE, Entity.class);
        ModelPlayerAPI.addMethod(string, clazz, beforeSetTextureOffsetHookTypes, "beforeSetTextureOffset", String.class, Integer.TYPE, Integer.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, overrideSetTextureOffsetHookTypes, "setTextureOffset", String.class, Integer.TYPE, Integer.TYPE);
        ModelPlayerAPI.addMethod(string, clazz, afterSetTextureOffsetHookTypes, "afterSetTextureOffset", String.class, Integer.TYPE, Integer.TYPE);
        ModelPlayerAPI.addDynamicMethods(string, clazz);
        ModelPlayerAPI.addDynamicKeys(string, clazz, beforeDynamicHookMethods, beforeDynamicHookTypes);
        ModelPlayerAPI.addDynamicKeys(string, clazz, overrideDynamicHookMethods, overrideDynamicHookTypes);
        ModelPlayerAPI.addDynamicKeys(string, clazz, afterDynamicHookMethods, afterDynamicHookTypes);
        ModelPlayerAPI.initialize();
        for (IModelPlayerAPI iModelPlayerAPI : ModelPlayerAPI.getAllInstancesList()) {
            iModelPlayerAPI.getModelPlayerAPI().attachModelPlayerBase(string);
        }
        System.out.println("Model Player: registered " + string);
        logger.fine("Model Player: registered class '" + clazz.getName() + "' with id '" + string + "'");
        initialized = false;
    }

    public static boolean unregister(String string) {
        boolean bl;
        if (string == null) {
            return false;
        }
        Constructor<?> constructor = allBaseConstructors.remove(string);
        if (constructor == null) {
            return false;
        }
        for (IModelPlayerAPI object : ModelPlayerAPI.getAllInstancesList()) {
            object.getModelPlayerAPI().detachModelPlayerBase(string);
        }
        beforeLocalConstructingHookTypes.remove(string);
        afterLocalConstructingHookTypes.remove(string);
        allBaseBeforeGetArmForSideSuperiors.remove(string);
        allBaseBeforeGetArmForSideInferiors.remove(string);
        allBaseOverrideGetArmForSideSuperiors.remove(string);
        allBaseOverrideGetArmForSideInferiors.remove(string);
        allBaseAfterGetArmForSideSuperiors.remove(string);
        allBaseAfterGetArmForSideInferiors.remove(string);
        beforeGetArmForSideHookTypes.remove(string);
        overrideGetArmForSideHookTypes.remove(string);
        afterGetArmForSideHookTypes.remove(string);
        allBaseBeforeGetMainHandSuperiors.remove(string);
        allBaseBeforeGetMainHandInferiors.remove(string);
        allBaseOverrideGetMainHandSuperiors.remove(string);
        allBaseOverrideGetMainHandInferiors.remove(string);
        allBaseAfterGetMainHandSuperiors.remove(string);
        allBaseAfterGetMainHandInferiors.remove(string);
        beforeGetMainHandHookTypes.remove(string);
        overrideGetMainHandHookTypes.remove(string);
        afterGetMainHandHookTypes.remove(string);
        allBaseBeforeGetRandomModelBoxSuperiors.remove(string);
        allBaseBeforeGetRandomModelBoxInferiors.remove(string);
        allBaseOverrideGetRandomModelBoxSuperiors.remove(string);
        allBaseOverrideGetRandomModelBoxInferiors.remove(string);
        allBaseAfterGetRandomModelBoxSuperiors.remove(string);
        allBaseAfterGetRandomModelBoxInferiors.remove(string);
        beforeGetRandomModelBoxHookTypes.remove(string);
        overrideGetRandomModelBoxHookTypes.remove(string);
        afterGetRandomModelBoxHookTypes.remove(string);
        allBaseBeforeGetTextureOffsetSuperiors.remove(string);
        allBaseBeforeGetTextureOffsetInferiors.remove(string);
        allBaseOverrideGetTextureOffsetSuperiors.remove(string);
        allBaseOverrideGetTextureOffsetInferiors.remove(string);
        allBaseAfterGetTextureOffsetSuperiors.remove(string);
        allBaseAfterGetTextureOffsetInferiors.remove(string);
        beforeGetTextureOffsetHookTypes.remove(string);
        overrideGetTextureOffsetHookTypes.remove(string);
        afterGetTextureOffsetHookTypes.remove(string);
        allBaseBeforePostRenderArmSuperiors.remove(string);
        allBaseBeforePostRenderArmInferiors.remove(string);
        allBaseOverridePostRenderArmSuperiors.remove(string);
        allBaseOverridePostRenderArmInferiors.remove(string);
        allBaseAfterPostRenderArmSuperiors.remove(string);
        allBaseAfterPostRenderArmInferiors.remove(string);
        beforePostRenderArmHookTypes.remove(string);
        overridePostRenderArmHookTypes.remove(string);
        afterPostRenderArmHookTypes.remove(string);
        allBaseBeforeRenderSuperiors.remove(string);
        allBaseBeforeRenderInferiors.remove(string);
        allBaseOverrideRenderSuperiors.remove(string);
        allBaseOverrideRenderInferiors.remove(string);
        allBaseAfterRenderSuperiors.remove(string);
        allBaseAfterRenderInferiors.remove(string);
        beforeRenderHookTypes.remove(string);
        overrideRenderHookTypes.remove(string);
        afterRenderHookTypes.remove(string);
        allBaseBeforeRenderCapeSuperiors.remove(string);
        allBaseBeforeRenderCapeInferiors.remove(string);
        allBaseOverrideRenderCapeSuperiors.remove(string);
        allBaseOverrideRenderCapeInferiors.remove(string);
        allBaseAfterRenderCapeSuperiors.remove(string);
        allBaseAfterRenderCapeInferiors.remove(string);
        beforeRenderCapeHookTypes.remove(string);
        overrideRenderCapeHookTypes.remove(string);
        afterRenderCapeHookTypes.remove(string);
        allBaseBeforeRenderDeadmau5HeadSuperiors.remove(string);
        allBaseBeforeRenderDeadmau5HeadInferiors.remove(string);
        allBaseOverrideRenderDeadmau5HeadSuperiors.remove(string);
        allBaseOverrideRenderDeadmau5HeadInferiors.remove(string);
        allBaseAfterRenderDeadmau5HeadSuperiors.remove(string);
        allBaseAfterRenderDeadmau5HeadInferiors.remove(string);
        beforeRenderDeadmau5HeadHookTypes.remove(string);
        overrideRenderDeadmau5HeadHookTypes.remove(string);
        afterRenderDeadmau5HeadHookTypes.remove(string);
        allBaseBeforeSetInvisibleSuperiors.remove(string);
        allBaseBeforeSetInvisibleInferiors.remove(string);
        allBaseOverrideSetInvisibleSuperiors.remove(string);
        allBaseOverrideSetInvisibleInferiors.remove(string);
        allBaseAfterSetInvisibleSuperiors.remove(string);
        allBaseAfterSetInvisibleInferiors.remove(string);
        beforeSetInvisibleHookTypes.remove(string);
        overrideSetInvisibleHookTypes.remove(string);
        afterSetInvisibleHookTypes.remove(string);
        allBaseBeforeSetLivingAnimationsSuperiors.remove(string);
        allBaseBeforeSetLivingAnimationsInferiors.remove(string);
        allBaseOverrideSetLivingAnimationsSuperiors.remove(string);
        allBaseOverrideSetLivingAnimationsInferiors.remove(string);
        allBaseAfterSetLivingAnimationsSuperiors.remove(string);
        allBaseAfterSetLivingAnimationsInferiors.remove(string);
        beforeSetLivingAnimationsHookTypes.remove(string);
        overrideSetLivingAnimationsHookTypes.remove(string);
        afterSetLivingAnimationsHookTypes.remove(string);
        allBaseBeforeSetModelAttributesSuperiors.remove(string);
        allBaseBeforeSetModelAttributesInferiors.remove(string);
        allBaseOverrideSetModelAttributesSuperiors.remove(string);
        allBaseOverrideSetModelAttributesInferiors.remove(string);
        allBaseAfterSetModelAttributesSuperiors.remove(string);
        allBaseAfterSetModelAttributesInferiors.remove(string);
        beforeSetModelAttributesHookTypes.remove(string);
        overrideSetModelAttributesHookTypes.remove(string);
        afterSetModelAttributesHookTypes.remove(string);
        allBaseBeforeSetRotationAnglesSuperiors.remove(string);
        allBaseBeforeSetRotationAnglesInferiors.remove(string);
        allBaseOverrideSetRotationAnglesSuperiors.remove(string);
        allBaseOverrideSetRotationAnglesInferiors.remove(string);
        allBaseAfterSetRotationAnglesSuperiors.remove(string);
        allBaseAfterSetRotationAnglesInferiors.remove(string);
        beforeSetRotationAnglesHookTypes.remove(string);
        overrideSetRotationAnglesHookTypes.remove(string);
        afterSetRotationAnglesHookTypes.remove(string);
        allBaseBeforeSetTextureOffsetSuperiors.remove(string);
        allBaseBeforeSetTextureOffsetInferiors.remove(string);
        allBaseOverrideSetTextureOffsetSuperiors.remove(string);
        allBaseOverrideSetTextureOffsetInferiors.remove(string);
        allBaseAfterSetTextureOffsetSuperiors.remove(string);
        allBaseAfterSetTextureOffsetInferiors.remove(string);
        beforeSetTextureOffsetHookTypes.remove(string);
        overrideSetTextureOffsetHookTypes.remove(string);
        afterSetTextureOffsetHookTypes.remove(string);
        for (IModelPlayerAPI iModelPlayerAPI : ModelPlayerAPI.getAllInstancesList()) {
            iModelPlayerAPI.getModelPlayerAPI().updateModelPlayerBases();
        }
        for (String string2 : keysToVirtualIds.keySet()) {
            if (!keysToVirtualIds.get(string2).equals(string)) continue;
            keysToVirtualIds.remove(string2);
        }
        boolean bl2 = false;
        Class<?> clazz = constructor.getDeclaringClass();
        for (String string3 : allBaseConstructors.keySet()) {
            Class<?> clazz2 = allBaseConstructors.get(string3).getDeclaringClass();
            if (string3.equals(string) || !clazz2.equals(clazz)) continue;
            bl = true;
            break;
        }
        if (!bl) {
            dynamicTypes.remove(clazz);
            virtualDynamicHookMethods.remove(clazz);
            beforeDynamicHookMethods.remove(clazz);
            overrideDynamicHookMethods.remove(clazz);
            afterDynamicHookMethods.remove(clazz);
        }
        ModelPlayerAPI.removeDynamicHookTypes(string, beforeDynamicHookTypes);
        ModelPlayerAPI.removeDynamicHookTypes(string, overrideDynamicHookTypes);
        ModelPlayerAPI.removeDynamicHookTypes(string, afterDynamicHookTypes);
        allBaseBeforeDynamicSuperiors.remove(string);
        allBaseBeforeDynamicInferiors.remove(string);
        allBaseOverrideDynamicSuperiors.remove(string);
        allBaseOverrideDynamicInferiors.remove(string);
        allBaseAfterDynamicSuperiors.remove(string);
        allBaseAfterDynamicInferiors.remove(string);
        ModelPlayerAPI.log("ModelPlayerAPI: unregistered id '" + string + "'");
        return true;
    }

    public static void removeDynamicHookTypes(String string, Map<String, List<String>> map) {
        Iterator<String> iterator = map.keySet().iterator();
        while (iterator.hasNext()) {
            map.get(iterator.next()).remove(string);
        }
    }

    public static Set<String> getRegisteredIds() {
        return unmodifiableAllIds;
    }

    private static void addSorting(String string, Map<String, String[]> map, String[] stringArray) {
        if (stringArray != null && stringArray.length > 0) {
            map.put(string, stringArray);
        }
    }

    private static void addDynamicSorting(String string, Map<String, Map<String, String[]>> map, Map<String, String[]> map2) {
        if (map2 != null && map2.size() > 0) {
            map.put(string, map2);
        }
    }

    private static boolean addMethod(String string, Class<?> clazz, List<String> list, String string2, Class<?> ... classArray) {
        try {
            boolean bl;
            Method method = clazz.getMethod(string2, classArray);
            boolean bl2 = bl = method.getDeclaringClass() != ModelPlayerBase.class;
            if (bl) {
                list.add(string);
            }
            return bl;
        }
        catch (Exception exception) {
            throw new RuntimeException("Can not reflect method '" + string2 + "' of class '" + clazz.getName() + "'", exception);
        }
    }

    private static void addDynamicMethods(String string, Class<?> clazz) {
        if (!dynamicTypes.add(clazz)) {
            return;
        }
        Map<String, Method> map = null;
        Map<String, Method> map2 = null;
        Map<String, Method> map3 = null;
        Map<String, Method> map4 = null;
        Method[] methodArray = clazz.getDeclaredMethods();
        for (int i = 0; i < methodArray.length; ++i) {
            String string2;
            int n;
            Method method = methodArray[i];
            if (method.getDeclaringClass() != clazz || Modifier.isAbstract(n = method.getModifiers()) || Modifier.isStatic(n) || (string2 = method.getName()).length() < 7 || !string2.substring(0, 7).equalsIgnoreCase("dynamic")) continue;
            string2 = string2.substring(7);
            while (string2.charAt(0) == '_') {
                string2 = string2.substring(1);
            }
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            boolean bl4 = false;
            if (string2.substring(0, 7).equalsIgnoreCase("virtual")) {
                bl2 = true;
                string2 = string2.substring(7);
            } else if (string2.length() >= 8 && string2.substring(0, 8).equalsIgnoreCase("override")) {
                string2 = string2.substring(8);
                bl3 = true;
            } else if (string2.length() >= 6 && string2.substring(0, 6).equalsIgnoreCase("before")) {
                bl = true;
                string2 = string2.substring(6);
            } else if (string2.length() >= 5 && string2.substring(0, 5).equalsIgnoreCase("after")) {
                bl4 = true;
                string2 = string2.substring(5);
            }
            if (string2.length() >= 1 && (bl || bl2 || bl3 || bl4)) {
                string2 = string2.substring(0, 1).toLowerCase() + string2.substring(1);
            }
            while (string2.charAt(0) == '_') {
                string2 = string2.substring(1);
            }
            if (string2.length() == 0) {
                throw new RuntimeException("Can not process dynamic hook method with no key");
            }
            keys.add(string2);
            if (bl2) {
                if (keysToVirtualIds.containsKey(string2)) {
                    throw new RuntimeException("Can not process more than one dynamic virtual method");
                }
                keysToVirtualIds.put(string2, string);
                map = ModelPlayerAPI.addDynamicMethod(string2, method, map);
                continue;
            }
            if (bl) {
                map2 = ModelPlayerAPI.addDynamicMethod(string2, method, map2);
                continue;
            }
            if (bl4) {
                map4 = ModelPlayerAPI.addDynamicMethod(string2, method, map4);
                continue;
            }
            map3 = ModelPlayerAPI.addDynamicMethod(string2, method, map3);
        }
        if (map != null) {
            virtualDynamicHookMethods.put(clazz, map);
        }
        if (map2 != null) {
            beforeDynamicHookMethods.put(clazz, map2);
        }
        if (map3 != null) {
            overrideDynamicHookMethods.put(clazz, map3);
        }
        if (map4 != null) {
            afterDynamicHookMethods.put(clazz, map4);
        }
    }

    private static void addDynamicKeys(String string, Class<?> clazz, Map<Class<?>, Map<String, Method>> map, Map<String, List<String>> map2) {
        Map<String, Method> map3 = map.get(clazz);
        if (map3 == null || map3.size() == 0) {
            return;
        }
        for (String string2 : map3.keySet()) {
            if (!map2.containsKey(string2)) {
                map2.put(string2, new ArrayList(1));
            }
            map2.get(string2).add(string);
        }
    }

    private static Map<String, Method> addDynamicMethod(String string, Method method, Map<String, Method> map) {
        if (map == null) {
            map = new HashMap<String, Method>();
        }
        if (map.containsKey(string)) {
            throw new RuntimeException("method with key '" + string + "' allready exists");
        }
        map.put(string, method);
        return map;
    }

    public static ModelPlayerAPI create(IModelPlayerAPI iModelPlayerAPI, float f, float f2, int n, int n2, boolean bl, String string) {
        if (allBaseConstructors.size() > 0 && !initialized) {
            ModelPlayerAPI.initialize();
        }
        return new ModelPlayerAPI(iModelPlayerAPI, f, f2, n, n2, bl, string);
    }

    private static void initialize() {
        ModelPlayerAPI.sortBases(beforeLocalConstructingHookTypes, allBaseBeforeLocalConstructingSuperiors, allBaseBeforeLocalConstructingInferiors, "beforeLocalConstructing");
        ModelPlayerAPI.sortBases(afterLocalConstructingHookTypes, allBaseAfterLocalConstructingSuperiors, allBaseAfterLocalConstructingInferiors, "afterLocalConstructing");
        for (String string : keys) {
            ModelPlayerAPI.sortDynamicBases(beforeDynamicHookTypes, allBaseBeforeDynamicSuperiors, allBaseBeforeDynamicInferiors, string);
            ModelPlayerAPI.sortDynamicBases(overrideDynamicHookTypes, allBaseOverrideDynamicSuperiors, allBaseOverrideDynamicInferiors, string);
            ModelPlayerAPI.sortDynamicBases(afterDynamicHookTypes, allBaseAfterDynamicSuperiors, allBaseAfterDynamicInferiors, string);
        }
        ModelPlayerAPI.sortBases(beforeGetArmForSideHookTypes, allBaseBeforeGetArmForSideSuperiors, allBaseBeforeGetArmForSideInferiors, "beforeGetArmForSide");
        ModelPlayerAPI.sortBases(overrideGetArmForSideHookTypes, allBaseOverrideGetArmForSideSuperiors, allBaseOverrideGetArmForSideInferiors, "overrideGetArmForSide");
        ModelPlayerAPI.sortBases(afterGetArmForSideHookTypes, allBaseAfterGetArmForSideSuperiors, allBaseAfterGetArmForSideInferiors, "afterGetArmForSide");
        ModelPlayerAPI.sortBases(beforeGetMainHandHookTypes, allBaseBeforeGetMainHandSuperiors, allBaseBeforeGetMainHandInferiors, "beforeGetMainHand");
        ModelPlayerAPI.sortBases(overrideGetMainHandHookTypes, allBaseOverrideGetMainHandSuperiors, allBaseOverrideGetMainHandInferiors, "overrideGetMainHand");
        ModelPlayerAPI.sortBases(afterGetMainHandHookTypes, allBaseAfterGetMainHandSuperiors, allBaseAfterGetMainHandInferiors, "afterGetMainHand");
        ModelPlayerAPI.sortBases(beforeGetRandomModelBoxHookTypes, allBaseBeforeGetRandomModelBoxSuperiors, allBaseBeforeGetRandomModelBoxInferiors, "beforeGetRandomModelBox");
        ModelPlayerAPI.sortBases(overrideGetRandomModelBoxHookTypes, allBaseOverrideGetRandomModelBoxSuperiors, allBaseOverrideGetRandomModelBoxInferiors, "overrideGetRandomModelBox");
        ModelPlayerAPI.sortBases(afterGetRandomModelBoxHookTypes, allBaseAfterGetRandomModelBoxSuperiors, allBaseAfterGetRandomModelBoxInferiors, "afterGetRandomModelBox");
        ModelPlayerAPI.sortBases(beforeGetTextureOffsetHookTypes, allBaseBeforeGetTextureOffsetSuperiors, allBaseBeforeGetTextureOffsetInferiors, "beforeGetTextureOffset");
        ModelPlayerAPI.sortBases(overrideGetTextureOffsetHookTypes, allBaseOverrideGetTextureOffsetSuperiors, allBaseOverrideGetTextureOffsetInferiors, "overrideGetTextureOffset");
        ModelPlayerAPI.sortBases(afterGetTextureOffsetHookTypes, allBaseAfterGetTextureOffsetSuperiors, allBaseAfterGetTextureOffsetInferiors, "afterGetTextureOffset");
        ModelPlayerAPI.sortBases(beforePostRenderArmHookTypes, allBaseBeforePostRenderArmSuperiors, allBaseBeforePostRenderArmInferiors, "beforePostRenderArm");
        ModelPlayerAPI.sortBases(overridePostRenderArmHookTypes, allBaseOverridePostRenderArmSuperiors, allBaseOverridePostRenderArmInferiors, "overridePostRenderArm");
        ModelPlayerAPI.sortBases(afterPostRenderArmHookTypes, allBaseAfterPostRenderArmSuperiors, allBaseAfterPostRenderArmInferiors, "afterPostRenderArm");
        ModelPlayerAPI.sortBases(beforeRenderHookTypes, allBaseBeforeRenderSuperiors, allBaseBeforeRenderInferiors, "beforeRender");
        ModelPlayerAPI.sortBases(overrideRenderHookTypes, allBaseOverrideRenderSuperiors, allBaseOverrideRenderInferiors, "overrideRender");
        ModelPlayerAPI.sortBases(afterRenderHookTypes, allBaseAfterRenderSuperiors, allBaseAfterRenderInferiors, "afterRender");
        ModelPlayerAPI.sortBases(beforeRenderCapeHookTypes, allBaseBeforeRenderCapeSuperiors, allBaseBeforeRenderCapeInferiors, "beforeRenderCape");
        ModelPlayerAPI.sortBases(overrideRenderCapeHookTypes, allBaseOverrideRenderCapeSuperiors, allBaseOverrideRenderCapeInferiors, "overrideRenderCape");
        ModelPlayerAPI.sortBases(afterRenderCapeHookTypes, allBaseAfterRenderCapeSuperiors, allBaseAfterRenderCapeInferiors, "afterRenderCape");
        ModelPlayerAPI.sortBases(beforeRenderDeadmau5HeadHookTypes, allBaseBeforeRenderDeadmau5HeadSuperiors, allBaseBeforeRenderDeadmau5HeadInferiors, "beforeRenderDeadmau5Head");
        ModelPlayerAPI.sortBases(overrideRenderDeadmau5HeadHookTypes, allBaseOverrideRenderDeadmau5HeadSuperiors, allBaseOverrideRenderDeadmau5HeadInferiors, "overrideRenderDeadmau5Head");
        ModelPlayerAPI.sortBases(afterRenderDeadmau5HeadHookTypes, allBaseAfterRenderDeadmau5HeadSuperiors, allBaseAfterRenderDeadmau5HeadInferiors, "afterRenderDeadmau5Head");
        ModelPlayerAPI.sortBases(beforeSetInvisibleHookTypes, allBaseBeforeSetInvisibleSuperiors, allBaseBeforeSetInvisibleInferiors, "beforeSetInvisible");
        ModelPlayerAPI.sortBases(overrideSetInvisibleHookTypes, allBaseOverrideSetInvisibleSuperiors, allBaseOverrideSetInvisibleInferiors, "overrideSetInvisible");
        ModelPlayerAPI.sortBases(afterSetInvisibleHookTypes, allBaseAfterSetInvisibleSuperiors, allBaseAfterSetInvisibleInferiors, "afterSetInvisible");
        ModelPlayerAPI.sortBases(beforeSetLivingAnimationsHookTypes, allBaseBeforeSetLivingAnimationsSuperiors, allBaseBeforeSetLivingAnimationsInferiors, "beforeSetLivingAnimations");
        ModelPlayerAPI.sortBases(overrideSetLivingAnimationsHookTypes, allBaseOverrideSetLivingAnimationsSuperiors, allBaseOverrideSetLivingAnimationsInferiors, "overrideSetLivingAnimations");
        ModelPlayerAPI.sortBases(afterSetLivingAnimationsHookTypes, allBaseAfterSetLivingAnimationsSuperiors, allBaseAfterSetLivingAnimationsInferiors, "afterSetLivingAnimations");
        ModelPlayerAPI.sortBases(beforeSetModelAttributesHookTypes, allBaseBeforeSetModelAttributesSuperiors, allBaseBeforeSetModelAttributesInferiors, "beforeSetModelAttributes");
        ModelPlayerAPI.sortBases(overrideSetModelAttributesHookTypes, allBaseOverrideSetModelAttributesSuperiors, allBaseOverrideSetModelAttributesInferiors, "overrideSetModelAttributes");
        ModelPlayerAPI.sortBases(afterSetModelAttributesHookTypes, allBaseAfterSetModelAttributesSuperiors, allBaseAfterSetModelAttributesInferiors, "afterSetModelAttributes");
        ModelPlayerAPI.sortBases(beforeSetRotationAnglesHookTypes, allBaseBeforeSetRotationAnglesSuperiors, allBaseBeforeSetRotationAnglesInferiors, "beforeSetRotationAngles");
        ModelPlayerAPI.sortBases(overrideSetRotationAnglesHookTypes, allBaseOverrideSetRotationAnglesSuperiors, allBaseOverrideSetRotationAnglesInferiors, "overrideSetRotationAngles");
        ModelPlayerAPI.sortBases(afterSetRotationAnglesHookTypes, allBaseAfterSetRotationAnglesSuperiors, allBaseAfterSetRotationAnglesInferiors, "afterSetRotationAngles");
        ModelPlayerAPI.sortBases(beforeSetTextureOffsetHookTypes, allBaseBeforeSetTextureOffsetSuperiors, allBaseBeforeSetTextureOffsetInferiors, "beforeSetTextureOffset");
        ModelPlayerAPI.sortBases(overrideSetTextureOffsetHookTypes, allBaseOverrideSetTextureOffsetSuperiors, allBaseOverrideSetTextureOffsetInferiors, "overrideSetTextureOffset");
        ModelPlayerAPI.sortBases(afterSetTextureOffsetHookTypes, allBaseAfterSetTextureOffsetSuperiors, allBaseAfterSetTextureOffsetInferiors, "afterSetTextureOffset");
        initialized = true;
    }

    private static List<IModelPlayerAPI> getAllInstancesList() {
        ArrayList<IModelPlayerAPI> arrayList = new ArrayList<IModelPlayerAPI>();
        Iterator<WeakReference<IModelPlayerAPI>> iterator = allInstances.iterator();
        while (iterator.hasNext()) {
            IModelPlayerAPI iModelPlayerAPI = (IModelPlayerAPI)iterator.next().get();
            if (iModelPlayerAPI != null) {
                arrayList.add(iModelPlayerAPI);
                continue;
            }
            iterator.remove();
        }
        return arrayList;
    }

    public static ModelBiped[] getAllInstances() {
        List<IModelPlayerAPI> list = ModelPlayerAPI.getAllInstancesList();
        return list.toArray(new ModelBiped[list.size()]);
    }

    public static void beforeLocalConstructing(IModelPlayerAPI iModelPlayerAPI, float f, float f2, int n, int n2, boolean bl) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            modelPlayerAPI.load();
        }
        allInstances.add(new WeakReference<IModelPlayerAPI>(iModelPlayerAPI));
        if (modelPlayerAPI != null) {
            modelPlayerAPI.beforeLocalConstructing(f, f2, n, n2, bl);
        }
    }

    public static void afterLocalConstructing(IModelPlayerAPI iModelPlayerAPI, float f, float f2, int n, int n2, boolean bl) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            modelPlayerAPI.afterLocalConstructing(f, f2, n, n2, bl);
        }
    }

    public static ModelPlayerBase getModelPlayerBase(IModelPlayerAPI iModelPlayerAPI, String string) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.getModelPlayerBase(string);
        }
        return null;
    }

    public static Set<String> getModelPlayerBaseIds(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        Set<String> set = null;
        set = modelPlayerAPI != null ? modelPlayerAPI.getModelPlayerBaseIds() : Collections.emptySet();
        return set;
    }

    public static float getExpandParameter(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramFloat1;
        }
        return 0.0f;
    }

    public static float getYOffsetParameter(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramFloat2;
        }
        return 0.0f;
    }

    public static int getTextureWidthParameter(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramInt1;
        }
        return 0;
    }

    public static int getTextureHeightParameter(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramInt2;
        }
        return 0;
    }

    public static boolean getSmallArmsParameter(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.paramBoolean;
        }
        return false;
    }

    public static String getModelPlayerType(IModelPlayerAPI iModelPlayerAPI) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.type != null) {
            return modelPlayerAPI.type;
        }
        return "other";
    }

    public static Object dynamic(IModelPlayerAPI iModelPlayerAPI, String string, Object[] objectArray) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null) {
            return modelPlayerAPI.dynamic(string, objectArray);
        }
        return null;
    }

    private static void sortBases(List<String> list, Map<String, String[]> map, Map<String, String[]> map2, String string) {
        new ModelPlayerBaseSorter(list, map, map2, string).Sort();
    }

    private static void sortDynamicBases(Map<String, List<String>> map, Map<String, Map<String, String[]>> map2, Map<String, Map<String, String[]>> map3, String string) {
        List<String> list = map.get(string);
        if (list != null && list.size() > 1) {
            ModelPlayerAPI.sortBases(list, ModelPlayerAPI.getDynamicSorters(string, list, map2), ModelPlayerAPI.getDynamicSorters(string, list, map3), string);
        }
    }

    private static Map<String, String[]> getDynamicSorters(String string, List<String> list, Map<String, Map<String, String[]>> map) {
        Map<String, String[]> map2 = null;
        for (String string2 : list) {
            String[] stringArray;
            Map<String, String[]> map3 = map.get(string2);
            if (map3 == null || (stringArray = map3.get(string)) == null || stringArray.length <= 0) continue;
            if (map2 == null) {
                map2 = new HashMap<String, String[]>(1);
            }
            map2.put(string2, stringArray);
        }
        return map2 != null ? map2 : EmptySortMap;
    }

    private ModelPlayerAPI(IModelPlayerAPI iModelPlayerAPI, float f, float f2, int n, int n2, boolean bl, String string) {
        this.modelPlayer = iModelPlayerAPI;
        this.paramFloat1 = f;
        this.paramFloat2 = f2;
        this.paramInt1 = n;
        this.paramInt2 = n2;
        this.paramBoolean = bl;
        this.type = string;
    }

    private void load() {
        for (String string : allBaseConstructors.keySet()) {
            ModelPlayerBase modelPlayerBase = this.createModelPlayerBase(string);
            modelPlayerBase.beforeBaseAttach(false);
            this.allBaseObjects.put(string, modelPlayerBase);
            this.baseObjectsToId.put(modelPlayerBase, string);
        }
        this.beforeLocalConstructingHooks = this.create(beforeLocalConstructingHookTypes);
        this.afterLocalConstructingHooks = this.create(afterLocalConstructingHookTypes);
        this.updateModelPlayerBases();
        Iterator<String> iterator = this.allBaseObjects.keySet().iterator();
        while (iterator.hasNext()) {
            this.allBaseObjects.get(iterator.next()).afterBaseAttach(false);
        }
    }

    private ModelPlayerBase createModelPlayerBase(String string) {
        ModelPlayerBase modelPlayerBase;
        Constructor<?> constructor = allBaseConstructors.get(string);
        try {
            modelPlayerBase = constructor.getParameterTypes().length == 1 ? (ModelPlayerBase)constructor.newInstance(this) : (ModelPlayerBase)constructor.newInstance(this, string);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while creating a ModelPlayerBase of type '" + constructor.getDeclaringClass() + "'", exception);
        }
        return modelPlayerBase;
    }

    private void updateModelPlayerBases() {
        this.beforeGetArmForSideHooks = this.create(beforeGetArmForSideHookTypes);
        this.overrideGetArmForSideHooks = this.create(overrideGetArmForSideHookTypes);
        this.afterGetArmForSideHooks = this.create(afterGetArmForSideHookTypes);
        this.isGetArmForSideModded = this.beforeGetArmForSideHooks != null || this.overrideGetArmForSideHooks != null || this.afterGetArmForSideHooks != null;
        this.beforeGetMainHandHooks = this.create(beforeGetMainHandHookTypes);
        this.overrideGetMainHandHooks = this.create(overrideGetMainHandHookTypes);
        this.afterGetMainHandHooks = this.create(afterGetMainHandHookTypes);
        this.isGetMainHandModded = this.beforeGetMainHandHooks != null || this.overrideGetMainHandHooks != null || this.afterGetMainHandHooks != null;
        this.beforeGetRandomModelBoxHooks = this.create(beforeGetRandomModelBoxHookTypes);
        this.overrideGetRandomModelBoxHooks = this.create(overrideGetRandomModelBoxHookTypes);
        this.afterGetRandomModelBoxHooks = this.create(afterGetRandomModelBoxHookTypes);
        this.isGetRandomModelBoxModded = this.beforeGetRandomModelBoxHooks != null || this.overrideGetRandomModelBoxHooks != null || this.afterGetRandomModelBoxHooks != null;
        this.beforeGetTextureOffsetHooks = this.create(beforeGetTextureOffsetHookTypes);
        this.overrideGetTextureOffsetHooks = this.create(overrideGetTextureOffsetHookTypes);
        this.afterGetTextureOffsetHooks = this.create(afterGetTextureOffsetHookTypes);
        this.isGetTextureOffsetModded = this.beforeGetTextureOffsetHooks != null || this.overrideGetTextureOffsetHooks != null || this.afterGetTextureOffsetHooks != null;
        this.beforePostRenderArmHooks = this.create(beforePostRenderArmHookTypes);
        this.overridePostRenderArmHooks = this.create(overridePostRenderArmHookTypes);
        this.afterPostRenderArmHooks = this.create(afterPostRenderArmHookTypes);
        this.isPostRenderArmModded = this.beforePostRenderArmHooks != null || this.overridePostRenderArmHooks != null || this.afterPostRenderArmHooks != null;
        this.beforeRenderHooks = this.create(beforeRenderHookTypes);
        this.overrideRenderHooks = this.create(overrideRenderHookTypes);
        this.afterRenderHooks = this.create(afterRenderHookTypes);
        this.isRenderModded = this.beforeRenderHooks != null || this.overrideRenderHooks != null || this.afterRenderHooks != null;
        this.beforeRenderCapeHooks = this.create(beforeRenderCapeHookTypes);
        this.overrideRenderCapeHooks = this.create(overrideRenderCapeHookTypes);
        this.afterRenderCapeHooks = this.create(afterRenderCapeHookTypes);
        this.isRenderCapeModded = this.beforeRenderCapeHooks != null || this.overrideRenderCapeHooks != null || this.afterRenderCapeHooks != null;
        this.beforeRenderDeadmau5HeadHooks = this.create(beforeRenderDeadmau5HeadHookTypes);
        this.overrideRenderDeadmau5HeadHooks = this.create(overrideRenderDeadmau5HeadHookTypes);
        this.afterRenderDeadmau5HeadHooks = this.create(afterRenderDeadmau5HeadHookTypes);
        this.isRenderDeadmau5HeadModded = this.beforeRenderDeadmau5HeadHooks != null || this.overrideRenderDeadmau5HeadHooks != null || this.afterRenderDeadmau5HeadHooks != null;
        this.beforeSetInvisibleHooks = this.create(beforeSetInvisibleHookTypes);
        this.overrideSetInvisibleHooks = this.create(overrideSetInvisibleHookTypes);
        this.afterSetInvisibleHooks = this.create(afterSetInvisibleHookTypes);
        this.isSetInvisibleModded = this.beforeSetInvisibleHooks != null || this.overrideSetInvisibleHooks != null || this.afterSetInvisibleHooks != null;
        this.beforeSetLivingAnimationsHooks = this.create(beforeSetLivingAnimationsHookTypes);
        this.overrideSetLivingAnimationsHooks = this.create(overrideSetLivingAnimationsHookTypes);
        this.afterSetLivingAnimationsHooks = this.create(afterSetLivingAnimationsHookTypes);
        this.isSetLivingAnimationsModded = this.beforeSetLivingAnimationsHooks != null || this.overrideSetLivingAnimationsHooks != null || this.afterSetLivingAnimationsHooks != null;
        this.beforeSetModelAttributesHooks = this.create(beforeSetModelAttributesHookTypes);
        this.overrideSetModelAttributesHooks = this.create(overrideSetModelAttributesHookTypes);
        this.afterSetModelAttributesHooks = this.create(afterSetModelAttributesHookTypes);
        this.isSetModelAttributesModded = this.beforeSetModelAttributesHooks != null || this.overrideSetModelAttributesHooks != null || this.afterSetModelAttributesHooks != null;
        this.beforeSetRotationAnglesHooks = this.create(beforeSetRotationAnglesHookTypes);
        this.overrideSetRotationAnglesHooks = this.create(overrideSetRotationAnglesHookTypes);
        this.afterSetRotationAnglesHooks = this.create(afterSetRotationAnglesHookTypes);
        this.isSetRotationAnglesModded = this.beforeSetRotationAnglesHooks != null || this.overrideSetRotationAnglesHooks != null || this.afterSetRotationAnglesHooks != null;
        this.beforeSetTextureOffsetHooks = this.create(beforeSetTextureOffsetHookTypes);
        this.overrideSetTextureOffsetHooks = this.create(overrideSetTextureOffsetHookTypes);
        this.afterSetTextureOffsetHooks = this.create(afterSetTextureOffsetHookTypes);
        this.isSetTextureOffsetModded = this.beforeSetTextureOffsetHooks != null || this.overrideSetTextureOffsetHooks != null || this.afterSetTextureOffsetHooks != null;
    }

    private void attachModelPlayerBase(String string) {
        ModelPlayerBase modelPlayerBase = this.createModelPlayerBase(string);
        modelPlayerBase.beforeBaseAttach(true);
        this.allBaseObjects.put(string, modelPlayerBase);
        this.updateModelPlayerBases();
        modelPlayerBase.afterBaseAttach(true);
    }

    private void detachModelPlayerBase(String string) {
        ModelPlayerBase modelPlayerBase = this.allBaseObjects.get(string);
        modelPlayerBase.beforeBaseDetach(true);
        this.allBaseObjects.remove(string);
        modelPlayerBase.afterBaseDetach(true);
    }

    private ModelPlayerBase[] create(List<String> list) {
        if (list.isEmpty()) {
            return null;
        }
        ModelPlayerBase[] modelPlayerBaseArray = new ModelPlayerBase[list.size()];
        for (int i = 0; i < modelPlayerBaseArray.length; ++i) {
            modelPlayerBaseArray[i] = this.getModelPlayerBase(list.get(i));
        }
        return modelPlayerBaseArray;
    }

    private void beforeLocalConstructing(float f, float f2, int n, int n2, boolean bl) {
        if (this.beforeLocalConstructingHooks != null) {
            for (int i = this.beforeLocalConstructingHooks.length - 1; i >= 0; --i) {
                this.beforeLocalConstructingHooks[i].beforeLocalConstructing(f, f2, n, n2, bl);
            }
        }
        this.beforeLocalConstructingHooks = null;
    }

    private void afterLocalConstructing(float f, float f2, int n, int n2, boolean bl) {
        if (this.afterLocalConstructingHooks != null) {
            for (int i = 0; i < this.afterLocalConstructingHooks.length; ++i) {
                this.afterLocalConstructingHooks[i].afterLocalConstructing(f, f2, n, n2, bl);
            }
        }
        this.afterLocalConstructingHooks = null;
    }

    public ModelPlayerBase getModelPlayerBase(String string) {
        return this.allBaseObjects.get(string);
    }

    public Set<String> getModelPlayerBaseIds() {
        return this.unmodifiableAllBaseIds;
    }

    public Object dynamic(String string, Object[] objectArray) {
        string = string.replace('.', '_').replace(' ', '_');
        this.executeAll(string, objectArray, beforeDynamicHookTypes, beforeDynamicHookMethods, true);
        Object object = this.dynamicOverwritten(string, objectArray, null);
        this.executeAll(string, objectArray, afterDynamicHookTypes, afterDynamicHookMethods, false);
        return object;
    }

    public Object dynamicOverwritten(String string, Object[] objectArray, ModelPlayerBase modelPlayerBase) {
        Map<Class<?>, Map<String, Method>> map;
        List<String> list = overrideDynamicHookTypes.get(string);
        String string2 = null;
        if (list != null) {
            if (modelPlayerBase != null) {
                string2 = this.baseObjectsToId.get(modelPlayerBase);
                int n = list.indexOf(string2);
                string2 = n > 0 ? list.get(n - 1) : null;
            } else if (list.size() > 0) {
                string2 = list.get(list.size() - 1);
            }
        }
        if (string2 == null) {
            string2 = keysToVirtualIds.get(string);
            if (string2 == null) {
                return null;
            }
            map = virtualDynamicHookMethods;
        } else {
            map = overrideDynamicHookMethods;
        }
        Map<String, Method> map2 = map.get(allBaseConstructors.get(string2).getDeclaringClass());
        if (map2 == null) {
            return null;
        }
        Method method = map2.get(string);
        if (method == null) {
            return null;
        }
        return this.execute(this.getModelPlayerBase(string2), method, objectArray);
    }

    private void executeAll(String string, Object[] objectArray, Map<String, List<String>> map, Map<Class<?>, Map<String, Method>> map2, boolean bl) {
        int n;
        List<String> list = map.get(string);
        if (list == null) {
            return;
        }
        int n2 = n = bl ? list.size() - 1 : 0;
        while (bl ? n >= 0 : n < list.size()) {
            Method method;
            String string2 = list.get(n);
            ModelPlayerBase modelPlayerBase = this.getModelPlayerBase(string2);
            Class<?> clazz = modelPlayerBase.getClass();
            Map<String, Method> map3 = map2.get(clazz);
            if (map3 != null && (method = map3.get(string)) != null) {
                this.execute(modelPlayerBase, method, objectArray);
            }
            n += bl ? -1 : 1;
        }
    }

    private Object execute(ModelPlayerBase modelPlayerBase, Method method, Object[] objectArray) {
        try {
            return method.invoke((Object)modelPlayerBase, objectArray);
        }
        catch (Exception exception) {
            throw new RuntimeException("Exception while invoking dynamic method", exception);
        }
    }

    public static ModelRenderer getArmForSide(IModelPlayerAPI iModelPlayerAPI, EnumHandSide enumHandSide) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        ModelRenderer modelRenderer = modelPlayerAPI != null && modelPlayerAPI.isGetArmForSideModded ? modelPlayerAPI.getArmForSide(enumHandSide) : iModelPlayerAPI.localGetArmForSide(enumHandSide);
        return modelRenderer;
    }

    private ModelRenderer getArmForSide(EnumHandSide enumHandSide) {
        if (this.beforeGetArmForSideHooks != null) {
            for (int i = this.beforeGetArmForSideHooks.length - 1; i >= 0; --i) {
                this.beforeGetArmForSideHooks[i].beforeGetArmForSide(enumHandSide);
            }
        }
        ModelRenderer modelRenderer = this.overrideGetArmForSideHooks != null ? this.overrideGetArmForSideHooks[this.overrideGetArmForSideHooks.length - 1].getArmForSide(enumHandSide) : this.modelPlayer.localGetArmForSide(enumHandSide);
        if (this.afterGetArmForSideHooks != null) {
            for (int i = 0; i < this.afterGetArmForSideHooks.length; ++i) {
                this.afterGetArmForSideHooks[i].afterGetArmForSide(enumHandSide);
            }
        }
        return modelRenderer;
    }

    protected ModelPlayerBase GetOverwrittenGetArmForSide(ModelPlayerBase modelPlayerBase) {
        if (this.overrideGetArmForSideHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideGetArmForSideHooks.length; ++i) {
            if (this.overrideGetArmForSideHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetArmForSideHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static EnumHandSide getMainHand(IModelPlayerAPI iModelPlayerAPI, Entity entity) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        EnumHandSide enumHandSide = modelPlayerAPI != null && modelPlayerAPI.isGetMainHandModded ? modelPlayerAPI.getMainHand(entity) : iModelPlayerAPI.localGetMainHand(entity);
        return enumHandSide;
    }

    private EnumHandSide getMainHand(Entity entity) {
        if (this.beforeGetMainHandHooks != null) {
            for (int i = this.beforeGetMainHandHooks.length - 1; i >= 0; --i) {
                this.beforeGetMainHandHooks[i].beforeGetMainHand(entity);
            }
        }
        EnumHandSide enumHandSide = this.overrideGetMainHandHooks != null ? this.overrideGetMainHandHooks[this.overrideGetMainHandHooks.length - 1].getMainHand(entity) : this.modelPlayer.localGetMainHand(entity);
        if (this.afterGetMainHandHooks != null) {
            for (int i = 0; i < this.afterGetMainHandHooks.length; ++i) {
                this.afterGetMainHandHooks[i].afterGetMainHand(entity);
            }
        }
        return enumHandSide;
    }

    protected ModelPlayerBase GetOverwrittenGetMainHand(ModelPlayerBase modelPlayerBase) {
        if (this.overrideGetMainHandHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideGetMainHandHooks.length; ++i) {
            if (this.overrideGetMainHandHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetMainHandHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static ModelRenderer getRandomModelBox(IModelPlayerAPI iModelPlayerAPI, Random random) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        ModelRenderer modelRenderer = modelPlayerAPI != null && modelPlayerAPI.isGetRandomModelBoxModded ? modelPlayerAPI.getRandomModelBox(random) : iModelPlayerAPI.localGetRandomModelBox(random);
        return modelRenderer;
    }

    private ModelRenderer getRandomModelBox(Random random) {
        if (this.beforeGetRandomModelBoxHooks != null) {
            for (int i = this.beforeGetRandomModelBoxHooks.length - 1; i >= 0; --i) {
                this.beforeGetRandomModelBoxHooks[i].beforeGetRandomModelBox(random);
            }
        }
        ModelRenderer modelRenderer = this.overrideGetRandomModelBoxHooks != null ? this.overrideGetRandomModelBoxHooks[this.overrideGetRandomModelBoxHooks.length - 1].getRandomModelBox(random) : this.modelPlayer.localGetRandomModelBox(random);
        if (this.afterGetRandomModelBoxHooks != null) {
            for (int i = 0; i < this.afterGetRandomModelBoxHooks.length; ++i) {
                this.afterGetRandomModelBoxHooks[i].afterGetRandomModelBox(random);
            }
        }
        return modelRenderer;
    }

    protected ModelPlayerBase GetOverwrittenGetRandomModelBox(ModelPlayerBase modelPlayerBase) {
        if (this.overrideGetRandomModelBoxHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideGetRandomModelBoxHooks.length; ++i) {
            if (this.overrideGetRandomModelBoxHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetRandomModelBoxHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static TextureOffset getTextureOffset(IModelPlayerAPI iModelPlayerAPI, String string) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        TextureOffset textureOffset = modelPlayerAPI != null && modelPlayerAPI.isGetTextureOffsetModded ? modelPlayerAPI.getTextureOffset(string) : iModelPlayerAPI.localGetTextureOffset(string);
        return textureOffset;
    }

    private TextureOffset getTextureOffset(String string) {
        if (this.beforeGetTextureOffsetHooks != null) {
            for (int i = this.beforeGetTextureOffsetHooks.length - 1; i >= 0; --i) {
                this.beforeGetTextureOffsetHooks[i].beforeGetTextureOffset(string);
            }
        }
        TextureOffset textureOffset = this.overrideGetTextureOffsetHooks != null ? this.overrideGetTextureOffsetHooks[this.overrideGetTextureOffsetHooks.length - 1].getTextureOffset(string) : this.modelPlayer.localGetTextureOffset(string);
        if (this.afterGetTextureOffsetHooks != null) {
            for (int i = 0; i < this.afterGetTextureOffsetHooks.length; ++i) {
                this.afterGetTextureOffsetHooks[i].afterGetTextureOffset(string);
            }
        }
        return textureOffset;
    }

    protected ModelPlayerBase GetOverwrittenGetTextureOffset(ModelPlayerBase modelPlayerBase) {
        if (this.overrideGetTextureOffsetHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideGetTextureOffsetHooks.length; ++i) {
            if (this.overrideGetTextureOffsetHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideGetTextureOffsetHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void postRenderArm(IModelPlayerAPI iModelPlayerAPI, float f, EnumHandSide enumHandSide) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isPostRenderArmModded) {
            modelPlayerAPI.postRenderArm(f, enumHandSide);
        } else {
            iModelPlayerAPI.localPostRenderArm(f, enumHandSide);
        }
    }

    private void postRenderArm(float f, EnumHandSide enumHandSide) {
        int n;
        if (this.beforePostRenderArmHooks != null) {
            for (n = this.beforePostRenderArmHooks.length - 1; n >= 0; --n) {
                this.beforePostRenderArmHooks[n].beforePostRenderArm(f, enumHandSide);
            }
        }
        if (this.overridePostRenderArmHooks != null) {
            this.overridePostRenderArmHooks[this.overridePostRenderArmHooks.length - 1].postRenderArm(f, enumHandSide);
        } else {
            this.modelPlayer.localPostRenderArm(f, enumHandSide);
        }
        if (this.afterPostRenderArmHooks != null) {
            for (n = 0; n < this.afterPostRenderArmHooks.length; ++n) {
                this.afterPostRenderArmHooks[n].afterPostRenderArm(f, enumHandSide);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenPostRenderArm(ModelPlayerBase modelPlayerBase) {
        if (this.overridePostRenderArmHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overridePostRenderArmHooks.length; ++i) {
            if (this.overridePostRenderArmHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overridePostRenderArmHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void render(IModelPlayerAPI iModelPlayerAPI, Entity entity, float f, float f2, float f3, float f4, float f5, float f6) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isRenderModded) {
            modelPlayerAPI.render(entity, f, f2, f3, f4, f5, f6);
        } else {
            iModelPlayerAPI.localRender(entity, f, f2, f3, f4, f5, f6);
        }
    }

    private void render(Entity entity, float f, float f2, float f3, float f4, float f5, float f6) {
        int n;
        if (this.beforeRenderHooks != null) {
            for (n = this.beforeRenderHooks.length - 1; n >= 0; --n) {
                this.beforeRenderHooks[n].beforeRender(entity, f, f2, f3, f4, f5, f6);
            }
        }
        if (this.overrideRenderHooks != null) {
            this.overrideRenderHooks[this.overrideRenderHooks.length - 1].render(entity, f, f2, f3, f4, f5, f6);
        } else {
            this.modelPlayer.localRender(entity, f, f2, f3, f4, f5, f6);
        }
        if (this.afterRenderHooks != null) {
            for (n = 0; n < this.afterRenderHooks.length; ++n) {
                this.afterRenderHooks[n].afterRender(entity, f, f2, f3, f4, f5, f6);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenRender(ModelPlayerBase modelPlayerBase) {
        if (this.overrideRenderHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideRenderHooks.length; ++i) {
            if (this.overrideRenderHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideRenderHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void renderCape(IModelPlayerAPI iModelPlayerAPI, float f) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isRenderCapeModded) {
            modelPlayerAPI.renderCape(f);
        } else {
            iModelPlayerAPI.localRenderCape(f);
        }
    }

    private void renderCape(float f) {
        int n;
        if (this.beforeRenderCapeHooks != null) {
            for (n = this.beforeRenderCapeHooks.length - 1; n >= 0; --n) {
                this.beforeRenderCapeHooks[n].beforeRenderCape(f);
            }
        }
        if (this.overrideRenderCapeHooks != null) {
            this.overrideRenderCapeHooks[this.overrideRenderCapeHooks.length - 1].renderCape(f);
        } else {
            this.modelPlayer.localRenderCape(f);
        }
        if (this.afterRenderCapeHooks != null) {
            for (n = 0; n < this.afterRenderCapeHooks.length; ++n) {
                this.afterRenderCapeHooks[n].afterRenderCape(f);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenRenderCape(ModelPlayerBase modelPlayerBase) {
        if (this.overrideRenderCapeHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideRenderCapeHooks.length; ++i) {
            if (this.overrideRenderCapeHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideRenderCapeHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void renderDeadmau5Head(IModelPlayerAPI iModelPlayerAPI, float f) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isRenderDeadmau5HeadModded) {
            modelPlayerAPI.renderDeadmau5Head(f);
        } else {
            iModelPlayerAPI.localRenderDeadmau5Head(f);
        }
    }

    private void renderDeadmau5Head(float f) {
        int n;
        if (this.beforeRenderDeadmau5HeadHooks != null) {
            for (n = this.beforeRenderDeadmau5HeadHooks.length - 1; n >= 0; --n) {
                this.beforeRenderDeadmau5HeadHooks[n].beforeRenderDeadmau5Head(f);
            }
        }
        if (this.overrideRenderDeadmau5HeadHooks != null) {
            this.overrideRenderDeadmau5HeadHooks[this.overrideRenderDeadmau5HeadHooks.length - 1].renderDeadmau5Head(f);
        } else {
            this.modelPlayer.localRenderDeadmau5Head(f);
        }
        if (this.afterRenderDeadmau5HeadHooks != null) {
            for (n = 0; n < this.afterRenderDeadmau5HeadHooks.length; ++n) {
                this.afterRenderDeadmau5HeadHooks[n].afterRenderDeadmau5Head(f);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenRenderDeadmau5Head(ModelPlayerBase modelPlayerBase) {
        if (this.overrideRenderDeadmau5HeadHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideRenderDeadmau5HeadHooks.length; ++i) {
            if (this.overrideRenderDeadmau5HeadHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideRenderDeadmau5HeadHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void setInvisible(IModelPlayerAPI iModelPlayerAPI, boolean bl) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetInvisibleModded) {
            modelPlayerAPI.setInvisible(bl);
        } else {
            iModelPlayerAPI.localSetInvisible(bl);
        }
    }

    private void setInvisible(boolean bl) {
        int n;
        if (this.beforeSetInvisibleHooks != null) {
            for (n = this.beforeSetInvisibleHooks.length - 1; n >= 0; --n) {
                this.beforeSetInvisibleHooks[n].beforeSetInvisible(bl);
            }
        }
        if (this.overrideSetInvisibleHooks != null) {
            this.overrideSetInvisibleHooks[this.overrideSetInvisibleHooks.length - 1].setInvisible(bl);
        } else {
            this.modelPlayer.localSetInvisible(bl);
        }
        if (this.afterSetInvisibleHooks != null) {
            for (n = 0; n < this.afterSetInvisibleHooks.length; ++n) {
                this.afterSetInvisibleHooks[n].afterSetInvisible(bl);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetInvisible(ModelPlayerBase modelPlayerBase) {
        if (this.overrideSetInvisibleHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideSetInvisibleHooks.length; ++i) {
            if (this.overrideSetInvisibleHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetInvisibleHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void setLivingAnimations(IModelPlayerAPI iModelPlayerAPI, EntityLivingBase entityLivingBase, float f, float f2, float f3) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetLivingAnimationsModded) {
            modelPlayerAPI.setLivingAnimations(entityLivingBase, f, f2, f3);
        } else {
            iModelPlayerAPI.localSetLivingAnimations(entityLivingBase, f, f2, f3);
        }
    }

    private void setLivingAnimations(EntityLivingBase entityLivingBase, float f, float f2, float f3) {
        int n;
        if (this.beforeSetLivingAnimationsHooks != null) {
            for (n = this.beforeSetLivingAnimationsHooks.length - 1; n >= 0; --n) {
                this.beforeSetLivingAnimationsHooks[n].beforeSetLivingAnimations(entityLivingBase, f, f2, f3);
            }
        }
        if (this.overrideSetLivingAnimationsHooks != null) {
            this.overrideSetLivingAnimationsHooks[this.overrideSetLivingAnimationsHooks.length - 1].setLivingAnimations(entityLivingBase, f, f2, f3);
        } else {
            this.modelPlayer.localSetLivingAnimations(entityLivingBase, f, f2, f3);
        }
        if (this.afterSetLivingAnimationsHooks != null) {
            for (n = 0; n < this.afterSetLivingAnimationsHooks.length; ++n) {
                this.afterSetLivingAnimationsHooks[n].afterSetLivingAnimations(entityLivingBase, f, f2, f3);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetLivingAnimations(ModelPlayerBase modelPlayerBase) {
        if (this.overrideSetLivingAnimationsHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideSetLivingAnimationsHooks.length; ++i) {
            if (this.overrideSetLivingAnimationsHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetLivingAnimationsHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void setModelAttributes(IModelPlayerAPI iModelPlayerAPI, ModelBase modelBase) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetModelAttributesModded) {
            modelPlayerAPI.setModelAttributes(modelBase);
        } else {
            iModelPlayerAPI.localSetModelAttributes(modelBase);
        }
    }

    private void setModelAttributes(ModelBase modelBase) {
        int n;
        if (this.beforeSetModelAttributesHooks != null) {
            for (n = this.beforeSetModelAttributesHooks.length - 1; n >= 0; --n) {
                this.beforeSetModelAttributesHooks[n].beforeSetModelAttributes(modelBase);
            }
        }
        if (this.overrideSetModelAttributesHooks != null) {
            this.overrideSetModelAttributesHooks[this.overrideSetModelAttributesHooks.length - 1].setModelAttributes(modelBase);
        } else {
            this.modelPlayer.localSetModelAttributes(modelBase);
        }
        if (this.afterSetModelAttributesHooks != null) {
            for (n = 0; n < this.afterSetModelAttributesHooks.length; ++n) {
                this.afterSetModelAttributesHooks[n].afterSetModelAttributes(modelBase);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetModelAttributes(ModelPlayerBase modelPlayerBase) {
        if (this.overrideSetModelAttributesHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideSetModelAttributesHooks.length; ++i) {
            if (this.overrideSetModelAttributesHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetModelAttributesHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void setRotationAngles(IModelPlayerAPI iModelPlayerAPI, float f, float f2, float f3, float f4, float f5, float f6, Entity entity) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetRotationAnglesModded) {
            modelPlayerAPI.setRotationAngles(f, f2, f3, f4, f5, f6, entity);
        } else {
            iModelPlayerAPI.localSetRotationAngles(f, f2, f3, f4, f5, f6, entity);
        }
    }

    private void setRotationAngles(float f, float f2, float f3, float f4, float f5, float f6, Entity entity) {
        int n;
        if (this.beforeSetRotationAnglesHooks != null) {
            for (n = this.beforeSetRotationAnglesHooks.length - 1; n >= 0; --n) {
                this.beforeSetRotationAnglesHooks[n].beforeSetRotationAngles(f, f2, f3, f4, f5, f6, entity);
            }
        }
        if (this.overrideSetRotationAnglesHooks != null) {
            this.overrideSetRotationAnglesHooks[this.overrideSetRotationAnglesHooks.length - 1].setRotationAngles(f, f2, f3, f4, f5, f6, entity);
        } else {
            this.modelPlayer.localSetRotationAngles(f, f2, f3, f4, f5, f6, entity);
        }
        if (this.afterSetRotationAnglesHooks != null) {
            for (n = 0; n < this.afterSetRotationAnglesHooks.length; ++n) {
                this.afterSetRotationAnglesHooks[n].afterSetRotationAngles(f, f2, f3, f4, f5, f6, entity);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetRotationAngles(ModelPlayerBase modelPlayerBase) {
        if (this.overrideSetRotationAnglesHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideSetRotationAnglesHooks.length; ++i) {
            if (this.overrideSetRotationAnglesHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetRotationAnglesHooks[i - 1];
        }
        return modelPlayerBase;
    }

    public static void setTextureOffset(IModelPlayerAPI iModelPlayerAPI, String string, int n, int n2) {
        ModelPlayerAPI modelPlayerAPI = iModelPlayerAPI.getModelPlayerAPI();
        if (modelPlayerAPI != null && modelPlayerAPI.isSetTextureOffsetModded) {
            modelPlayerAPI.setTextureOffset(string, n, n2);
        } else {
            iModelPlayerAPI.localSetTextureOffset(string, n, n2);
        }
    }

    private void setTextureOffset(String string, int n, int n2) {
        int n3;
        if (this.beforeSetTextureOffsetHooks != null) {
            for (n3 = this.beforeSetTextureOffsetHooks.length - 1; n3 >= 0; --n3) {
                this.beforeSetTextureOffsetHooks[n3].beforeSetTextureOffset(string, n, n2);
            }
        }
        if (this.overrideSetTextureOffsetHooks != null) {
            this.overrideSetTextureOffsetHooks[this.overrideSetTextureOffsetHooks.length - 1].setTextureOffset(string, n, n2);
        } else {
            this.modelPlayer.localSetTextureOffset(string, n, n2);
        }
        if (this.afterSetTextureOffsetHooks != null) {
            for (n3 = 0; n3 < this.afterSetTextureOffsetHooks.length; ++n3) {
                this.afterSetTextureOffsetHooks[n3].afterSetTextureOffset(string, n, n2);
            }
        }
    }

    protected ModelPlayerBase GetOverwrittenSetTextureOffset(ModelPlayerBase modelPlayerBase) {
        if (this.overrideSetTextureOffsetHooks == null) {
            return modelPlayerBase;
        }
        for (int i = 0; i < this.overrideSetTextureOffsetHooks.length; ++i) {
            if (this.overrideSetTextureOffsetHooks[i] != modelPlayerBase) continue;
            if (i == 0) {
                return null;
            }
            return this.overrideSetTextureOffsetHooks[i - 1];
        }
        return modelPlayerBase;
    }

    static {
        logger = Logger.getLogger("ModelPlayerAPI");
        allInstances = new ArrayList<WeakReference<IModelPlayerAPI>>();
        EmptySortMap = Collections.unmodifiableMap(new HashMap());
        beforeGetArmForSideHookTypes = new LinkedList<String>();
        overrideGetArmForSideHookTypes = new LinkedList<String>();
        afterGetArmForSideHookTypes = new LinkedList<String>();
        allBaseBeforeGetArmForSideSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetArmForSideInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetArmForSideSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetArmForSideInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetArmForSideSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetArmForSideInferiors = new Hashtable<String, String[]>(0);
        beforeGetMainHandHookTypes = new LinkedList<String>();
        overrideGetMainHandHookTypes = new LinkedList<String>();
        afterGetMainHandHookTypes = new LinkedList<String>();
        allBaseBeforeGetMainHandSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetMainHandInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetMainHandSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetMainHandInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetMainHandSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetMainHandInferiors = new Hashtable<String, String[]>(0);
        beforeGetRandomModelBoxHookTypes = new LinkedList<String>();
        overrideGetRandomModelBoxHookTypes = new LinkedList<String>();
        afterGetRandomModelBoxHookTypes = new LinkedList<String>();
        allBaseBeforeGetRandomModelBoxSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetRandomModelBoxInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetRandomModelBoxSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetRandomModelBoxInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetRandomModelBoxSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetRandomModelBoxInferiors = new Hashtable<String, String[]>(0);
        beforeGetTextureOffsetHookTypes = new LinkedList<String>();
        overrideGetTextureOffsetHookTypes = new LinkedList<String>();
        afterGetTextureOffsetHookTypes = new LinkedList<String>();
        allBaseBeforeGetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeGetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideGetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterGetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        beforePostRenderArmHookTypes = new LinkedList<String>();
        overridePostRenderArmHookTypes = new LinkedList<String>();
        afterPostRenderArmHookTypes = new LinkedList<String>();
        allBaseBeforePostRenderArmSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforePostRenderArmInferiors = new Hashtable<String, String[]>(0);
        allBaseOverridePostRenderArmSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverridePostRenderArmInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterPostRenderArmSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterPostRenderArmInferiors = new Hashtable<String, String[]>(0);
        beforeRenderHookTypes = new LinkedList<String>();
        overrideRenderHookTypes = new LinkedList<String>();
        afterRenderHookTypes = new LinkedList<String>();
        allBaseBeforeRenderSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeRenderInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderInferiors = new Hashtable<String, String[]>(0);
        beforeRenderCapeHookTypes = new LinkedList<String>();
        overrideRenderCapeHookTypes = new LinkedList<String>();
        afterRenderCapeHookTypes = new LinkedList<String>();
        allBaseBeforeRenderCapeSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeRenderCapeInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderCapeSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderCapeInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderCapeSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderCapeInferiors = new Hashtable<String, String[]>(0);
        beforeRenderDeadmau5HeadHookTypes = new LinkedList<String>();
        overrideRenderDeadmau5HeadHookTypes = new LinkedList<String>();
        afterRenderDeadmau5HeadHookTypes = new LinkedList<String>();
        allBaseBeforeRenderDeadmau5HeadSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeRenderDeadmau5HeadInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderDeadmau5HeadSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideRenderDeadmau5HeadInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderDeadmau5HeadSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterRenderDeadmau5HeadInferiors = new Hashtable<String, String[]>(0);
        beforeSetInvisibleHookTypes = new LinkedList<String>();
        overrideSetInvisibleHookTypes = new LinkedList<String>();
        afterSetInvisibleHookTypes = new LinkedList<String>();
        allBaseBeforeSetInvisibleSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetInvisibleInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetInvisibleSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetInvisibleInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetInvisibleSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetInvisibleInferiors = new Hashtable<String, String[]>(0);
        beforeSetLivingAnimationsHookTypes = new LinkedList<String>();
        overrideSetLivingAnimationsHookTypes = new LinkedList<String>();
        afterSetLivingAnimationsHookTypes = new LinkedList<String>();
        allBaseBeforeSetLivingAnimationsSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetLivingAnimationsInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetLivingAnimationsSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetLivingAnimationsInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetLivingAnimationsSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetLivingAnimationsInferiors = new Hashtable<String, String[]>(0);
        beforeSetModelAttributesHookTypes = new LinkedList<String>();
        overrideSetModelAttributesHookTypes = new LinkedList<String>();
        afterSetModelAttributesHookTypes = new LinkedList<String>();
        allBaseBeforeSetModelAttributesSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetModelAttributesInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetModelAttributesSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetModelAttributesInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetModelAttributesSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetModelAttributesInferiors = new Hashtable<String, String[]>(0);
        beforeSetRotationAnglesHookTypes = new LinkedList<String>();
        overrideSetRotationAnglesHookTypes = new LinkedList<String>();
        afterSetRotationAnglesHookTypes = new LinkedList<String>();
        allBaseBeforeSetRotationAnglesSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetRotationAnglesInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetRotationAnglesSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetRotationAnglesInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetRotationAnglesSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetRotationAnglesInferiors = new Hashtable<String, String[]>(0);
        beforeSetTextureOffsetHookTypes = new LinkedList<String>();
        overrideSetTextureOffsetHookTypes = new LinkedList<String>();
        afterSetTextureOffsetHookTypes = new LinkedList<String>();
        allBaseBeforeSetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeSetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseOverrideSetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetTextureOffsetSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterSetTextureOffsetInferiors = new Hashtable<String, String[]>(0);
        keys = new HashSet<String>();
        keysToVirtualIds = new HashMap<String, String>();
        dynamicTypes = new HashSet();
        virtualDynamicHookMethods = new HashMap();
        beforeDynamicHookMethods = new HashMap();
        overrideDynamicHookMethods = new HashMap();
        afterDynamicHookMethods = new HashMap();
        beforeLocalConstructingHookTypes = new LinkedList<String>();
        afterLocalConstructingHookTypes = new LinkedList<String>();
        beforeDynamicHookTypes = new Hashtable<String, List<String>>(0);
        overrideDynamicHookTypes = new Hashtable<String, List<String>>(0);
        afterDynamicHookTypes = new Hashtable<String, List<String>>(0);
        allBaseConstructors = new Hashtable();
        unmodifiableAllIds = Collections.unmodifiableSet(allBaseConstructors.keySet());
        allBaseBeforeLocalConstructingSuperiors = new Hashtable<String, String[]>(0);
        allBaseBeforeLocalConstructingInferiors = new Hashtable<String, String[]>(0);
        allBaseAfterLocalConstructingSuperiors = new Hashtable<String, String[]>(0);
        allBaseAfterLocalConstructingInferiors = new Hashtable<String, String[]>(0);
        allBaseBeforeDynamicSuperiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseBeforeDynamicInferiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseOverrideDynamicSuperiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseOverrideDynamicInferiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseAfterDynamicSuperiors = new Hashtable<String, Map<String, String[]>>(0);
        allBaseAfterDynamicInferiors = new Hashtable<String, Map<String, String[]>>(0);
        initialized = false;
    }
}

