/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets;

import de.maxhenkel.reusable_rockets.corelib.CommonRegistry;
import de.maxhenkel.rockets.ServerConfig;
import de.maxhenkel.rockets.item.ItemReusableRocket;
import de.maxhenkel.rockets.recipe.RefuelRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod(value="reusable_rockets")
public class Main {
    public static final String MODID = "reusable_rockets";
    public static ServerConfig SERVER_CONFIG;
    public static RefuelRecipe.RecipeRefuelSerializer CRAFTING_REFUEL;
    public static final ItemReusableRocket REUSABLE_ROCKET_TIER_1;
    public static final ItemReusableRocket REUSABLE_ROCKET_TIER_2;
    public static final ItemReusableRocket REUSABLE_ROCKET_TIER_3;
    public static ITag<Item> ROCKET_FUEL;

    public Main() {
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(Item.class, this::registerItems);
        FMLJavaModLoadingContext.get().getModEventBus().addGenericListener(IRecipeSerializer.class, this::registerRecipes);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::commonSetup);
        SERVER_CONFIG = CommonRegistry.registerConfig(ModConfig.Type.SERVER, ServerConfig.class);
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> this.clientStart());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void clientStart() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::clientSetup);
    }

    @SubscribeEvent
    public void commonSetup(FMLCommonSetupEvent event) {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public void clientSetup(FMLClientSetupEvent event) {
    }

    @SubscribeEvent
    public void registerRecipes(RegistryEvent.Register<IRecipeSerializer<?>> event) {
        CRAFTING_REFUEL = new RefuelRecipe.RecipeRefuelSerializer();
        CRAFTING_REFUEL.setRegistryName(new ResourceLocation(MODID, "refuel"));
        event.getRegistry().register((IForgeRegistryEntry)CRAFTING_REFUEL);
    }

    @SubscribeEvent
    public void registerItems(RegistryEvent.Register<Item> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{REUSABLE_ROCKET_TIER_1, REUSABLE_ROCKET_TIER_2, REUSABLE_ROCKET_TIER_3});
    }

    static {
        REUSABLE_ROCKET_TIER_1 = new ItemReusableRocket("reusable_rocket_tier_1", 32, 2);
        REUSABLE_ROCKET_TIER_2 = new ItemReusableRocket("reusable_rocket_tier_2", 64, 4);
        REUSABLE_ROCKET_TIER_3 = new ItemReusableRocket("reusable_rocket_tier_3", 128, 6);
        ROCKET_FUEL = ItemTags.func_199901_a((String)new ResourceLocation(MODID, "rocket_fuel").toString());
    }
}

