/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets.item;

import de.maxhenkel.rockets.Main;
import java.util.List;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.FireworkRocketEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.ActionResult;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;

public class ItemReusableRocket
extends Item {
    private final int maxDuration;

    public ItemReusableRocket(String name, int uses, int maxDuration) {
        super(new Item.Properties().func_200917_a(1).func_200916_a(ItemGroup.field_78026_f).func_200918_c(uses));
        this.maxDuration = maxDuration;
        this.setRegistryName(new ResourceLocation("reusable_rockets", name));
    }

    public ActionResult<ItemStack> func_77659_a(World world, PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (player.func_225608_bj_()) {
            byte duration = this.getFlightDuration(stack);
            if ((duration = (byte)(duration + 1)) > this.maxDuration) {
                duration = 1;
            }
            this.setFlightDuration(stack, duration);
            player.func_146105_b((ITextComponent)new TranslationTextComponent("message.reusable_rockets.set_flight_duration", new Object[]{duration, this.maxDuration}), true);
            player.func_184185_a(SoundEvents.field_187837_fU, 1.0f, 1.0f);
            return ActionResult.func_233538_a_((Object)player.func_184586_b(hand), (boolean)world.func_201670_d());
        }
        if (player.func_184613_cA() && stack.func_77952_i() < stack.func_77958_k()) {
            if (!((Boolean)Main.SERVER_CONFIG.allowRocketSpamming.get()).booleanValue() && this.isGettingBoosted(player)) {
                return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
            }
            if (!world.field_72995_K) {
                int duration = Math.min(this.getFlightDuration(stack), stack.func_77958_k() - stack.func_77952_i());
                world.func_217376_c((Entity)new FireworkRocketEntity(world, this.createDummyFirework((byte)duration), (LivingEntity)player));
                stack.func_196085_b(Math.min(stack.func_77958_k(), stack.func_77952_i() + duration));
            }
            return ActionResult.func_233538_a_((Object)player.func_184586_b(hand), (boolean)world.func_201670_d());
        }
        return ActionResult.func_226251_d_((Object)player.func_184586_b(hand));
    }

    protected byte getFlightDuration(ItemStack stack) {
        CompoundNBT tag = stack.func_196082_o();
        if (tag.func_74764_b("Duration")) {
            return tag.func_74771_c("Duration");
        }
        return 1;
    }

    protected void setFlightDuration(ItemStack stack, byte duration) {
        CompoundNBT tag = stack.func_196082_o();
        tag.func_74774_a("Duration", duration);
    }

    public boolean func_77616_k(ItemStack stack) {
        return false;
    }

    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tooltip, ITooltipFlag flag) {
        tooltip.add((ITextComponent)new TranslationTextComponent("item.minecraft.firework_rocket.flight").func_240702_b_(" ").func_240702_b_(String.valueOf(this.getFlightDuration(stack))).func_240699_a_(TextFormatting.GRAY));
        tooltip.add((ITextComponent)new TranslationTextComponent("tooltip.reusable_rockets.sneak_to_change").func_240699_a_(TextFormatting.GRAY));
        super.func_77624_a(stack, world, tooltip, flag);
    }

    protected ItemStack createDummyFirework(byte flightDuration) {
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196152_dE);
        stack.func_190925_c("Fireworks").func_74774_a("Flight", flightDuration);
        return stack;
    }

    public boolean isGettingBoosted(PlayerEntity player) {
        return player.field_70170_p.func_175647_a(FireworkRocketEntity.class, player.func_174813_aQ().func_186662_g(2.0), rocket -> {
            LivingEntity entity = null;
            try {
                entity = (LivingEntity)ObfuscationReflectionHelper.getPrivateValue(FireworkRocketEntity.class, (Object)rocket, (String)"field_191513_e");
            }
            catch (Exception exception) {
                // empty catch block
            }
            return entity == player;
        }).stream().findAny().isPresent();
    }
}

