/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.rockets.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import de.maxhenkel.rockets.Main;
import de.maxhenkel.rockets.item.ItemReusableRocket;
import java.util.ArrayList;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.ICraftingRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.ShapedRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.IShapedRecipe;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class RefuelRecipe
implements ICraftingRecipe,
IShapedRecipe<CraftingInventory> {
    private ResourceLocation id;
    private ItemStack rocket;
    private Ingredient fuel;

    public RefuelRecipe(ResourceLocation id, ItemStack rocket, Ingredient fuel) {
        this.id = id;
        this.rocket = rocket;
        this.fuel = fuel;
    }

    public int getRecipeWidth() {
        return 1;
    }

    public int getRecipeHeight() {
        return 1;
    }

    public NonNullList<Ingredient> func_192400_c() {
        return NonNullList.func_193580_a((Object)Ingredient.field_193370_a, (Object[])new Ingredient[]{Ingredient.func_193369_a((ItemStack[])new ItemStack[]{this.rocket}), this.fuel});
    }

    public boolean matches(CraftingInventory inv, World worldIn) {
        return this.craft(inv) != null;
    }

    public NonNullList<ItemStack> getRemainingItems(CraftingInventory inv) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.remaining;
    }

    public ItemStack getCraftingResult(CraftingInventory inv) {
        CraftingResult craft = this.craft(inv);
        if (craft == null) {
            return null;
        }
        return craft.result;
    }

    public boolean func_194133_a(int width, int height) {
        return width > 1 && height > 1;
    }

    public ItemStack func_77571_b() {
        return this.rocket;
    }

    public ResourceLocation func_199560_c() {
        return this.id;
    }

    public ItemStack getRocket() {
        return this.rocket;
    }

    public Ingredient getFuel() {
        return this.fuel;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return Main.CRAFTING_REFUEL;
    }

    protected CraftingResult craft(CraftingInventory inv) {
        ItemStack rocket = null;
        ArrayList<Integer> gunpowderSlotIndices = new ArrayList<Integer>();
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            if (stack.func_77973_b() instanceof ItemReusableRocket) {
                if (rocket != null) {
                    return null;
                }
                rocket = stack;
                continue;
            }
            if (!stack.func_77973_b().func_206844_a(Main.ROCKET_FUEL)) continue;
            gunpowderSlotIndices.add(i);
        }
        if (rocket == null || gunpowderSlotIndices.size() <= 0 || rocket.func_77952_i() <= 0) {
            return null;
        }
        ItemStack rocketOut = rocket.func_77946_l();
        int count = Math.min(rocketOut.func_77952_i(), gunpowderSlotIndices.size());
        NonNullList remaining = NonNullList.func_191197_a((int)inv.func_70302_i_(), (Object)ItemStack.field_190927_a);
        if (count < gunpowderSlotIndices.size()) {
            int reAddCount = gunpowderSlotIndices.size() - count;
            for (Integer index : gunpowderSlotIndices) {
                if (reAddCount <= 0) break;
                ItemStack gp = inv.func_70301_a(index.intValue()).func_77946_l();
                gp.func_190920_e(1);
                remaining.set(index.intValue(), (Object)gp);
                --reAddCount;
            }
        }
        rocketOut.func_196085_b(rocketOut.func_77952_i() - count);
        return new CraftingResult(rocketOut, (NonNullList<ItemStack>)remaining);
    }

    private static class CraftingResult {
        public final ItemStack result;
        public final NonNullList<ItemStack> remaining;

        public CraftingResult(ItemStack result, NonNullList<ItemStack> remaining) {
            this.result = result;
            this.remaining = remaining;
        }
    }

    public static class RecipeRefuelSerializer
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<RefuelRecipe> {
        public RefuelRecipe read(ResourceLocation resourceLocation, JsonObject jsonObject) {
            return new RefuelRecipe(resourceLocation, ShapedRecipe.func_199798_a((JsonObject)jsonObject.getAsJsonObject("rocket")), Ingredient.func_199802_a((JsonElement)jsonObject.getAsJsonObject("fuel")));
        }

        public RefuelRecipe read(ResourceLocation resourceLocation, PacketBuffer packetBuffer) {
            return new RefuelRecipe(packetBuffer.func_192575_l(), packetBuffer.func_150791_c(), Ingredient.func_199566_b((PacketBuffer)packetBuffer));
        }

        public void write(PacketBuffer packetBuffer, RefuelRecipe recipe) {
            packetBuffer.func_192572_a(recipe.func_199560_c());
            packetBuffer.func_150788_a(recipe.rocket);
            recipe.fuel.func_199564_a(packetBuffer);
        }
    }
}

