/*
 * Decompiled with CFR 0.152.
 */
package com.grumpychunks.scarper;

import com.grumpychunks.scarper.Scarper;
import com.grumpychunks.scarper.config.Config;
import java.util.List;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class EntityHandler {
    @SubscribeEvent
    public static void onMobAttacked(LivingAttackEvent event) {
        LivingEntity livingEntityUnderAttack = event.getEntityLiving();
        if (!(livingEntityUnderAttack instanceof CreatureEntity)) {
            return;
        }
        Entity entityDamageSource = event.getSource().func_76346_g();
        if (!(entityDamageSource instanceof PlayerEntity)) {
            return;
        }
        CreatureEntity creatureEntityUnderAttack = (CreatureEntity)livingEntityUnderAttack;
        PlayerEntity player = (PlayerEntity)entityDamageSource;
        EntityHandler.angerLocalMobs(creatureEntityUnderAttack, player);
    }

    private static void angerLocalMobs(CreatureEntity creatureUnderAttack, PlayerEntity player) {
        List<CreatureEntity> creaturesInRange = EntityHandler.getMobsInRange(creatureUnderAttack, Config.effectRange);
        EntityHandler.processNearbyCreatures(creaturesInRange, player, creatureUnderAttack);
    }

    private static List<CreatureEntity> getMobsInRange(CreatureEntity creatureUnderAttack, double blockRange) {
        Scarper.LOGGER.debug("BlockRange: " + blockRange);
        World world = creatureUnderAttack.func_130014_f_();
        BlockPos attackPosition = new BlockPos(creatureUnderAttack.func_226277_ct_(), creatureUnderAttack.func_226278_cu_(), creatureUnderAttack.func_226281_cx_());
        AxisAlignedBB boundingBox = new AxisAlignedBB((double)attackPosition.func_177958_n() - blockRange, (double)attackPosition.func_177956_o() - blockRange, (double)attackPosition.func_177952_p() - blockRange, (double)attackPosition.func_177958_n() + blockRange, (double)attackPosition.func_177956_o() + blockRange, (double)attackPosition.func_177952_p() + blockRange);
        return world.func_217357_a(CreatureEntity.class, boundingBox);
    }

    private static void processNearbyCreatures(List<CreatureEntity> creatures, PlayerEntity player, CreatureEntity creatureUnderAttack) {
        for (CreatureEntity creatureEntity : creatures) {
            if (creatureEntity instanceof AnimalEntity) {
                if (Config.onlySameSpecies && (!Config.onlySameSpecies || !EntityHandler.matchSpecies(creatureEntity, creatureUnderAttack))) continue;
                EntityHandler.mobScarper(creatureEntity);
                continue;
            }
            if (!Config.hostileMobsTargetAttacker) continue;
            EntityHandler.mobAttack(creatureEntity, player);
        }
    }

    private static boolean matchSpecies(CreatureEntity creature1, CreatureEntity creature2) {
        return creature1.getClass().equals(creature2.getClass());
    }

    private static void mobAttack(CreatureEntity creatureEntity, PlayerEntity player) {
        creatureEntity.func_70624_b((LivingEntity)player);
    }

    private static void mobScarper(CreatureEntity creatureEntity) {
        creatureEntity.field_70714_bg.func_75776_a(0, (Goal)new AvoidEntityGoal(creatureEntity, PlayerEntity.class, 24.0f, 1.0, 2.0));
    }
}

