/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import java.util.Collection;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.util.IGearComponent;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearHelper;

public interface IMaterial
extends IGearComponent<IMaterialInstance> {
    public String getPackName();

    public ResourceLocation getId();

    public IMaterialSerializer<?> getSerializer();

    @Nullable
    public IMaterial getParent();

    default public Optional<IMaterial> getParentOptional() {
        return Optional.ofNullable(this.getParent());
    }

    @Deprecated
    default public Collection<IMaterialCategory> getCategories() {
        return this.getCategories(MaterialInstance.of(this));
    }

    public Collection<IMaterialCategory> getCategories(MaterialInstance var1);

    public int getTier(PartType var1);

    public Optional<Ingredient> getPartSubstitute(PartType var1);

    public boolean hasPartSubstitutes();

    public boolean canSalvage();

    public boolean isSimple();

    public Set<PartType> getPartTypes(IMaterialInstance var1);

    public boolean allowedInPart(IMaterialInstance var1, PartType var2);

    default public void retainData(@Nullable IMaterial oldMaterial) {
    }

    public Collection<StatGearKey> getStatKeys(IMaterialInstance var1, PartType var2);

    @Deprecated
    default public IMaterialLayerList getMaterialDisplay(ItemStack gear, PartType partType) {
        return MaterialLayerList.DEFAULT;
    }

    public IFormattableTextComponent getDisplayName(PartType var1, ItemStack var2);

    default public IFormattableTextComponent getDisplayName(PartType partType) {
        return this.getDisplayName(partType, ItemStack.field_190927_a);
    }

    @Nullable
    public IFormattableTextComponent getDisplayNamePrefix(ItemStack var1, PartType var2);

    default public int getNameColor(PartType partType, ItemStack gear) {
        return this.getNameColor(partType, GearHelper.getType(gear, GearType.ALL));
    }

    @Deprecated
    default public int getNameColor(PartType partType, GearType gearType) {
        return this.getNameColor(partType, gearType, LazyMaterialInstance.of(Const.NULL_ID));
    }

    public int getNameColor(PartType var1, GearType var2, IMaterialInstance var3);

    default public String getModelKey(IMaterialInstance material) {
        return SilentGear.shortenId(this.getId());
    }

    default public boolean isVisible(PartType partType) {
        return true;
    }

    default public ItemStack getDisplayItem(PartType type, int ticks) {
        ItemStack[] stacks = this.getIngredient().func_193365_a();
        if (stacks.length == 0) {
            return ItemStack.field_190927_a;
        }
        return stacks[ticks / 20 % stacks.length];
    }

    public void updateIngredient(SyncMaterialCraftingItemsPacket var1);
}

