/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.material;

import com.google.gson.JsonObject;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.MaterialGrade;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.IGearComponentInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.util.TextUtil;

public interface IMaterialInstance
extends IGearComponentInstance<IMaterial> {
    @Deprecated
    default public ResourceLocation getMaterialId() {
        return this.getId();
    }

    @Deprecated
    @Nullable
    default public IMaterial getMaterial() {
        return (IMaterial)this.get();
    }

    public MaterialGrade getGrade();

    public int getTier(PartType var1);

    default public boolean isSimple() {
        IMaterial mat = (IMaterial)this.get();
        return mat != null && mat.isSimple();
    }

    default public float getStat(PartType partType, IItemStat stat) {
        return this.getStat(partType, StatGearKey.of(stat, GearType.ALL), ItemStack.field_190927_a);
    }

    @Override
    default public float getStat(PartType partType, StatGearKey key, ItemStack gear) {
        IMaterial material = (IMaterial)this.get();
        if (material != null) {
            return material.getStat(this, partType, key, gear);
        }
        return 0.0f;
    }

    @Override
    default public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key, ItemStack gear) {
        IMaterial material = (IMaterial)this.get();
        if (material == null) {
            return Collections.emptyList();
        }
        return material.getStatModifiers(this, partType, key, gear);
    }

    @Override
    default public Collection<TraitInstance> getTraits(PartType partType, GearType gearType, ItemStack gear) {
        IMaterial material = (IMaterial)this.get();
        if (material == null) {
            return Collections.emptyList();
        }
        return material.getTraits(this, partType, gearType, gear);
    }

    public CompoundNBT write(CompoundNBT var1);

    public IFormattableTextComponent getDisplayName(PartType var1, ItemStack var2);

    default public IFormattableTextComponent getDisplayName(PartType partType) {
        return this.getDisplayName(partType, ItemStack.field_190927_a);
    }

    public String getModelKey();

    default public IFormattableTextComponent getDisplayNameWithGrade(PartType partType) {
        IFormattableTextComponent displayName = this.getDisplayName(partType, ItemStack.field_190927_a);
        MaterialGrade grade = this.getGrade();
        if (grade != MaterialGrade.NONE) {
            displayName.func_230529_a_((ITextComponent)TextUtil.translate("misc", "spaceBrackets", grade.getDisplayName()));
        }
        return displayName;
    }

    default public JsonObject serialize() {
        JsonObject json = new JsonObject();
        json.addProperty("material", this.getId().toString());
        MaterialGrade grade = this.getGrade();
        if (grade != MaterialGrade.NONE) {
            json.addProperty("grade", grade.name());
        }
        return json;
    }

    public void write(PacketBuffer var1);
}

