/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.api.part;

import com.google.gson.JsonObject;
import com.google.gson.JsonSyntaxException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.client.model.PartTextures;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.LazyPartData;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.ToolHeadItem;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.lib.util.NameUtils;

public final class PartType {
    private static final Map<ResourceLocation, PartType> VALUES = new HashMap<ResourceLocation, PartType>();
    private static final Map<PartGearKey, Optional<CompoundPartItem>> ITEM_CACHE = new HashMap<PartGearKey, Optional<CompoundPartItem>>();
    public static final PartType NONE = PartType.create(Builder.builder(SilentGear.getId("none")));
    public static final PartType ADORNMENT = PartType.create(Builder.builder(SilentGear.getId("adornment")).compoundPartItem(() -> (CompoundPartItem)ModItems.ADORNMENT.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.ADORNMENT_GENERIC).isRemovable(true));
    public static final PartType BINDING = PartType.create(Builder.builder(SilentGear.getId("binding")).compoundPartItem(() -> (CompoundPartItem)ModItems.BINDING.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.BINDING_GENERIC).isRemovable(true));
    public static final PartType BOWSTRING = PartType.create(Builder.builder(SilentGear.getId("bowstring")).compoundPartItem(() -> (CompoundPartItem)ModItems.BOWSTRING.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.BOWSTRING_STRING));
    public static final PartType COATING = PartType.create(Builder.builder(SilentGear.getId("coating")).compoundPartItem(() -> (CompoundPartItem)ModItems.COATING.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.MAIN_GENERIC_HC).isRemovable(true));
    public static final PartType FLETCHING = PartType.create(Builder.builder(SilentGear.getId("fletching")).compoundPartItem(() -> (CompoundPartItem)ModItems.FLETCHING.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.FLETCHING_GENERIC));
    public static final PartType GRIP = PartType.create(Builder.builder(SilentGear.getId("grip")).compoundPartItem(() -> (CompoundPartItem)ModItems.GRIP.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.GRIP_WOOL).isRemovable(true));
    public static final PartType LINING = PartType.create(Builder.builder(SilentGear.getId("lining")).compoundPartItem(() -> (CompoundPartItem)ModItems.LINING.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.LINING_CLOTH).isRemovable(true));
    public static final PartType MAIN = PartType.create(Builder.builder(SilentGear.getId("main")).compoundPartItem(PartType::getToolHeadItem).defaultTexture(PartTextures.MAIN_GENERIC_HC));
    public static final PartType MISC_UPGRADE = PartType.create(Builder.builder(SilentGear.getId("misc_upgrade")).isRemovable(true).isUpgrade(true).maxPerItem(Integer.MAX_VALUE));
    public static final PartType ROD = PartType.create(Builder.builder(SilentGear.getId("rod")).compoundPartItem(() -> (CompoundPartItem)ModItems.ROD.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.ROD_GENERIC_LC));
    public static final PartType TIP = PartType.create(Builder.builder(SilentGear.getId("tip")).compoundPartItem(() -> (CompoundPartItem)ModItems.TIP.orElseThrow(IllegalStateException::new)).defaultTexture(PartTextures.TIP_SHARP).isRemovable(true));
    private final ResourceLocation name;
    private final boolean isRemovable;
    private final boolean isUpgrade;
    private final Function<GearType, Integer> maxPerItem;
    @Nullable
    private final Function<GearType, Optional<CompoundPartItem>> compoundPartItem;
    @Nullable
    private final PartTextures defaultTexture;

    public static PartType create(Builder builder) {
        if (VALUES.containsKey(builder.name)) {
            throw new IllegalArgumentException(String.format("Already have PartType \"%s\"", builder.name));
        }
        PartType type = new PartType(builder);
        VALUES.put(builder.name, type);
        return type;
    }

    @Nullable
    public static PartType get(ResourceLocation name) {
        return VALUES.get(name);
    }

    public static PartType getNonNull(ResourceLocation name) {
        PartType type = PartType.get(name);
        return type != null ? type : NONE;
    }

    public static Collection<PartType> getValues() {
        return VALUES.values();
    }

    public static PartType fromJson(JsonObject json, String key) {
        String str = JSONUtils.func_151200_h((JsonObject)json, (String)key);
        PartType type = PartType.get(new ModResourceLocation(str));
        if (type == null) {
            throw new JsonSyntaxException("Unknown part type: " + str);
        }
        return type;
    }

    private PartType(Builder builder) {
        this.name = builder.name;
        this.isRemovable = builder.isRemovable;
        this.isUpgrade = builder.isUpgrade;
        this.maxPerItem = builder.maxPerItem;
        this.compoundPartItem = builder.compoundPartItem;
        this.defaultTexture = builder.defaultTexture;
    }

    public boolean isInvalid() {
        return this == NONE;
    }

    public ResourceLocation getName() {
        return this.name;
    }

    public boolean isRemovable() {
        return this.isRemovable;
    }

    public boolean isUpgrade() {
        return this.isUpgrade;
    }

    public int getMaxPerItem(GearType gearType) {
        return this.maxPerItem.apply(gearType);
    }

    public IFormattableTextComponent getDisplayName(int tier) {
        return new TranslationTextComponent("part." + this.name.func_110624_b() + ".type." + this.name.func_110623_a());
    }

    public ResourceLocation getCompoundPartId(GearType gearType) {
        return this.getCompoundPartItem(gearType).map(NameUtils::from).orElseGet(() -> SilentGear.getId("invalid"));
    }

    public Optional<? extends CompoundPartItem> getCompoundPartItem(GearType gearType) {
        if (this.compoundPartItem == null) {
            return Optional.empty();
        }
        PartGearKey key = PartGearKey.of(gearType, this);
        return ITEM_CACHE.computeIfAbsent(key, gt -> this.compoundPartItem.apply(gearType));
    }

    public Optional<? extends IPartData> makeCompoundPart(GearType gearType, DataResource<IMaterial> material) {
        return this.makeCompoundPart(gearType, Collections.singletonList(LazyMaterialInstance.of(material)));
    }

    public Optional<? extends IPartData> makeCompoundPart(GearType gearType, List<IMaterialInstance> materials) {
        return this.getCompoundPartItem(gearType).map(item -> {
            ItemStack stack = item.create(materials);
            return LazyPartData.of(this.getCompoundPartId(gearType), stack);
        });
    }

    private static Optional<CompoundPartItem> getToolHeadItem(GearType gearType) {
        for (Item item : ForgeRegistries.ITEMS.getValues()) {
            if (!(item instanceof ToolHeadItem) || gearType != ((ToolHeadItem)item).getGearType()) continue;
            return Optional.of((CompoundPartItem)item);
        }
        return Optional.empty();
    }

    @Nullable
    public PartTextures getDefaultTexture() {
        return this.defaultTexture;
    }

    public String toString() {
        return "PartType{name='" + this.name + "'}";
    }

    public static final class Builder {
        private final ResourceLocation name;
        private boolean isRemovable = false;
        private boolean isUpgrade = false;
        @Nullable
        private Function<GearType, Optional<CompoundPartItem>> compoundPartItem;
        private Function<GearType, Integer> maxPerItem = gt -> 1;
        @Nullable
        private PartTextures defaultTexture;

        private Builder(ResourceLocation name) {
            this.name = name;
        }

        public static Builder builder(ResourceLocation name) {
            return new Builder(name);
        }

        public Builder isRemovable(boolean value) {
            this.isRemovable = value;
            return this;
        }

        public Builder isUpgrade(boolean value) {
            this.isUpgrade = value;
            return this;
        }

        public Builder compoundPartItem(Supplier<CompoundPartItem> item) {
            return this.compoundPartItem((GearType gt) -> Optional.ofNullable(item.get()));
        }

        public Builder compoundPartItem(Function<GearType, Optional<CompoundPartItem>> itemGetter) {
            this.compoundPartItem = itemGetter;
            return this;
        }

        public Builder maxPerItem(int value) {
            return this.maxPerItem(gt -> value);
        }

        public Builder maxPerItem(Function<GearType, Integer> function) {
            this.maxPerItem = function;
            return this;
        }

        public Builder defaultTexture(PartTextures texture) {
            this.defaultTexture = texture;
            return this;
        }
    }
}

