/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.block.compounder;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.stream.IntStream;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IIntArray;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.block.compounder.CompounderContainer;
import net.silentchaos512.gear.block.compounder.CompounderInfo;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.lib.tile.LockableSidedInventoryTileEntity;
import net.silentchaos512.lib.tile.SyncVariable;
import net.silentchaos512.lib.util.InventoryUtils;
import net.silentchaos512.lib.util.TimeUtils;

public class CompounderTileEntity<R extends CompoundingRecipe>
extends LockableSidedInventoryTileEntity
implements ITickableTileEntity {
    public static final int STANDARD_INPUT_SLOTS = 4;
    static final int WORK_TIME = TimeUtils.ticksFromSeconds((float)(SilentGear.isDevBuild() ? 2.0f : 10.0f));
    private final CompounderInfo<R> info;
    private final int[] allSlots;
    @SyncVariable(name="Progress")
    private int progress = 0;
    @SyncVariable(name="WorkEnabled")
    private boolean workEnabled = true;
    private final IIntArray fields = new IIntArray(){

        public int func_221476_a(int index) {
            switch (index) {
                case 0: {
                    return CompounderTileEntity.this.progress;
                }
                case 1: {
                    return CompounderTileEntity.this.workEnabled ? 1 : 0;
                }
            }
            return 0;
        }

        public void func_221477_a(int index, int value) {
            switch (index) {
                case 0: {
                    CompounderTileEntity.this.progress = value;
                    break;
                }
                case 1: {
                    CompounderTileEntity.this.workEnabled = value != 0;
                }
            }
        }

        public int func_221478_a() {
            return 2;
        }
    };

    public CompounderTileEntity(CompounderInfo<R> info) {
        super(info.getTileEntityType(), info.getInputSlotCount() + 2);
        this.info = info;
        this.allSlots = IntStream.range(0, this.items.size()).toArray();
    }

    protected IRecipeType<R> getRecipeType() {
        return this.info.getRecipeType();
    }

    @Nullable
    public R getRecipe() {
        if (this.field_145850_b == null) {
            return null;
        }
        return (R)((CompoundingRecipe)this.field_145850_b.func_199532_z().func_215371_a(this.getRecipeType(), (IInventory)this, this.field_145850_b).orElse(null));
    }

    protected CompoundMaterialItem getOutputItem(Collection<MaterialInstance> materials) {
        return this.info.getOutputItem();
    }

    protected ItemStack getWorkOutput(@Nullable R recipe, List<MaterialInstance> materials) {
        if (recipe != null) {
            return ((CompoundingRecipe)recipe).getCraftingResult(this);
        }
        return this.getOutputItem(materials).create(materials);
    }

    public int getInputSlotCount() {
        return this.func_70302_i_() - 2;
    }

    public int getOutputSlotIndex() {
        return this.func_70302_i_() - 2;
    }

    public int getOutputHintSlotIndex() {
        return this.func_70302_i_() - 1;
    }

    public void encodeExtraData(PacketBuffer buffer) {
        buffer.writeByte(this.items.size());
        buffer.writeByte(this.fields.func_221478_a());
    }

    private boolean areInputsEmpty() {
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            if (this.func_70301_a(i).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    public void func_73660_a() {
        if (this.field_145850_b == null || this.field_145850_b.field_72995_K || this.areInputsEmpty()) {
            this.updateOutputHint(ItemStack.field_190927_a);
            return;
        }
        R recipe = this.getRecipe();
        if (recipe != null) {
            this.doWork(recipe, Collections.emptyList());
        } else {
            List<MaterialInstance> materials = this.getInputs();
            if (!CompounderTileEntity.hasMultipleMaterials(materials) || !this.canCompoundMaterials(materials)) {
                this.stopWork(true);
                return;
            }
            this.doWork(null, materials);
        }
    }

    private void doWork(@Nullable R recipe, List<MaterialInstance> materials) {
        assert (this.field_145850_b != null);
        ItemStack current = this.func_70301_a(this.getOutputSlotIndex());
        ItemStack output = this.getWorkOutput(recipe, materials);
        this.updateOutputHint(output);
        if (!current.func_190926_b()) {
            int newCount = current.func_190916_E() + output.func_190916_E();
            if (!InventoryUtils.canItemsStack((ItemStack)current, (ItemStack)output) || newCount > output.func_77976_d()) {
                this.stopWork(false);
                return;
            }
        }
        if (this.workEnabled) {
            if (this.progress < WORK_TIME) {
                ++this.progress;
            }
            if (this.progress >= WORK_TIME && !this.field_145850_b.field_72995_K) {
                this.finishWork(recipe, materials, current);
            }
        } else {
            this.stopWork(false);
        }
    }

    private void updateOutputHint(ItemStack hintStack) {
        this.func_70299_a(this.getOutputHintSlotIndex(), hintStack);
    }

    private void stopWork(boolean clearHintItem) {
        this.progress = 0;
        if (clearHintItem) {
            this.func_70299_a(this.getOutputHintSlotIndex(), ItemStack.field_190927_a);
        }
    }

    private void finishWork(@Nullable R recipe, List<MaterialInstance> materials, ItemStack current) {
        this.progress = 0;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            this.func_70298_a(i, 1);
        }
        ItemStack output = this.getWorkOutput(recipe, materials);
        if (!current.func_190926_b()) {
            current.func_190917_f(output.func_190916_E());
        } else {
            this.func_70299_a(this.getOutputSlotIndex(), output);
        }
    }

    private static boolean hasMultipleMaterials(List<MaterialInstance> materials) {
        if (materials.size() < 2) {
            return false;
        }
        IMaterial first = materials.get(0).get();
        for (int i = 1; i < materials.size(); ++i) {
            if (materials.get(i).get() == first) continue;
            return true;
        }
        return false;
    }

    private boolean canCompoundMaterials(List<MaterialInstance> materials) {
        HashSet<PartType> partTypes = new HashSet<PartType>(PartType.getValues());
        for (MaterialInstance material : materials) {
            if (!material.hasAnyCategory(this.info.getCategories())) {
                return false;
            }
            partTypes.removeIf(pt -> !material.getPartTypes().contains(pt));
        }
        return !partTypes.isEmpty();
    }

    private List<MaterialInstance> getInputs() {
        boolean allEmpty = true;
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            allEmpty = false;
            break;
        }
        if (allEmpty) {
            return Collections.emptyList();
        }
        ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
        for (int i = 0; i < this.getInputSlotCount(); ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            MaterialInstance material = MaterialInstance.from(stack);
            if (material != null && material.get().isSimple()) {
                ret.add(material);
                continue;
            }
            return Collections.emptyList();
        }
        return ret;
    }

    NonNullList<ItemStack> getItemsToDrop() {
        NonNullList ret = NonNullList.func_191196_a();
        for (int i = 0; i < this.func_70302_i_() - 1; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            ret.add((Object)stack);
        }
        return ret;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
    }

    public int[] func_180463_a(Direction side) {
        return (int[])this.allSlots.clone();
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return index < this.getInputSlotCount();
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, @Nullable Direction direction) {
        return this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == this.getOutputSlotIndex();
    }

    protected ITextComponent func_213907_g() {
        return new TranslationTextComponent("container.silentgear.compounder");
    }

    protected Container func_213906_a(int id, PlayerInventory player) {
        return new CompounderContainer(this.info.getContainerType(), id, player, (IInventory)this, this.fields, this.info.getCategories());
    }

    public void func_230337_a_(BlockState state, CompoundNBT tags) {
        super.func_230337_a_(state, tags);
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
    }

    public CompoundNBT func_189515_b(CompoundNBT tags) {
        CompoundNBT compoundTag = super.func_189515_b(tags);
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)compoundTag, (SyncVariable.Type)SyncVariable.Type.WRITE);
        return compoundTag;
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT tags = super.func_189517_E_();
        SyncVariable.Helper.writeSyncVars((Object)((Object)this), (CompoundNBT)tags, (SyncVariable.Type)SyncVariable.Type.PACKET);
        return tags;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        super.onDataPacket(net, packet);
        CompoundNBT tags = packet.func_148857_g();
        SyncVariable.Helper.readSyncVars((Object)((Object)this), (CompoundNBT)tags);
    }
}

