/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;

public class CompoundMaterialDisplay
implements IMaterialDisplay {
    public static final CompoundMaterialDisplay INSTANCE = new CompoundMaterialDisplay();

    @Override
    public ResourceLocation getMaterialId() {
        return Const.NULL_ID;
    }

    @Override
    public IMaterialLayerList getLayerList(GearType gearType, IPartData part, IMaterialInstance material) {
        MaterialInstance primary;
        if (!material.isSimple() && (primary = IColoredMaterialItem.getPrimarySubMaterial(material.getItem())) != null) {
            IMaterialDisplay model = MaterialDisplayManager.get(primary.get());
            return model.getLayerList(gearType, part, material);
        }
        return MaterialLayerList.DEFAULT;
    }

    @Override
    public int getLayerColor(GearType gearType, IPartData part, IMaterialInstance materialIn, int layer) {
        ItemStack stack;
        List<MaterialLayer> layers = this.getLayerList(gearType, part, materialIn).getLayers();
        if (layer < layers.size() && (stack = materialIn.getItem()).func_77973_b() instanceof CompoundMaterialItem) {
            List<MaterialInstance> subMaterials = CompoundMaterialItem.getSubMaterials(stack);
            int color = ColorUtils.getBlendedColor((CompoundMaterialItem)stack.func_77973_b(), subMaterials, layer);
            return color;
        }
        return 0xFFFFFF;
    }
}

