/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.material;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.resource.IResourceType;
import net.minecraftforge.resource.VanillaResourceType;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartDisplay;
import net.silentchaos512.gear.api.part.PartDisplay;
import net.silentchaos512.gear.client.material.CompoundMaterialDisplay;
import net.silentchaos512.gear.client.material.DefaultMaterialDisplay;
import net.silentchaos512.gear.client.material.MaterialDisplay;
import net.silentchaos512.gear.client.model.fragment.FragmentModelLoader;
import net.silentchaos512.gear.client.model.gear.GearModelLoader;
import net.silentchaos512.gear.client.model.part.CompoundPartModelLoader;
import net.silentchaos512.gear.util.IEarlySelectiveReloadListener;
import net.silentchaos512.gear.util.TextUtil;
import org.apache.commons.io.IOUtils;

public final class MaterialDisplayManager
implements IEarlySelectiveReloadListener {
    public static final MaterialDisplayManager INSTANCE = new MaterialDisplayManager();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static final String PATH_MATERIALS = "silentgear_materials";
    private static final String PATH_PARTS = "silentgear_parts";
    private static final Map<ResourceLocation, IMaterialDisplay> MATERIALS = Collections.synchronizedMap(new LinkedHashMap());
    private static final Map<ResourceLocation, IPartDisplay> PARTS = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();

    private MaterialDisplayManager() {
    }

    @Override
    public void onResourceManagerReload(IResourceManager resourceManager, Predicate<IResourceType> predicate) {
        if (predicate.test((IResourceType)VanillaResourceType.MODELS)) {
            CompoundPartModelLoader.clearCaches();
            FragmentModelLoader.clearCaches();
            GearModelLoader.clearCaches();
            ERROR_LIST.clear();
            MaterialDisplayManager.reloadMaterials(resourceManager);
            MaterialDisplayManager.reloadParts(resourceManager);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadMaterials(IResourceManager resourceManager) {
        Collection resources = resourceManager.func_199003_a(PATH_MATERIALS, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IMaterialDisplay> map = MATERIALS;
        synchronized (map) {
            SilentGear.LOGGER.info("Reloading material model files");
            MATERIALS.clear();
            String packName = "ERROR";
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(PATH_MATERIALS.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        packName = iresource.func_199026_d();
                        JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error("Could not load material model {} as it's null or empty", (Object)name);
                            continue;
                        }
                        MaterialDisplay model = MaterialDisplay.deserialize(name, json);
                        MATERIALS.put(name, model);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error("Parsing error loading material model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("material:%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error("Could not read material model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("material:%s (%s)", name, packName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void reloadParts(IResourceManager resourceManager) {
        Collection resources = resourceManager.func_199003_a(PATH_PARTS, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        Map<ResourceLocation, IPartDisplay> map = PARTS;
        synchronized (map) {
            SilentGear.LOGGER.info("Reloading part model files");
            PARTS.clear();
            String packName = "ERROR";
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(PATH_PARTS.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        packName = iresource.func_199026_d();
                        JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error("Could not load part model {} as it's null or empty", (Object)name);
                            continue;
                        }
                        PartDisplay model = PartDisplay.deserialize(name, json);
                        PARTS.put(name, model);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error("Parsing error loading part model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("part:%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error("Could not read part model {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("part:%s (%s)", name, packName));
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IMaterialDisplay> getMaterials() {
        Map<ResourceLocation, IMaterialDisplay> map = MATERIALS;
        synchronized (map) {
            return MATERIALS.values();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Collection<IPartDisplay> getParts() {
        Map<ResourceLocation, IPartDisplay> map = PARTS;
        synchronized (map) {
            return PARTS.values();
        }
    }

    public static IMaterialDisplay get(IMaterialInstance material) {
        IMaterial mat = (IMaterial)material.get();
        return mat != null ? MaterialDisplayManager.get(mat) : MaterialDisplayManager.getMaterial(material.getId());
    }

    @Deprecated
    public static IMaterialDisplay get(IMaterial material) {
        if (!MATERIALS.containsKey(material.getId()) && !material.isSimple()) {
            return CompoundMaterialDisplay.INSTANCE;
        }
        return MaterialDisplayManager.getMaterial(material.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    public static IMaterialDisplay getMaterial(ResourceLocation materialId) {
        Map<ResourceLocation, IMaterialDisplay> map = MATERIALS;
        synchronized (map) {
            return MATERIALS.getOrDefault(materialId, DefaultMaterialDisplay.INSTANCE);
        }
    }

    @Nullable
    public static IPartDisplay get(IGearPart part) {
        return MaterialDisplayManager.getPart(part.getId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IPartDisplay getPart(ResourceLocation partId) {
        Map<ResourceLocation, IPartDisplay> map = PARTS;
        synchronized (map) {
            return PARTS.get(partId);
        }
    }

    public static Collection<ITextComponent> getErrorMessages(PlayerEntity player) {
        ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            ret.add((ITextComponent)TextUtil.withColor((IFormattableTextComponent)new StringTextComponent("[Silent Gear] The following part/material models failed to load, check your log file:"), TextFormatting.RED));
            ret.add((ITextComponent)new StringTextComponent(listStr));
        }
        return ret;
    }
}

