/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.fragment;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.fragment.FragmentModel;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.item.FragmentItem;

public class FragmentModelOverrideList
extends ItemOverrideList {
    private final Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final FragmentModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private final IModelTransform modelTransform;
    private final ResourceLocation modelLocation;

    public FragmentModelOverrideList(FragmentModel model, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    @Nullable
    public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
        CacheKey key = FragmentModelOverrideList.getKey(model, stack, (World)worldIn, entityIn);
        try {
            return (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, worldIn, entityIn));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return model;
        }
    }

    private IBakedModel getOverrideModel(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
        ArrayList<MaterialLayer> layers = new ArrayList<MaterialLayer>();
        IMaterial material = FragmentItem.getMaterial(stack);
        if (material != null) {
            IMaterialDisplay model = MaterialDisplayManager.get(material);
            for (MaterialLayer layer : model.getLayerList(GearType.FRAGMENT, PartType.MAIN, (IMaterialInstance)MaterialInstance.of(material))) {
                layers.add(layer);
            }
        }
        return this.model.bake(layers, this.owner, this.bakery, this.spriteGetter, this.modelTransform, this, this.modelLocation);
    }

    private static CacheKey getKey(IBakedModel model, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        return new CacheKey(model, FragmentItem.getModelKey(stack));
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return super.getOverrides();
    }

    public void clearCache() {
        SilentGear.LOGGER.debug("Clearing model cache for fragments");
        this.bakedModelCache.invalidateAll();
    }

    static final class CacheKey {
        final IBakedModel parent;
        final String data;

        CacheKey(IBakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parent == cacheKey.parent && Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.data.hashCode();
        }
    }
}

