/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.gear;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.client.renderer.model.ItemCameraTransforms;
import net.minecraft.resources.IResourceManager;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModelLoader;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.model.gear.GearModel;

public class GearModelLoader
implements IModelLoader<GearModel> {
    private static final Collection<GearModel> MODELS = new ArrayList<GearModel>();

    public static void clearCaches() {
        MODELS.forEach(GearModel::clearCache);
    }

    public void func_195410_a(IResourceManager resourceManager) {
        MODELS.clear();
    }

    public GearModel read(JsonDeserializationContext deserializationContext, JsonObject modelContents) {
        String gearTypeStr;
        GearType gearType;
        ItemCameraTransforms cameraTransforms = (ItemCameraTransforms)deserializationContext.deserialize(modelContents.get("display"), ItemCameraTransforms.class);
        if (cameraTransforms == null) {
            cameraTransforms = ItemCameraTransforms.field_178357_a;
        }
        if ((gearType = GearType.get(gearTypeStr = JSONUtils.func_151200_h((JsonObject)modelContents, (String)"gear_type"))).isInvalid()) {
            throw new NullPointerException("Unknown gear type: " + gearTypeStr);
        }
        String texturePath = JSONUtils.func_151219_a((JsonObject)modelContents, (String)"texture_path", (String)gearType.getName());
        String brokenTexturePath = JSONUtils.func_151219_a((JsonObject)modelContents, (String)"broken_texture_path", (String)gearType.getName());
        ArrayList<PartType> brokenTextureTypes = new ArrayList<PartType>();
        JsonArray brokenTypesJson = JSONUtils.func_151213_a((JsonObject)modelContents, (String)"broken_texture_types", null);
        if (brokenTypesJson != null) {
            for (JsonElement element : brokenTypesJson) {
                ResourceLocation id = SilentGear.getIdWithDefaultNamespace(element.getAsString());
                if (id == null) continue;
                PartType type = PartType.get(id);
                if (type != null) {
                    brokenTextureTypes.add(type);
                    continue;
                }
                SilentGear.LOGGER.error("Unknown part type '{}' in model {}", (Object)id, (Object)this.func_225594_i_());
            }
        }
        GearModel model = new GearModel(cameraTransforms, gearType, texturePath, brokenTexturePath, brokenTextureTypes);
        MODELS.add(model);
        return model;
    }
}

