/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.client.model.part;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.model.IModelTransform;
import net.minecraft.client.renderer.model.ItemOverride;
import net.minecraft.client.renderer.model.ItemOverrideList;
import net.minecraft.client.renderer.model.ModelBakery;
import net.minecraft.client.renderer.model.RenderMaterial;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.client.model.IModelConfiguration;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.client.model.part.CompoundPartModel;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.item.CompoundPartItem;

public class CompoundPartModelOverrideList
extends ItemOverrideList {
    private final Cache<CacheKey, IBakedModel> bakedModelCache = CacheBuilder.newBuilder().maximumSize(1000L).expireAfterWrite(5L, TimeUnit.MINUTES).build();
    private final CompoundPartModel model;
    private final IModelConfiguration owner;
    private final ModelBakery bakery;
    private final Function<RenderMaterial, TextureAtlasSprite> spriteGetter;
    private final IModelTransform modelTransform;
    private final ResourceLocation modelLocation;

    public CompoundPartModelOverrideList(CompoundPartModel model, IModelConfiguration owner, ModelBakery bakery, Function<RenderMaterial, TextureAtlasSprite> spriteGetter, IModelTransform modelTransform, ResourceLocation modelLocation) {
        this.model = model;
        this.owner = owner;
        this.bakery = bakery;
        this.spriteGetter = spriteGetter;
        this.modelTransform = modelTransform;
        this.modelLocation = modelLocation;
    }

    @Nullable
    public IBakedModel func_239290_a_(IBakedModel model, ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
        CacheKey key = CompoundPartModelOverrideList.getKey(model, stack, (World)worldIn, entityIn);
        try {
            return (IBakedModel)this.bakedModelCache.get((Object)key, () -> this.getOverrideModel(stack, worldIn, entityIn));
        }
        catch (ExecutionException e) {
            e.printStackTrace();
            return model;
        }
    }

    private IBakedModel getOverrideModel(ItemStack stack, @Nullable ClientWorld worldIn, @Nullable LivingEntity entityIn) {
        ArrayList<MaterialLayer> layers = new ArrayList<MaterialLayer>();
        PartData part = PartData.from(stack);
        MaterialInstance primaryMaterial = CompoundPartItem.getPrimaryMaterial(stack);
        if (part != null && primaryMaterial != null) {
            this.addWithBlendedColor(layers, part, primaryMaterial, stack);
        }
        return this.model.bake(layers, "test", this.owner, this.bakery, this.spriteGetter, this.modelTransform, this, this.modelLocation);
    }

    private void addWithBlendedColor(List<MaterialLayer> list, PartData part, MaterialInstance material, ItemStack stack) {
        IMaterialDisplay materialModel = MaterialDisplayManager.get(material.get());
        List<MaterialLayer> layers = materialModel.getLayerList(this.model.gearType, part, (IMaterialInstance)material).getLayers();
        for (int i = 0; i < layers.size(); ++i) {
            MaterialLayer layer = layers.get(i);
            if ((layer.getColor() & 0xFFFFFF) < 0xFFFFFF) {
                int blendedColor = part.getColor(stack, i, 0);
                list.add(new MaterialLayer(layer.getTextureId(), part.getType(), blendedColor, false));
                continue;
            }
            list.add(layer);
        }
    }

    private static CacheKey getKey(IBakedModel model, ItemStack stack, @Nullable World world, @Nullable LivingEntity entity) {
        return new CacheKey(model, CompoundPartItem.getModelKey(stack));
    }

    public ImmutableList<ItemOverride> getOverrides() {
        return super.getOverrides();
    }

    public void clearCache() {
        SilentGear.LOGGER.debug("Clearing model cache for {}/{}", (Object)this.model.partType, (Object)this.model.gearType);
        this.bakedModelCache.invalidateAll();
    }

    static final class CacheKey {
        final IBakedModel parent;
        final String data;

        CacheKey(IBakedModel parent, String hash) {
            this.parent = parent;
            this.data = hash;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            CacheKey cacheKey = (CacheKey)o;
            return this.parent == cacheKey.parent && Objects.equals(this.data, cacheKey.data);
        }

        public int hashCode() {
            return 31 * this.parent.hashCode() + this.data.hashCode();
        }
    }
}

