/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.command.arguments.ResourceLocationArgument;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.network.NetworkDirection;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.SimpleTrait;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.gear.trait.TraitSerializers;
import net.silentchaos512.gear.gear.trait.condition.AndTraitCondition;
import net.silentchaos512.gear.network.ClientOutputCommandPacket;
import net.silentchaos512.gear.network.Network;

public final class TraitsCommand {
    private static final SuggestionProvider<CommandSource> TRAIT_ID_SUGGESTIONS = (ctx, builder) -> ISuggestionProvider.func_212476_a(TraitManager.getValues().stream().map(ITrait::getId), (SuggestionsBuilder)builder);
    private static final String TRAITS_DATA_PATH = "https://github.com/SilentChaos512/Silent-Gear/tree/1.16.x/src/generated/resources/data/silentgear/silentgear_traits/";

    private TraitsCommand() {
    }

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"sgear_traits").then(Commands.func_197057_a((String)"describe").then(Commands.func_197056_a((String)"traitID", (ArgumentType)ResourceLocationArgument.func_197197_a()).suggests(TRAIT_ID_SUGGESTIONS).executes(context -> TraitsCommand.runDescribe((CommandContext<CommandSource>)context, ResourceLocationArgument.func_197195_e((CommandContext)context, (String)"traitID")))))).then(Commands.func_197057_a((String)"dump_md").executes(TraitsCommand::runDumpMd))).then(Commands.func_197057_a((String)"list").executes(TraitsCommand::runList)));
    }

    private static int runDescribe(CommandContext<CommandSource> context, ResourceLocation traitId) {
        ITrait trait = TraitManager.get(traitId);
        if (trait == null) {
            ((CommandSource)context.getSource()).func_197021_a((ITextComponent)new TranslationTextComponent("command.silentgear.traits.traitNotFound", new Object[]{traitId}));
            return 0;
        }
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)trait.getDisplayName(0), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)trait.getDescription(1), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new TranslationTextComponent("command.silentgear.traits.maxLevel", new Object[]{trait.getMaxLevel()}), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Object: " + trait), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Serializer: " + trait.getSerializer()), true);
        return 1;
    }

    private static int runList(CommandContext<CommandSource> context) {
        String listStr = TraitManager.getValues().stream().map(trait -> trait.getId().toString()).collect(Collectors.joining(", "));
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent(listStr), true);
        ((CommandSource)context.getSource()).func_197030_a((ITextComponent)new StringTextComponent("Total: " + TraitManager.getValues().size()), true);
        return 1;
    }

    private static int runDumpMd(CommandContext<CommandSource> context) throws CommandSyntaxException {
        ServerPlayerEntity player = ((CommandSource)context.getSource()).func_197035_h();
        SilentGear.LOGGER.info("Send traits wiki dump packet to client {}", (Object)player.func_195047_I_());
        ClientOutputCommandPacket message = new ClientOutputCommandPacket(ClientOutputCommandPacket.Type.TRAITS, true);
        Network.channel.sendTo((Object)message, player.field_71135_a.field_147371_a, NetworkDirection.PLAY_TO_CLIENT);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runDumpMdClient() {
        PlayerEntity player = SilentGear.PROXY.getClientPlayer();
        if (player == null) {
            SilentGear.LOGGER.error("TraitsCommand#runDumpMcClient: player is null?");
            return;
        }
        String dirPath = "output/silentgear";
        String fileName = "traits_list.md";
        File output = new File(dirPath, fileName);
        File directory = output.getParentFile();
        if (!directory.exists() && !directory.mkdirs()) {
            player.func_145747_a((ITextComponent)new StringTextComponent("Could not create directory: " + output.getParent()), Util.field_240973_b_);
            return;
        }
        try (OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(output), StandardCharsets.UTF_8);){
            writer.write("# Traits\n\n");
            writer.write("Generated in-game by `sgear_traits dump_md` command on " + TraitsCommand.getCurrentDateTime() + "\n\n");
            writer.write("This data may or may not be accurate depending on the mod pack you are playing and the mods or data packs installed.\n\n");
            writer.write("## Data Sources\n\n");
            writer.write("The following mods and data packs have added traits to the output. Running the dump command yourself may produce different results.\n\n");
            writer.write(TraitsCommand.getDataSources() + "\n");
            writer.write("## Trait Types\n\n");
            writer.write("These are trait serializers. You can define custom instances of these types using data packs.\n");
            writer.write("Code for traits and their serializers can be found in `net.silentchaos512.gear.gear.trait`.\n\n");
            writer.write("Note that \"simple\" traits are often used where custom code is required.\n");
            writer.write("They are not especially useful when just defined by a data pack.\n\n");
            for (ITraitSerializer<?> serializer : TraitSerializers.getSerializers()) {
                String typeName = serializer instanceof SimpleTrait.Serializer ? ((SimpleTrait.Serializer)serializer).getTypeName() : "";
                writer.write("- `" + serializer.getName() + "`");
                if (!typeName.isEmpty()) {
                    writer.write(" _(" + typeName + ")_");
                }
                writer.write("\n");
            }
            writer.write("\n## List of Traits");
            ArrayList<ResourceLocation> ids = new ArrayList<ResourceLocation>(TraitManager.getKeys());
            ids.sort(Comparator.comparing(id -> Objects.requireNonNull(TraitManager.get(id)).getDisplayName(0).getString()));
            for (ResourceLocation id2 : ids) {
                Collection<String> wikiLines;
                ITrait trait = TraitManager.get(id2);
                assert (trait != null);
                writer.write("\n");
                writer.write("### " + TraitsCommand.getLinkToBuiltinTraitJson(id2, trait.getDisplayName(0).getString()) + "\n");
                writer.write("- " + trait.getDescription(0).getString() + "\n");
                String materialsWithTrait = TraitsCommand.getMaterialsWithTrait(trait);
                writer.write("- Found On:\n  - Materials: " + (materialsWithTrait.isEmpty() ? "Nothing" : materialsWithTrait) + "\n");
                String partsWithTrait = TraitsCommand.getPartsWithTrait(trait);
                if (!partsWithTrait.isEmpty()) {
                    writer.write("  - Parts: " + partsWithTrait + "\n");
                }
                if (!trait.getConditions().isEmpty()) {
                    AndTraitCondition condition = new AndTraitCondition(trait.getConditions().toArray(new ITraitCondition[0]));
                    writer.write("- Conditions: " + condition.getDisplayText().getString() + "\n");
                }
                writer.write("- ID: `" + id2 + "`\n");
                writer.write("- Type: `" + trait.getSerializer().getName() + "`\n");
                writer.write("- Max Level: " + trait.getMaxLevel() + "\n");
                Collection cancelsWithSet = trait.getCancelsWithSet().stream().map(s -> "`" + s + "`").collect(Collectors.toList());
                if (!cancelsWithSet.isEmpty()) {
                    writer.write("- Cancels With: " + String.join((CharSequence)", ", cancelsWithSet) + "\n");
                }
                if ((wikiLines = trait.getExtraWikiLines()).isEmpty()) continue;
                writer.write("- Extra Info:\n");
                for (String line : wikiLines) {
                    writer.write(line + "\n");
                }
            }
            writer.write("\n");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            IFormattableTextComponent fileNameText = new StringTextComponent(output.getAbsolutePath()).func_240699_a_(TextFormatting.UNDERLINE).func_240700_a_(style -> style.func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_FILE, output.getAbsolutePath())));
            player.func_145747_a((ITextComponent)new StringTextComponent("Wrote to ").func_230529_a_((ITextComponent)fileNameText), Util.field_240973_b_);
        }
    }

    private static String getCurrentDateTime() {
        DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy/MM/dd HH:mm:ss");
        LocalDateTime now = LocalDateTime.now();
        return formatter.format(now);
    }

    private static String getLinkToBuiltinTraitJson(ResourceLocation traitId, String text) {
        if ("silentgear".equals(traitId.func_110624_b())) {
            return String.format("[%s](%s)", text, TRAITS_DATA_PATH + traitId.func_110623_a() + ".json");
        }
        return text;
    }

    private static String getMaterialsWithTrait(ITrait trait) {
        StringBuilder str = new StringBuilder();
        boolean foundAny = false;
        for (IMaterial material : MaterialManager.getValues(false)) {
            ArrayList<PartType> typesWithTrait = new ArrayList<PartType>();
            block1: for (PartType partType : PartType.getValues()) {
                Collection<TraitInstance> traits = MaterialInstance.of(material).getTraits(partType);
                for (TraitInstance inst : traits) {
                    if (!inst.getTrait().equals(trait) || !material.isVisible(partType)) continue;
                    typesWithTrait.add(partType);
                    continue block1;
                }
            }
            if (typesWithTrait.isEmpty()) continue;
            if (foundAny) {
                str.append(", ");
            }
            foundAny = true;
            str.append("**").append(material.getDisplayName(PartType.MAIN).getString()).append("**").append(" _(").append(typesWithTrait.stream().map(pt -> pt.getDisplayName(0).getString()).collect(Collectors.joining(", "))).append(")_");
        }
        return str.toString();
    }

    private static String getPartsWithTrait(ITrait trait) {
        StringBuilder str = new StringBuilder();
        boolean foundAny = false;
        for (IGearPart part : PartManager.getValues()) {
            PartData partData = PartData.of(part);
            for (TraitInstance inst : partData.getTraits()) {
                if (!inst.getTrait().equals(trait) || !part.isVisible()) continue;
                if (foundAny) {
                    str.append(", ");
                }
                foundAny = true;
                str.append("**").append(partData.getDisplayName(ItemStack.field_190927_a).getString()).append("**");
            }
        }
        return str.toString();
    }

    private static String getDataSources() {
        LinkedHashSet<String> sourceSet = new LinkedHashSet<String>();
        for (ITrait trait : TraitManager.getValues()) {
            sourceSet.add(trait.getId().func_110624_b());
        }
        StringBuilder ret = new StringBuilder();
        for (String id : sourceSet) {
            ret.append("- ");
            Optional container = ModList.get().getModContainerById(id);
            if (container.isPresent()) {
                ret.append(((ModContainer)container.get()).getModInfo().getDisplayName()).append(" (").append(id).append(")\n");
                continue;
            }
            ret.append(id);
        }
        return ret.toString();
    }
}

