/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.compat.jei;

import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.Arrays;
import java.util.Collections;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IGuiItemStackGroup;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.block.compounder.CompounderInfo;
import net.silentchaos512.gear.block.compounder.CompounderScreen;
import net.silentchaos512.gear.crafting.recipe.compounder.CompoundingRecipe;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundingRecipeCategory<R extends CompoundingRecipe>
implements IRecipeCategory<R> {
    private static final int GUI_START_X = 15;
    private static final int GUI_START_Y = 29;
    private static final int GUI_WIDTH = 132;
    private static final int GUI_HEIGHT = 27;
    private final CompounderInfo<R> info;
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated arrow;
    private final String localizedName;

    public CompoundingRecipeCategory(CompounderInfo<R> info, String categoryName, IGuiHelper guiHelper) {
        this.info = info;
        this.background = guiHelper.createDrawable(CompounderScreen.TEXTURE, 15, 29, 132, 27);
        this.icon = guiHelper.createDrawableIngredient((Object)new ItemStack((IItemProvider)info.getBlock()));
        this.arrow = guiHelper.drawableBuilder(CompounderScreen.TEXTURE, 176, 14, 24, 17).buildAnimated(200, IDrawableAnimated.StartDirection.LEFT, false);
        this.localizedName = TextUtil.translate("jei", "category.compounding." + categoryName).getString();
    }

    public ResourceLocation getUid() {
        return NameUtils.from(this.info.getRecipeSerializer());
    }

    public Class<? extends R> getRecipeClass() {
        return this.info.getRecipeClass();
    }

    public String getTitle() {
        return this.localizedName;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setIngredients(R recipe, IIngredients ingredients) {
        ingredients.setInputIngredients(((CompoundingRecipe)recipe).func_192400_c());
        ingredients.setOutput(VanillaTypes.ITEM, (Object)((CompoundingRecipe)recipe).func_77571_b());
    }

    public void setRecipe(IRecipeLayout recipeLayout, R recipe, IIngredients ingredients) {
        int i;
        IGuiItemStackGroup itemStacks = recipeLayout.getItemStacks();
        for (i = 0; i < this.info.getInputSlotCount(); ++i) {
            itemStacks.init(i, true, 18 * i + 16 - 15, 5);
        }
        for (i = 0; i < ((CompoundingRecipe)recipe).func_192400_c().size(); ++i) {
            itemStacks.set(i, Arrays.asList(((Ingredient)((CompoundingRecipe)recipe).func_192400_c().get(i)).func_193365_a()));
        }
        itemStacks.init(this.info.getInputSlotCount(), false, 110, 5);
        itemStacks.set(this.info.getInputSlotCount(), Collections.singletonList(((CompoundingRecipe)recipe).func_77571_b()));
    }

    public void draw(R recipe, MatrixStack matrixStack, double mouseX, double mouseY) {
        this.arrow.draw(matrixStack, 78, 5);
    }
}

