/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.ShapelessRecipe;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.lib.crafting.recipe.ExtendedShapelessRecipe;

public final class ConversionRecipe
extends ExtendedShapelessRecipe {
    private final Map<PartType, List<IMaterialInstance>> resultMaterials = new LinkedHashMap<PartType, List<IMaterialInstance>>();
    private final ICoreItem item;

    private ConversionRecipe(ShapelessRecipe recipe) {
        super(recipe);
        ItemStack output = recipe.func_77571_b();
        if (!(output.func_77973_b() instanceof ICoreItem)) {
            throw new JsonParseException("result is not a gear item: " + output);
        }
        this.item = (ICoreItem)output.func_77973_b();
    }

    private static void deserializeMaterials(JsonObject json, ConversionRecipe recipe) {
        JsonObject resultJson = json.getAsJsonObject("result");
        for (Map.Entry entry : resultJson.getAsJsonObject("materials").entrySet()) {
            PartType partType = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace((String)entry.getKey())));
            JsonElement element = (JsonElement)entry.getValue();
            if (element.isJsonArray()) {
                ArrayList<LazyMaterialInstance> list = new ArrayList<LazyMaterialInstance>();
                for (JsonElement e : element.getAsJsonArray()) {
                    list.add(LazyMaterialInstance.deserialize(e.getAsJsonObject()));
                }
                recipe.resultMaterials.put(partType, list);
                continue;
            }
            recipe.resultMaterials.put(partType, Collections.singletonList(LazyMaterialInstance.deserialize(element.getAsJsonObject())));
        }
    }

    private static void readMaterials(PacketBuffer buffer, ConversionRecipe recipe) {
        int typeCount = buffer.readByte();
        for (int i = 0; i < typeCount; ++i) {
            PartType partType = PartType.get(buffer.func_192575_l());
            int matCount = buffer.readByte();
            ArrayList<LazyMaterialInstance> list = new ArrayList<LazyMaterialInstance>(matCount);
            for (int j = 0; j < matCount; ++j) {
                list.add(LazyMaterialInstance.read(buffer));
            }
            recipe.resultMaterials.put(partType, list);
        }
    }

    private static void writeMaterials(PacketBuffer buffer, ConversionRecipe recipe) {
        buffer.writeByte(recipe.resultMaterials.size());
        recipe.resultMaterials.forEach((partType, list) -> {
            buffer.func_192572_a(partType.getName());
            buffer.writeByte(list.size());
            list.forEach(mat -> mat.write(buffer));
        });
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.CONVERSION.get();
    }

    public boolean func_77569_a(CraftingInventory inv, World worldIn) {
        return this.getBaseRecipe().func_77569_a(inv, worldIn);
    }

    public ItemStack func_77572_b(CraftingInventory inv) {
        ItemStack result = this.item.construct(this.getParts());
        ItemStack original = ConversionRecipe.findOriginalItem((IInventory)inv);
        if (!original.func_190926_b()) {
            result.func_196085_b(original.func_77952_i());
            if (original.func_77948_v()) {
                Map enchantments = EnchantmentHelper.func_82781_a((ItemStack)original);
                EnchantmentHelper.func_82782_a((Map)enchantments, (ItemStack)result);
            }
        }
        return result;
    }

    private static ItemStack findOriginalItem(IInventory inv) {
        for (int i = 0; i < inv.func_70302_i_(); ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b() || !stack.func_77984_f()) continue;
            return stack;
        }
        return ItemStack.field_190927_a;
    }

    private Collection<? extends IPartData> getParts() {
        PartDataList ret = PartDataList.of(new PartData[0]);
        this.resultMaterials.forEach((partType, list) -> partType.getCompoundPartItem(this.item.getGearType()).ifPresent(partItem -> {
            PartData part = PartData.from(partItem.create((List<? extends IMaterialInstance>)list));
            if (part != null) {
                ret.add(part);
            }
        }));
        return ret;
    }

    public boolean func_192399_d() {
        return true;
    }

    public static class Serializer
    extends ExtendedShapelessRecipe.Serializer<ConversionRecipe> {
        public Serializer() {
            super(x$0 -> new ConversionRecipe((ShapelessRecipe)x$0), (x$0, x$1) -> ConversionRecipe.deserializeMaterials(x$0, (ConversionRecipe)x$1), (x$0, x$1) -> ConversionRecipe.readMaterials(x$0, (ConversionRecipe)x$1), (x$0, x$1) -> ConversionRecipe.writeMaterials(x$0, (ConversionRecipe)x$1));
        }
    }
}

