/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.crafting.recipe.compounder;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.ForgeRegistryEntry;
import net.silentchaos512.gear.block.compounder.CompounderTileEntity;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.item.CustomMaterialItem;

public class CompoundingRecipe
implements IRecipe<CompounderTileEntity> {
    private final ResourceLocation recipeId;
    final List<Ingredient> ingredients = new ArrayList<Ingredient>();
    ItemStack result;

    public CompoundingRecipe(ResourceLocation recipeId) {
        this.recipeId = recipeId;
    }

    public boolean matches(CompounderTileEntity inv, World worldIn) {
        HashSet<Integer> matches = new HashSet<Integer>();
        int inputs = 0;
        for (int i = 0; i < inv.getInputSlotCount(); ++i) {
            if (inv.func_70301_a(i).func_190926_b()) continue;
            ++inputs;
        }
        for (Ingredient ingredient : this.ingredients) {
            boolean found = false;
            for (int i = 0; i < inv.getInputSlotCount(); ++i) {
                ItemStack stack = inv.func_70301_a(i);
                if (stack.func_190926_b() || !ingredient.test(stack)) continue;
                found = true;
                matches.add(i);
            }
            if (found) continue;
            return false;
        }
        int matchCount = matches.size();
        return matchCount == inputs && matchCount == this.ingredients.size();
    }

    public ItemStack getCraftingResult(CompounderTileEntity inv) {
        return this.result.func_77946_l();
    }

    public boolean func_194133_a(int width, int height) {
        return width * height <= this.ingredients.size();
    }

    public ItemStack func_77571_b() {
        return this.result.func_77946_l();
    }

    public NonNullList<Ingredient> func_192400_c() {
        NonNullList ret = NonNullList.func_191196_a();
        ret.addAll(this.ingredients);
        return ret;
    }

    public boolean func_192399_d() {
        return true;
    }

    public ResourceLocation func_199560_c() {
        return this.recipeId;
    }

    public IRecipeSerializer<?> func_199559_b() {
        return (IRecipeSerializer)ModRecipes.COMPOUNDING.get();
    }

    public IRecipeType<?> func_222127_g() {
        return ModRecipes.COMPOUNDING_TYPE;
    }

    public static class Serializer<T extends CompoundingRecipe>
    extends ForgeRegistryEntry<IRecipeSerializer<?>>
    implements IRecipeSerializer<T> {
        private final Function<ResourceLocation, T> factory;

        public Serializer(Function<ResourceLocation, T> factory) {
            this.factory = factory;
        }

        public T read(ResourceLocation recipeId, JsonObject json) {
            CompoundingRecipe ret = (CompoundingRecipe)this.factory.apply(recipeId);
            JsonArray array = json.getAsJsonArray("ingredients");
            for (JsonElement je : array) {
                ret.ingredients.add(Ingredient.func_199802_a((JsonElement)je));
            }
            JsonObject resultJson = json.getAsJsonObject("result");
            ResourceLocation itemId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)resultJson, (String)"item"));
            Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
            if (item == null) {
                throw new JsonParseException("Unknown item: " + itemId);
            }
            int count = JSONUtils.func_151208_a((JsonObject)resultJson, (String)"count", (int)1);
            if (item instanceof CustomMaterialItem && resultJson.has("material")) {
                ResourceLocation id = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)resultJson, (String)"material"));
                ret.result = ((CustomMaterialItem)item).create(LazyMaterialInstance.of(id), count);
            }
            if (ret.result == null) {
                ret.result = new ItemStack((IItemProvider)item, count);
            }
            return (T)ret;
        }

        @Nullable
        public T read(ResourceLocation recipeId, PacketBuffer buffer) {
            CompoundingRecipe ret = (CompoundingRecipe)this.factory.apply(recipeId);
            int count = buffer.readByte();
            for (int i = 0; i < count; ++i) {
                ret.ingredients.add(Ingredient.func_199566_b((PacketBuffer)buffer));
            }
            ret.result = buffer.func_150791_c();
            return (T)ret;
        }

        public void write(PacketBuffer buffer, T recipe) {
            buffer.writeByte(((CompoundingRecipe)recipe).ingredients.size());
            ((CompoundingRecipe)recipe).ingredients.forEach(ingredient -> ingredient.func_199564_a(buffer));
            buffer.func_150788_a(((CompoundingRecipe)recipe).result);
        }
    }
}

