/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Sets;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.function.Consumer;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.FrameType;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.advancements.IRequirementsStrategy;
import net.minecraft.advancements.criterion.ChangeDimensionTrigger;
import net.minecraft.advancements.criterion.EnchantmentPredicate;
import net.minecraft.advancements.criterion.InventoryChangeTrigger;
import net.minecraft.advancements.criterion.ItemPredicate;
import net.minecraft.advancements.criterion.MinMaxBounds;
import net.minecraft.advancements.criterion.NBTPredicate;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.event.GearEvents;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.part.LazyPartData;
import net.silentchaos512.gear.gear.trait.DurabilityTrait;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModTags;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.RepairKitItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.lib.advancements.GenericIntTrigger;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ModAdvancementProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public ModAdvancementProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public void func_200398_a(DirectoryCache cache) {
        Path path = this.generator.func_200391_b();
        HashSet set = Sets.newHashSet();
        Consumer<Advancement> consumer = p_204017_3_ -> {
            if (!set.add(p_204017_3_.func_192067_g())) {
                throw new IllegalStateException("Duplicate advancement " + p_204017_3_.func_192067_g());
            }
            Path path1 = ModAdvancementProvider.getPath(path, p_204017_3_);
            try {
                IDataProvider.func_218426_a((Gson)GSON, (DirectoryCache)cache, (JsonElement)p_204017_3_.func_192075_a().func_200273_b(), (Path)path1);
            }
            catch (IOException ioexception) {
                LOGGER.error("Couldn't save advancement {}", (Object)path1, (Object)ioexception);
            }
        };
        new Advancements().accept(consumer);
    }

    public String func_200397_b() {
        return "Silent Gear - Advancements";
    }

    private static Path getPath(Path pathIn, Advancement advancementIn) {
        return pathIn.resolve("data/" + advancementIn.func_192067_g().func_110624_b() + "/advancements/" + advancementIn.func_192067_g().func_110623_a() + ".json");
    }

    private static class Advancements
    implements Consumer<Consumer<Advancement>> {
        private Advancements() {
        }

        @Override
        public void accept(Consumer<Advancement> consumer) {
            ItemStack rootIcon = new ItemStack(ModItems.PICKAXE);
            GearData.writeConstructionParts(rootIcon, (Collection<? extends IPartData>)ImmutableList.of((Object)LazyPartData.of(Const.Parts.PICKAXE_HEAD, (CompoundPartItem)ModItems.PICKAXE_HEAD.get(), Const.Materials.CRIMSON_STEEL), (Object)LazyPartData.of(Const.Parts.ROD, (CompoundPartItem)ModItems.ROD.get(), Const.Materials.BLAZE_GOLD), (Object)LazyPartData.of(Const.Parts.TIP, (CompoundPartItem)ModItems.TIP.get(), Const.Materials.AZURE_ELECTRUM), (Object)LazyPartData.of(Const.Parts.GRIP, (CompoundPartItem)ModItems.GRIP.get(), Const.Materials.WOOL_BLACK), (Object)LazyPartData.of(Const.Parts.BINDING, (CompoundPartItem)ModItems.BINDING.get(), Const.Materials.STRING)));
            Advancement root = Advancement.Builder.func_200278_a().func_215092_a(rootIcon, Advancements.title("root"), Advancements.description("root"), new ResourceLocation("minecraft:textures/gui/advancements/backgrounds/adventure.png"), FrameType.TASK, false, false, false).func_200275_a("get_item", Advancements.getItem(new IItemProvider[]{Items.field_221734_cc})).func_203904_a(consumer, Advancements.id("root"));
            Advancement overworldPlants = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)CraftingItems.FLAX_FIBER, Advancements.title("overworld_plants"), Advancements.description("overworld_plants"), null, FrameType.TASK, true, true, false).func_200275_a("seeds", Advancements.getItem(new IItemProvider[]{ModItems.FLAX_SEEDS})).func_200275_a("fiber", Advancements.getItem(CraftingItems.FLAX_FIBER)).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("overworld_plants"));
            Advancement kachink1 = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)Items.field_191525_da, Advancements.title("kachink1"), Advancements.description("kachink1"), null, FrameType.TASK, true, true, false).func_200275_a("kachink", Advancements.genericInt(GearHelper.DAMAGE_FACTOR_CHANGE, 1)).func_203904_a(consumer, Advancements.id("kachink1"));
            Advancement kachink2 = Advancement.Builder.func_200278_a().func_203905_a(kachink1).func_203902_a((IItemProvider)CraftingItems.DIAMOND_SHARD, Advancements.title("kachink2"), Advancements.description("kachink2"), null, FrameType.TASK, true, true, false).func_200275_a("kachink", Advancements.genericInt(DurabilityTrait.TRIGGER_BRITTLE, 1)).func_203904_a(consumer, Advancements.id("kachink2"));
            Advancement crudeTool = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)CraftingItems.ROUGH_ROD, Advancements.title("crude_tool"), Advancements.description("crude_tool"), null, FrameType.TASK, true, true, false).func_200275_a("tool_has_rough_rod", Advancements.genericInt(GearEvents.CRAFTED_WITH_ROUGH_ROD, 1)).func_203904_a(consumer, Advancements.id("crude_tool"));
            Advancement survivalTool = Advancement.Builder.func_200278_a().func_203905_a(crudeTool).func_203902_a(ModItems.KNIFE, Advancements.title("survival_tool"), Advancements.description("survival_tool"), null, FrameType.TASK, true, true, false).func_200275_a("knife", Advancements.getItem(new IItemProvider[]{ModItems.KNIFE})).func_200275_a("dagger", Advancements.getItem(new IItemProvider[]{ModItems.DAGGER})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, Advancements.id("survival_tool"));
            Advancement templateBoard = Advancements.simpleGetItem(consumer, CraftingItems.TEMPLATE_BOARD, survivalTool);
            Advancement blueprintPaper = Advancements.simpleGetItem(consumer, CraftingItems.BLUEPRINT_PAPER, templateBoard);
            Advancement upgradeBase = Advancements.simpleGetItem(consumer, CraftingItems.UPGRADE_BASE, templateBoard);
            Advancement.Builder builder = Advancement.Builder.func_200278_a().func_203905_a(templateBoard).func_203902_a(ModItems.CRUDE_REPAIR_KIT, Advancements.title("repair_kit"), Advancements.description("repair_kit"), null, FrameType.TASK, true, true, false).func_200270_a(IRequirementsStrategy.field_223215_b_);
            Registration.getItems(RepairKitItem.class).forEach(item -> builder.func_200275_a(NameUtils.fromItem((IItemProvider)item).func_110623_a(), Advancements.getItem(new IItemProvider[]{item})));
            Advancement repairKit = builder.func_203904_a(consumer, Advancements.id("repair_kit"));
            Advancement crimsonRepairKit = Advancements.simpleGetItem(consumer, ModItems.CRIMSON_REPAIR_KIT, repairKit);
            Advancement azureRepairKit = Advancements.simpleGetItem(consumer, ModItems.AZURE_REPAIR_KIT, crimsonRepairKit);
            Advancement repairFromBroken = Advancement.Builder.func_200278_a().func_203905_a(repairKit).func_203902_a((IItemProvider)Items.field_151145_ak, Advancements.title("repair_from_broken"), Advancements.description("repair_from_broken"), null, FrameType.TASK, true, true, false).func_200275_a("repair", Advancements.genericInt(GearEvents.REPAIR_FROM_BROKEN, 1)).func_203904_a(consumer, Advancements.id("repair_from_broken"));
            Advancement blueprintBook = Advancements.simpleGetItem(consumer, ModItems.BLUEPRINT_BOOK, blueprintPaper);
            Advancement tipUpgrade = Advancements.simpleGetItem(consumer, ModItems.TIP, ((CompoundPartItem)ModItems.TIP.get()).create(LazyMaterialInstance.of(Const.Materials.EXAMPLE)), upgradeBase, "tip_upgrade");
            Advancement mixedMaterials = Advancement.Builder.func_200278_a().func_203905_a(blueprintPaper).func_203902_a((IItemProvider)Items.field_151166_bC, Advancements.title("mixed_materials"), Advancements.description("mixed_materials"), null, FrameType.TASK, true, true, false).func_200275_a("mixed_materials", Advancements.genericInt(GearEvents.UNIQUE_MAIN_PARTS, 2)).func_203904_a(consumer, Advancements.id("mixed_materials"));
            Advancement armor = Advancement.Builder.func_200278_a().func_203905_a(blueprintPaper).func_203902_a(ModItems.HELMET, Advancements.title("armor"), Advancements.description("armor"), null, FrameType.TASK, true, true, false).func_200275_a("helmet", Advancements.getItem(new IItemProvider[]{ModItems.HELMET})).func_200275_a("chestplate", Advancements.getItem(new IItemProvider[]{ModItems.CHESTPLATE})).func_200275_a("leggings", Advancements.getItem(new IItemProvider[]{ModItems.LEGGINGS})).func_200275_a("boots", Advancements.getItem(new IItemProvider[]{ModItems.BOOTS})).func_200270_a(IRequirementsStrategy.field_223215_b_).func_203904_a(consumer, Advancements.id("armor"));
            Advancement bow = Advancement.Builder.func_200278_a().func_203905_a(blueprintPaper).func_203902_a(ModItems.BOW, Advancements.title("bow"), Advancements.description("bow"), null, FrameType.TASK, true, true, false).func_200275_a("get_item", Advancements.getItem(new IItemProvider[]{ModItems.BOW})).func_203904_a(consumer, Advancements.id("bow"));
            Advancement standardTools = Advancement.Builder.func_200278_a().func_203905_a(blueprintPaper).func_203902_a(ModItems.PICKAXE, Advancements.title("standard_tools"), Advancements.description("standard_tools"), null, FrameType.TASK, true, true, false).func_200275_a("pickaxe", Advancements.getItem(new IItemProvider[]{ModItems.PICKAXE})).func_200275_a("shovel", Advancements.getItem(new IItemProvider[]{ModItems.SHOVEL})).func_200275_a("axe", Advancements.getItem(new IItemProvider[]{ModItems.AXE})).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("standard_tools"));
            Advancement swords = Advancement.Builder.func_200278_a().func_203905_a(blueprintPaper).func_203902_a(ModItems.SWORD, Advancements.title("swords"), Advancements.description("swords"), null, FrameType.TASK, true, true, false).func_200275_a("sword", Advancements.getItem(new IItemProvider[]{ModItems.SWORD})).func_200275_a("katana", Advancements.getItem(new IItemProvider[]{ModItems.KATANA})).func_200275_a("machete", Advancements.getItem(new IItemProvider[]{ModItems.MACHETE})).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("swords"));
            Advancement bigJobTools = Advancement.Builder.func_200278_a().func_203905_a(standardTools).func_203902_a(ModItems.HAMMER, Advancements.title("big_job_tools"), Advancements.description("big_job_tools"), null, FrameType.TASK, true, true, false).func_200275_a("hammer", Advancements.getItem(new IItemProvider[]{ModItems.HAMMER})).func_200275_a("excavator", Advancements.getItem(new IItemProvider[]{ModItems.EXCAVATOR})).func_200275_a("lumber_axe", Advancements.getItem(new IItemProvider[]{ModItems.SAW})).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("big_job_tools"));
            Advancement crossbow = Advancements.simpleGetItem(consumer, ModItems.CROSSBOW, bow);
            Advancement mattock = Advancements.simpleGetItem(consumer, ModItems.MATTOCK, standardTools);
            Advancement sickle = Advancements.simpleGetItem(consumer, ModItems.SICKLE, mattock);
            Advancement nether = Advancement.Builder.func_200278_a().func_203905_a(root).func_203902_a((IItemProvider)Items.field_221655_bP, Advancements.title("nether"), Advancements.description("nether"), null, FrameType.TASK, false, false, false).func_200275_a("entered_nether", (ICriterionInstance)ChangeDimensionTrigger.Instance.func_233552_a_((RegistryKey)World.field_234919_h_)).func_203904_a(consumer, Advancements.id("nether"));
            Advancement netherPlants = Advancement.Builder.func_200278_a().func_203905_a(nether).func_203902_a(ModItems.NETHER_BANANA, Advancements.title("nether_plants"), Advancements.description("nether_plants"), null, FrameType.TASK, true, true, false).func_200275_a("banana", Advancements.getItem(new IItemProvider[]{ModItems.NETHER_BANANA})).func_200275_a("sapling", Advancements.getItem(new IItemProvider[]{ModBlocks.NETHERWOOD_SAPLING})).func_200270_a(IRequirementsStrategy.field_223214_a_).func_203904_a(consumer, Advancements.id("nether_plants"));
            Advancement blazeGold = Advancements.simpleGetItem(consumer, CraftingItems.BLAZE_GOLD_INGOT, nether, "blaze_gold");
            Advancement crimsonIron = Advancement.Builder.func_200278_a().func_203905_a(nether).func_203902_a((IItemProvider)CraftingItems.CRIMSON_IRON_INGOT, Advancements.title("crimson_iron"), Advancements.description("crimson_iron"), null, FrameType.TASK, true, true, false).func_200275_a("get_ore", Advancements.getItem(new IItemProvider[]{ModBlocks.CRIMSON_IRON_ORE})).func_200275_a("get_ingot", Advancements.getItem(CraftingItems.CRIMSON_IRON_INGOT)).func_203904_a(consumer, Advancements.id("crimson_iron"));
            Advancement materialGrader = Advancement.Builder.func_200278_a().func_203905_a(blazeGold).func_203902_a(ModBlocks.MATERIAL_GRADER, Advancements.title("material_grader"), Advancements.description("material_grader"), null, FrameType.TASK, true, true, false).func_200275_a("get_grader", Advancements.getItem(new IItemProvider[]{ModBlocks.MATERIAL_GRADER})).func_200275_a("get_catalyst", Advancements.getItem(ModTags.Items.GRADER_CATALYSTS_TIER_1)).func_203904_a(consumer, Advancements.id("material_grader"));
            Advancement crimsonSteel = Advancements.simpleGetItem(consumer, CraftingItems.CRIMSON_STEEL_INGOT, crimsonIron, "crimson_steel");
            Advancement salvager = Advancements.simpleGetItem(consumer, ModBlocks.SALVAGER, crimsonIron);
            Advancement highDurability = Advancement.Builder.func_200278_a().func_203905_a(materialGrader).func_215092_a(((CompoundPartItem)ModItems.TIP.get()).create(LazyMaterialInstance.of(Const.Materials.EMERALD)), Advancements.title("high_durability"), Advancements.description("high_durability"), null, FrameType.TASK, true, true, false).func_200275_a("durability", Advancements.genericInt(GearEvents.MAX_DURABILITY, 16000)).func_203904_a(consumer, Advancements.id("high_durability"));
            Advancement graderCatalyst2 = Advancement.Builder.func_200278_a().func_203905_a(materialGrader).func_203902_a((IItemProvider)CraftingItems.BLAZING_DUST, Advancements.title("grader_catalyst_2"), Advancements.description("grader_catalyst_2"), null, FrameType.TASK, true, true, false).func_200275_a("get_item", Advancements.getItem(ModTags.Items.GRADER_CATALYSTS_TIER_2)).func_203904_a(consumer, Advancements.id("grader_catalyst_2"));
            Advancement graderCatalyst3 = Advancement.Builder.func_200278_a().func_203905_a(graderCatalyst2).func_203902_a((IItemProvider)CraftingItems.GLITTERY_DUST, Advancements.title("grader_catalyst_3"), Advancements.description("grader_catalyst_3"), null, FrameType.TASK, true, true, false).func_200275_a("get_item", Advancements.getItem(ModTags.Items.GRADER_CATALYSTS_TIER_3)).func_203904_a(consumer, Advancements.id("grader_catalyst_3"));
            Advancement theEnd = Advancement.Builder.func_200278_a().func_203905_a(nether).func_203902_a((IItemProvider)Items.field_221828_dx, Advancements.title("the_end"), Advancements.description("the_end"), null, FrameType.TASK, false, false, false).func_200275_a("entered_the_end", (ICriterionInstance)ChangeDimensionTrigger.Instance.func_233552_a_((RegistryKey)World.field_234920_i_)).func_203904_a(consumer, Advancements.id("the_end"));
            Advancement azureSilver = Advancement.Builder.func_200278_a().func_203905_a(theEnd).func_203902_a((IItemProvider)CraftingItems.AZURE_SILVER_INGOT, Advancements.title("azure_silver"), Advancements.description("azure_silver"), null, FrameType.TASK, true, true, false).func_200275_a("get_ore", Advancements.getItem(new IItemProvider[]{ModBlocks.AZURE_SILVER_ORE})).func_200275_a("get_ingot", Advancements.getItem(CraftingItems.AZURE_SILVER_INGOT)).func_203904_a(consumer, Advancements.id("azure_silver"));
            Advancement azureElectrum = Advancement.Builder.func_200278_a().func_203905_a(azureSilver).func_203902_a((IItemProvider)CraftingItems.AZURE_ELECTRUM_INGOT, Advancements.title("azure_electrum"), Advancements.description("azure_electrum"), null, FrameType.TASK, true, true, false).func_200275_a("get_ingot", Advancements.getItem(CraftingItems.AZURE_ELECTRUM_INGOT)).func_203904_a(consumer, Advancements.id("azure_electrum"));
            ItemStack azureSilverBoots = new ItemStack(ModItems.BOOTS);
            GearData.writeConstructionParts(azureSilverBoots, Collections.singleton(LazyPartData.of(Const.Parts.ARMOR_BODY, (CompoundPartItem)ModItems.BOOT_PLATES.get(), LazyMaterialInstance.of(Const.Materials.AZURE_SILVER))));
            Advancement moonwalker = Advancement.Builder.func_200278_a().func_203905_a(azureSilver).func_215092_a(azureSilverBoots, Advancements.title("moonwalker"), Advancements.description("moonwalker"), null, FrameType.TASK, true, true, false).func_200275_a("fall_with_moonwalker_boots", Advancements.genericInt(GearEvents.FALL_WITH_MOONWALKER, 1)).func_203904_a(consumer, Advancements.id("moonwalker"));
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, IItemProvider item, Advancement parent) {
            return Advancements.simpleGetItem(consumer, item, parent, NameUtils.fromItem((IItemProvider)item).func_110623_a());
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, IItemProvider item, Advancement parent, String key) {
            return Advancements.simpleGetItem(consumer, item, new ItemStack(item), parent, key);
        }

        private static Advancement simpleGetItem(Consumer<Advancement> consumer, IItemProvider item, ItemStack icon, Advancement parent, String key) {
            return Advancement.Builder.func_200278_a().func_203905_a(parent).func_215092_a(icon, Advancements.title(key), Advancements.description(key), null, FrameType.TASK, true, true, false).func_200275_a("get_item", Advancements.getItem(item)).func_203904_a(consumer, Advancements.id(key));
        }

        private static String id(String path) {
            return SilentGear.getId(path).toString();
        }

        private static ICriterionInstance getItem(IItemProvider ... items) {
            return InventoryChangeTrigger.Instance.func_203922_a((IItemProvider[])items);
        }

        private static ICriterionInstance getItem(ITag<Item> tag) {
            return InventoryChangeTrigger.Instance.func_203923_a((ItemPredicate[])new ItemPredicate[]{new ItemPredicate(tag, null, MinMaxBounds.IntBound.field_211347_e, MinMaxBounds.IntBound.field_211347_e, EnchantmentPredicate.field_226534_b_, EnchantmentPredicate.field_226534_b_, null, NBTPredicate.field_193479_a)});
        }

        private static ICriterionInstance genericInt(ResourceLocation id, int value) {
            return GenericIntTrigger.Instance.instance((ResourceLocation)id, (int)value);
        }

        private static ITextComponent title(String key) {
            return new TranslationTextComponent("advancements.silentgear." + key + ".title");
        }

        private static ITextComponent description(String key) {
            return new TranslationTextComponent("advancements.silentgear." + key + ".description");
        }
    }
}

