/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.client;

import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.data.DataGenerator;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.blueprint.GearBlueprintItem;
import net.silentchaos512.gear.item.blueprint.PartBlueprintItem;
import net.silentchaos512.lib.util.NameUtils;

public class ModItemModelProvider
extends ItemModelProvider {
    public ModItemModelProvider(DataGenerator generator, ExistingFileHelper existingFileHelper) {
        super(generator, "silentgear", existingFileHelper);
    }

    @Nonnull
    public String func_200397_b() {
        return "Silent Gear - Item Models";
    }

    protected void registerModels() {
        Registration.BLOCKS.getEntries().stream().map(RegistryObject::get).forEach(this::blockItemModel);
        ModelFile.ExistingModelFile itemGenerated = this.getExistingFile(new ResourceLocation("item/generated"));
        for (CraftingItems item : CraftingItems.values()) {
            this.builder(item, (ModelFile)itemGenerated, "item/" + item.getName());
        }
        this.builder((IItemProvider)ModItems.NETHERWOOD_CHARCOAL, (ModelFile)itemGenerated);
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem(ModItems.ALLOY_INGOT).func_110623_a())).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem(ModItems.HYBRID_GEM).func_110623_a())).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem(ModItems.CUSTOM_INGOT).func_110623_a())).parent((ModelFile)itemGenerated)).texture("layer0", "item/alloy_ingot")).texture("layer1", "item/alloy_ingot_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem(ModItems.CUSTOM_GEM).func_110623_a())).parent((ModelFile)itemGenerated)).texture("layer0", "item/hybrid_gem")).texture("layer1", "item/hybrid_gem_highlight");
        ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem(ModItems.BLUEPRINT_BOOK).func_110623_a())).parent((ModelFile)itemGenerated)).texture("layer0", "item/blueprint_book_cover")).texture("layer1", "item/blueprint_book_pages")).texture("layer2", "item/blueprint_book_deco");
        this.builder((IItemProvider)ModItems.JEWELER_TOOLS, (ModelFile)itemGenerated, "item/jeweler_tools");
        Registration.getItems(PartBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$0((ModelFile)itemGenerated, arg_0));
        Registration.getItems(GearBlueprintItem.class).forEach(arg_0 -> this.lambda$registerModels$1((ModelFile)itemGenerated, arg_0));
        this.builder((IItemProvider)ModItems.MOD_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.VERY_CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.CRUDE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.STURDY_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.CRIMSON_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.AZURE_REPAIR_KIT, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.BLUEPRINT_PACKAGE, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.FLAX_SEEDS, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.FLUFFY_SEEDS, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.GOLDEN_NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.NETHER_BANANA, (ModelFile)itemGenerated);
        this.builder((IItemProvider)ModItems.PEBBLE, (ModelFile)itemGenerated);
    }

    private void blockItemModel(Block block) {
        if (block == ModBlocks.FLAX_PLANT.get() || block == ModBlocks.FLUFFY_PLANT.get()) {
            return;
        }
        SilentGear.LOGGER.debug("blockItemModel: {}, {}", (Object)block, (Object)block.func_199767_j());
        if (block == ModBlocks.PHANTOM_LIGHT.get()) {
            this.builder((IItemProvider)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/phantom_light");
        } else if (block == ModBlocks.NETHERWOOD_SAPLING.get() || block == ModBlocks.STONE_TORCH.get()) {
            this.builder((IItemProvider)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "block/" + NameUtils.from((IForgeRegistryEntry)block).func_110623_a());
        } else if (block == ModBlocks.NETHERWOOD_FENCE.get()) {
            this.withExistingParent("netherwood_fence", this.modLoc("block/netherwood_fence_inventory"));
        } else if (block == ModBlocks.NETHERWOOD_DOOR.get()) {
            this.builder((IItemProvider)block, (ModelFile)this.getExistingFile(this.mcLoc("item/generated")), "item/netherwood_door");
        } else if (block == ModBlocks.NETHERWOOD_TRAPDOOR.get()) {
            this.withExistingParent("netherwood_trapdoor", this.modLoc("block/netherwood_trapdoor_bottom"));
        } else if (block.func_199767_j() != Items.field_190931_a) {
            String name = NameUtils.from((IForgeRegistryEntry)block).func_110623_a();
            this.withExistingParent(name, this.modLoc("block/" + name));
        }
    }

    private void builder(IItemProvider item, ModelFile parent) {
        String name = NameUtils.fromItem((IItemProvider)item).func_110623_a();
        this.builder(item, parent, "item/" + name);
    }

    private void builder(IItemProvider item, ModelFile parent, String texture) {
        ((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.fromItem((IItemProvider)item).func_110623_a())).parent(parent)).texture("layer0", texture);
    }

    private /* synthetic */ void lambda$registerModels$1(ModelFile itemGenerated, GearBlueprintItem item) {
        ItemModelBuilder cfr_ignored_0 = (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)item).func_110623_a())).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getGearType().getName());
    }

    private /* synthetic */ void lambda$registerModels$0(ModelFile itemGenerated, PartBlueprintItem item) {
        if (item.hasStandardModel()) {
            ((ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(NameUtils.from((IForgeRegistryEntry)item).func_110623_a())).parent(itemGenerated)).texture("layer0", "item/" + (item.isSingleUse() ? "template" : "blueprint"))).texture("layer1", "item/blueprint_" + item.getPartType().getName().func_110623_a());
        }
    }
}

