/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.part;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.GearTypeMatcher;
import net.silentchaos512.gear.api.material.MaterialLayer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.data.part.PartBuilder;
import net.silentchaos512.gear.gear.part.PartSerializers;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.Registration;
import net.silentchaos512.gear.item.CraftingItems;
import net.silentchaos512.gear.item.ToolHeadItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PartsProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public PartsProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public String func_200397_b() {
        return "Silent Gear - Parts";
    }

    protected Collection<PartBuilder> getParts() {
        ArrayList<PartBuilder> ret = new ArrayList<PartBuilder>();
        ret.add(PartsProvider.part("adornment", GearType.CURIO, PartType.ADORNMENT, ModItems.ADORNMENT));
        ret.add(PartsProvider.part("binding", GearType.TOOL, PartType.BINDING, ModItems.BINDING));
        ret.add(PartsProvider.part("bowstring", GearType.RANGED_WEAPON, PartType.BOWSTRING, ModItems.BOWSTRING));
        ret.add(PartsProvider.part("coating", GearType.ALL, PartType.COATING, ModItems.COATING).blacklistGearType(GearType.ELYTRA));
        ret.add(PartsProvider.part("fletching", GearType.PROJECTILE, PartType.FLETCHING, ModItems.FLETCHING));
        ret.add(PartsProvider.part("grip", GearType.TOOL, PartType.GRIP, ModItems.GRIP));
        ret.add(PartsProvider.part("lining", GearType.ARMOR, PartType.LINING, ModItems.LINING));
        ret.add(PartsProvider.part("long_rod", GearType.TOOL, PartType.ROD, ModItems.LONG_ROD));
        ret.add(PartsProvider.part("rod", GearType.TOOL, PartType.ROD, ModItems.ROD));
        ret.add(PartsProvider.part("tip", GearType.TOOL, PartType.TIP, ModItems.TIP));
        Registration.getItems(ToolHeadItem.class).forEach(item -> {
            PartBuilder builder = PartsProvider.part(NameUtils.fromItem((IItemProvider)item).func_110623_a(), item.getGearType(), item.getPartType(), (IItemProvider)item);
            ret.add(PartsProvider.addHeadStats(builder));
        });
        ret.add(PartsProvider.upgradePart("misc/spoon", CraftingItems.SPOON_UPGRADE).upgradeGearTypes(GearType.PICKAXE.getMatcher(false)).stat(ItemStats.DURABILITY, 0.2f, StatInstance.Operation.MUL1).stat(ItemStats.RARITY, 10.0f, StatInstance.Operation.ADD).trait(Const.Traits.SPOON, 1, new ITraitCondition[0]).display(GearType.PICKAXE, PartType.MISC_UPGRADE, new MaterialLayer(SilentGear.getId("spoon"), 0xFFFFFF)));
        ret.add(PartsProvider.upgradePart("misc/road_maker", CraftingItems.ROAD_MAKER_UPGRADE).upgradeGearTypes(GearType.EXCAVATOR.getMatcher(false)).stat(ItemStats.DURABILITY, 0.1f, StatInstance.Operation.MUL1).stat(ItemStats.RARITY, 10.0f, StatInstance.Operation.ADD).trait(Const.Traits.ROAD_MAKER, 1, new ITraitCondition[0]).display(GearType.EXCAVATOR, PartType.MISC_UPGRADE, new MaterialLayer(SilentGear.getId("road_maker"), 0xFFFFFF)));
        ret.add(PartsProvider.upgradePart("misc/red_card", CraftingItems.RED_CARD_UPGRADE).upgradeGearTypes(GearTypeMatcher.ALL).stat(ItemStats.RARITY, -5.0f, StatInstance.Operation.ADD).trait(Const.Traits.RED_CARD, 1, new ITraitCondition[0]));
        return ret;
    }

    private static PartBuilder part(String name, GearType gearType, PartType partType, IItemProvider item) {
        return new PartBuilder((ResourceLocation)SilentGear.getId(name), gearType, partType, item).name((ITextComponent)new TranslationTextComponent("part.silentgear." + name.replace('/', '.')));
    }

    private static PartBuilder upgradePart(String name, IItemProvider item) {
        return PartsProvider.part(name, GearType.ALL, PartType.MISC_UPGRADE, item).serializerType(PartSerializers.UPGRADE_PART);
    }

    private static PartBuilder addHeadStats(PartBuilder builder) {
        if (PartsProvider.isToolHead(builder, ModItems.AXE_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 5.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -3.0f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.EXCAVATOR_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -3.0f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.5f).stat(ItemStats.DURABILITY, 1.0f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.5f, StatInstance.Operation.MUL1).stat(ItemStats.HARVEST_SPEED, -0.5f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.HAMMER_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 4.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -3.2f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 0.75f).stat(ItemStats.DURABILITY, 1.0f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.5f, StatInstance.Operation.MUL1).stat(ItemStats.HARVEST_SPEED, -0.5f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.MATTOCK_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 1.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.6f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f).stat(ItemStats.DURABILITY, 0.25f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.25f, StatInstance.Operation.MUL1).stat(ItemStats.HARVEST_SPEED, -0.25f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.PROSPECTOR_HAMMER_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.6f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.5f).stat(ItemStats.DURABILITY, -0.25f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.25f, StatInstance.Operation.MUL1).stat(ItemStats.HARVEST_SPEED, -0.25f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.PAXEL_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 3.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -3.0f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 0.9f).stat(ItemStats.DURABILITY, 0.35f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.3f, StatInstance.Operation.MUL1).stat(ItemStats.HARVEST_SPEED, -0.2f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.PICKAXE_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 1.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.8f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SAW_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.4f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 0.75f).stat(ItemStats.DURABILITY, 1.0f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.5f, StatInstance.Operation.MUL1).stat(ItemStats.HARVEST_SPEED, -0.75f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SHOVEL_HEAD)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 1.5f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -3.0f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 2.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SICKLE_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 1.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -1.8f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.DAGGER_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -1.2f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 2.0f).stat(ItemStats.MELEE_DAMAGE, -0.5f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.KATANA_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.2f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 0.75f).stat(ItemStats.DURABILITY, -0.2f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.KNIFE_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 1.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -1.6f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 2.0f).stat(ItemStats.MELEE_DAMAGE, -0.5f, StatInstance.Operation.MUL1).stat(ItemStats.DURABILITY, 0.25f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.MACHETE_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 4.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.6f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f).stat(ItemStats.DURABILITY, 0.2f, StatInstance.Operation.MUL1).stat(ItemStats.ENCHANTABILITY, -0.1f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SPEAR_TIP)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 3.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.7f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.25f).stat(ItemStats.DURABILITY, -0.2f, StatInstance.Operation.MUL1).stat(ItemStats.ATTACK_REACH, 1.0f, StatInstance.Operation.ADD);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SWORD_BLADE)) {
            return builder.stat(ItemStats.MELEE_DAMAGE, 3.0f, StatInstance.Operation.ADD).stat(ItemStats.ATTACK_SPEED, -2.4f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.BOW_LIMBS)) {
            return builder.stat(ItemStats.RANGED_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.RANGED_SPEED, 1.0f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f).stat(ItemStats.ENCHANTABILITY, -0.45f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.CROSSBOW_LIMBS)) {
            return builder.stat(ItemStats.RANGED_DAMAGE, 2.0f, StatInstance.Operation.ADD).stat(ItemStats.RANGED_SPEED, 1.0f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f).stat(ItemStats.ENCHANTABILITY, -0.45f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SLINGSHOT_LIMBS)) {
            return builder.stat(ItemStats.RANGED_DAMAGE, 0.0f, StatInstance.Operation.ADD).stat(ItemStats.RANGED_SPEED, 1.5f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 2.0f).stat(ItemStats.ENCHANTABILITY, -0.65f, StatInstance.Operation.MUL1).stat(ItemStats.RANGED_DAMAGE, -0.75f, StatInstance.Operation.MUL1);
        }
        if (PartsProvider.isToolHead(builder, ModItems.ARMOR_BODY) || PartsProvider.isToolHead(builder, ModItems.HELMET_PLATES) || PartsProvider.isToolHead(builder, ModItems.CHESTPLATE_PLATES) || PartsProvider.isToolHead(builder, ModItems.LEGGING_PLATES) || PartsProvider.isToolHead(builder, ModItems.BOOT_PLATES)) {
            return builder.stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.ELYTRA_WINGS)) {
            return builder.stat(ItemStats.ARMOR, -0.65f, StatInstance.Operation.MUL1).stat(ItemStats.ARMOR, -3.5f, StatInstance.Operation.ADD).stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SHEARS_BLADES)) {
            return builder.stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.SHIELD_PLATE)) {
            return builder.stat(ItemStats.REPAIR_EFFICIENCY, 1.0f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.ARROW_HEADS)) {
            return builder.stat(ItemStats.REPAIR_EFFICIENCY, 0.75f);
        }
        if (PartsProvider.isToolHead(builder, ModItems.RING_SHANK)) {
            return builder;
        }
        if (PartsProvider.isToolHead(builder, ModItems.BRACELET_BAND)) {
            return builder;
        }
        throw new IllegalArgumentException("Stats for " + builder.id + " are missing!");
    }

    private static boolean isToolHead(PartBuilder builder, IItemProvider item) {
        if (!(item.func_199767_j() instanceof ToolHeadItem)) {
            throw new IllegalArgumentException("Item " + NameUtils.fromItem((IItemProvider)item) + " is not a tool head!");
        }
        return builder.id.equals((Object)NameUtils.fromItem((IItemProvider)item));
    }

    public void func_200398_a(DirectoryCache cache) {
        Path outputFolder = this.generator.func_200391_b();
        for (PartBuilder builder : this.getParts()) {
            try {
                String jsonStr = GSON.toJson((JsonElement)builder.serialize());
                String hashStr = field_208307_a.hashUnencodedChars((CharSequence)jsonStr).toString();
                Path path = outputFolder.resolve(String.format("data/%s/silentgear_parts/%s.json", builder.id.func_110624_b(), builder.id.func_110623_a()));
                if (!Objects.equals(cache.func_208323_a(outputFolder), hashStr) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(jsonStr);
                    }
                }
                cache.func_208316_a(path, hashStr);
            }
            catch (IOException ex) {
                LOGGER.error("Could not save parts to {}", (Object)outputFolder, (Object)ex);
            }
            try {
                JsonObject modelJson = builder.serializeModel();
                if (modelJson.entrySet().isEmpty()) continue;
                String jsonStr = GSON.toJson((JsonElement)modelJson);
                String hashStr = field_208307_a.hashUnencodedChars((CharSequence)jsonStr).toString();
                Path path = outputFolder.resolve(String.format("assets/%s/silentgear_parts/%s.json", builder.id.func_110624_b(), builder.id.func_110623_a()));
                if (!Objects.equals(cache.func_208323_a(outputFolder), hashStr) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(jsonStr);
                    }
                }
                cache.func_208316_a(path, hashStr);
            }
            catch (IOException ex) {
                LOGGER.error("Could not save part models to {}", (Object)outputFolder, (Object)ex);
            }
        }
    }
}

