/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.data.trait;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DirectoryCache;
import net.minecraft.data.IDataProvider;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.util.SoundEvents;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.Tags;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.data.trait.AttributeTraitBuilder;
import net.silentchaos512.gear.data.trait.BlockFillerTraitBuilder;
import net.silentchaos512.gear.data.trait.BlockPlacerTraitBuilder;
import net.silentchaos512.gear.data.trait.DurabilityTraitBuilder;
import net.silentchaos512.gear.data.trait.EnchantmentTraitBuilder;
import net.silentchaos512.gear.data.trait.PotionTraitBuilder;
import net.silentchaos512.gear.data.trait.StatModifierTraitBuilder;
import net.silentchaos512.gear.data.trait.SynergyTraitBuilder;
import net.silentchaos512.gear.data.trait.TargetEffectTraitBuilder;
import net.silentchaos512.gear.data.trait.TraitBuilder;
import net.silentchaos512.gear.gear.trait.BonusDropsTrait;
import net.silentchaos512.gear.gear.trait.CancelEffectsTrait;
import net.silentchaos512.gear.gear.trait.DamageTypeTrait;
import net.silentchaos512.gear.gear.trait.PotionEffectTrait;
import net.silentchaos512.gear.gear.trait.SelfRepairTrait;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.lib.util.NameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TraitsProvider
implements IDataProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private final DataGenerator generator;

    public TraitsProvider(DataGenerator generator) {
        this.generator = generator;
    }

    public String func_200397_b() {
        return "Silent Gear - Traits";
    }

    protected Collection<TraitBuilder> getTraits() {
        ArrayList<TraitBuilder> ret = new ArrayList<TraitBuilder>();
        ret.add(TraitBuilder.simple(Const.Traits.ANCIENT, 5).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.BOUNCE, 1).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.BRILLIANT, 1));
        ret.add(TraitBuilder.simple(Const.Traits.CONFETTI, 5).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.FLAMMABLE, 1));
        ret.add(TraitBuilder.simple(Const.Traits.INDESTRUCTIBLE, 1).extraWikiLines("  - The damage (durability lost) of the item will remain the same as when the trait was added", "  - The item can still be repaired if desired"));
        ret.add(TraitBuilder.simple(Const.Traits.JABBERWOCKY, 1).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]).extraWikiLines("Something may happen if you mine certain blocks with this"));
        ret.add(TraitBuilder.simple(Const.Traits.LUSTROUS, 5).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.MAGMATIC, 1).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]).extraWikiLines("Smelted drops are not affected by fortune to prevent item duplication"));
        ret.add(TraitBuilder.simple(Const.Traits.MAGNETIC, 5).extraWikiLines("Higher levels increase range"));
        ret.add(TraitBuilder.simple(Const.Traits.MULTI_BREAK, 5).extraWikiLines("  - This trait has never been coded ~~and has almost achieved meme status~~", "  - Intended effect: mine multiple blocks like vein miner"));
        ret.add(TraitBuilder.simple(Const.Traits.RED_CARD, 1));
        ret.add(TraitBuilder.simple(Const.Traits.SPOON, 1).withGearTypeCondition(GearType.PICKAXE, new GearType[0]));
        ret.add(TraitBuilder.simple(Const.Traits.TURTLE, 1).withGearTypeCondition(GearType.HELMET, GearType.CURIO));
        ret.add(TraitBuilder.simple(Const.Traits.VOID_WARD, 1).withGearTypeCondition(GearType.ARMOR, new GearType[0]).extraWikiLines("When void damage is taken, the player is launched upward and given a levitation and slow falling effect"));
        ret.add(new SynergyTraitBuilder(Const.Traits.CRUDE, 5, -0.04f).cancelsWith(Const.Traits.RUSTIC).cancelsWith(Const.Traits.SYNERGISTIC));
        ret.add(new SynergyTraitBuilder(Const.Traits.RUSTIC, 5, 0.05f).setRange(0.749f, 1.001f).cancelsWith(Const.Traits.SYNERGISTIC));
        ret.add(new SynergyTraitBuilder(Const.Traits.SYNERGISTIC, 5, 0.04f).setRangeMin(1.0f).cancelsWith(Const.Traits.CRUDE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.BRITTLE, 5, 1, 0.1f).cancelsWith(Const.Traits.MALLEABLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.FLEXIBLE, 5, -1, 0.05f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.MALLEABLE, 5, -1, 0.1f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(new DurabilityTraitBuilder(Const.Traits.STURDY, 5, -1, 0.175f).cancelsWith(Const.Traits.BRITTLE));
        ret.add(TraitsProvider.selfRepairTrait(Const.Traits.RENEW, 5, 0.018f, 1));
        ret.add(new AttributeTraitBuilder(Const.Traits.BASTION, 5).addModifierAnySlot(GearType.ALL, Attributes.field_233826_i_, AttributeModifier.Operation.ADDITION, 1.0f, 2.0f, 3.0f, 4.0f, 5.0f).withGearTypeCondition(GearType.ARMOR, GearType.CURIO));
        ret.add(new AttributeTraitBuilder(Const.Traits.CURSED, 7).addModifierAnySlot(GearType.ALL, Attributes.field_233828_k_, AttributeModifier.Operation.ADDITION, -0.5f, -1.0f, -1.5f, -2.0f, -3.0f, -4.0f, -5.0f).cancelsWith(Const.Traits.LUCKY).extraWikiLines("  - Please see the extra info on the Lucky trait and this wiki page: https://minecraft.gamepedia.com/Luck"));
        ret.add(new AttributeTraitBuilder(Const.Traits.LUCKY, 7).addModifierAnySlot(GearType.ALL, Attributes.field_233828_k_, AttributeModifier.Operation.ADDITION, 0.5f, 1.0f, 1.5f, 2.0f, 3.0f, 4.0f, 5.0f).cancelsWith(Const.Traits.CURSED).extraWikiLines("  - **Luck has nothing to do with the Fortune enchantment!** It affects loot from some loot tables, but not most. It does not increase drops from normal ores. Please read here for more information: https://minecraft.gamepedia.com/Luck"));
        ret.add(new AttributeTraitBuilder(Const.Traits.HEAVY, 5).addArmorModifier(Attributes.field_233821_d_, AttributeModifier.Operation.MULTIPLY_BASE, -0.01f, -0.02f, -0.03f, -0.04f, -0.05f).cancelsWith(Const.Traits.LIGHT).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(new AttributeTraitBuilder(Const.Traits.LIGHT, 5).addArmorModifier(Attributes.field_233821_d_, AttributeModifier.Operation.MULTIPLY_BASE, 0.01f, 0.02f, 0.03f, 0.04f, 0.05f).cancelsWith(Const.Traits.HEAVY).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        int maxLevel = 5;
        float[] values = new float[maxLevel];
        for (int i = 0; i < maxLevel; ++i) {
            values[i] = -0.15f * (float)(i + 1);
        }
        ret.add(new AttributeTraitBuilder(Const.Traits.MOONWALKER, maxLevel).addModifier(GearType.BOOTS, EquipmentSlotType.FEET, (Attribute)ForgeMod.ENTITY_GRAVITY.get(), AttributeModifier.Operation.MULTIPLY_BASE, values).withGearTypeCondition(GearType.BOOTS, new GearType[0]));
        ret.add(new AttributeTraitBuilder(Const.Traits.REACH, 5).addModifierAnySlot(GearType.ALL, (Attribute)ForgeMod.REACH_DISTANCE.get(), AttributeModifier.Operation.ADDITION, 0.5f, 1.0f, 1.5f, 2.0f, 3.0f));
        ret.add(new AttributeTraitBuilder(Const.Traits.SWIFT_SWIM, 5).addModifierAnySlot(GearType.ALL, (Attribute)ForgeMod.SWIM_SPEED.get(), AttributeModifier.Operation.ADDITION, 0.2f, 0.4f, 0.6f, 0.8f, 1.0f));
        ret.add(new EnchantmentTraitBuilder(Const.Traits.FIERY, 2).addEnchantments(GearType.MELEE_WEAPON, Enchantments.field_77334_n, 1, 2).addEnchantments(GearType.RANGED_WEAPON, Enchantments.field_185311_w, 1).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(new EnchantmentTraitBuilder(Const.Traits.SILKY, 1).addEnchantments(GearType.HARVEST_TOOL, Enchantments.field_185306_r, 1).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(new PotionTraitBuilder(Const.Traits.ADAMANT, 5).addEffect(GearType.ARMOR, PotionEffectTrait.LevelType.PIECE_COUNT, Effects.field_76429_m, 1, 1, 1, 2).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(new PotionTraitBuilder(Const.Traits.AQUATIC, 5).addEffect(GearType.ARMOR, PotionEffectTrait.LevelType.FULL_SET_ONLY, Effects.field_76427_o, 1).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(new PotionTraitBuilder(Const.Traits.FLAME_WARD, 1).addEffect(GearType.ARMOR, PotionEffectTrait.LevelType.FULL_SET_ONLY, Effects.field_76426_n, 1).overridesTrait(Const.Traits.FLAMMABLE).withGearTypeCondition(GearType.ARMOR, new GearType[0]));
        ret.add(new PotionTraitBuilder(Const.Traits.KITTY_VISION, 1).addEffect(GearType.HELMET, PotionEffectTrait.LevelType.TRAIT_LEVEL, Effects.field_76439_r, 1).addEffect(GearType.CURIO, PotionEffectTrait.LevelType.TRAIT_LEVEL, Effects.field_76439_r, 1).withGearTypeCondition(GearType.HELMET, GearType.CURIO));
        ret.add(new PotionTraitBuilder(Const.Traits.MIGHTY, 5).addEffect(GearType.TOOL, PotionEffectTrait.LevelType.TRAIT_LEVEL, Effects.field_76420_g, 0, 0, 1, 1, 2).addEffect(GearType.TOOL, PotionEffectTrait.LevelType.TRAIT_LEVEL, Effects.field_76422_e, 1, 1, 1, 2, 3).addEffect(GearType.CURIO, PotionEffectTrait.LevelType.TRAIT_LEVEL, Effects.field_76422_e, 1, 1, 2, 2, 3).withGearTypeCondition(GearType.TOOL, GearType.CURIO));
        ret.add(new PotionTraitBuilder(Const.Traits.STELLAR, 5).addEffect(GearType.ARMOR, PotionEffectTrait.LevelType.PIECE_COUNT, Effects.field_76424_c, 0, 1, 2, 3).addEffect(GearType.ARMOR, PotionEffectTrait.LevelType.PIECE_COUNT, Effects.field_76430_j, 1, 2, 3, 4).extraWikiLines(String.format("  - Has a %d%% chance per level to restore 1 durability each second", 2)));
        ret.add(new TargetEffectTraitBuilder(Const.Traits.VENOM, 5).withDurationByLevel(GearType.TOOL, Effects.field_76436_u, 0, 4.0f).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ACCELERATE, 5).addStatMod(ItemStats.HARVEST_SPEED, 2.0f, true, false).addStatMod(ItemStats.ATTACK_SPEED, 0.01f, true, false).addStatMod(ItemStats.RANGED_SPEED, 0.01f, true, false).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.BULKY, 5).addStatMod(ItemStats.ATTACK_SPEED, -0.075f, true, false).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.CHIPPING, 5).addStatMod(ItemStats.ARMOR, -0.075f, true, true).addStatMod(ItemStats.HARVEST_SPEED, 0.25f, true, true));
        ret.add(new StatModifierTraitBuilder(Const.Traits.CRUSHING, 5).addStatMod(ItemStats.ARMOR, 0.05f, true, true).addStatMod(ItemStats.MELEE_DAMAGE, -0.1667f, true, true));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ERODED, 5).addStatMod(ItemStats.MELEE_DAMAGE, -0.15f, true, true).addStatMod(ItemStats.HARVEST_SPEED, 0.15f, true, true).cancelsWith(Const.Traits.JAGGED).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.HARD, 5).addStatMod(ItemStats.HARVEST_SPEED, 0.05f, true, true).addStatMod(ItemStats.RANGED_DAMAGE, -0.1f, true, true).cancelsWith(Const.Traits.SOFT).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.JAGGED, 5).addStatMod(ItemStats.MELEE_DAMAGE, 0.1667f, true, true).addStatMod(ItemStats.RANGED_DAMAGE, -0.1667f, true, true).cancelsWith(Const.Traits.ERODED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.ORGANIC, 5).addStatMod(ItemStats.ENCHANTABILITY, 0.1f, true, true).addStatMod(ItemStats.MAGIC_DAMAGE, -0.15f, true, true).cancelsWith(Const.Traits.ERODED));
        ret.add(new StatModifierTraitBuilder(Const.Traits.SHARP, 5).addStatMod(ItemStats.HARVEST_SPEED, 0.125f, true, true).addStatMod(ItemStats.MELEE_DAMAGE, 0.125f, true, true).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new StatModifierTraitBuilder(Const.Traits.SOFT, 5).addStatMod(ItemStats.HARVEST_SPEED, -0.15f, true, true).cancelsWith(Const.Traits.HARD).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.CRACKLER, 1, Blocks.field_235337_cO_, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.FLOATSTONER, 1, Blocks.field_150377_bs, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.IGNITE, 1, Blocks.field_150480_ab, 1).sound(SoundEvents.field_187649_bu, 1.0f, 1.0f).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.RACKER, 1, Blocks.field_150424_aL, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.REFRACTIVE, 1, (Block)ModBlocks.PHANTOM_LIGHT.get(), 5).sound(SoundEvents.field_187638_cR, 0.75f, 0.5f).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.TERMINUS, 1, Blocks.field_150348_b, 3).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockPlacerTraitBuilder(Const.Traits.VULCAN, 1, Blocks.field_150343_Z, 20).cooldown(100).withGearTypeCondition(GearType.TOOL, new GearType[0]));
        ret.add(new BlockFillerTraitBuilder(Const.Traits.ROAD_MAKER, 1, Blocks.field_185774_da, 0.5f).target(Blocks.field_196658_i).fillRange(1, 0, 1, false));
        ret.add(TraitsProvider.bonusDropsTraits(Const.Traits.GOLD_DIGGER, 5, 0.15f, 0.5f, Ingredient.func_199805_a((ITag)Tags.Items.NUGGETS)).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(TraitsProvider.bonusDropsTraits(Const.Traits.IMPERIAL, 5, 0.08f, 1.0f, Ingredient.func_199805_a((ITag)Tags.Items.GEMS)).withGearTypeCondition(GearType.HARVEST_TOOL, new GearType[0]));
        ret.add(TraitsProvider.cancelEffectsTrait(Const.Traits.CURE_POISON, Effects.field_76436_u));
        ret.add(TraitsProvider.cancelEffectsTrait(Const.Traits.CURE_WITHER, Effects.field_82731_v));
        ret.add(TraitsProvider.damageTypeTrait(Const.Traits.CHILLED, 5, "chilled", 2).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        ret.add(TraitsProvider.damageTypeTrait(Const.Traits.HOLY, 5, "holy", 2).withGearTypeCondition(GearType.WEAPON, new GearType[0]));
        return ret;
    }

    protected static TraitBuilder bonusDropsTraits(DataResource<ITrait> trait, int maxLevel, float chance, float multiplier, Ingredient ingredient) {
        return new TraitBuilder(trait, maxLevel, BonusDropsTrait.SERIALIZER).extraData(json -> {
            json.addProperty("base_chance", (Number)Float.valueOf(chance));
            json.addProperty("bonus_multiplier", (Number)Float.valueOf(multiplier));
            json.add("ingredient", ingredient.func_200304_c());
        });
    }

    protected static TraitBuilder cancelEffectsTrait(DataResource<ITrait> trait, Effect ... effects) {
        JsonArray array = new JsonArray();
        for (Effect effect : effects) {
            array.add(NameUtils.from((IForgeRegistryEntry)effect).toString());
        }
        return new TraitBuilder(trait, 1, CancelEffectsTrait.SERIALIZER).extraData(json -> json.add("effects", (JsonElement)array));
    }

    protected static TraitBuilder damageTypeTrait(DataResource<ITrait> trait, int maxLevel, String damageType, int damageBonus) {
        return new TraitBuilder(trait, maxLevel, DamageTypeTrait.SERIALIZER).extraData(json -> {
            json.addProperty("damage_type", damageType);
            json.addProperty("damage_bonus", (Number)damageBonus);
        });
    }

    protected static TraitBuilder selfRepairTrait(DataResource<ITrait> trait, int maxLevel, float activationChance, int repairAmount) {
        return new TraitBuilder(trait, maxLevel, SelfRepairTrait.SERIALIZER).extraData(json -> {
            json.addProperty("activation_chance", (Number)Float.valueOf(activationChance));
            json.addProperty("repair_amount", (Number)repairAmount);
        });
    }

    public void func_200398_a(DirectoryCache cache) {
        Path outputFolder = this.generator.func_200391_b();
        for (TraitBuilder builder : this.getTraits()) {
            try {
                String jsonStr = GSON.toJson((JsonElement)builder.serialize());
                String hashStr = field_208307_a.hashUnencodedChars((CharSequence)jsonStr).toString();
                Path path = outputFolder.resolve(String.format("data/%s/silentgear_traits/%s.json", builder.traitId.func_110624_b(), builder.traitId.func_110623_a()));
                if (!Objects.equals(cache.func_208323_a(outputFolder), hashStr) || !Files.exists(path, new LinkOption[0])) {
                    Files.createDirectories(path.getParent(), new FileAttribute[0]);
                    try (BufferedWriter writer = Files.newBufferedWriter(path, new OpenOption[0]);){
                        writer.write(jsonStr);
                    }
                }
                cache.func_208316_a(path, hashStr);
            }
            catch (IOException ex) {
                LOGGER.error("Could not save traits to {}", (Object)outputFolder, (Object)ex);
            }
        }
    }
}

