/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetMaterialStatsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.item.CompoundMaterialItem;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.gear.util.SynergyUtils;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.utils.Color;
import net.silentchaos512.utils.MathUtils;

public class CompoundMaterial
implements IMaterial {
    private final ResourceLocation materialId;
    private final String packName;
    private final Collection<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
    private Ingredient ingredient = Ingredient.field_193370_a;
    private boolean visible = true;
    private boolean canSalvage = true;
    private ITextComponent displayName;
    @Nullable
    private ITextComponent namePrefix = null;

    public CompoundMaterial(ResourceLocation id, String packName) {
        this.materialId = id;
        this.packName = packName;
    }

    public static List<MaterialInstance> getSubMaterials(IMaterialInstance material) {
        return CompoundMaterialItem.getSubMaterials(material.getItem());
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    public IMaterialSerializer<?> getSerializer() {
        return MaterialSerializers.COMPOUND;
    }

    @Override
    @Nullable
    public IMaterial getParent() {
        return null;
    }

    @Override
    public Collection<IMaterialCategory> getCategories(MaterialInstance material) {
        HashSet<IMaterialCategory> set = new HashSet<IMaterialCategory>(this.categories);
        for (MaterialInstance mat : CompoundMaterial.getSubMaterials(material)) {
            set.addAll(mat.getCategories());
        }
        return set;
    }

    @Override
    public int getTier(PartType partType) {
        return 0;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.empty();
    }

    @Override
    public boolean hasPartSubstitutes() {
        return false;
    }

    @Override
    public boolean canSalvage() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return false;
    }

    @Override
    public Set<PartType> getPartTypes(IMaterialInstance material) {
        List<MaterialInstance> subMaterials = CompoundMaterial.getSubMaterials(material);
        if (subMaterials.isEmpty()) {
            return Collections.emptySet();
        }
        if (subMaterials.size() == 1) {
            return subMaterials.get(0).getPartTypes();
        }
        LinkedHashSet<PartType> set = new LinkedHashSet<PartType>(subMaterials.get(0).getPartTypes());
        for (int i = 1; i < subMaterials.size(); ++i) {
            Set<PartType> set1 = subMaterials.get(i).getPartTypes();
            HashSet<PartType> toRemove = new HashSet<PartType>();
            for (PartType type : set) {
                if (set1.contains(type)) continue;
                toRemove.add(type);
            }
            set.removeAll(toRemove);
        }
        return set;
    }

    @Override
    public boolean allowedInPart(IMaterialInstance material, PartType partType) {
        return this.getPartTypes(material).contains(partType);
    }

    @Override
    public Collection<StatInstance> getStatModifiers(IMaterialInstance material, PartType partType, StatGearKey key, ItemStack gear) {
        float synergy;
        ItemStat stat;
        List<MaterialInstance> materials = CompoundMaterial.getSubMaterials(material);
        List<StatInstance> statMods = materials.stream().flatMap(m -> m.getStatModifiers(partType, key).stream()).collect(Collectors.toList());
        ItemStat itemStat = stat = key.getStat() instanceof ItemStat ? (ItemStat)key.getStat() : null;
        if (stat == null || statMods.isEmpty()) {
            return statMods;
        }
        MaterialInstance matInst = material instanceof MaterialInstance ? (MaterialInstance)material : null;
        GetMaterialStatsEvent event = null;
        if (matInst != null) {
            event = new GetMaterialStatsEvent(matInst, stat, partType, statMods);
            MinecraftForge.EVENT_BUS.post((Event)event);
        }
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(event != null ? event.getModifiers() : Collections.emptyList());
        for (StatInstance.Operation op : StatInstance.Operation.values()) {
            Collection modsForOp = ret.stream().filter(s -> s.getOp() == op).collect(Collectors.toList());
            if (modsForOp.size() <= 1) continue;
            StatInstance mod = CompoundMaterial.compressModifiers(modsForOp, op, key);
            ret.removeIf(inst -> inst.getOp() == op);
            ret.add(mod);
        }
        if (stat.doesSynergyApply() && matInst != null && !MathUtils.floatsEqual((float)(synergy = SynergyUtils.getSynergy(partType, new ArrayList<MaterialInstance>(materials), this.getTraits(matInst, partType, key.getGearType(), gear))), (float)1.0f)) {
            float multi = synergy - 1.0f;
            for (int i = 0; i < ret.size(); ++i) {
                StatInstance oldMod = (StatInstance)ret.get(i);
                float value = oldMod.getValue();
                StatInstance newMod = oldMod.copySetValue(value + Math.abs(value) * multi);
                ret.remove(i);
                ret.add(i, newMod);
            }
        }
        return ret;
    }

    @Override
    public Collection<StatGearKey> getStatKeys(IMaterialInstance material, PartType type) {
        return CompoundMaterial.getSubMaterials(material).stream().flatMap(mat -> mat.get().getStatKeys((IMaterialInstance)mat, type).stream()).collect(Collectors.toSet());
    }

    private static StatInstance compressModifiers(Collection<StatInstance> mods, StatInstance.Operation operation, StatGearKey key) {
        if (operation == StatInstance.Operation.MAX) {
            return mods.stream().max((o1, o2) -> Float.compare(o1.getValue(), o2.getValue())).orElse(StatInstance.of(0.0f, operation, key)).copy();
        }
        return StatInstance.getMaterialWeightedAverageMod(mods, operation);
    }

    @Override
    public Collection<TraitInstance> getTraits(IMaterialInstance material, PartType partType, GearType gearType, ItemStack gear) {
        ArrayList<TraitInstance> ret = new ArrayList<TraitInstance>();
        ArrayList<MaterialInstance> list = new ArrayList<MaterialInstance>(CompoundMaterial.getSubMaterials(material));
        TraitHelper.getTraits(list, gearType, partType, ItemStack.field_190927_a).forEach((trait, level) -> {
            TraitInstance inst = TraitInstance.of(trait, (int)level, new ITraitCondition[0]);
            if (inst.conditionsMatch(PartGearKey.of(gearType, partType), ItemStack.field_190927_a, list)) {
                ret.add(inst);
            }
        });
        return ret;
    }

    @Override
    public boolean isCraftingAllowed(IMaterialInstance material, PartType partType, GearType gearType, @Nullable IInventory inventory) {
        if (!this.allowedInPart(material, partType)) {
            return false;
        }
        if (partType == PartType.MAIN) {
            StatGearKey key = StatGearKey.of(gearType.getDurabilityStat(), gearType);
            return !this.getStatModifiers(material, partType, key).isEmpty() && this.getStatUnclamped(material, partType, key, ItemStack.field_190927_a) > 0.0f;
        }
        return true;
    }

    @Override
    public IFormattableTextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.displayName.func_230532_e_();
    }

    @Override
    @Nullable
    public IFormattableTextComponent getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return this.namePrefix != null ? this.namePrefix.func_230532_e_() : null;
    }

    @Override
    public int getNameColor(PartType partType, GearType gearType, IMaterialInstance material) {
        IMaterialDisplay model = MaterialDisplayManager.get(material);
        int color = model.getLayerColor(gearType, partType, material, 0);
        return Color.blend((int)color, (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
    }

    @Override
    public String getModelKey(IMaterialInstance material) {
        StringBuilder str = new StringBuilder(IMaterial.super.getModelKey(material) + "[");
        ArrayList<String> elements = new ArrayList<String>();
        MaterialInstance last = null;
        IMaterial previous = null;
        int prevCount = 0;
        Iterator<MaterialInstance> iterator = CompoundMaterial.getSubMaterials(material).iterator();
        while (iterator.hasNext()) {
            MaterialInstance mat;
            last = mat = iterator.next();
            if (mat.get() != previous) {
                if (previous != null) {
                    elements.add(mat.getModelKey() + (prevCount > 1 ? "*" + prevCount : ""));
                }
                previous = mat.get();
                prevCount = 0;
            }
            ++prevCount;
        }
        if (prevCount > 0) {
            elements.add(last.getModelKey());
        }
        return str.append(String.join((CharSequence)",", elements)).append("]").toString();
    }

    @Override
    public void updateIngredient(SyncMaterialCraftingItemsPacket msg) {
        if (msg.isValid()) {
            msg.getIngredient(this.materialId).ifPresent(ing -> {
                this.ingredient = ing;
            });
        }
    }

    public String toString() {
        return "CompoundMaterial{id=" + this.materialId + ", ingredient=" + this.ingredient + '}';
    }

    public static final class Serializer
    implements IMaterialSerializer<CompoundMaterial> {
        static final int PACK_NAME_MAX_LENGTH = 32;
        public static final ModResourceLocation NAME = SilentGear.getId("compound");

        @Override
        public CompoundMaterial deserialize(ResourceLocation id, String packName, JsonObject json) {
            CompoundMaterial ret = new CompoundMaterial(id, packName);
            Serializer.deserializeCraftingItems(json, ret);
            Serializer.deserializeNames(json, ret);
            Serializer.deserializeAvailability(json, ret);
            return ret;
        }

        private static void deserializeAvailability(JsonObject json, CompoundMaterial ret) {
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                Serializer.deserializeCategories(obj.get("categories"), ret);
                ret.visible = JSONUtils.func_151209_a((JsonObject)obj, (String)"visible", (boolean)ret.visible);
                ret.canSalvage = JSONUtils.func_151209_a((JsonObject)obj, (String)"can_salvage", (boolean)ret.canSalvage);
            }
        }

        private static void deserializeCategories(@Nullable JsonElement json, CompoundMaterial material) {
            if (json != null) {
                if (json.isJsonArray()) {
                    JsonArray array = json.getAsJsonArray();
                    for (JsonElement elem : array) {
                        material.categories.add(MaterialCategories.get(elem.getAsString()));
                    }
                } else if (json.isJsonPrimitive()) {
                    material.categories.add(MaterialCategories.get(json.getAsString()));
                } else {
                    throw new JsonParseException("Expected 'categories' to be array or string");
                }
            }
        }

        private static void deserializeCraftingItems(JsonObject json, CompoundMaterial ret) {
            JsonElement craftingItems = json.get("crafting_items");
            if (craftingItems != null && craftingItems.isJsonObject()) {
                JsonElement main = craftingItems.getAsJsonObject().get("main");
                if (main != null) {
                    ret.ingredient = Ingredient.func_199802_a((JsonElement)main);
                }
            } else {
                throw new JsonSyntaxException("Expected 'crafting_items' to be an object");
            }
        }

        private static void deserializeNames(JsonObject json, CompoundMaterial ret) {
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            ret.displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                ret.namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
        }

        private static ITextComponent deserializeText(JsonElement json) {
            return (ITextComponent)Objects.requireNonNull(ITextComponent.Serializer.func_240641_a_((JsonElement)json));
        }

        @Override
        public CompoundMaterial read(ResourceLocation id, PacketBuffer buffer) {
            CompoundMaterial material = new CompoundMaterial(id, buffer.func_150789_c(32));
            int categoryCount = buffer.readByte();
            for (int i = 0; i < categoryCount; ++i) {
                material.categories.add(MaterialCategories.get(buffer.func_218666_n()));
            }
            material.displayName = buffer.func_179258_d();
            if (buffer.readBoolean()) {
                material.namePrefix = buffer.func_179258_d();
            }
            material.visible = buffer.readBoolean();
            material.canSalvage = buffer.readBoolean();
            material.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            return material;
        }

        @Override
        public void write(PacketBuffer buffer, CompoundMaterial material) {
            buffer.func_211400_a(material.packName.substring(0, Math.min(32, material.packName.length())), 32);
            buffer.writeByte(material.categories.size());
            material.categories.forEach(cat -> buffer.func_180714_a(cat.getName()));
            buffer.func_179256_a(material.displayName);
            buffer.writeBoolean(material.namePrefix != null);
            if (material.namePrefix != null) {
                buffer.func_179256_a(material.namePrefix);
            }
            buffer.writeBoolean(material.visible);
            buffer.writeBoolean(material.canSalvage);
            material.ingredient.func_199564_a(buffer);
        }

        @Override
        public ResourceLocation getName() {
            return NAME;
        }
    }
}

