/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Multimap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.resources.IResource;
import net.minecraft.resources.IResourceManager;
import net.minecraft.resources.IResourceManagerReloadListener;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.fml.network.NetworkEvent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.network.SyncMaterialsPacket;
import net.silentchaos512.gear.util.TextUtil;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public class MaterialManager
implements IResourceManagerReloadListener {
    public static final MaterialManager INSTANCE = new MaterialManager();
    private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();
    public static final Marker MARKER = MarkerManager.getMarker((String)"MaterialManager");
    private static final String DATA_PATH = "silentgear_materials";
    private static final Map<ResourceLocation, IMaterial> MAP = Collections.synchronizedMap(new LinkedHashMap());
    private static final Collection<String> ERROR_LIST = new ArrayList<String>();
    private static final Collection<String> INGREDIENT_CONFLICT_LIST = new ArrayList<String>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void func_195410_a(IResourceManager resourceManager) {
        Collection resources = resourceManager.func_199003_a(DATA_PATH, s -> s.endsWith(".json"));
        if (resources.isEmpty()) {
            return;
        }
        HashMultimap ingredientConflicts = HashMultimap.create();
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            MAP.clear();
            ERROR_LIST.clear();
            SilentGear.LOGGER.info(MARKER, "Reloading material files");
            for (ResourceLocation id : resources) {
                String path = id.func_110623_a().substring(DATA_PATH.length() + 1, id.func_110623_a().length() - ".json".length());
                ResourceLocation name = new ResourceLocation(id.func_110624_b(), path);
                String packName = "ERROR";
                try {
                    IResource iresource = resourceManager.func_199002_a(id);
                    Throwable throwable = null;
                    try {
                        packName = iresource.func_199026_d();
                        JsonObject json = (JsonObject)JSONUtils.func_188178_a((Gson)GSON, (String)IOUtils.toString((InputStream)iresource.func_199027_b(), (Charset)StandardCharsets.UTF_8), JsonObject.class);
                        if (json == null) {
                            SilentGear.LOGGER.error(MARKER, "Could not load material {} as it's null or empty", (Object)name);
                            continue;
                        }
                        if (!CraftingHelper.processConditions((JsonObject)json, (String)"conditions")) {
                            SilentGear.LOGGER.info(MARKER, "Skipping loading material {} as its conditions were not met", (Object)name);
                            continue;
                        }
                        IMaterial material = MaterialSerializers.deserialize(name, packName, json);
                        MAP.put(material.getId(), material);
                        MaterialManager.addIngredientChecks((Multimap<String, IMaterial>)ingredientConflicts, material, json);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (iresource == null) continue;
                        if (throwable != null) {
                            try {
                                iresource.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        iresource.close();
                    }
                }
                catch (JsonParseException | IllegalArgumentException ex) {
                    SilentGear.LOGGER.error(MARKER, "Parsing error loading material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
                catch (IOException ex) {
                    SilentGear.LOGGER.error(MARKER, "Could not read material {}", (Object)name, (Object)ex);
                    ERROR_LIST.add(String.format("%s (%s)", name, packName));
                }
            }
        }
        MaterialManager.checkForIngredientConflicts((Multimap<String, IMaterial>)ingredientConflicts);
    }

    private static void addIngredientChecks(Multimap<String, IMaterial> map, IMaterial material, JsonObject json) {
        JsonObject craftingItemsJson = json.getAsJsonObject("crafting_items");
        if (craftingItemsJson != null && craftingItemsJson.has("main")) {
            JsonElement mainJson = craftingItemsJson.get("main");
            String key = GSON.toJson(mainJson);
            map.put((Object)key, (Object)material);
        }
    }

    private static void checkForIngredientConflicts(Multimap<String, IMaterial> map) {
        INGREDIENT_CONFLICT_LIST.clear();
        for (String key : map.keySet()) {
            if (map.get((Object)key).size() <= 1) continue;
            String collect = map.get((Object)key).stream().map(mat -> mat.getId().toString()).collect(Collectors.joining(" and "));
            INGREDIENT_CONFLICT_LIST.add("Conflicting crafting items for: " + collect);
        }
    }

    public static List<IMaterial> getValues() {
        return MaterialManager.getValues(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMaterial> getValues(boolean includeChildren) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            ArrayList<IMaterial> list = new ArrayList<IMaterial>();
            for (IMaterial m : MAP.values()) {
                if (!includeChildren && m.getParent() != null) continue;
                list.add(m);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<IMaterial> getChildren(IMaterial material) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            ArrayList<IMaterial> list = new ArrayList<IMaterial>();
            for (IMaterial m : MAP.values()) {
                if (m.getParent() != material) continue;
                list.add(m);
            }
            return list;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static IMaterial get(@Nullable ResourceLocation id) {
        if (id == null) {
            return null;
        }
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            return MAP.get(id);
        }
    }

    @Nullable
    public static IMaterial from(ItemStack stack) {
        if (stack.func_190926_b()) {
            return null;
        }
        for (IMaterial material : MaterialManager.getValues()) {
            if (!material.getIngredient().test(stack)) continue;
            return material;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleSyncPacket(SyncMaterialsPacket msg, Supplier<NetworkEvent.Context> ctx) {
        Map<ResourceLocation, IMaterial> map = MAP;
        synchronized (map) {
            ImmutableMap oldMaterials = ImmutableMap.copyOf(MAP);
            MAP.clear();
            for (IMaterial mat : msg.getMaterials()) {
                mat.retainData((IMaterial)oldMaterials.get(mat.getId()));
                MAP.put(mat.getId(), mat);
            }
            SilentGear.LOGGER.info("Read {} materials from server", (Object)MAP.size());
        }
        ctx.get().setPacketHandled(true);
    }

    public static Collection<ITextComponent> getErrorMessages(ServerPlayerEntity player) {
        ArrayList<ITextComponent> ret = new ArrayList<ITextComponent>();
        if (!ERROR_LIST.isEmpty()) {
            String listStr = String.join((CharSequence)", ", ERROR_LIST);
            ret.add((ITextComponent)TextUtil.withColor((IFormattableTextComponent)new StringTextComponent("[Silent Gear] The following materials failed to load, check your log file:"), TextFormatting.RED));
            ret.add((ITextComponent)new StringTextComponent(listStr));
        }
        INGREDIENT_CONFLICT_LIST.forEach(line -> {
            IFormattableTextComponent text = TextUtil.withColor((IFormattableTextComponent)new StringTextComponent(line), TextFormatting.YELLOW);
            ret.add((ITextComponent)new StringTextComponent("[Silent Gear] ").func_230529_a_((ITextComponent)text));
        });
        return ret;
    }
}

