/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.gear.material.CompoundMaterial;
import net.silentchaos512.gear.gear.material.CustomCompoundMaterial;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.PartMaterial;

public final class MaterialSerializers {
    private static final Map<ResourceLocation, IMaterialSerializer<?>> REGISTRY = new HashMap();
    public static final PartMaterial.Serializer<?> STANDARD = MaterialSerializers.register(new PartMaterial.Serializer<PartMaterial>(SilentGear.getId("standard"), PartMaterial::new));
    public static final CompoundMaterial.Serializer COMPOUND = MaterialSerializers.register(new CompoundMaterial.Serializer());
    public static final PartMaterial.Serializer<?> CUSTOM_COMPOUND = MaterialSerializers.register(new PartMaterial.Serializer<CustomCompoundMaterial>(SilentGear.getId("custom_compound"), CustomCompoundMaterial::new));

    private MaterialSerializers() {
    }

    public static <S extends IMaterialSerializer<T>, T extends IMaterial> S register(S serializer) {
        if (REGISTRY.containsKey(serializer.getName())) {
            throw new IllegalArgumentException("Duplicate material serializer " + serializer.getName());
        }
        SilentGear.LOGGER.info(MaterialManager.MARKER, "Registered material serializer '{}'", (Object)serializer.getName());
        REGISTRY.put(serializer.getName(), serializer);
        return serializer;
    }

    public static IMaterial deserialize(ResourceLocation id, String packName, JsonObject json) {
        ResourceLocation type = SilentGear.getIdWithDefaultNamespace(JSONUtils.func_151219_a((JsonObject)json, (String)"type", (String)STANDARD.getName().toString()));
        IMaterialSerializer serializer = REGISTRY.getOrDefault(type, STANDARD);
        return serializer.deserialize(id, packName, json);
    }

    public static IMaterial read(PacketBuffer buffer) {
        ResourceLocation id = buffer.func_192575_l();
        ResourceLocation type = buffer.func_192575_l();
        IMaterialSerializer<?> serializer = REGISTRY.get(type);
        if (serializer == null) {
            throw new IllegalArgumentException("Unknown material serializer: " + type);
        }
        return serializer.read(id, buffer);
    }

    public static <T extends IMaterial> void write(T material, PacketBuffer buffer) {
        buffer.func_192572_a(material.getId());
        buffer.func_192572_a(material.getSerializer().getName());
        IMaterialSerializer<?> serializer = material.getSerializer();
        serializer.write(buffer, material);
    }
}

