/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.material;

import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialCategory;
import net.silentchaos512.gear.api.material.IMaterialDisplay;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.material.IMaterialLayerList;
import net.silentchaos512.gear.api.material.IMaterialSerializer;
import net.silentchaos512.gear.api.material.MaterialLayerList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.IItemStat;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.stats.SplitItemStat;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.stats.StatModifierMap;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.client.material.MaterialDisplayManager;
import net.silentchaos512.gear.crafting.ingredient.CustomCompoundIngredient;
import net.silentchaos512.gear.gear.material.MaterialCategories;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.material.MaterialSerializers;
import net.silentchaos512.gear.item.CustomMaterialItem;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.util.ModResourceLocation;
import net.silentchaos512.utils.Color;

public class PartMaterial
implements IMaterial {
    private final ResourceLocation materialId;
    @Nullable
    ResourceLocation parent;
    final String packName;
    final Collection<IMaterialCategory> categories = new ArrayList<IMaterialCategory>();
    Ingredient ingredient = Ingredient.field_193370_a;
    final Map<PartType, Ingredient> partSubstitutes = new HashMap<PartType, Ingredient>();
    boolean visible = true;
    int tier = -1;
    boolean canSalvage = true;
    boolean simple = true;
    final Map<PartType, StatModifierMap> stats = new LinkedHashMap<PartType, StatModifierMap>();
    final Map<PartType, List<TraitInstance>> traits = new LinkedHashMap<PartType, List<TraitInstance>>();
    ITextComponent displayName;
    @Nullable
    ITextComponent namePrefix = null;
    final Map<String, MaterialLayerList> display = new HashMap<String, MaterialLayerList>();
    final List<String> blacklistedGearTypes = new ArrayList<String>();

    public PartMaterial(ResourceLocation id, String packName) {
        this.materialId = id;
        this.packName = packName;
    }

    @Override
    public String getPackName() {
        return this.packName;
    }

    @Override
    public ResourceLocation getId() {
        return this.materialId;
    }

    @Override
    public IMaterialSerializer<?> getSerializer() {
        return MaterialSerializers.STANDARD;
    }

    @Override
    @Nullable
    public IMaterial getParent() {
        if (this.parent != null) {
            return MaterialManager.get(this.parent);
        }
        return null;
    }

    @Override
    public Collection<IMaterialCategory> getCategories(MaterialInstance material) {
        if (this.categories.isEmpty() && this.getParent() != null) {
            return this.getParent().getCategories(material);
        }
        return Collections.unmodifiableCollection(this.categories);
    }

    @Override
    public int getTier(PartType partType) {
        if (this.tier < 0 && this.getParent() != null) {
            return this.getParent().getTier(partType);
        }
        return this.tier;
    }

    @Override
    public Ingredient getIngredient() {
        return this.ingredient;
    }

    @Override
    public Optional<Ingredient> getPartSubstitute(PartType partType) {
        return Optional.ofNullable(this.partSubstitutes.get(partType));
    }

    @Override
    public boolean hasPartSubstitutes() {
        return !this.partSubstitutes.isEmpty();
    }

    @Override
    public boolean canSalvage() {
        return this.canSalvage;
    }

    @Override
    public boolean isSimple() {
        return this.simple;
    }

    @Override
    public Set<PartType> getPartTypes(IMaterialInstance material) {
        return Sets.union(this.stats.keySet(), this.getParentOptional().map(m -> new LinkedHashSet<PartType>(m.getPartTypes(material))).orElse(Collections.emptySet()));
    }

    @Override
    public boolean allowedInPart(IMaterialInstance material, PartType partType) {
        return this.stats.containsKey(partType) || this.getParent() != null && this.getParent().allowedInPart(material, partType);
    }

    @Override
    public Collection<StatInstance> getStatModifiers(IMaterialInstance material, PartType partType, StatGearKey key, ItemStack gear) {
        ArrayList<StatInstance> ret = new ArrayList<StatInstance>(this.stats.getOrDefault(partType, StatModifierMap.EMPTY_STAT_MAP).get(key));
        if (ret.isEmpty() && this.getParent() != null) {
            ret.addAll(this.getParent().getStatModifiers(material, partType, key, gear));
        }
        return ret;
    }

    @Override
    public Collection<StatGearKey> getStatKeys(IMaterialInstance material, PartType type) {
        return this.stats.getOrDefault(type, StatModifierMap.EMPTY_STAT_MAP).keySet();
    }

    @Override
    public Collection<TraitInstance> getTraits(IMaterialInstance instance, PartType partType, GearType gearType, ItemStack gear) {
        ArrayList<TraitInstance> ret = new ArrayList<TraitInstance>(this.traits.getOrDefault(partType, Collections.emptyList()));
        if (ret.isEmpty() && this.getParent() != null) {
            ret.addAll(this.getParent().getTraits(instance, partType, gearType, gear));
        }
        return ret;
    }

    @Override
    public boolean isCraftingAllowed(IMaterialInstance material, PartType partType, GearType gearType, @Nullable IInventory inventory) {
        if (this.isGearTypeBlacklisted(gearType) || !this.allowedInPart(material, partType)) {
            return false;
        }
        if (this.stats.containsKey(partType) || this.getParent() != null && this.getParent().isCraftingAllowed(material, partType, gearType, inventory)) {
            if (partType == PartType.MAIN) {
                ItemStat stat = gearType.getDurabilityStat();
                StatGearKey key = StatGearKey.of(stat, gearType);
                return !this.getStatModifiers(material, partType, key).isEmpty() && this.getStatUnclamped(material, partType, key, ItemStack.field_190927_a) > 0.0f;
            }
            return true;
        }
        return false;
    }

    private boolean isGearTypeBlacklisted(GearType gearType) {
        for (String s : this.blacklistedGearTypes) {
            if (!gearType.matches(s)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Deprecated
    public IMaterialLayerList getMaterialDisplay(ItemStack gear, PartType partType) {
        if (!gear.func_190926_b()) {
            GearType gearType = ((ICoreItem)gear.func_77973_b()).getGearType();
            String gearTypeKey = partType.getName() + "/" + gearType.getName();
            if (this.display.containsKey(gearTypeKey)) {
                return this.display.get(gearTypeKey);
            }
            for (String key : this.display.keySet()) {
                if (!gearType.matches(key, false)) continue;
                return this.display.get(key);
            }
        }
        return this.display.getOrDefault(partType.getName().func_110623_a() + "/all", this.display.getOrDefault(partType.getName() + "/all", MaterialLayerList.DEFAULT));
    }

    @Override
    public IFormattableTextComponent getDisplayName(PartType partType, ItemStack gear) {
        return this.displayName.func_230532_e_();
    }

    @Override
    @Nullable
    public IFormattableTextComponent getDisplayNamePrefix(ItemStack gear, PartType partType) {
        return this.namePrefix != null ? this.namePrefix.func_230532_e_() : null;
    }

    @Override
    public int getNameColor(PartType partType, GearType gearType, IMaterialInstance material) {
        IMaterialDisplay model = MaterialDisplayManager.get(this);
        int color = model.getLayerColor(gearType, partType, material, 0);
        return Color.blend((int)color, (int)0xFFFFFF, (float)0.25f) & 0xFFFFFF;
    }

    @Override
    public boolean isVisible(PartType partType) {
        return this.visible;
    }

    @Override
    public void updateIngredient(SyncMaterialCraftingItemsPacket msg) {
        if (msg.isValid()) {
            msg.getIngredient(this.materialId).ifPresent(ing -> {
                this.ingredient = ing;
            });
            this.partSubstitutes.clear();
            msg.getPartSubstitutes(this.materialId).forEach(this.partSubstitutes::put);
        }
    }

    public String toString() {
        return "PartMaterial{id=" + this.materialId + ", tier=" + this.tier + ", ingredient=" + this.ingredient + '}';
    }

    public static final class Serializer<T extends PartMaterial>
    implements IMaterialSerializer<T> {
        static final int PACK_NAME_MAX_LENGTH = 32;
        private final ResourceLocation id;
        private final BiFunction<ResourceLocation, String, T> factory;

        public Serializer(ResourceLocation id, BiFunction<ResourceLocation, String, T> factory) {
            this.id = id;
            this.factory = factory;
        }

        @Override
        public T deserialize(ResourceLocation id, String packName, JsonObject json) {
            PartMaterial ret = (PartMaterial)this.factory.apply(id, packName);
            if (json.has("parent")) {
                ret.parent = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)json, (String)"parent"));
            }
            this.deserializeStats(json, ret);
            this.deserializeTraits(json, ret);
            Serializer.deserializeCraftingItems(json, ret);
            Serializer.deserializeNames(json, ret);
            Serializer.deserializeDisplayProps(json, ret);
            Serializer.deserializeAvailability(json, ret);
            return (T)ret;
        }

        void deserializeStats(JsonObject json, T ret) {
            JsonElement elementStats = json.get("stats");
            if (elementStats != null && elementStats.isJsonObject()) {
                for (Map.Entry entry : elementStats.getAsJsonObject().entrySet()) {
                    ResourceLocation partTypeName = SilentGear.getIdWithDefaultNamespace((String)entry.getKey());
                    if (partTypeName == null) continue;
                    PartType partType = PartType.get(partTypeName);
                    StatModifierMap statMods = StatModifierMap.deserialize((JsonElement)entry.getValue());
                    ((PartMaterial)ret).stats.put(partType, statMods);
                }
            }
            Serializer.sanitizeStats(ret);
        }

        private static <T extends PartMaterial> void sanitizeStats(T ret) {
            for (PartType partType : ret.stats.keySet()) {
                StatModifierMap statMap = ret.stats.get(partType);
                for (IItemStat iItemStat : ItemStats.allStatsOrdered()) {
                    if (!(iItemStat instanceof SplitItemStat)) continue;
                    Serializer.sanitizeSplitStat((SplitItemStat)iItemStat, statMap);
                }
            }
        }

        private static void sanitizeSplitStat(SplitItemStat stat, StatModifierMap statMap) {
            StatGearKey all = StatGearKey.of(stat, GearType.ALL);
            for (GearType type : stat.getSplitTypes()) {
                StatGearKey key = StatGearKey.of(stat, type);
                if (statMap.containsKey(key)) continue;
                Collection<StatInstance> mods = statMap.get(all);
                for (StatInstance mod : mods) {
                    statMap.put(key, Serializer.getSplitStatMod(stat, key, mod));
                }
            }
        }

        @Nonnull
        private static StatInstance getSplitStatMod(SplitItemStat stat, StatGearKey key, StatInstance mod) {
            if (mod.getOp() == StatInstance.Operation.AVG) {
                float value = stat.compute(stat.getBaseValue(), true, key.getGearType(), mod.getKey().getGearType(), Collections.singleton(mod));
                return StatInstance.of(value, mod.getOp(), key);
            }
            return StatInstance.of(mod.getValue(), mod.getOp(), key);
        }

        private void deserializeTraits(JsonObject json, T ret) {
            JsonElement elementTraits = json.get("traits");
            if (elementTraits != null && elementTraits.isJsonObject()) {
                for (Map.Entry entry : elementTraits.getAsJsonObject().entrySet()) {
                    PartType partType = PartType.get(Objects.requireNonNull(SilentGear.getIdWithDefaultNamespace((String)entry.getKey())));
                    if (partType == null) continue;
                    ArrayList list = new ArrayList();
                    ((JsonElement)entry.getValue()).getAsJsonArray().forEach(e -> list.add(TraitInstance.deserialize(e.getAsJsonObject())));
                    ((PartMaterial)ret).traits.put(partType, list);
                }
            }
        }

        private static void deserializeCraftingItems(JsonObject json, PartMaterial ret) {
            JsonElement craftingItems = json.get("crafting_items");
            if (craftingItems != null && craftingItems.isJsonObject()) {
                JsonElement subs;
                JsonElement customCompound;
                JsonElement main = craftingItems.getAsJsonObject().get("main");
                if (main != null) {
                    ret.ingredient = Ingredient.func_199802_a((JsonElement)main);
                }
                if ((customCompound = craftingItems.getAsJsonObject().get("custom_compound")) != null && customCompound.isJsonObject()) {
                    ResourceLocation itemId = new ResourceLocation(JSONUtils.func_151200_h((JsonObject)customCompound.getAsJsonObject(), (String)"item"));
                    Item item = (Item)ForgeRegistries.ITEMS.getValue(itemId);
                    if (!(item instanceof CustomMaterialItem)) {
                        throw new JsonParseException("Item '" + itemId + "' is not a CustomMaterialItem");
                    }
                    ret.ingredient = CustomCompoundIngredient.of((CustomMaterialItem)item, ret.materialId);
                }
                if ((subs = craftingItems.getAsJsonObject().get("subs")) != null && subs.isJsonObject()) {
                    JsonObject jo = subs.getAsJsonObject();
                    HashMap map = new HashMap();
                    jo.entrySet().forEach(entry -> {
                        PartType partType = PartType.get(new ModResourceLocation((String)entry.getKey()));
                        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)((JsonElement)entry.getValue()));
                        map.put(partType, ingredient);
                    });
                    ret.partSubstitutes.putAll(map);
                }
            } else {
                throw new JsonSyntaxException("Expected 'crafting_items' to be an object");
            }
        }

        private static void deserializeNames(JsonObject json, PartMaterial ret) {
            JsonElement elementName = json.get("name");
            if (elementName == null || !elementName.isJsonObject()) {
                throw new JsonSyntaxException("Expected 'name' element");
            }
            ret.displayName = Serializer.deserializeText(elementName);
            JsonElement elementNamePrefix = json.get("name_prefix");
            if (elementNamePrefix != null) {
                ret.namePrefix = Serializer.deserializeText(elementNamePrefix);
            }
        }

        @Deprecated
        private static void deserializeDisplayProps(JsonObject json, PartMaterial ret) {
            JsonElement elementDisplay = json.get("display");
            if (elementDisplay != null && elementDisplay.isJsonObject()) {
                JsonObject obj = elementDisplay.getAsJsonObject();
                MaterialLayerList defaultProps = ret.display.getOrDefault("all", MaterialLayerList.DEFAULT);
                if (!ret.display.containsKey("all")) {
                    ret.display.put("all", defaultProps);
                }
                for (Map.Entry entry : obj.entrySet()) {
                    PartGearKey key = PartGearKey.read((String)entry.getKey());
                    JsonElement value = (JsonElement)entry.getValue();
                    ret.display.put(key.toString(), MaterialLayerList.deserialize(key, value, defaultProps));
                }
            }
        }

        private static void deserializeAvailability(JsonObject json, PartMaterial ret) {
            ret.simple = JSONUtils.func_151209_a((JsonObject)json, (String)"simple", (boolean)true);
            JsonElement elementAvailability = json.get("availability");
            if (elementAvailability != null && elementAvailability.isJsonObject()) {
                JsonObject obj = elementAvailability.getAsJsonObject();
                Serializer.deserializeCategories(obj.get("categories"), ret);
                ret.tier = JSONUtils.func_151208_a((JsonObject)obj, (String)"tier", (int)ret.tier);
                ret.visible = JSONUtils.func_151209_a((JsonObject)obj, (String)"visible", (boolean)ret.visible);
                ret.canSalvage = JSONUtils.func_151209_a((JsonObject)obj, (String)"can_salvage", (boolean)ret.canSalvage);
                JsonArray blacklist = JSONUtils.func_151213_a((JsonObject)obj, (String)"gear_blacklist", null);
                if (blacklist != null) {
                    ret.blacklistedGearTypes.clear();
                    blacklist.forEach(e -> ret.blacklistedGearTypes.add(e.getAsString()));
                }
            } else if (ret.parent == null) {
                throw new JsonSyntaxException("Expected 'availability' to be an object");
            }
        }

        private static void deserializeCategories(@Nullable JsonElement json, PartMaterial material) {
            if (json != null) {
                if (json.isJsonArray()) {
                    JsonArray array = json.getAsJsonArray();
                    for (JsonElement elem : array) {
                        material.categories.add(MaterialCategories.get(elem.getAsString()));
                    }
                } else if (json.isJsonPrimitive()) {
                    material.categories.add(MaterialCategories.get(json.getAsString()));
                } else {
                    throw new JsonParseException("Expected 'categories' to be array or string");
                }
            }
        }

        private static ITextComponent deserializeText(JsonElement json) {
            return (ITextComponent)Objects.requireNonNull(ITextComponent.Serializer.func_240641_a_((JsonElement)json));
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            PartMaterial material = (PartMaterial)this.factory.apply(id, buffer.func_150789_c(32));
            if (buffer.readBoolean()) {
                material.parent = buffer.func_192575_l();
            }
            int categoryCount = buffer.readByte();
            for (int i = 0; i < categoryCount; ++i) {
                material.categories.add(MaterialCategories.get(buffer.func_218666_n()));
            }
            material.displayName = buffer.func_179258_d();
            if (buffer.readBoolean()) {
                material.namePrefix = buffer.func_179258_d();
            }
            material.tier = buffer.readByte();
            material.visible = buffer.readBoolean();
            material.canSalvage = buffer.readBoolean();
            material.simple = buffer.readBoolean();
            material.ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
            int subCount = buffer.readByte();
            for (int i = 0; i < subCount; ++i) {
                PartType partType = PartType.get(buffer.func_192575_l());
                Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buffer);
                material.partSubstitutes.put(partType, ingredient);
            }
            material.blacklistedGearTypes.clear();
            int blacklistSize = buffer.readByte();
            for (int i = 0; i < blacklistSize; ++i) {
                material.blacklistedGearTypes.add(buffer.func_218666_n());
            }
            int displayCount = buffer.func_150792_a();
            for (int i = 0; i < displayCount; ++i) {
                String key = buffer.func_150789_c(255);
                MaterialLayerList display = MaterialLayerList.read(buffer);
                material.display.put(key, display);
            }
            Serializer.readStats(buffer, material);
            Serializer.readTraits(buffer, material);
            return (T)material;
        }

        @Override
        public void write(PacketBuffer buffer, T material) {
            buffer.func_211400_a(((PartMaterial)material).packName.substring(0, Math.min(32, ((PartMaterial)material).packName.length())), 32);
            buffer.writeBoolean(((PartMaterial)material).parent != null);
            if (((PartMaterial)material).parent != null) {
                buffer.func_192572_a(((PartMaterial)material).parent);
            }
            buffer.writeByte(((PartMaterial)material).categories.size());
            ((PartMaterial)material).categories.forEach(cat -> buffer.func_180714_a(cat.getName()));
            buffer.func_179256_a(((PartMaterial)material).displayName);
            buffer.writeBoolean(((PartMaterial)material).namePrefix != null);
            if (((PartMaterial)material).namePrefix != null) {
                buffer.func_179256_a(((PartMaterial)material).namePrefix);
            }
            buffer.writeByte(((PartMaterial)material).tier);
            buffer.writeBoolean(((PartMaterial)material).visible);
            buffer.writeBoolean(((PartMaterial)material).canSalvage);
            buffer.writeBoolean(((PartMaterial)material).simple);
            ((PartMaterial)material).ingredient.func_199564_a(buffer);
            buffer.writeByte(((PartMaterial)material).partSubstitutes.size());
            ((PartMaterial)material).partSubstitutes.forEach((type, ing) -> {
                buffer.func_192572_a(type.getName());
                ing.func_199564_a(buffer);
            });
            buffer.writeByte(((PartMaterial)material).blacklistedGearTypes.size());
            ((PartMaterial)material).blacklistedGearTypes.forEach(arg_0 -> ((PacketBuffer)buffer).func_180714_a(arg_0));
            buffer.func_150787_b(((PartMaterial)material).display.size());
            ((PartMaterial)material).display.forEach((s, display) -> {
                buffer.func_180714_a(s);
                display.write(buffer);
            });
            Serializer.writeStats(buffer, material);
            Serializer.writeTraits(buffer, material);
        }

        @Override
        public ResourceLocation getName() {
            return this.id;
        }

        private static void readStats(PacketBuffer buffer, PartMaterial material) {
            material.stats.clear();
            int typeCount = buffer.readByte();
            for (int i = 0; i < typeCount; ++i) {
                PartType partType = PartType.get(buffer.func_192575_l());
                int statCount = buffer.readByte();
                StatModifierMap map = new StatModifierMap();
                for (int j = 0; j < statCount; ++j) {
                    StatGearKey key = StatGearKey.read(buffer);
                    StatInstance mod = StatInstance.read(key, buffer);
                    map.put(key, mod);
                }
                material.stats.put(partType, map);
            }
        }

        private static void writeStats(PacketBuffer buffer, PartMaterial material) {
            buffer.writeByte(material.stats.size());
            material.stats.forEach((partType, map) -> {
                buffer.func_192572_a(partType.getName());
                buffer.writeByte(map.size());
                map.forEach((key, mod) -> {
                    buffer.func_180714_a(key.toString());
                    mod.write(buffer);
                });
            });
        }

        private static void readTraits(PacketBuffer buffer, PartMaterial material) {
            material.traits.clear();
            int typeCount = buffer.readByte();
            for (int i = 0; i < typeCount; ++i) {
                PartType partType = PartType.get(buffer.func_192575_l());
                int traitCount = buffer.readByte();
                ArrayList<TraitInstance> list = new ArrayList<TraitInstance>();
                for (int j = 0; j < traitCount; ++j) {
                    list.add(TraitInstance.read(buffer));
                }
                material.traits.put(partType, list);
            }
        }

        private static void writeTraits(PacketBuffer buffer, PartMaterial material) {
            buffer.writeByte(material.traits.size());
            material.traits.forEach((partType, list) -> {
                buffer.func_192572_a(partType.getName());
                buffer.writeByte(list.size());
                list.forEach(trait -> trait.write(buffer));
            });
        }
    }
}

