/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.part;

import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.inventory.CraftingInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.ITextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.IGearPart;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.StatInstance;
import net.silentchaos512.gear.api.util.StatGearKey;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.LazyPartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.item.CompoundPartItem;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.lib.util.InventoryUtils;

public final class PartData
implements IPartData {
    private static final Map<ResourceLocation, PartData> CACHE_UNGRADED_PARTS = new HashMap<ResourceLocation, PartData>();
    public static final String NBT_ID = "ID";
    private final IGearPart part;
    private final ItemStack craftingItem;

    private PartData(IGearPart part) {
        this(part, ItemStack.field_190927_a);
    }

    private PartData(IGearPart part, ItemStack craftingItem) {
        this.part = part;
        this.craftingItem = craftingItem.func_77946_l();
        if (!this.craftingItem.func_190926_b()) {
            this.craftingItem.func_190920_e(1);
        }
    }

    public static PartData of(IGearPart part) {
        ResourceLocation name = part.getId();
        if (CACHE_UNGRADED_PARTS.containsKey(name)) {
            return CACHE_UNGRADED_PARTS.get(name);
        }
        PartData inst = new PartData(part);
        CACHE_UNGRADED_PARTS.put(name, inst);
        return inst;
    }

    public static PartData of(IGearPart part, ItemStack craftingItem) {
        return new PartData(part, craftingItem);
    }

    public static IPartData of(DataResource<IGearPart> part, ItemStack craftingItem) {
        if (part.isPresent()) {
            return PartData.of(part.get(), craftingItem);
        }
        return LazyPartData.of(part, craftingItem);
    }

    @Nullable
    public static PartData from(ItemStack craftingItem) {
        return PartData.from(craftingItem, true);
    }

    @Nullable
    public static PartData from(ItemStack craftingItem, boolean checkSubstitutes) {
        IGearPart part = PartManager.from(craftingItem);
        if (part == null) {
            if (checkSubstitutes) {
                return PartData.fromMaterialSubstitute(craftingItem);
            }
            return null;
        }
        return PartData.of(part, craftingItem);
    }

    @Nullable
    private static PartData fromMaterialSubstitute(ItemStack stack) {
        for (IMaterial material : MaterialManager.getValues()) {
            if (!material.hasPartSubstitutes()) continue;
            for (PartType partType : PartType.getValues()) {
                Optional<? extends CompoundPartItem> item;
                Optional<Ingredient> ingredient = material.getPartSubstitute(partType);
                if (!ingredient.isPresent() || !ingredient.get().test(stack) || !(item = partType.getCompoundPartItem(GearType.PART)).isPresent()) continue;
                ItemStack result = item.get().create(MaterialInstance.of(material));
                return PartData.from(result, false);
            }
        }
        return null;
    }

    @Nullable
    public static PartData read(CompoundNBT tags) {
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(tags.func_74779_i(NBT_ID));
        if (id == null) {
            return null;
        }
        IGearPart part = PartManager.get(id);
        if (part == null) {
            return null;
        }
        ItemStack craftingItem = ItemStack.func_199557_a((CompoundNBT)tags.func_74775_l("Item"));
        return PartData.of(part, craftingItem);
    }

    @Override
    public CompoundNBT write(@Nonnull CompoundNBT tags) {
        tags.func_74778_a(NBT_ID, this.part.getId().toString());
        CompoundNBT itemTag = new CompoundNBT();
        this.craftingItem.func_77955_b(itemTag);
        tags.func_218657_a("Item", (INBT)itemTag);
        return tags;
    }

    @Override
    public ResourceLocation getId() {
        return this.part.getId();
    }

    @Override
    @Nonnull
    public IGearPart get() {
        return this.part;
    }

    @Override
    public ItemStack getItem() {
        return this.craftingItem;
    }

    @Override
    public int getTier() {
        return this.part.getTier(this);
    }

    @Override
    @Nonnull
    public PartType getType() {
        return this.part.getType();
    }

    @Override
    public GearType getGearType() {
        return this.part.getGearType();
    }

    @Override
    public Collection<StatInstance> getStatModifiers(PartType partType, StatGearKey key, ItemStack gear) {
        return this.part.getStatModifiers(this, this.getType(), key, gear);
    }

    public List<MaterialInstance> getMaterials() {
        return this.part.getMaterials(this);
    }

    public boolean containsMaterial(DataResource<IMaterial> materialIn) {
        if (materialIn.isPresent()) {
            for (MaterialInstance mat : this.getMaterials()) {
                if (!mat.get().equals(materialIn.get())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isCraftingAllowed(GearType gearType, @Nullable CraftingInventory inventory) {
        return this.part.isCraftingAllowed(this, this.getType(), gearType, (IInventory)inventory);
    }

    public ITextComponent getDisplayName(ItemStack gear) {
        return this.part.getDisplayName(this, gear);
    }

    public ITextComponent getMaterialName(ItemStack gear) {
        return this.part.getMaterialName(this, gear);
    }

    @Override
    public String getModelKey() {
        return this.part.getModelKey(this);
    }

    public int getColor(ItemStack gear) {
        return this.getColor(gear, 0, 0);
    }

    public int getColor(ItemStack gear, int layer, int animationFrame) {
        return this.part.getColor(this, gear, layer, animationFrame);
    }

    @Override
    public void onAddToGear(ItemStack gear) {
        this.part.onAddToGear(gear, this);
    }

    public void onRemoveFromGear(ItemStack gear) {
        this.part.onRemoveFromGear(gear, this);
    }

    public String toString() {
        return "PartData{" + this.part + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PartData partData = (PartData)o;
        return this.part.equals(partData.part) && InventoryUtils.canItemsStack((ItemStack)this.craftingItem, (ItemStack)partData.craftingItem);
    }

    public int hashCode() {
        return Objects.hash(this.part, this.craftingItem);
    }
}

