/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.gear.trait;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Multimap;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.JSONUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.ITraitCondition;
import net.silentchaos512.gear.api.traits.ITraitSerializer;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.gear.trait.TraitSerializers;

public class SimpleTrait
implements ITrait {
    public static final Serializer<SimpleTrait> SERIALIZER = new Serializer<SimpleTrait>(Serializer.access$000(), SimpleTrait::new);
    private final ResourceLocation objId;
    private final ITraitSerializer<?> serializer;
    int maxLevel;
    ImmutableList<ITraitCondition> conditions = ImmutableList.of();
    Set<String> cancelsWith = new HashSet<String>();
    ITextComponent displayName;
    ITextComponent description;
    boolean hidden;
    final Collection<ITextComponent> wikiLines = new ArrayList<ITextComponent>();

    @Deprecated
    public SimpleTrait(ResourceLocation id) {
        this(id, SERIALIZER);
    }

    public SimpleTrait(ResourceLocation id, ITraitSerializer<?> serializer) {
        this.objId = id;
        this.serializer = serializer;
    }

    @Override
    public ResourceLocation getId() {
        return this.objId;
    }

    @Override
    public int getMaxLevel() {
        return this.maxLevel;
    }

    @Override
    public Collection<ITraitCondition> getConditions() {
        return this.conditions;
    }

    @Override
    public boolean willCancelWith(ITrait other) {
        return this.cancelsWith.contains(other.getId().toString());
    }

    @Override
    public Collection<String> getCancelsWithSet() {
        return Collections.unmodifiableSet(this.cancelsWith);
    }

    @Override
    public void retainData(@Nullable ITrait oldTrait) {
        if (oldTrait instanceof SimpleTrait) {
            this.wikiLines.addAll(((SimpleTrait)oldTrait).wikiLines);
        }
    }

    @Override
    public IFormattableTextComponent getDisplayName(int level) {
        IFormattableTextComponent text = this.displayName.func_230532_e_();
        if (level > 0 && this.maxLevel > 1) {
            text.func_240702_b_(" ").func_230529_a_((ITextComponent)new TranslationTextComponent("enchantment.level." + level));
        }
        return text;
    }

    @Override
    public IFormattableTextComponent getDescription(int level) {
        return this.description.func_230532_e_();
    }

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public ITraitSerializer<?> getSerializer() {
        return this.serializer;
    }

    @Override
    public float onAttackEntity(TraitActionContext context, LivingEntity target, float baseValue) {
        return baseValue;
    }

    @Override
    public float onDurabilityDamage(TraitActionContext context, int damageTaken) {
        return damageTaken;
    }

    @Override
    public void onGearCrafted(TraitActionContext context) {
    }

    @Override
    public void onRecalculatePre(TraitActionContext context) {
    }

    @Override
    public void onRecalculatePost(TraitActionContext context) {
    }

    @Override
    public float onGetStat(TraitActionContext context, ItemStat stat, float value, float damageRatio) {
        return value;
    }

    @Override
    public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> modifiers, String slot) {
    }

    @Override
    @Deprecated
    public void onGetAttributeModifiers(TraitActionContext context, Multimap<Attribute, AttributeModifier> modifiers, EquipmentSlotType slot) {
    }

    @Override
    public ActionResultType onItemUse(ItemUseContext context, int traitLevel) {
        return ActionResultType.PASS;
    }

    @Override
    public void onItemSwing(ItemStack stack, LivingEntity wielder, int traitLevel) {
    }

    @Override
    public void onUpdate(TraitActionContext context, boolean isEquipped) {
    }

    @Override
    public ItemStack addLootDrops(TraitActionContext context, ItemStack stack) {
        return ItemStack.field_190927_a;
    }

    @Override
    public Collection<String> getExtraWikiLines() {
        return this.wikiLines.stream().map(ITextComponent::getString).collect(Collectors.toCollection(ArrayList::new));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SimpleTrait that = (SimpleTrait)o;
        return this.objId.equals((Object)that.objId);
    }

    public int hashCode() {
        return Objects.hash(this.objId);
    }

    public static final class Serializer<T extends SimpleTrait>
    implements ITraitSerializer<T> {
        private static final ResourceLocation NAME = SilentGear.getId("simple_trait");
        private final ResourceLocation serializerId;
        private final Function<ResourceLocation, T> factory;
        @Nullable
        private final BiConsumer<T, JsonObject> readJson;
        @Nullable
        private final BiConsumer<T, PacketBuffer> readBuffer;
        @Nullable
        private final BiConsumer<T, PacketBuffer> writeBuffer;

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory) {
            this(serializerId, factory, null, null, null);
        }

        public Serializer(ResourceLocation serializerId, Function<ResourceLocation, T> factory, @Nullable BiConsumer<T, JsonObject> readJson, @Nullable BiConsumer<T, PacketBuffer> readBuffer, @Nullable BiConsumer<T, PacketBuffer> writeBuffer) {
            this.serializerId = serializerId;
            this.factory = factory;
            this.readJson = readJson;
            this.readBuffer = readBuffer;
            this.writeBuffer = writeBuffer;
        }

        @Override
        public T read(ResourceLocation id, JsonObject json) {
            JsonArray array;
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = JSONUtils.func_151208_a((JsonObject)json, (String)"max_level", (int)1);
            trait.displayName = Serializer.deserializeText(json.get("name"));
            trait.description = Serializer.deserializeText(json.get("description"));
            trait.hidden = JSONUtils.func_151209_a((JsonObject)json, (String)"hidden", (boolean)false);
            if (json.has("conditions")) {
                ArrayList<ITraitCondition> conditions = new ArrayList<ITraitCondition>();
                JsonArray array2 = json.getAsJsonArray("conditions");
                for (JsonElement elem : array2) {
                    conditions.add(TraitSerializers.deserializeCondition(elem.getAsJsonObject()));
                }
                trait.conditions = ImmutableList.copyOf(conditions);
            }
            if (json.has("cancels_with")) {
                array = json.getAsJsonArray("cancels_with");
                for (JsonElement elem : array) {
                    trait.cancelsWith.add(elem.getAsString());
                }
            }
            if (json.has("extra_wiki_lines")) {
                array = json.getAsJsonArray("extra_wiki_lines");
                for (JsonElement elem : array) {
                    trait.wikiLines.add((ITextComponent)ITextComponent.Serializer.func_240641_a_((JsonElement)elem));
                }
            }
            if (this.readJson != null) {
                this.readJson.accept(trait, json);
            }
            return (T)trait;
        }

        @Override
        public T read(ResourceLocation id, PacketBuffer buffer) {
            SimpleTrait trait = (SimpleTrait)this.factory.apply(id);
            trait.maxLevel = buffer.readByte();
            trait.displayName = buffer.func_179258_d();
            trait.description = buffer.func_179258_d();
            trait.hidden = buffer.readBoolean();
            Object[] conditions = new ITraitCondition[buffer.readByte()];
            for (int i = 0; i < conditions.length; ++i) {
                conditions[i] = TraitSerializers.readCondition(buffer);
            }
            trait.conditions = ImmutableList.copyOf((Object[])conditions);
            int cancelsCount = buffer.func_150792_a();
            for (int i = 0; i < cancelsCount; ++i) {
                trait.cancelsWith.add(buffer.func_150789_c(255));
            }
            if (this.readBuffer != null) {
                this.readBuffer.accept(trait, buffer);
            }
            return (T)trait;
        }

        @Override
        public void write(PacketBuffer buffer, T trait) {
            buffer.writeByte(((SimpleTrait)trait).maxLevel);
            buffer.func_179256_a(((SimpleTrait)trait).displayName);
            buffer.func_179256_a(((SimpleTrait)trait).description);
            buffer.writeBoolean(((SimpleTrait)trait).hidden);
            buffer.writeByte(((SimpleTrait)trait).conditions.size());
            ((SimpleTrait)trait).conditions.forEach(condition -> TraitSerializers.writeCondition(condition, buffer));
            buffer.func_150787_b(((SimpleTrait)trait).cancelsWith.size());
            for (String str : ((SimpleTrait)trait).cancelsWith) {
                buffer.func_180714_a(str);
            }
            if (this.writeBuffer != null) {
                this.writeBuffer.accept(trait, buffer);
            }
        }

        @Override
        public ResourceLocation getName() {
            return this.serializerId;
        }

        private static ITextComponent deserializeText(JsonElement json) {
            if (json.isJsonObject() && json.getAsJsonObject().has("name")) {
                boolean translate = JSONUtils.func_151209_a((JsonObject)json.getAsJsonObject(), (String)"translate", (boolean)false);
                String name = JSONUtils.func_151200_h((JsonObject)json.getAsJsonObject(), (String)"name");
                return translate ? new TranslationTextComponent(name) : new StringTextComponent(name);
            }
            return (ITextComponent)Objects.requireNonNull(ITextComponent.Serializer.func_240641_a_((JsonElement)json));
        }

        private static ITextComponent readTextComponent(JsonObject json, String name) {
            JsonElement element = json.get(name);
            if (element != null && element.isJsonObject()) {
                JsonObject obj = element.getAsJsonObject();
                boolean translate = JSONUtils.func_151209_a((JsonObject)obj, (String)"translate", (boolean)false);
                String value = JSONUtils.func_151200_h((JsonObject)obj, (String)"name");
                return translate ? new TranslationTextComponent(value) : new StringTextComponent(value);
            }
            if (element != null) {
                throw new JsonParseException("Expected '" + name + "' to be an object");
            }
            throw new JsonParseException("Missing required object '" + name + "'");
        }

        public String getTypeName() {
            SimpleTrait temp = (SimpleTrait)this.factory.apply(new ResourceLocation("null"));
            return temp.getClass().getCanonicalName();
        }

        static /* synthetic */ ResourceLocation access$000() {
            return NAME;
        }
    }
}

