/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.init;

import java.util.Collection;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.item.Item;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.tileentity.TileEntityType;
import net.minecraftforge.common.loot.GlobalLootModifierSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.silentchaos512.gear.init.ModBlocks;
import net.silentchaos512.gear.init.ModContainers;
import net.silentchaos512.gear.init.ModEntities;
import net.silentchaos512.gear.init.ModItems;
import net.silentchaos512.gear.init.ModLootStuff;
import net.silentchaos512.gear.init.ModRecipes;
import net.silentchaos512.gear.init.ModTileEntities;

public final class Registration {
    public static final DeferredRegister<Block> BLOCKS = Registration.create(ForgeRegistries.BLOCKS);
    public static final DeferredRegister<ContainerType<?>> CONTAINERS = Registration.create(ForgeRegistries.CONTAINERS);
    public static final DeferredRegister<EntityType<?>> ENTITIES = Registration.create(ForgeRegistries.ENTITIES);
    public static final DeferredRegister<Item> ITEMS = Registration.create(ForgeRegistries.ITEMS);
    public static final DeferredRegister<GlobalLootModifierSerializer<?>> LOOT_MODIFIERS = Registration.create(ForgeRegistries.LOOT_MODIFIER_SERIALIZERS);
    public static final DeferredRegister<IRecipeSerializer<?>> RECIPE_SERIALIZERS = Registration.create(ForgeRegistries.RECIPE_SERIALIZERS);
    public static final DeferredRegister<TileEntityType<?>> TILE_ENTITIES = Registration.create(ForgeRegistries.TILE_ENTITIES);

    private Registration() {
        throw new IllegalAccessError("Utility class");
    }

    public static void register() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        BLOCKS.register(modEventBus);
        CONTAINERS.register(modEventBus);
        ENTITIES.register(modEventBus);
        ITEMS.register(modEventBus);
        LOOT_MODIFIERS.register(modEventBus);
        RECIPE_SERIALIZERS.register(modEventBus);
        TILE_ENTITIES.register(modEventBus);
        ModBlocks.register();
        ModContainers.register();
        ModEntities.register();
        ModItems.register();
        ModLootStuff.init();
        ModRecipes.register();
        ModTileEntities.register();
    }

    public static <T extends Block> Collection<T> getBlocks(Class<T> clazz) {
        return BLOCKS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(block -> block).collect(Collectors.toList());
    }

    public static <T> Collection<T> getItems(Class<T> clazz) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(clazz::isInstance).map(item -> item).collect(Collectors.toList());
    }

    public static Collection<Item> getItems(Predicate<Item> predicate) {
        return ITEMS.getEntries().stream().map(RegistryObject::get).filter(predicate).collect(Collectors.toList());
    }

    private static <T extends IForgeRegistryEntry<T>> DeferredRegister<T> create(IForgeRegistry<T> registry) {
        return DeferredRegister.create(registry, (String)"silentgear");
    }
}

