/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.nbt.StringNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.client.util.ColorUtils;
import net.silentchaos512.gear.client.util.TextListBuilder;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;
import net.silentchaos512.lib.util.NameUtils;

public class CompoundMaterialItem
extends Item
implements IColoredMaterialItem {
    public CompoundMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public static List<MaterialInstance> getSubMaterials(ItemStack stack) {
        ArrayList<MaterialInstance> ret = new ArrayList<MaterialInstance>();
        ListNBT listNbt = stack.func_196082_o().func_150295_c("Materials", 8);
        for (INBT nbt : listNbt) {
            IMaterial mat = MaterialManager.get(SilentGear.getIdWithDefaultNamespace(nbt.func_150285_a_()));
            if (mat == null) continue;
            ret.add(MaterialInstance.of(mat));
        }
        return ret;
    }

    public int getCraftedCount(ItemStack stack) {
        ListNBT listNbt = stack.func_196082_o().func_150295_c("Materials", 8);
        return listNbt.size();
    }

    public ItemStack create(List<? extends IMaterialInstance> materials) {
        return this.create(materials, materials.size());
    }

    public ItemStack create(List<? extends IMaterialInstance> materials, int craftedCount) {
        ListNBT materialListNbt = new ListNBT();
        for (IMaterialInstance iMaterialInstance : materials) {
            materialListNbt.add((Object)StringNBT.func_229705_a_((String)iMaterialInstance.getId().toString()));
        }
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("Materials", (INBT)materialListNbt);
        ItemStack itemStack = new ItemStack((IItemProvider)this, materials.size());
        itemStack.func_77982_d(tag);
        return itemStack;
    }

    @Nullable
    public static MaterialInstance getPrimaryMaterial(ItemStack stack) {
        IMaterial material;
        INBT nbt;
        ResourceLocation id;
        ListNBT listNbt = stack.func_196082_o().func_150295_c("Materials", 8);
        if (!listNbt.isEmpty() && (id = ResourceLocation.func_208304_a((String)(nbt = listNbt.get(0)).func_150285_a_())) != null && (material = MaterialManager.get(id)) != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    public static String getModelKey(ItemStack stack) {
        StringBuilder s = new StringBuilder(SilentGear.shortenId(NameUtils.fromItem((ItemStack)stack)) + "#");
        if (!stack.func_77942_o()) {
            return s.append(Const.Materials.EXAMPLE.getId()).toString();
        }
        for (MaterialInstance material : CompoundMaterialItem.getSubMaterials(stack)) {
            s.append(SilentGear.shortenId(material.getId()));
        }
        return s.toString();
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        return ColorUtils.getBlendedColor(this, CompoundMaterialItem.getSubMaterials(stack), layer);
    }

    public int getColorWeight(int index, int totalCount) {
        return 1;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        MaterialInstance material = CompoundMaterialItem.getPrimaryMaterial(stack);
        if (material != null) {
            TranslationTextComponent nameText = new TranslationTextComponent(this.func_77658_a(), new Object[]{material.getDisplayName(PartType.MAIN)});
            int nameColor = material.getNameColor(PartType.MAIN, GearType.ALL);
            return TextUtil.withColor((IFormattableTextComponent)nameText, nameColor);
        }
        return new TranslationTextComponent(this.func_77658_a(), new Object[]{TextUtil.misc("unknown", new Object[0])});
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TextUtil.withColor(TextUtil.misc("wip", new Object[0]), TextFormatting.RED));
        List<MaterialInstance> materials = CompoundMaterialItem.getSubMaterials(stack);
        TextListBuilder statsBuilder = new TextListBuilder();
        for (MaterialInstance material : materials) {
            int nameColor = material.getNameColor(PartType.MAIN, GearType.ALL);
            statsBuilder.add((ITextComponent)TextUtil.withColor(material.getDisplayName(PartType.MAIN), nameColor));
        }
        tooltip.addAll(statsBuilder.build());
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        items.add((Object)this.create(Collections.singletonList(LazyMaterialInstance.of(Const.Materials.EXAMPLE)), 1));
    }
}

