/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.material.IMaterialInstance;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.gear.material.LazyMaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.item.IColoredMaterialItem;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.TextUtil;

public class CustomMaterialItem
extends Item
implements IColoredMaterialItem {
    private static final String NBT_MATERIAL = "Material";

    public CustomMaterialItem(Item.Properties properties) {
        super(properties);
    }

    public ItemStack create(IMaterialInstance material) {
        return this.create(material, 1);
    }

    public ItemStack create(IMaterialInstance material, int count) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_74778_a(NBT_MATERIAL, SilentGear.shortenId(material.getId()));
        ItemStack result = new ItemStack((IItemProvider)this, count);
        result.func_77982_d(tag);
        return result;
    }

    @Nullable
    public static MaterialInstance getMaterial(ItemStack stack) {
        IMaterial material;
        String str = stack.func_196082_o().func_74779_i(NBT_MATERIAL);
        ResourceLocation id = SilentGear.getIdWithDefaultNamespace(str);
        if (id != null && (material = MaterialManager.get(id)) != null) {
            return MaterialInstance.of(material);
        }
        return null;
    }

    @Override
    public int getColor(ItemStack stack, int layer) {
        MaterialInstance material;
        if (layer == 0 && (material = CustomMaterialItem.getMaterial(stack)) != null) {
            return material.getPrimaryColor(GearType.ALL, PartType.MAIN);
        }
        return 0xFFFFFF;
    }

    public ITextComponent func_200295_i(ItemStack stack) {
        MaterialInstance material = CustomMaterialItem.getMaterial(stack);
        if (material != null) {
            TranslationTextComponent nameText = new TranslationTextComponent(this.func_77658_a(), new Object[]{material.getDisplayName(PartType.MAIN)});
            int nameColor = material.getNameColor(PartType.MAIN, GearType.ALL);
            return TextUtil.withColor((IFormattableTextComponent)nameText, nameColor);
        }
        return super.func_200295_i(stack);
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TextUtil.withColor(TextUtil.misc("wip", new Object[0]), TextFormatting.RED));
    }

    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!this.func_194125_a(group)) {
            return;
        }
        items.add((Object)this.create(LazyMaterialInstance.of(Const.Materials.EXAMPLE)));
    }
}

