/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.item;

import com.mojang.datafixers.util.Pair;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.util.Tuple;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.silentchaos512.gear.api.material.IMaterial;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.RepairContext;
import net.silentchaos512.gear.item.FragmentItem;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.TextUtil;

public class RepairKitItem
extends Item {
    private static final String NBT_STORAGE = "Storage";
    private final Supplier<Integer> capacity;
    private final Supplier<Double> efficiency;

    public RepairKitItem(Supplier<Integer> capacity, Supplier<Double> efficiency, Item.Properties properties) {
        super(properties);
        this.capacity = capacity;
        this.efficiency = efficiency;
    }

    public boolean addMaterial(ItemStack repairKit, ItemStack materialStack) {
        Tuple<MaterialInstance, Float> tuple = RepairKitItem.getMaterialAndValue(materialStack);
        if (tuple != null) {
            MaterialInstance mat = (MaterialInstance)tuple.func_76341_a();
            float value = ((Float)tuple.func_76340_b()).floatValue();
            if (RepairKitItem.getStoredMaterialAmount(repairKit) > (float)this.getKitCapacity() - value) {
                return false;
            }
            String key = RepairKitItem.getShorthandKey(mat);
            CompoundNBT storageTag = repairKit.func_190925_c(NBT_STORAGE);
            float current = storageTag.func_74760_g(key);
            storageTag.func_74776_a(key, current + value);
            return true;
        }
        return false;
    }

    @Nullable
    private static Tuple<MaterialInstance, Float> getMaterialAndValue(ItemStack stack) {
        if (stack.func_77973_b() instanceof FragmentItem) {
            IMaterial material = FragmentItem.getMaterial(stack);
            if (material != null) {
                return new Tuple((Object)MaterialInstance.of(material), (Object)Float.valueOf(0.125f));
            }
            return null;
        }
        MaterialInstance mat = MaterialInstance.from(stack);
        if (mat != null) {
            return new Tuple((Object)mat, (Object)Float.valueOf(1.0f));
        }
        return null;
    }

    private int getKitCapacity() {
        return this.capacity.get();
    }

    public float getRepairEfficiency(RepairContext.Type repairType) {
        return this.efficiency.get().floatValue() + repairType.getBonusEfficiency();
    }

    private static float getStoredAmount(ItemStack stack, MaterialInstance material) {
        CompoundNBT nbt = stack.func_190925_c(NBT_STORAGE);
        return nbt.func_74760_g(RepairKitItem.getShorthandKey(material));
    }

    private static float getStoredMaterialAmount(ItemStack repairKit) {
        float sum = 0.0f;
        for (float amount : RepairKitItem.getStoredMaterials(repairKit).values()) {
            sum += amount;
        }
        return sum;
    }

    private static Map<MaterialInstance, Float> getStoredMaterials(ItemStack stack) {
        CompoundNBT nbt = stack.func_190925_c(NBT_STORAGE);
        List<MaterialInstance> list = nbt.func_150296_c().stream().map(MaterialInstance::readShorthand).filter(Objects::nonNull).sorted(Comparator.comparing(mat1 -> mat1.getTier(PartType.MAIN)).thenComparing(mat1 -> mat1.getDisplayName(PartType.MAIN).func_230531_f_().getString())).collect(Collectors.toList());
        LinkedHashMap<MaterialInstance, Float> ret = new LinkedHashMap<MaterialInstance, Float>();
        list.forEach(mat -> {
            float value = nbt.func_74760_g(RepairKitItem.getShorthandKey(mat));
            ret.put((MaterialInstance)mat, Float.valueOf(value));
        });
        return ret;
    }

    @Nonnull
    private static String getShorthandKey(MaterialInstance mat) {
        return MaterialInstance.writeShorthand(mat);
    }

    private Pair<Map<MaterialInstance, Float>, Integer> getMaterialsToRepair(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        Map<MaterialInstance, Float> stored = RepairKitItem.getStoredMaterials(repairKit);
        HashMap<MaterialInstance, Float> used = new HashMap<MaterialInstance, Float>();
        float gearRepairEfficiency = GearData.getStat(gear, ItemStats.REPAIR_EFFICIENCY);
        float kitEfficiency = this.getRepairEfficiency(repairType);
        int damageLeft = gear.func_77952_i();
        if (gearRepairEfficiency > 0.0f && kitEfficiency > 0.0f) {
            for (Map.Entry<MaterialInstance, Float> entry : stored.entrySet()) {
                MaterialInstance mat = entry.getKey();
                float amount = entry.getValue().floatValue();
                int repairValue = mat.getRepairValue(gear);
                if (repairValue <= 0) continue;
                float totalRepairValue = (float)repairValue * amount;
                int maxRepair = Math.round(totalRepairValue * gearRepairEfficiency * kitEfficiency);
                int toRepair = Math.min(maxRepair, damageLeft);
                float repairValueUsed = (float)toRepair / gearRepairEfficiency / kitEfficiency;
                float amountUsed = repairValueUsed / (float)repairValue;
                used.put(mat, Float.valueOf(amountUsed));
                if ((damageLeft -= toRepair) > 0) continue;
                break;
            }
        }
        return Pair.of(used, (Object)(gear.func_77952_i() - damageLeft));
    }

    public Map<MaterialInstance, Float> getRepairMaterials(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        return (Map)this.getMaterialsToRepair(gear, repairKit, repairType).getFirst();
    }

    public int getDamageToRepair(ItemStack gear, ItemStack repairKit, RepairContext.Type repairType) {
        return (Integer)this.getMaterialsToRepair(gear, repairKit, repairType).getSecond();
    }

    public void removeRepairMaterials(ItemStack repairKit, Map<MaterialInstance, Float> toRemove) {
        CompoundNBT nbt = repairKit.func_190925_c(NBT_STORAGE);
        for (Map.Entry<MaterialInstance, Float> entry : toRemove.entrySet()) {
            MaterialInstance mat = entry.getKey();
            Float amount = entry.getValue();
            String key = RepairKitItem.getShorthandKey(mat);
            float newValue = nbt.func_74760_g(key) - amount.floatValue();
            if (newValue < 0.01f) {
                nbt.func_82580_o(key);
                continue;
            }
            nbt.func_74776_a(key, newValue);
        }
    }

    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)TextUtil.translate("item", "repair_kit.efficiency", (int)(this.getRepairEfficiency(RepairContext.Type.QUICK) * 100.0f)));
        tooltip.add((ITextComponent)TextUtil.translate("item", "repair_kit.capacity", RepairKitItem.format(RepairKitItem.getStoredMaterialAmount(stack)), this.getKitCapacity()));
        Map<MaterialInstance, Float> storedMaterials = RepairKitItem.getStoredMaterials(stack);
        if (storedMaterials.isEmpty()) {
            tooltip.add((ITextComponent)TextUtil.translate("item", "repair_kit.hint1").func_240699_a_(TextFormatting.ITALIC));
            tooltip.add((ITextComponent)TextUtil.translate("item", "repair_kit.hint2").func_240699_a_(TextFormatting.ITALIC));
            tooltip.add((ITextComponent)TextUtil.translate("item", "repair_kit.hint3").func_240699_a_(TextFormatting.ITALIC));
            return;
        }
        for (Map.Entry<MaterialInstance, Float> entry : storedMaterials.entrySet()) {
            tooltip.add((ITextComponent)TextUtil.translate("item", "repair_kit.material", entry.getKey().getDisplayNameWithGrade(PartType.MAIN), RepairKitItem.format(entry.getValue().floatValue())));
        }
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return 1.0 - (double)(RepairKitItem.getStoredMaterialAmount(stack) / (float)this.getKitCapacity());
    }

    public int getRGBDurabilityForDisplay(ItemStack stack) {
        return MathHelper.func_181758_c((float)(Math.max(0.0f, (float)(1.0 - this.getDurabilityForDisplay(stack))) / 3.0f + 0.5f), (float)1.0f, (float)1.0f);
    }

    private static String format(float f) {
        return String.format("%.2f", Float.valueOf(f));
    }
}

