/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.network;

import java.util.Objects;
import java.util.function.Supplier;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.FMLHandshakeHandler;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkDirection;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import net.silentchaos512.gear.gear.material.MaterialManager;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.network.ClientOutputCommandPacket;
import net.silentchaos512.gear.network.CompounderUpdatePacket;
import net.silentchaos512.gear.network.GearLeftClickPacket;
import net.silentchaos512.gear.network.KeyPressOnItemPacket;
import net.silentchaos512.gear.network.LoginPacket;
import net.silentchaos512.gear.network.ProspectingResultPacket;
import net.silentchaos512.gear.network.SelectBlueprintFromBookPacket;
import net.silentchaos512.gear.network.ShowPartsScreenPacket;
import net.silentchaos512.gear.network.SyncGearCraftingItemsPacket;
import net.silentchaos512.gear.network.SyncGearPartsPacket;
import net.silentchaos512.gear.network.SyncMaterialCraftingItemsPacket;
import net.silentchaos512.gear.network.SyncMaterialsPacket;
import net.silentchaos512.gear.network.SyncTraitsPacket;

public final class Network {
    private static final ResourceLocation NAME = new ResourceLocation("silentgear", "network");
    private static final String VERSION = "sgear-net-8";
    public static SimpleChannel channel = NetworkRegistry.ChannelBuilder.named((ResourceLocation)NAME).clientAcceptedVersions(s -> Objects.equals(s, VERSION)).serverAcceptedVersions(s -> Objects.equals(s, VERSION)).networkProtocolVersion(() -> "sgear-net-8").simpleChannel();

    private Network() {
    }

    public static void init() {
    }

    static {
        channel.messageBuilder(SyncTraitsPacket.class, 1).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncTraitsPacket::fromBytes).encoder(SyncTraitsPacket::toBytes).markAsLoginPacket().consumer(FMLHandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            TraitManager.handleTraitSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(SyncGearPartsPacket.class, 2).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncGearPartsPacket::fromBytes).encoder(SyncGearPartsPacket::toBytes).markAsLoginPacket().consumer(FMLHandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            PartManager.handlePartSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(LoginPacket.Reply.class, 3).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(buffer -> new LoginPacket.Reply()).encoder((msg, buffer) -> {}).consumer(FMLHandshakeHandler.indexFirst((hh, msg, ctx) -> msg.handle((Supplier<NetworkEvent.Context>)ctx))).add();
        channel.messageBuilder(SyncGearCraftingItemsPacket.class, 4).encoder(SyncGearCraftingItemsPacket::toBytes).decoder(SyncGearCraftingItemsPacket::fromBytes).consumer(SyncGearCraftingItemsPacket::handle).add();
        channel.messageBuilder(ShowPartsScreenPacket.class, 5).encoder((packet, buffer) -> {}).decoder(buffer -> new ShowPartsScreenPacket()).consumer(ShowPartsScreenPacket::handle).add();
        channel.messageBuilder(SyncMaterialsPacket.class, 6).loginIndex(LoginPacket::getLoginIndex, LoginPacket::setLoginIndex).decoder(SyncMaterialsPacket::fromBytes).encoder(SyncMaterialsPacket::toBytes).markAsLoginPacket().consumer(FMLHandshakeHandler.biConsumerFor((hh, msg, ctx) -> {
            MaterialManager.handleSyncPacket(msg, ctx);
            channel.reply((Object)new LoginPacket.Reply(), (NetworkEvent.Context)ctx.get());
        })).add();
        channel.messageBuilder(FMLPlayMessages.SpawnEntity.class, 7).encoder(FMLPlayMessages.SpawnEntity::encode).decoder(FMLPlayMessages.SpawnEntity::decode).consumer(FMLPlayMessages.SpawnEntity::handle).add();
        channel.messageBuilder(SyncMaterialCraftingItemsPacket.class, 8).decoder(SyncMaterialCraftingItemsPacket::decode).encoder(SyncMaterialCraftingItemsPacket::encode).consumer(SyncMaterialCraftingItemsPacket::handle).add();
        channel.messageBuilder(KeyPressOnItemPacket.class, 9, NetworkDirection.PLAY_TO_SERVER).decoder(KeyPressOnItemPacket::decode).encoder(KeyPressOnItemPacket::encode).consumer(KeyPressOnItemPacket::handle).add();
        channel.messageBuilder(SelectBlueprintFromBookPacket.class, 10, NetworkDirection.PLAY_TO_SERVER).decoder(SelectBlueprintFromBookPacket::decode).encoder(SelectBlueprintFromBookPacket::encode).consumer(SelectBlueprintFromBookPacket::handle).add();
        channel.messageBuilder(ProspectingResultPacket.class, 11, NetworkDirection.PLAY_TO_CLIENT).decoder(ProspectingResultPacket::decode).encoder(ProspectingResultPacket::encode).consumer(ProspectingResultPacket::handle).add();
        channel.messageBuilder(GearLeftClickPacket.class, 12, NetworkDirection.PLAY_TO_SERVER).decoder(GearLeftClickPacket::decode).encoder(GearLeftClickPacket::encode).consumer(GearLeftClickPacket::handle).add();
        channel.messageBuilder(ClientOutputCommandPacket.class, 13).encoder(ClientOutputCommandPacket::encode).decoder(ClientOutputCommandPacket::decode).consumer(ClientOutputCommandPacket::handle).add();
        channel.messageBuilder(CompounderUpdatePacket.class, 14, NetworkDirection.PLAY_TO_SERVER).encoder(CompounderUpdatePacket::encode).decoder(CompounderUpdatePacket::decode).consumer(CompounderUpdatePacket::handle).add();
    }
}

