/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.attributes.ModifiableAttributeInstance;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.item.Rarity;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.Event;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GearNamePrefixesEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.item.ICoreItem;
import net.silentchaos512.gear.api.item.ICoreTool;
import net.silentchaos512.gear.api.part.IPartData;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.stats.ItemStat;
import net.silentchaos512.gear.api.stats.ItemStats;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.config.Config;
import net.silentchaos512.gear.crafting.ingredient.IPartIngredient;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.part.PartManager;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearGenerator;
import net.silentchaos512.gear.util.TraitHelper;
import net.silentchaos512.lib.advancements.LibTriggers;

public final class GearHelper {
    public static final ResourceLocation DAMAGE_FACTOR_CHANGE = SilentGear.getId("damage_factor_change");
    private static final UUID REACH_MODIFIER_UUID = UUID.fromString("5e889b20-a8bd-43df-9ece-88a9f9be7530");
    private static final float BROKEN_ATTACK_SPEED_CHANGE = 0.7f;
    private static final float BROKEN_DESTROY_SPEED = 0.25f;

    private GearHelper() {
    }

    public static Optional<ICoreItem> getItem(ItemStack gear) {
        if (gear.func_77973_b() instanceof ICoreItem) {
            return Optional.of((ICoreItem)gear.func_77973_b());
        }
        return Optional.empty();
    }

    public static boolean isGear(ItemStack stack) {
        return stack.func_77973_b() instanceof ICoreItem;
    }

    public static float getMeleeDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 1.0f;
        }
        float val = GearData.getStat(stack, ItemStats.MELEE_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getMagicDamageModifier(ItemStack stack) {
        if (GearHelper.isBroken(stack)) {
            return 0.0f;
        }
        float val = GearData.getStat(stack, ItemStats.MAGIC_DAMAGE);
        return val < 0.0f ? 0.0f : val;
    }

    public static float getAttackSpeedModifier(ItemStack stack) {
        if (!(stack.func_77973_b() instanceof ICoreTool)) {
            return 0.0f;
        }
        float speed = GearData.getStat(stack, ItemStats.ATTACK_SPEED);
        if (GearHelper.isBroken(stack)) {
            speed += 0.7f;
        }
        return speed;
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack) {
        return GearHelper.getAttributeModifiers(slot, stack, true);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, boolean addStandardMainHandMods) {
        LinkedHashMultimap map = LinkedHashMultimap.create((Multimap)stack.func_77973_b().func_111205_h(slot));
        return GearHelper.getAttributeModifiers(slot, stack, (Multimap<Attribute, AttributeModifier>)map, addStandardMainHandMods);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map) {
        return GearHelper.getAttributeModifiers(slot, stack, map, true);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlotType slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, boolean addStandardMainHandMods) {
        return GearHelper.getAttributeModifiers(slot.func_188450_d(), stack, map, addStandardMainHandMods);
    }

    public static Multimap<Attribute, AttributeModifier> getAttributeModifiers(String slot, ItemStack stack, Multimap<Attribute, AttributeModifier> map, boolean addStandardMainHandMods) {
        if (addStandardMainHandMods && GearHelper.isValidSlot(stack, slot) && slot.equals(EquipmentSlotType.MAINHAND.func_188450_d())) {
            GearHelper.replaceAttributeModifierInMap(map, Attributes.field_233823_f_, GearHelper.getMeleeDamageModifier(stack));
            GearHelper.replaceAttributeModifierInMap(map, Attributes.field_233825_h_, GearHelper.getAttackSpeedModifier(stack));
            ForgeMod.REACH_DISTANCE.ifPresent(attr -> {
                float reachStat = GearData.getStat(stack, ItemStats.REACH_DISTANCE);
                AttributeModifier mod = new AttributeModifier(REACH_MODIFIER_UUID, "Gear reach", (double)reachStat, AttributeModifier.Operation.ADDITION);
                map.put(attr, (Object)mod);
            });
        }
        TraitHelper.getCachedTraits(stack).forEach((trait, level) -> trait.onGetAttributeModifiers(new TraitActionContext(null, (int)level, stack), map, slot));
        return map;
    }

    private static void replaceAttributeModifierInMap(Multimap<Attribute, AttributeModifier> map, Attribute key, float value) {
        Iterator iter;
        if (map.containsKey((Object)key) && (iter = map.get((Object)key).iterator()).hasNext()) {
            AttributeModifier mod = (AttributeModifier)iter.next();
            map.removeAll((Object)key);
            map.put((Object)key, (Object)new AttributeModifier(mod.func_111167_a(), mod.func_111166_b(), (double)value, mod.func_220375_c()));
        }
    }

    public static boolean isValidSlot(ItemStack gear, String slot) {
        if (gear.func_77973_b() instanceof ICoreItem) {
            return ((ICoreItem)gear.func_77973_b()).isValidSlot(slot);
        }
        return false;
    }

    public static boolean getIsRepairable(ItemStack stack, ItemStack materialItem) {
        MaterialInstance material = MaterialInstance.from(materialItem);
        return material != null && GearHelper.getIsRepairable(stack, material);
    }

    public static boolean getIsRepairable(ItemStack gear, MaterialInstance material) {
        PartData part = GearData.getPrimaryPart(gear);
        return part != null && material.getTier(PartType.MAIN) >= part.getTier() && material.getRepairValue(gear) > 0;
    }

    public static ItemStat getDurabilityStat(ItemStack gear) {
        return GearHelper.getItem(gear).map(ICoreItem::getDurabilityStat).orElse(ItemStats.DURABILITY);
    }

    public static float getRepairModifier(ItemStack gear) {
        return GearHelper.getItem(gear).map(item -> Float.valueOf(item.getRepairModifier(gear))).orElse(Float.valueOf(1.0f)).floatValue();
    }

    public static void attemptDamage(ItemStack stack, int amount, @Nullable LivingEntity entity, Hand hand) {
        GearHelper.attemptDamage(stack, amount, entity, hand == Hand.OFF_HAND ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND);
    }

    public static void attemptDamage(ItemStack stack, int amount, @Nullable LivingEntity entity, EquipmentSlotType slot) {
        if (GearHelper.isUnbreakable(stack) || entity instanceof PlayerEntity && ((PlayerEntity)entity).field_71075_bZ.field_75098_d) {
            return;
        }
        ServerPlayerEntity player = entity instanceof ServerPlayerEntity ? (ServerPlayerEntity)entity : null;
        int preTraitAmount = amount;
        amount = (int)TraitHelper.activateTraits(stack, preTraitAmount, (trait, level, val) -> trait.onDurabilityDamage(new TraitActionContext((PlayerEntity)player, level, stack), (int)val));
        int maxDamage = stack.func_77958_k();
        int preDamageFactor = GearHelper.getDamageFactor(stack, maxDamage);
        if (!GearHelper.canBreakPermanently(stack)) {
            amount = Math.min(maxDamage - stack.func_77952_i(), amount);
        }
        stack.func_96631_a(amount, SilentGear.RANDOM, player);
        if (GearHelper.getDamageFactor(stack, maxDamage) != preDamageFactor) {
            GearData.recalculateStats(stack, (PlayerEntity)player);
            if (player != null) {
                GearHelper.onDamageFactorChange(player, preDamageFactor, GearHelper.getDamageFactor(stack, maxDamage));
            }
        }
        GearHelper.handleBrokenItem(stack, (PlayerEntity)player, slot);
    }

    private static void handleBrokenItem(ItemStack stack, @Nullable PlayerEntity player, EquipmentSlotType slot) {
        if (GearHelper.isBroken(stack)) {
            GearHelper.onBroken(stack, player, slot);
        } else if (GearHelper.canBreakPermanently(stack) && stack.func_77952_i() > stack.func_77958_k()) {
            if (player != null) {
                player.func_213361_c(slot);
            }
            stack.func_190918_g(1);
        }
    }

    public static void onBroken(ItemStack stack, @Nullable PlayerEntity player, EquipmentSlotType slot) {
        GearData.incrementBrokenCount(stack);
        GearData.recalculateStats(stack, player);
        if (player != null) {
            player.func_213361_c(slot);
            GearHelper.notifyPlayerOfBrokenGear(stack, player);
        }
    }

    public static ActionResultType useAndCheckBroken(ItemUseContext context, Function<ItemUseContext, ActionResultType> useFunction) {
        ActionResultType result = useFunction.apply(context);
        if (context.func_195999_j() instanceof ServerPlayerEntity) {
            GearHelper.handleBrokenItem(context.func_195996_i(), context.func_195999_j(), context.func_221531_n() == Hand.OFF_HAND ? EquipmentSlotType.OFFHAND : EquipmentSlotType.MAINHAND);
        }
        return result;
    }

    private static void onDamageFactorChange(ServerPlayerEntity player, int preDamageFactor, int newDamageFactor) {
        if (newDamageFactor > preDamageFactor) {
            if (((Boolean)Config.Client.playKachinkSound.get()).booleanValue()) {
                player.field_70170_p.func_184133_a(null, player.func_233580_cy_(), SoundEvents.field_187635_cQ, SoundCategory.PLAYERS, 0.5f, 2.0f);
            }
            LibTriggers.GENERIC_INT.trigger(player, DAMAGE_FACTOR_CHANGE, 1);
        }
    }

    private static void notifyPlayerOfBrokenGear(ItemStack stack, PlayerEntity player) {
        if (((Boolean)Config.Common.sendGearBrokenMessage.get()).booleanValue()) {
            player.func_145747_a((ITextComponent)new TranslationTextComponent("misc.silentgear.notifyOnBreak", new Object[]{stack.func_200301_q()}), Util.field_240973_b_);
        }
    }

    private static int getDamageFactor(ItemStack stack, int maxDamage) {
        if (maxDamage == 0) {
            return 1;
        }
        int levels = (Integer)Config.Common.damageFactorLevels.get();
        int step = Math.max(1, maxDamage / (levels < 1 ? 10 : levels));
        return stack.func_77952_i() / step;
    }

    public static int calcDamageClamped(ItemStack stack, int damage) {
        if (GearHelper.isUnbreakable(stack)) {
            return 0;
        }
        if (!GearHelper.canBreakPermanently(stack)) {
            damage = damage > stack.func_77952_i() ? Math.min(stack.func_77958_k(), damage) : Math.max(0, damage);
        }
        return damage;
    }

    private static boolean canBreakPermanently(ItemStack stack) {
        return (Boolean)Config.Common.gearBreaksPermanently.get() != false || TraitHelper.hasTrait(stack, Const.Traits.RED_CARD);
    }

    public static boolean isBroken(ItemStack stack) {
        if (stack.func_190926_b() || GearHelper.canBreakPermanently(stack) || GearHelper.isUnbreakable(stack)) {
            return false;
        }
        int maxDamage = stack.func_77958_k();
        return maxDamage > 0 && stack.func_77952_i() >= maxDamage - 1;
    }

    public static boolean isUnbreakable(ItemStack stack) {
        return TraitHelper.getTraitLevel(stack, Const.Traits.INDESTRUCTIBLE) > 0;
    }

    public static void setDamage(ItemStack stack, int damage, BiConsumer<ItemStack, Integer> superFunction) {
        int newDamage = GearHelper.calcDamageClamped(stack, damage);
        int diff = newDamage - stack.func_77952_i();
        if (diff > 0 && !GearHelper.isBroken(stack)) {
            GearHelper.damageParts(stack, diff);
        }
        superFunction.accept(stack, newDamage);
        if (GearHelper.isBroken(stack)) {
            GearData.recalculateStats(stack, null);
        }
    }

    public static <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        int preTraitValue;
        if (GearHelper.isUnbreakable(stack)) {
            preTraitValue = 0;
        } else if (!((Boolean)Config.Common.gearBreaksPermanently.get()).booleanValue()) {
            preTraitValue = MathHelper.func_76125_a((int)amount, (int)0, (int)(stack.func_77958_k() - stack.func_77952_i() - 1));
            if (!GearHelper.isBroken(stack) && stack.func_77952_i() + preTraitValue >= stack.func_77958_k() - 1) {
                onBroken.accept(entity);
            }
        } else {
            preTraitValue = amount;
        }
        int value = (int)TraitHelper.activateTraits(stack, preTraitValue, (trait, level, val) -> trait.onDurabilityDamage(new TraitActionContext(null, level, stack), (int)val));
        GearHelper.damageParts(stack, value);
        return value;
    }

    private static void damageParts(ItemStack stack, int amount) {
        GearData.getConstructionParts(stack).forEach(p -> p.get().onGearDamaged((PartData)p, stack, amount));
    }

    public static Item.Properties getBuilder(@Nullable ToolType toolType) {
        Item.Properties b = new Item.Properties().func_200917_a(1).func_200916_a(SilentGear.ITEM_GROUP);
        if (toolType != null) {
            b.addToolType(toolType, 3);
        }
        return b;
    }

    public static GearType getType(ItemStack gear) {
        return GearHelper.getType(gear, GearType.NONE);
    }

    public static GearType getType(ItemStack gear, GearType defaultType) {
        if (gear.func_190926_b() || !(gear.func_77973_b() instanceof ICoreItem)) {
            return defaultType;
        }
        return ((ICoreItem)gear.func_77973_b()).getGearType();
    }

    public static boolean isEquivalent(ItemStack gear1, ItemStack gear2) {
        if (!GearHelper.isGear(gear1) || !GearHelper.isGear(gear2) || gear1.func_77973_b() != gear2.func_77973_b()) {
            return false;
        }
        PartDataList parts1 = GearData.getConstructionParts(gear1);
        PartDataList parts2 = GearData.getConstructionParts(gear2);
        if (parts1.size() != parts2.size()) {
            return false;
        }
        if (parts1.isEmpty()) {
            return true;
        }
        block0: for (PartData part1 : parts1) {
            for (PartData part2 : parts2) {
                if (!part1.equals(part2)) continue;
                parts2.remove(part2);
                continue block0;
            }
        }
        return parts2.isEmpty();
    }

    public static int getHarvestLevel(ItemStack stack, ToolType toolClass, @Nullable BlockState state, @Nullable Set<Material> effectiveMaterials) {
        if (GearHelper.isBroken(stack) || !stack.func_77973_b().getToolTypes(stack).contains(toolClass)) {
            return -1;
        }
        return GearData.getStatInt(stack, ItemStats.HARVEST_LEVEL);
    }

    public static float getDestroySpeed(ItemStack stack, BlockState state, @Nullable Set<Material> extraMaterials) {
        if (GearHelper.isBroken(stack)) {
            return 0.25f;
        }
        float speed = GearData.getStat(stack, ItemStats.HARVEST_SPEED);
        if (stack.func_77973_b().canHarvestBlock(stack, state)) {
            return speed;
        }
        for (ToolType type : stack.func_77973_b().getToolTypes(stack)) {
            if (!state.func_177230_c().isToolEffective(state, type)) continue;
            return speed;
        }
        if (extraMaterials != null && extraMaterials.contains(state.func_185904_a())) {
            return speed;
        }
        return 1.0f;
    }

    public static boolean onBlockDestroyed(ItemStack stack, World world, BlockState state, BlockPos pos, LivingEntity entityLiving) {
        if (!GearHelper.isBroken(stack) && stack.func_77973_b() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.func_77973_b()).getDamageOnBlockBreak(stack, world, state, pos);
            GearHelper.attemptDamage(stack, damage, entityLiving, EquipmentSlotType.MAINHAND);
        }
        return true;
    }

    public static boolean hitEntity(ItemStack stack, LivingEntity target, LivingEntity attacker) {
        boolean isBroken = GearHelper.isBroken(stack);
        if (!isBroken && stack.func_77973_b() instanceof ICoreTool) {
            int damage = ((ICoreTool)stack.func_77973_b()).getDamageOnHitEntity(stack, target, attacker);
            GearHelper.attemptDamage(stack, damage, attacker, EquipmentSlotType.MAINHAND);
        }
        return !isBroken;
    }

    public static void inventoryTick(ItemStack stack, World world, Entity entity, int itemSlot, boolean isSelected) {
        if (!world.field_72995_K) {
            PlayerEntity player = entity instanceof PlayerEntity ? (PlayerEntity)entity : null;
            TraitHelper.tickTraits(world, player, stack, isSelected);
        }
    }

    public static ActionResultType onItemUse(ItemUseContext context) {
        ActionResultType ret = ActionResultType.PASS;
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(context.func_195996_i());
        for (Map.Entry<ITrait, Integer> entry : traits.entrySet()) {
            ActionResultType result = entry.getKey().onItemUse(context, entry.getValue());
            if (result == ActionResultType.PASS) continue;
            ret = result;
        }
        return ret;
    }

    public static void onItemSwing(ItemStack stack, LivingEntity wielder) {
        if (wielder instanceof PlayerEntity && GearHelper.getType(stack).matches(GearType.MELEE_WEAPON) && GearHelper.tryAttackWithExtraReach((PlayerEntity)wielder, false) != null) {
            return;
        }
        Map<ITrait, Integer> traits = TraitHelper.getCachedTraits(stack);
        for (Map.Entry<ITrait, Integer> entry : traits.entrySet()) {
            entry.getKey().onItemSwing(stack, wielder, entry.getValue());
        }
    }

    @Nullable
    public static Entity getAttackTargetWithExtraReach(PlayerEntity player) {
        if (GearHelper.getType(player.func_184614_ca()).matches(GearType.MELEE_WEAPON)) {
            return GearHelper.tryAttackWithExtraReach(player, true);
        }
        return null;
    }

    @Nullable
    public static Entity tryAttackWithExtraReach(PlayerEntity player) {
        return GearHelper.tryAttackWithExtraReach(player, false);
    }

    @Nullable
    private static Entity tryAttackWithExtraReach(PlayerEntity player, boolean simulate) {
        AxisAlignedBB axisalignedbb;
        double range = GearHelper.getAttackRange((LivingEntity)player);
        Vector3d vector3d = player.func_174824_e(0.0f);
        double rangeSquared = range * range;
        Vector3d vector3d1 = player.func_70676_i(1.0f);
        Vector3d vector3d2 = vector3d.func_72441_c(vector3d1.field_72450_a * range, vector3d1.field_72448_b * range, vector3d1.field_72449_c * range);
        EntityRayTraceResult rayTrace = GearHelper.rayTraceEntities((Entity)player, vector3d, vector3d2, axisalignedbb = player.func_174813_aQ().func_216361_a(vector3d1.func_186678_a(range)).func_72314_b(1.0, 1.0, 1.0), entity -> !entity.func_175149_v() && entity.func_70067_L(), rangeSquared);
        if (rayTrace != null) {
            Entity entity2 = rayTrace.func_216348_a();
            if (!simulate) {
                player.func_71059_n(entity2);
            }
            return entity2;
        }
        return null;
    }

    private static double getAttackRange(LivingEntity entity) {
        ItemStack stack = entity.func_184614_ca();
        double base = GearHelper.getType(stack).matches(GearType.TOOL) ? (double)GearData.getStat(stack, ItemStats.ATTACK_REACH) : (double)ItemStats.ATTACK_REACH.getBaseValue();
        ModifiableAttributeInstance attribute = entity.func_110148_a((Attribute)ForgeMod.REACH_DISTANCE.get());
        if (attribute != null) {
            double reachBonus = attribute.func_111126_e() - attribute.func_111125_b();
            return base + reachBonus;
        }
        return base;
    }

    @Nullable
    private static EntityRayTraceResult rayTraceEntities(Entity shooter, Vector3d startVec, Vector3d endVec, AxisAlignedBB boundingBox, Predicate<Entity> filter, double distance) {
        World world = shooter.field_70170_p;
        double d0 = distance;
        Entity entity = null;
        Vector3d vector3d = null;
        for (Entity entity1 : world.func_175674_a(shooter, boundingBox, filter)) {
            Vector3d vector3d1;
            double d1;
            AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)entity1.func_70111_Y());
            Optional optional = axisalignedbb.func_216365_b(startVec, endVec);
            if (axisalignedbb.func_72318_a(startVec)) {
                if (!(d0 >= 0.0)) continue;
                entity = entity1;
                vector3d = optional.orElse(startVec);
                d0 = 0.0;
                continue;
            }
            if (!optional.isPresent() || !((d1 = startVec.func_72436_e(vector3d1 = (Vector3d)optional.get())) < d0) && d0 != 0.0) continue;
            if (entity1.func_184208_bv() == shooter.func_184208_bv() && !entity1.canRiderInteract()) {
                if (d0 != 0.0) continue;
                entity = entity1;
                vector3d = vector3d1;
                continue;
            }
            entity = entity1;
            vector3d = vector3d1;
            d0 = d1;
        }
        return entity == null ? null : new EntityRayTraceResult(entity, vector3d);
    }

    public static Rarity getRarity(ItemStack stack) {
        int rarity = GearData.getStatInt(stack, ItemStats.RARITY);
        if (stack.func_77948_v()) {
            rarity += 20;
        }
        if (rarity < 40) {
            return Rarity.COMMON;
        }
        if (rarity < 80) {
            return Rarity.UNCOMMON;
        }
        if (rarity < 120) {
            return Rarity.RARE;
        }
        return Rarity.EPIC;
    }

    public static void fillItemGroup(ICoreItem item, ItemGroup group, Collection<ItemStack> items) {
        boolean inTab = false;
        for (ItemGroup tabInList : item.func_199767_j().getCreativeTabs()) {
            if (tabInList != group) continue;
            inTab = true;
            break;
        }
        if (!inTab) {
            return;
        }
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 3; i <= Math.max(4, PartManager.getHighestMainPartTier()); ++i) {
            ItemStack stack = GearHelper.createSampleItem(item, i);
            if (stack.func_190926_b()) continue;
            list.add(stack);
        }
        items.addAll(list);
    }

    private static ItemStack createSampleItem(ICoreItem item, int tier) {
        ItemStack result = GearGenerator.create(item, tier);
        if (result.func_190926_b()) {
            ArrayList parts = new ArrayList();
            for (PartType partType : item.getRequiredParts()) {
                partType.makeCompoundPart(item.getGearType(), Const.Materials.EXAMPLE).ifPresent(parts::add);
            }
            result = item.construct(parts);
        }
        GearData.setExampleTag(result, true);
        return result;
    }

    public static ITextComponent getDisplayName(ItemStack gear) {
        TranslationTextComponent gearName;
        PartData part = GearData.getPrimaryPart(gear);
        if (part == null) {
            return new TranslationTextComponent(gear.func_77977_a());
        }
        ITextComponent partName = part.getMaterialName(gear);
        TranslationTextComponent result = gearName = new TranslationTextComponent(gear.func_77977_a() + ".nameProper", new Object[]{partName});
        if (gear.func_77973_b() instanceof ICoreTool) {
            ICoreItem item = (ICoreItem)gear.func_77973_b();
            if (item.requiresPartOfType(PartType.ROD) && GearData.getPartOfType(gear, PartType.ROD) == null) {
                result = new TranslationTextComponent(gear.func_77977_a() + ".noRod", new Object[]{gearName});
            } else if (item.requiresPartOfType(PartType.BOWSTRING) && GearData.getPartOfType(gear, PartType.BOWSTRING) == null) {
                result = new TranslationTextComponent(gear.func_77977_a() + ".unstrung", new Object[]{gearName});
            }
        }
        for (ITextComponent t : GearHelper.getNamePrefixes(gear, GearData.getConstructionParts(gear))) {
            result = t.func_230532_e_().func_230529_a_((ITextComponent)new StringTextComponent(" ")).func_230529_a_((ITextComponent)result);
        }
        return result;
    }

    private static Collection<ITextComponent> getNamePrefixes(ItemStack gear, PartDataList parts) {
        GearNamePrefixesEvent event = new GearNamePrefixesEvent(gear, parts);
        MinecraftForge.EVENT_BUS.post((Event)event);
        return event.getPrefixes();
    }

    public static Collection<IPartData> getExamplePartsFromRecipe(GearType gearType, Iterable<Ingredient> ingredients) {
        LinkedHashMap map = new LinkedHashMap();
        PartType.MAIN.makeCompoundPart(gearType, Const.Materials.EXAMPLE).ifPresent(p -> map.put(PartType.MAIN, p));
        for (Ingredient ingredient : ingredients) {
            if (!(ingredient instanceof IPartIngredient)) continue;
            PartType type = ((IPartIngredient)ingredient).getPartType();
            type.makeCompoundPart(gearType, Const.Materials.EXAMPLE).ifPresent(p -> map.put(type, p));
        }
        return map.values();
    }
}

