/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.network.IPacket;
import net.minecraft.network.play.server.SChangeBlockPacket;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.GameType;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.DrawHighlightEvent;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.silentchaos512.gear.config.Config;

public interface IAOETool {
    @Nonnull
    public ToolType getAOEToolClass();

    @Nullable
    public RayTraceResult rayTraceBlocks(World var1, PlayerEntity var2);

    default public List<BlockPos> getExtraBlocks(World world, @Nullable BlockRayTraceResult rt, PlayerEntity player, ItemStack stack) {
        BlockState state;
        ArrayList<BlockPos> positions = new ArrayList<BlockPos>();
        if (player.func_213453_ef() || rt == null || rt.func_216350_a() == null || rt.func_216354_b() == null) {
            return positions;
        }
        BlockPos pos = rt.func_216350_a();
        if (this.isEffectiveOnBlock(stack, world, pos, state = world.func_180495_p(pos), player)) {
            switch (rt.func_216354_b().func_176740_k()) {
                case Y: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST).func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST).func_177972_a(Direction.NORTH), stack, positions);
                    break;
                }
                case X: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.NORTH).func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP).func_177972_a(Direction.SOUTH), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.SOUTH).func_177972_a(Direction.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN).func_177972_a(Direction.NORTH), stack, positions);
                    break;
                }
                case Z: {
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.DOWN).func_177972_a(Direction.EAST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.EAST).func_177972_a(Direction.UP), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.UP).func_177972_a(Direction.WEST), stack, positions);
                    this.attemptAddExtraBlock(world, state, pos.func_177972_a(Direction.WEST).func_177972_a(Direction.DOWN), stack, positions);
                }
            }
        }
        return positions;
    }

    default public boolean isEffectiveOnBlock(ItemStack stack, World world, BlockPos pos, BlockState state, PlayerEntity player) {
        return stack.func_77973_b().canHarvestBlock(stack, state) || ForgeHooks.canHarvestBlock((BlockState)state, (PlayerEntity)player, (IBlockReader)world, (BlockPos)pos);
    }

    default public void attemptAddExtraBlock(World world, BlockState state1, BlockPos pos2, ItemStack stack, List<BlockPos> list) {
        BlockState state2 = world.func_180495_p(pos2);
        if (state2.func_185887_b((IBlockReader)world, pos2) < 0.0f) {
            return;
        }
        if (!world.func_175623_d(pos2) && BreakHandler.areBlocksSimilar(state1, state2) && (state2.func_177230_c().isToolEffective(state2, this.getAOEToolClass()) || stack.func_77973_b().canHarvestBlock(stack, state2))) {
            list.add(pos2);
        }
    }

    @Mod.EventBusSubscriber(modid="silentgear", value={Dist.CLIENT})
    public static final class HighlightHandler {
        private HighlightHandler() {
        }

        @SubscribeEvent
        public static void onDrawBlockHighlight(DrawHighlightEvent event) {
            ItemStack stack;
            ActiveRenderInfo info = event.getInfo();
            Entity entity = info.func_216773_g();
            if (!(entity instanceof PlayerEntity)) {
                return;
            }
            PlayerEntity player = (PlayerEntity)entity;
            RayTraceResult rt = event.getTarget();
            if (rt.func_216346_c() == RayTraceResult.Type.BLOCK && (stack = player.func_184614_ca()).func_77973_b() instanceof IAOETool) {
                World world = player.func_130014_f_();
                IAOETool item = (IAOETool)stack.func_77973_b();
                for (BlockPos pos : item.getExtraBlocks(world, (BlockRayTraceResult)rt, player, stack)) {
                    IVertexBuilder vertexBuilder = event.getBuffers().getBuffer(RenderType.func_228659_m_());
                    Vector3d vec = event.getInfo().func_216785_c();
                    BlockState blockState = world.func_180495_p(pos);
                    HighlightHandler.drawSelectionBox(event.getMatrix(), world, vertexBuilder, event.getInfo().func_216773_g(), vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, pos, blockState);
                }
            }
        }

        private static void drawSelectionBox(MatrixStack matrixStackIn, World world, IVertexBuilder bufferIn, Entity entityIn, double xIn, double yIn, double zIn, BlockPos blockPosIn, BlockState blockStateIn) {
            HighlightHandler.drawShape(matrixStackIn, bufferIn, blockStateIn.func_215700_a((IBlockReader)world, blockPosIn, ISelectionContext.func_216374_a((Entity)entityIn)), (double)blockPosIn.func_177958_n() - xIn, (double)blockPosIn.func_177956_o() - yIn, (double)blockPosIn.func_177952_p() - zIn, 0.0f, 0.0f, 0.0f, 0.4f);
        }

        private static void drawShape(MatrixStack matrixStackIn, IVertexBuilder bufferIn, VoxelShape shapeIn, double xIn, double yIn, double zIn, float red, float green, float blue, float alpha) {
            Matrix4f matrix4f = matrixStackIn.func_227866_c_().func_227870_a_();
            shapeIn.func_197754_a((p_230013_12_, p_230013_14_, p_230013_16_, p_230013_18_, p_230013_20_, p_230013_22_) -> {
                bufferIn.func_227888_a_(matrix4f, (float)(p_230013_12_ + xIn), (float)(p_230013_14_ + yIn), (float)(p_230013_16_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
                bufferIn.func_227888_a_(matrix4f, (float)(p_230013_18_ + xIn), (float)(p_230013_20_ + yIn), (float)(p_230013_22_ + zIn)).func_227885_a_(red, green, blue, alpha).func_181675_d();
            });
        }
    }

    public static final class BreakHandler {
        private BreakHandler() {
        }

        public static boolean onBlockStartBreak(ItemStack tool, BlockPos pos, PlayerEntity player) {
            World world = player.func_130014_f_();
            if (world.field_72995_K || !(world instanceof ServerWorld) || !(player instanceof ServerPlayerEntity) || !(tool.func_77973_b() instanceof IAOETool)) {
                return false;
            }
            IAOETool item = (IAOETool)tool.func_77973_b();
            RayTraceResult rt = item.rayTraceBlocks(world, player);
            BlockState stateOriginal = world.func_180495_p(pos);
            if (rt != null && rt.func_216346_c() == RayTraceResult.Type.BLOCK && item.isEffectiveOnBlock(tool, world, pos, stateOriginal, player)) {
                BlockRayTraceResult brt = (BlockRayTraceResult)rt;
                Direction side = brt.func_216354_b();
                List<BlockPos> extraBlocks = item.getExtraBlocks(world, brt, player, tool);
                for (BlockPos pos2 : extraBlocks) {
                    BlockState state = world.func_180495_p(pos2);
                    if (!world.func_175667_e(pos2) || !player.func_175151_a(pos2, side, tool) || !state.canHarvestBlock((IBlockReader)world, pos2, player)) continue;
                    if (player.field_71075_bZ.field_75098_d) {
                        if (state.removedByPlayer(world, pos2, player, true, state.func_204520_s())) {
                            state.func_177230_c().func_176206_d((IWorld)world, pos2, state);
                        }
                    } else {
                        int xp = ForgeHooks.onBlockBreakEvent((World)world, (GameType)((ServerPlayerEntity)player).field_71134_c.func_73081_b(), (ServerPlayerEntity)((ServerPlayerEntity)player), (BlockPos)pos2);
                        if (xp == -1) continue;
                        tool.func_77973_b().func_179218_a(tool, world, state, pos2, (LivingEntity)player);
                        TileEntity tileEntity = world.func_175625_s(pos2);
                        if (state.removedByPlayer(world, pos2, player, true, state.func_204520_s())) {
                            state.func_177230_c().func_176206_d((IWorld)world, pos2, state);
                            state.func_177230_c().func_180657_a(world, player, pos2, state, tileEntity, tool);
                            state.func_177230_c().func_180637_b((ServerWorld)world, pos2, xp);
                        }
                    }
                    world.func_217379_c(2001, pos, Block.func_196246_j((BlockState)state));
                    ((ServerPlayerEntity)player).field_71135_a.func_147359_a((IPacket)new SChangeBlockPacket((IBlockReader)world, pos));
                }
            }
            return false;
        }

        static boolean areBlocksSimilar(BlockState state1, BlockState state2) {
            int level2;
            MatchMode mode;
            Block block1 = state1.func_177230_c();
            Block block2 = state2.func_177230_c();
            boolean isOre1 = BreakHandler.isOre(state1);
            boolean isOre2 = BreakHandler.isOre(state2);
            MatchMode matchMode = mode = isOre1 && isOre2 ? (MatchMode)((Object)Config.Common.matchModeOres.get()) : (MatchMode)((Object)Config.Common.matchModeStandard.get());
            if (mode == MatchMode.LOOSE || block1 == block2) {
                return true;
            }
            if (mode == MatchMode.STRICT || !isOre1 && isOre2) {
                return false;
            }
            int level1 = block1.getHarvestLevel(state1);
            return level1 >= (level2 = block2.getHarvestLevel(state2)) || level2 == 0;
        }

        private static boolean isOre(BlockState state) {
            return state.func_235714_a_((ITag)Tags.Blocks.ORES);
        }
    }

    public static enum MatchMode {
        LOOSE,
        MODERATE,
        STRICT;

    }
}

