/*
 * Decompiled with CFR 0.152.
 */
package net.silentchaos512.gear.util;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.util.Hand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fml.ModList;
import net.silentchaos512.gear.SilentGear;
import net.silentchaos512.gear.api.event.GetTraitsEvent;
import net.silentchaos512.gear.api.item.GearType;
import net.silentchaos512.gear.api.part.PartDataList;
import net.silentchaos512.gear.api.part.PartType;
import net.silentchaos512.gear.api.traits.ITrait;
import net.silentchaos512.gear.api.traits.TraitActionContext;
import net.silentchaos512.gear.api.traits.TraitFunction;
import net.silentchaos512.gear.api.traits.TraitInstance;
import net.silentchaos512.gear.api.util.PartGearKey;
import net.silentchaos512.gear.compat.curios.CuriosCompat;
import net.silentchaos512.gear.gear.material.MaterialInstance;
import net.silentchaos512.gear.gear.part.PartData;
import net.silentchaos512.gear.gear.trait.TraitManager;
import net.silentchaos512.gear.util.Const;
import net.silentchaos512.gear.util.DataResource;
import net.silentchaos512.gear.util.GearData;
import net.silentchaos512.gear.util.GearHelper;
import net.silentchaos512.utils.MathUtils;

public final class TraitHelper {
    private TraitHelper() {
        throw new IllegalAccessError("Utility class");
    }

    public static float activateTraits(ItemStack gear, float inputValue, TraitFunction action) {
        if (!GearHelper.isGear(gear)) {
            SilentGear.LOGGER.error("Called activateTraits on non-gear item, {}", (Object)gear);
            SilentGear.LOGGER.catching((Throwable)new IllegalArgumentException());
            return inputValue;
        }
        ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        float value = inputValue;
        for (INBT nbt : tagList) {
            CompoundNBT tagCompound;
            String regName;
            ITrait trait;
            if (!(nbt instanceof CompoundNBT) || (trait = TraitManager.get(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name"))) == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            value = action.apply(trait, level, value);
        }
        return value;
    }

    public static int getTraitLevel(ItemStack gear, DataResource<ITrait> trait) {
        return TraitHelper.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ITrait trait) {
        return TraitHelper.getTraitLevel(gear, trait.getId());
    }

    public static int getTraitLevel(ItemStack gear, ResourceLocation traitId) {
        if (GearHelper.isGear(gear)) {
            ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
            for (INBT nbt : tagList) {
                CompoundNBT tagCompound;
                String regName;
                if (!(nbt instanceof CompoundNBT) || !(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name")).equals(traitId.toString())) continue;
                return tagCompound.func_74771_c("Level");
            }
        }
        return 0;
    }

    public static boolean hasTrait(ItemStack gear, DataResource<ITrait> trait) {
        return TraitHelper.hasTrait(gear, trait.getId());
    }

    public static boolean hasTrait(ItemStack gear, ITrait trait) {
        return TraitHelper.hasTrait(gear, trait.getId());
    }

    public static boolean hasTrait(ItemStack gear, ResourceLocation traitId) {
        if (GearHelper.isGear(gear)) {
            ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
            for (INBT nbt : tagList) {
                CompoundNBT tagCompound;
                String regName;
                if (!(nbt instanceof CompoundNBT) || !(regName = (tagCompound = (CompoundNBT)nbt).func_74779_i("Name")).equals(traitId.toString())) continue;
                return true;
            }
            return false;
        }
        return false;
    }

    public static int getHighestLevelEitherHand(PlayerEntity player, DataResource<ITrait> trait) {
        return TraitHelper.getHighestLevelEitherHand(player, trait.getId());
    }

    @Deprecated
    public static int getHighestLevelEitherHand(PlayerEntity player, ResourceLocation traitId) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return Math.max(TraitHelper.getTraitLevel(main, traitId), TraitHelper.getTraitLevel(off, traitId));
    }

    public static int getHighestLevelArmor(PlayerEntity player, DataResource<ITrait> trait) {
        int max = 0;
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            max = Math.max(max, TraitHelper.getTraitLevel(stack, trait));
        }
        return max;
    }

    public static int getHighestLevelCurio(LivingEntity entity, DataResource<ITrait> trait) {
        if (ModList.get().isLoaded("curios")) {
            return CuriosCompat.getHighestTraitLevel(entity, trait);
        }
        return 0;
    }

    public static boolean hasTraitEitherHand(PlayerEntity player, DataResource<ITrait> trait) {
        return TraitHelper.hasTraitEitherHand(player, trait.getId());
    }

    @Deprecated
    public static boolean hasTraitEitherHand(PlayerEntity player, ResourceLocation traitId) {
        ItemStack main = player.func_184614_ca();
        ItemStack off = player.func_184592_cb();
        return TraitHelper.hasTrait(main, traitId) || TraitHelper.hasTrait(off, traitId);
    }

    public static boolean hasTraitArmor(PlayerEntity player, DataResource<ITrait> trait) {
        for (ItemStack stack : player.field_71071_by.field_70460_b) {
            if (!TraitHelper.hasTrait(stack, trait)) continue;
            return true;
        }
        return false;
    }

    public static Map<ITrait, Integer> getCachedTraits(ItemStack gear) {
        if (!GearHelper.isGear(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (INBT nbt : tagList) {
            if (!(nbt instanceof CompoundNBT)) continue;
            CompoundNBT tagCompound = (CompoundNBT)nbt;
            String name = tagCompound.func_74779_i("Name");
            ITrait trait = TraitManager.get(name);
            byte level = tagCompound.func_74771_c("Level");
            if (trait == null || level <= 0) continue;
            result.put(trait, Integer.valueOf(level));
        }
        return result;
    }

    @Deprecated
    public static Map<ITrait, Integer> getTraits(ItemStack gear, PartDataList parts) {
        return TraitHelper.getTraits(gear, GearHelper.getType(gear), parts);
    }

    public static Map<ITrait, Integer> getTraits(ItemStack gear, GearType gearType, PartDataList parts) {
        if (parts.isEmpty() || !gear.func_190926_b() && GearHelper.isBroken(gear)) {
            return ImmutableMap.of();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        for (PartData part : parts) {
            for (TraitInstance inst : part.getTraits(gear)) {
                if (!inst.conditionsMatch(PartGearKey.of(gearType, PartType.NONE), gear, parts)) continue;
                ITrait trait = inst.getTrait();
                result.merge(trait, inst.getLevel(), Integer::max);
            }
        }
        ITrait[] keys = result.keySet().toArray(new ITrait[0]);
        TraitHelper.cancelTraits(result, keys);
        MinecraftForge.EVENT_BUS.post((Event)new GetTraitsEvent(gear, parts, result));
        return result;
    }

    @Deprecated
    public static Map<ITrait, Integer> getTraits(List<MaterialInstance> materials, PartType partType, ItemStack gear) {
        return TraitHelper.getTraits(materials, GearHelper.getType(gear), partType, gear);
    }

    public static Map<ITrait, Integer> getTraits(List<MaterialInstance> materials, GearType gearType, PartType partType, ItemStack gear) {
        ITrait[] keys;
        if (materials.isEmpty()) {
            return Collections.emptyMap();
        }
        LinkedHashMap<ITrait, Integer> result = new LinkedHashMap<ITrait, Integer>();
        HashMap<ITrait, Integer> countMatsWithTrait = new HashMap<ITrait, Integer>();
        for (MaterialInstance material : materials) {
            for (TraitInstance inst : material.getTraits(partType, gearType, gear)) {
                if (!inst.conditionsMatch(PartGearKey.of(gearType, partType), gear, materials)) continue;
                result.merge(inst.getTrait(), inst.getLevel(), Integer::sum);
                countMatsWithTrait.merge(inst.getTrait(), 1, Integer::sum);
            }
        }
        for (ITrait trait : keys = result.keySet().toArray(new ITrait[0])) {
            int matsWithTrait = (Integer)countMatsWithTrait.get(trait);
            float divisor = Math.max((float)materials.size() / 2.0f, (float)matsWithTrait);
            int value = Math.round((float)((Integer)result.get(trait)).intValue() / divisor);
            result.put(trait, MathHelper.func_76125_a((int)value, (int)1, (int)trait.getMaxLevel()));
        }
        TraitHelper.cancelTraits(result, keys);
        return result;
    }

    private static void cancelTraits(Map<ITrait, Integer> mapToModify, ITrait[] keys) {
        block0: for (int i = 0; i < keys.length; ++i) {
            ITrait t1 = keys[i];
            if (!mapToModify.containsKey(t1)) continue;
            for (int j = i + 1; j < keys.length; ++j) {
                int otherLevel;
                ITrait t2 = keys[j];
                if (!mapToModify.containsKey(t2) || !t1.willCancelWith(t2)) continue;
                int level = mapToModify.get(t1);
                int cancelLevel = t1.getCanceledLevel(level, t2, otherLevel = mapToModify.get(t2).intValue());
                if (cancelLevel > 0) {
                    mapToModify.put(t1, cancelLevel);
                    mapToModify.remove(t2);
                    continue;
                }
                if (cancelLevel < 0) {
                    mapToModify.put(t2, -cancelLevel);
                    mapToModify.remove(t1);
                    continue block0;
                }
                mapToModify.remove(t1);
                mapToModify.remove(t2);
                continue block0;
            }
        }
    }

    static void tickTraits(World world, @Nullable PlayerEntity player, ItemStack gear, boolean isEquipped) {
        ListNBT tagList = GearData.getPropertiesData(gear).func_150295_c("Traits", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundNBT tagCompound = tagList.func_150305_b(i);
            String regName = tagCompound.func_74779_i("Name");
            ITrait trait = TraitManager.get(regName);
            if (trait == null) continue;
            byte level = tagCompound.func_74771_c("Level");
            TraitActionContext context = new TraitActionContext(player, level, gear);
            trait.onUpdate(context, isEquipped);
            TraitHelper.extraTickFunctions(trait, context);
        }
    }

    private static void extraTickFunctions(ITrait trait, TraitActionContext context) {
        float chance;
        PlayerEntity player = context.getPlayer();
        if (trait.getId().equals((Object)Const.Traits.STELLAR.getId()) && player != null && player.field_70173_aa % 20 == 0 && MathUtils.tryPercentage((double)(chance = 0.02f * (float)context.getTraitLevel()))) {
            GearHelper.attemptDamage(context.getGear(), -1, (LivingEntity)player, Hand.MAIN_HAND);
        }
    }
}

