/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.item;

import com.lothrazar.simpletomb.ConfigTomb;
import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.NBTHelper;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;

public class ItemGraveKey
extends Item {
    private static final String TOMB_POS = "tombPos";
    protected static final String name = "grave_key";

    public ItemGraveKey() {
        this.func_77625_d(1);
        this.setRegistryName(name);
        this.func_77655_b(name);
    }

    public String func_77653_i(ItemStack stack) {
        return TextFormatting.GOLD + super.func_77653_i(stack);
    }

    public void onUsingTick(ItemStack stack, EntityLivingBase entity, int timeLeft) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            LocationBlockPos location = this.getTombPos(stack);
            if (location == null || location.isOrigin() || location.dim != player.field_71093_bK) {
                return;
            }
            double distance = location.getDistance(player.func_180425_c());
            boolean canTp = false;
            if (player.func_184812_l_()) {
                canTp = ConfigTomb.INSTANCE.tpToGraveCreative;
            } else {
                boolean bl = canTp = ConfigTomb.INSTANCE.distanceUntilTpSurvival > 0 && distance < (double)ConfigTomb.INSTANCE.distanceUntilTpSurvival || ConfigTomb.INSTANCE.distanceUntilTpSurvival == -1;
            }
            if (canTp) {
                if (timeLeft <= 1) {
                    BlockPos pos = location.toBlockPos();
                    player.func_70634_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p());
                } else if (entity.field_70170_p.field_72995_K) {
                    ModTomb.PROXY.produceParticleCasting(entity, p -> !p.func_184587_cr());
                }
            }
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 86;
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, EnumHand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        playerIn.func_184598_c(handIn);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)itemstack);
    }

    public String func_77658_a() {
        return "simpletomb.item.grave_key";
    }

    public String func_77667_c(ItemStack stack) {
        return this.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World world, List<String> list, ITooltipFlag flag) {
        if (GuiScreen.func_146272_n()) {
            LocationBlockPos location = this.getTombPos(stack);
            EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
            if (player != null && !location.isOrigin()) {
                BlockPos pos = player.func_180425_c();
                int distance = (int)location.getDistance(pos);
                list.add(TextFormatting.DARK_PURPLE + MessageType.MESSAGE_DISTANCE.getClientTranslation(distance, location.x, location.y, location.z, location.dim));
            }
        }
        super.func_77624_a(stack, world, list, flag);
    }

    public void addItemPosition(List<String> list, LocationBlockPos location) {
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null && !location.isOrigin()) {
            BlockPos pos = player.func_180425_c();
            int distance = (int)location.toBlockPos().func_185332_f(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            list.add(TextFormatting.DARK_PURPLE + MessageType.MESSAGE_DISTANCE.getClientTranslation(distance, location.x, location.y, location.z, location.dim));
        }
    }

    public boolean setTombPos(ItemStack stack, LocationBlockPos location) {
        if (stack.func_77973_b() == this && !location.isOrigin()) {
            NBTHelper.setLocation(stack, TOMB_POS, location);
            return true;
        }
        return false;
    }

    public LocationBlockPos getTombPos(ItemStack stack) {
        return stack.func_77973_b() == this ? NBTHelper.getLocation(stack, TOMB_POS) : LocationBlockPos.ORIGIN;
    }

    public boolean removeKeyForGraveInInventory(EntityPlayer player, LocationBlockPos graveLoc) {
        IItemHandler itemHandler = (IItemHandler)player.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
        if (itemHandler != null) {
            for (int i = 0; i < itemHandler.getSlots(); ++i) {
                ItemStack stack = itemHandler.getStackInSlot(i);
                if (stack.func_77973_b() != TombRegistry.grave_key || !TombRegistry.grave_key.getTombPos(stack).equals(graveLoc)) continue;
                itemHandler.extractItem(i, 1, false);
                return true;
            }
        }
        return false;
    }

    public int countKeyInInventory(EntityPlayer player) {
        return (int)player.field_71071_by.field_70462_a.stream().filter(stack -> stack.func_77973_b() == TombRegistry.grave_key).count();
    }
}

