/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.particle;

import com.lothrazar.simpletomb.helper.WorldHelper;
import com.lothrazar.simpletomb.particle.SpriteTypes;
import java.util.function.Predicate;
import net.minecraft.client.particle.Particle;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class ParticleCasting
extends Particle {
    private final EntityLivingBase caster;
    private final Predicate<EntityLivingBase> predic;
    private final double angle;
    private final float colorR;
    private final float colorG;
    private final float colorB;
    private boolean goUp;

    public ParticleCasting(World world, EntityLivingBase caster, Predicate<EntityLivingBase> predic, double addY, double angle) {
        super(world, caster.field_70165_t, caster.field_70163_u + addY, caster.field_70161_v);
        SpriteTypes.CASTING.setTexture(this);
        this.goUp = addY < 1.0;
        this.caster = caster;
        this.predic = predic;
        this.field_70544_f = 1.3f;
        this.angle = angle + WorldHelper.getRandom(world.field_73012_v, -0.25, 0.25);
        float[] color = WorldHelper.getRGBColor3F(14937088);
        this.colorR = color[0];
        this.colorG = color[1];
        this.colorB = color[2];
        this.func_70538_b(this.colorR, this.colorG, this.colorB);
        this.field_82339_as = 1.0f;
        this.field_190017_n = false;
        this.updatePosition();
    }

    private void updatePosition() {
        double ratio = (double)this.field_70546_d % 80.0 / 80.0;
        this.field_187131_k = 0.0;
        this.field_187130_j = 0.0;
        this.field_187129_i = 0.0;
        this.field_187123_c = this.field_187126_f = this.caster.field_70165_t + 1.1 * Math.cos(Math.PI * 2 * (ratio + this.angle));
        this.field_187124_d = this.field_187127_g += this.goUp ? 0.02 : -0.02;
        this.field_187125_e = this.field_187128_h = this.caster.field_70161_v + 1.1 * Math.sin(Math.PI * 2 * (ratio + this.angle));
        this.func_70538_b(this.clampColor(this.colorR + WorldHelper.getRandom(this.field_187122_b.field_73012_v, -10.0f, 50.0f) / 255.0f), this.clampColor(this.colorG - WorldHelper.getRandom(this.field_187122_b.field_73012_v, 0.0f, 30.0f) / 255.0f), this.clampColor(this.colorB + WorldHelper.getRandom(this.field_187122_b.field_73012_v, -50.0f, 30.0f) / 255.0f));
    }

    private float clampColor(float color) {
        return MathHelper.func_76131_a((float)color, (float)0.0f, (float)1.0f);
    }

    public void func_189213_a() {
        if (this.field_187127_g > this.caster.field_70163_u + 2.0 || this.field_187127_g < this.caster.field_70163_u) {
            boolean bl = this.goUp = !this.goUp;
        }
        if (this.predic.test(this.caster)) {
            this.func_187112_i();
        }
        this.updatePosition();
        ++this.field_70546_d;
    }

    public boolean func_187111_c() {
        return true;
    }

    public int func_70537_b() {
        return 1;
    }

    public int func_189214_a(float partialTick) {
        return 0xF000F0;
    }
}

