/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.ModelTomb;
import com.lothrazar.simpletomb.block.TileEntityTomb;
import com.lothrazar.simpletomb.data.LocationBlockPos;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.EnumProperty;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.Explosion;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;

public class BlockTomb
extends Block {
    public static final EnumProperty<Direction> FACING = EnumProperty.func_177709_a((String)"facing", Direction.class);
    public static final IntegerProperty MODEL_TEXTURE = IntegerProperty.func_177719_a((String)"model_texture", (int)0, (int)1);
    public static final BooleanProperty IS_ENGRAVED = BooleanProperty.func_177716_a((String)"is_engraved");
    private static final VoxelShape GROUND = Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)0.0625, (double)1.0);
    protected final String name;
    protected final ModelTomb graveModel;

    public BlockTomb(Block.Properties properties, ModelTomb graveModel) {
        super(properties.func_226896_b_().func_200948_a(-1.0f, 3600000.0f).func_222380_e());
        this.graveModel = graveModel;
        this.name = graveModel.func_176610_l();
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return GROUND;
    }

    public ModelTomb getGraveType() {
        return this.graveModel;
    }

    public boolean func_149659_a(Explosion explosionIn) {
        return false;
    }

    public String func_149739_a() {
        return "simpletomb.grave." + this.name;
    }

    @Nullable
    public TileEntityTomb getTileEntity(World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        return tile instanceof TileEntityTomb ? (TileEntityTomb)tile : null;
    }

    public TileEntity createTileEntity(BlockState state, IBlockReader world) {
        return new TileEntityTomb();
    }

    public boolean hasTileEntity(BlockState state) {
        return true;
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{FACING}).func_206894_a(new IProperty[]{IS_ENGRAVED}).func_206894_a(new IProperty[]{MODEL_TEXTURE});
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!world.field_72995_K && entity.func_225608_bj_() && entity.func_70089_S() && EntityHelper.isValidPlayer(entity)) {
            this.activatePlayerGrave(world, pos, state, (PlayerEntity)((ServerPlayerEntity)entity));
        }
    }

    private void activatePlayerGrave(World world, BlockPos pos, BlockState state, PlayerEntity player) {
        TileEntityTomb tile = this.getTileEntity(world, pos);
        if (tile != null && player.func_70089_S()) {
            if (tile.onlyOwnersCanAccess() && !tile.isOwner(player)) {
                MessageType.MESSAGE_OPEN_GRAVE_NEED_OWNER.sendSpecialMessage(player, new Object[0]);
            } else {
                tile.giveInventory(player);
                TombRegistry.grave_key.removeKeyForGraveInInventory(player, new LocationBlockPos(pos, world));
            }
        }
    }
}

