/*
 * Decompiled with CFR 0.152.
 */
package com.lothrazar.simpletomb.block;

import com.lothrazar.simpletomb.ModTomb;
import com.lothrazar.simpletomb.TombRegistry;
import com.lothrazar.simpletomb.block.BlockTomb;
import com.lothrazar.simpletomb.data.MessageType;
import com.lothrazar.simpletomb.helper.EntityHelper;
import com.lothrazar.simpletomb.helper.WorldHelper;
import java.util.UUID;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.ItemStackHandler;

public class TileEntityTomb
extends TileEntity
implements ITickableTileEntity {
    private LazyOptional<IItemHandler> handler = LazyOptional.of(this::createHandler);
    protected String ownerName = "";
    protected long deathDate;
    public int timer = 0;
    protected UUID ownerId = null;
    private boolean onlyOwnersAccess = true;

    public TileEntityTomb() {
        super(TombRegistry.tombstoneTileEntity);
    }

    private IItemHandler createHandler() {
        return new ItemStackHandler(120);
    }

    public void giveInventory(@Nullable PlayerEntity player) {
        IItemHandler inventory = (IItemHandler)this.handler.orElse(null);
        if (!this.field_145850_b.field_72995_K && player != null && !(player instanceof FakePlayer)) {
            for (int i = inventory.getSlots() - 1; i >= 0; --i) {
                if (!EntityHelper.autoequip(inventory.getStackInSlot(i), player)) continue;
                inventory.extractItem(i, 64, false);
            }
            IntStream.range(0, inventory.getSlots()).forEach(ix -> {
                ItemStack stack = inventory.getStackInSlot(ix);
                if (!stack.func_190926_b()) {
                    ItemHandlerHelper.giveItemToPlayer((PlayerEntity)player, (ItemStack)stack.func_77946_l());
                    inventory.extractItem(ix, 64, false);
                }
            });
            this.removeGraveBy(player);
            if (player.field_71069_bz != null) {
                player.field_71069_bz.func_75142_b();
            }
            MessageType.MESSAGE_OPEN_GRAVE_SUCCESS.sendSpecialMessage(player, new Object[0]);
        }
    }

    public boolean onlyOwnersCanAccess() {
        return this.onlyOwnersAccess;
    }

    private void removeGraveBy(@Nullable PlayerEntity player) {
        if (this.field_145850_b != null) {
            WorldHelper.removeNoEvent(this.field_145850_b, this.field_174879_c);
            if (player != null) {
                this.field_145850_b.func_184133_a(player, player.func_180425_c(), SoundEvents.field_187873_gM, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
        }
    }

    public void initTombstoneOwner(PlayerEntity owner) {
        this.deathDate = System.currentTimeMillis();
        this.ownerName = owner.func_145748_c_().getString();
        this.ownerId = owner.func_110124_au();
    }

    public boolean isOwner(PlayerEntity owner) {
        if (this.ownerId == null || owner == null || !this.hasOwner()) {
            return false;
        }
        return this.ownerId.equals(owner.func_110124_au());
    }

    public AxisAlignedBB getRenderBoundingBox() {
        double renderExtension = 1.0;
        return new AxisAlignedBB((double)this.field_174879_c.func_177958_n() - renderExtension, (double)this.field_174879_c.func_177956_o() - renderExtension, (double)this.field_174879_c.func_177952_p() - renderExtension, (double)(this.field_174879_c.func_177958_n() + 1) + renderExtension, (double)(this.field_174879_c.func_177956_o() + 1) + renderExtension, (double)(this.field_174879_c.func_177952_p() + 1) + renderExtension);
    }

    public void func_73660_a() {
        ++this.timer;
        if (this.field_145850_b.field_72995_K && this.timer % 100 == 0) {
            ModTomb.proxy.produceGraveSoul(this.field_145850_b, this.field_174879_c);
            this.timer = 1;
        }
        ModTomb.proxy.produceGraveSmoke(this.field_145850_b, this.field_174879_c.func_177958_n(), this.field_174879_c.func_177956_o(), this.field_174879_c.func_177952_p());
    }

    String getOwnerName() {
        return this.ownerName;
    }

    boolean hasOwner() {
        return this.ownerName.length() > 0;
    }

    long getOwnerDeathTime() {
        return this.deathDate;
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.timer);
        if (this.ownerId != null) {
            compound.func_186854_a("ownerid", this.ownerId);
        }
        this.handler.ifPresent(h -> {
            CompoundNBT ct = (CompoundNBT)((INBTSerializable)h).serializeNBT();
            compound.func_218657_a("inv", (INBT)ct);
        });
        compound.func_74757_a("onlyOwnersAccess", this.onlyOwnersAccess);
        return super.func_189515_b(compound);
    }

    public void func_145839_a(CompoundNBT compound) {
        this.ownerName = compound.func_74779_i("ownerName");
        this.deathDate = compound.func_74763_f("deathDate");
        this.timer = compound.func_74762_e("countTicks");
        CompoundNBT invTag = compound.func_74775_l("inv");
        this.handler.ifPresent(h -> ((INBTSerializable)h).deserializeNBT((INBT)invTag));
        if (compound.func_186855_b("ownerid")) {
            this.ownerId = compound.func_186857_a("ownerid");
        }
        this.onlyOwnersAccess = compound.func_74767_n("onlyOwnersAccess");
        super.func_145839_a(compound);
    }

    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction side) {
        if (cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.handler.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        IItemHandler inventory = (IItemHandler)this.handler.orElse(null);
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_180495_p(this.field_174879_c).func_177230_c() instanceof BlockTomb) {
                return;
            }
            for (int i = 0; i < inventory.getSlots(); ++i) {
                ItemStack stack = inventory.getStackInSlot(i);
                if (stack.func_190926_b()) continue;
                InventoryHelper.func_180173_a((World)this.field_145850_b, (double)this.field_174879_c.func_177958_n(), (double)this.field_174879_c.func_177956_o(), (double)this.field_174879_c.func_177952_p(), (ItemStack)inventory.extractItem(i, stack.func_190916_E(), false));
            }
        }
        super.invalidateCaps();
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = new CompoundNBT();
        super.func_189515_b(compound);
        compound.func_74778_a("ownerName", this.ownerName);
        compound.func_74772_a("deathDate", this.deathDate);
        compound.func_74768_a("countTicks", this.timer);
        return compound;
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.field_174879_c, 1, this.func_189517_E_());
    }

    public boolean func_145842_c(int id, int type) {
        return true;
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }
}

